/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.controller.open;

import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.metadata.streaming.StreamingJobRecord;
import org.apache.kylin.rest.controller.NBasicController;
import org.apache.kylin.rest.request.StreamingJobExecuteRequest;
import org.apache.kylin.rest.request.StreamingJobFilter;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.EnvelopeResponse;
import org.apache.kylin.rest.response.StreamingJobDataStatsResponse;
import org.apache.kylin.rest.response.StreamingJobResponse;
import org.apache.kylin.rest.service.StreamingJobService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/api/streaming_jobs"}, produces={"application/vnd.apache.kylin-v4-public+json"})
public class OpenStreamingJobController
extends NBasicController {
    @Autowired
    @Qualifier(value="streamingJobService")
    private StreamingJobService streamingJobService;

    @GetMapping(value={""})
    @ResponseBody
    public EnvelopeResponse<DataResult<List<StreamingJobResponse>>> getStreamingJobList(@RequestParam(value="model_name", required=false, defaultValue="") String modelName, @RequestParam(value="model_names", required=false) List<String> modelNames, @RequestParam(value="job_types", required=false, defaultValue="") List<String> jobTypes, @RequestParam(value="statuses", required=false, defaultValue="") List<String> statuses, @RequestParam(value="project", required=false, defaultValue="") String project, @RequestParam(value="page_offset", required=false, defaultValue="0") Integer pageOffset, @RequestParam(value="page_size", required=false, defaultValue="10") Integer pageSize, @RequestParam(value="sort_by", required=false, defaultValue="last_modified") String sortBy, @RequestParam(value="reverse", required=false, defaultValue="true") boolean reverse, @RequestParam(value="job_ids", required=false, defaultValue="") List<String> jobIds) {
        this.checkStreamingEnabled();
        this.checkStreamingJobsStatus(statuses);
        this.checkStreamingJobTypeStatus(jobTypes);
        project = this.getInsensitiveProject(project);
        modelName = this.getInsensitiveProjectModelName(project, modelName);
        StreamingJobFilter jobFilter = new StreamingJobFilter(modelName, modelNames, jobTypes, statuses, project, sortBy, reverse, jobIds);
        DataResult data = this.streamingJobService.getStreamingJobList(jobFilter, pageOffset.intValue(), pageSize.intValue());
        return new EnvelopeResponse("000", (Object)data, "");
    }

    @ApiOperation(value="updateStreamingJobStatus", notes="Update Body: jobId")
    @PutMapping(value={"/status"})
    @ResponseBody
    public EnvelopeResponse<String> updateStreamingJobStatus(@RequestBody StreamingJobExecuteRequest streamingJobExecuteRequest) {
        this.checkStreamingEnabled();
        this.checkRequiredArg("action", streamingJobExecuteRequest.getAction());
        if (CollectionUtils.isEmpty((Collection)streamingJobExecuteRequest.getJobIds())) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{"job_ids"});
        }
        this.streamingJobService.updateStreamingJobStatus(streamingJobExecuteRequest.getProject(), streamingJobExecuteRequest.getJobIds(), streamingJobExecuteRequest.getAction());
        return new EnvelopeResponse("000", (Object)"", "");
    }

    @GetMapping(value={"/stats/{jobId:.+}"})
    @ResponseBody
    public EnvelopeResponse<StreamingJobDataStatsResponse> getStreamingJobDataStats(@PathVariable(value="jobId") String jobId, @RequestParam(value="time_filter", required=false, defaultValue="30") Integer timeFilter) {
        this.checkStreamingEnabled();
        StreamingJobDataStatsResponse response = this.streamingJobService.getStreamingJobDataStats(jobId, timeFilter);
        return new EnvelopeResponse("000", (Object)response, "");
    }

    @GetMapping(value={"/records"})
    @ResponseBody
    public EnvelopeResponse<List<StreamingJobRecord>> getStreamingJobRecordList(@RequestParam(value="job_id") String jobId) {
        this.checkStreamingEnabled();
        if (StringUtils.isEmpty((String)jobId)) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.REQUEST_PARAMETER_EMPTY_OR_VALUE_EMPTY, new Object[]{"job_id"});
        }
        List data = this.streamingJobService.getStreamingJobRecordList(jobId);
        return new EnvelopeResponse("000", (Object)data, "");
    }
}

