/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.utils;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.shaded.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpressionComparator {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionComparator.class);

    public static boolean isNodeEqual(SqlNode queryNode, SqlNode exprNode, SqlNodeComparator nodeComparator) {
        try {
            Preconditions.checkNotNull((Object)nodeComparator);
            return nodeComparator.isSqlNodeEqual(queryNode, exprNode);
        }
        catch (Exception e) {
            logger.error("Exception while running isNodeEqual, return false", (Throwable)e);
            return false;
        }
    }

    public static abstract class SqlNodeComparator {
        protected abstract boolean isSqlIdentifierEqual(SqlIdentifier var1, SqlIdentifier var2);

        public boolean isSqlNodeEqual(SqlNode queryNode, SqlNode exprNode) {
            if (queryNode == null) {
                return exprNode == null;
            }
            if (exprNode == null) {
                return false;
            }
            if (!Objects.equals(queryNode.getClass().getSimpleName(), exprNode.getClass().getSimpleName())) {
                return false;
            }
            if (queryNode instanceof SqlCall) {
                if (!(exprNode instanceof SqlCall)) {
                    return false;
                }
                SqlCall thisNode = (SqlCall)queryNode;
                SqlCall thatNode = (SqlCall)exprNode;
                if (!thisNode.getOperator().getName().equalsIgnoreCase(thatNode.getOperator().getName())) {
                    return false;
                }
                return this.isNodeListEqual(thisNode.getOperandList(), thatNode.getOperandList());
            }
            if (queryNode instanceof SqlLiteral) {
                if (!(exprNode instanceof SqlLiteral)) {
                    return false;
                }
                SqlLiteral thisNode = (SqlLiteral)queryNode;
                SqlLiteral thatNode = (SqlLiteral)exprNode;
                return Objects.equals(thisNode.getValue(), thatNode.getValue());
            }
            if (queryNode instanceof SqlNodeList) {
                if (!(exprNode instanceof SqlNodeList)) {
                    return false;
                }
                SqlNodeList thisNode = (SqlNodeList)queryNode;
                SqlNodeList thatNode = (SqlNodeList)exprNode;
                if (thisNode.getList().size() != thatNode.getList().size()) {
                    return false;
                }
                for (int i = 0; i < thisNode.getList().size(); ++i) {
                    SqlNode thatChild;
                    SqlNode thisChild = (SqlNode)thisNode.getList().get(i);
                    if (this.isSqlNodeEqual(thisChild, thatChild = (SqlNode)thatNode.getList().get(i))) continue;
                    return false;
                }
                return true;
            }
            if (queryNode instanceof SqlIdentifier) {
                if (!(exprNode instanceof SqlIdentifier)) {
                    return false;
                }
                SqlIdentifier thisNode = (SqlIdentifier)queryNode;
                SqlIdentifier thatNode = (SqlIdentifier)exprNode;
                return this.isSqlIdentifierEqual(thisNode, thatNode);
            }
            if (queryNode instanceof SqlDataTypeSpec) {
                if (!(exprNode instanceof SqlDataTypeSpec)) {
                    return false;
                }
                SqlDataTypeSpec thisNode = (SqlDataTypeSpec)queryNode;
                SqlDataTypeSpec thatNode = (SqlDataTypeSpec)exprNode;
                return this.isSqlDataTypeSpecEqual(thisNode, thatNode);
            }
            return false;
        }

        protected boolean isSqlDataTypeSpecEqual(SqlDataTypeSpec querySqlDataTypeSpec, SqlDataTypeSpec exprSqlDataTypeSpec) {
            if (querySqlDataTypeSpec.getTypeName() == null || CollectionUtils.isEmpty((Collection)querySqlDataTypeSpec.getTypeName().names)) {
                return false;
            }
            if (querySqlDataTypeSpec.getTypeName().names.size() != exprSqlDataTypeSpec.getTypeName().names.size()) {
                return false;
            }
            for (int i = 0; i < querySqlDataTypeSpec.getTypeName().names.size(); ++i) {
                String queryName = (String)querySqlDataTypeSpec.getTypeName().names.get(i);
                if (exprSqlDataTypeSpec.getTypeName().names.contains((Object)queryName)) continue;
                return false;
            }
            return querySqlDataTypeSpec.getScale() == exprSqlDataTypeSpec.getScale() && querySqlDataTypeSpec.getPrecision() == exprSqlDataTypeSpec.getPrecision();
        }

        protected boolean isNodeListEqual(List<SqlNode> queryNodeList, List<SqlNode> exprNodeList) {
            if (queryNodeList.size() != exprNodeList.size()) {
                return false;
            }
            for (int i = 0; i < queryNodeList.size(); ++i) {
                if (this.isSqlNodeEqual(queryNodeList.get(i), exprNodeList.get(i))) continue;
                return false;
            }
            return true;
        }
    }
}

