/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.util.List;
import java.util.Map;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWindow;
import org.apache.calcite.util.Litmus;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.sdk.datasource.framework.conv.ParamNodeParser;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDef;
import org.apache.kylin.sdk.datasource.framework.def.TypeDef;
import org.apache.kylin.sdk.datasource.framework.utils.ExpressionComparator;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class ConvMaster {
    private final DataSourceDef sourceDS;
    private final DataSourceDef targetDS;

    public ConvMaster(DataSourceDef sourceDS, DataSourceDef targetDS) {
        this.sourceDS = sourceDS;
        this.targetDS = targetDS;
    }

    Pair<SqlNode, SqlNode> matchSqlFunc(SqlNode sourceFunc) {
        String funcName;
        List<String> validDefIds;
        if (sourceFunc == null || this.sourceDS == null || this.targetDS == null) {
            return null;
        }
        if ((sourceFunc instanceof SqlCall || sourceFunc instanceof SqlIdentifier) && (validDefIds = this.sourceDS.getFuncDefsByName(funcName = sourceFunc instanceof SqlCall ? ((SqlCall)sourceFunc).getOperator().getName() : sourceFunc.toString())) != null) {
            for (String defId : validDefIds) {
                SqlNode targetTmpl;
                SqlNode sourceCandidate = this.sourceDS.getFuncDefSqlNode(defId);
                if (!ExpressionComparator.isNodeEqual(sourceFunc, sourceCandidate, new ParamSqlNodeComparator()) || (targetTmpl = this.targetDS.getFuncDefSqlNode(defId)) == null) continue;
                return new Pair((Object)sourceCandidate, (Object)this.targetDS.getFuncDefSqlNode(defId));
            }
        }
        return null;
    }

    SqlDataTypeSpec findTargetSqlDataTypeSpec(SqlDataTypeSpec typeSpec) {
        if (this.sourceDS == null || this.targetDS == null || typeSpec == null) {
            return null;
        }
        List<TypeDef> validTypeDefs = this.sourceDS.getTypeDefsByName(typeSpec.getTypeName().toString());
        if (validTypeDefs != null) {
            for (TypeDef typeDef : validTypeDefs) {
                if (typeDef.getMaxPrecision() < typeSpec.getPrecision()) continue;
                TypeDef targetType = this.targetDS.getTypeDef(typeDef.getId());
                return new SqlDataTypeSpec(new SqlIdentifier(targetType.getName(), typeSpec.getParserPosition()), targetType.getDefaultPrecision() >= 0 ? targetType.getDefaultPrecision() : typeSpec.getPrecision(), targetType.getDefaultScale() >= 0 ? targetType.getDefaultScale() : typeSpec.getScale(), typeSpec.getCharSetName(), typeSpec.getTimeZone(), typeSpec.getParserPosition());
            }
        }
        return null;
    }

    private static class ParamSqlNodeComparator
    extends ExpressionComparator.SqlNodeComparator {
        private final Map<Integer, SqlNode> matchedNodesMap;

        private ParamSqlNodeComparator() {
            this(Maps.newHashMap());
        }

        private ParamSqlNodeComparator(Map<Integer, SqlNode> matchedNodesMap) {
            this.matchedNodesMap = matchedNodesMap;
        }

        @Override
        public boolean isSqlIdentifierEqual(SqlIdentifier querySqlIdentifier, SqlIdentifier exprSqlIdentifier) {
            int parsedIdx = ParamNodeParser.parseParamIdx(exprSqlIdentifier.toString());
            if (parsedIdx >= 0) {
                SqlNode matchedBefore = this.matchedNodesMap.get(parsedIdx);
                if (matchedBefore != null) {
                    return ExpressionComparator.isNodeEqual((SqlNode)querySqlIdentifier, matchedBefore, this);
                }
                this.matchedNodesMap.put(parsedIdx, (SqlNode)querySqlIdentifier);
                return true;
            }
            return querySqlIdentifier.equalsDeep((SqlNode)exprSqlIdentifier, Litmus.IGNORE);
        }

        @Override
        public boolean isSqlNodeEqual(SqlNode queryNode, SqlNode exprNode) {
            if (queryNode != null && exprNode != null) {
                if (exprNode instanceof SqlIdentifier) {
                    int parsedIdx = ParamNodeParser.parseParamIdx(exprNode.toString());
                    if (parsedIdx >= 0) {
                        SqlNode matchedBefore = this.matchedNodesMap.get(parsedIdx);
                        if (matchedBefore != null) {
                            return ExpressionComparator.isNodeEqual(queryNode, matchedBefore, this);
                        }
                        this.matchedNodesMap.put(parsedIdx, queryNode);
                        return true;
                    }
                } else {
                    if (exprNode instanceof SqlIntervalQualifier) {
                        if (!(queryNode instanceof SqlIntervalQualifier)) {
                            return false;
                        }
                        SqlIntervalQualifier thisNode = (SqlIntervalQualifier)queryNode;
                        SqlIntervalQualifier thatNode = (SqlIntervalQualifier)exprNode;
                        return thisNode.toString().equals(thatNode.toString());
                    }
                    if (exprNode instanceof SqlWindow) {
                        if (!(queryNode instanceof SqlWindow)) {
                            return false;
                        }
                        if (((SqlWindow)exprNode).getRefName() instanceof SqlIdentifier) {
                            return true;
                        }
                    }
                }
            }
            return super.isSqlNodeEqual(queryNode, exprNode);
        }
    }
}

