/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.util.Locale;
import java.util.Map;
import org.apache.calcite.sql.SqlDialect;
import org.apache.kylin.sdk.datasource.adaptor.AbstractJdbcAdaptor;
import org.apache.kylin.sdk.datasource.framework.conv.SqlConverter;
import org.apache.kylin.sdk.datasource.framework.def.DataSourceDef;
import org.apache.kylin.shaded.com.google.common.collect.Maps;

public class DefaultConfigurer
implements SqlConverter.IConfigurer {
    private static final Map<String, SqlDialect> sqlDialectMap = Maps.newHashMap();
    private AbstractJdbcAdaptor adaptor;
    private DataSourceDef dsDef;

    public DefaultConfigurer(AbstractJdbcAdaptor adaptor, DataSourceDef dsDef) {
        this.adaptor = adaptor;
        this.dsDef = dsDef;
    }

    public DefaultConfigurer(DataSourceDef dsDef) {
        this(null, dsDef);
    }

    @Override
    public boolean skipDefaultConvert() {
        return !"true".equalsIgnoreCase(this.dsDef.getPropertyValue("sql.default-converted-enabled", "true"));
    }

    @Override
    public boolean skipHandleDefault() {
        return !"true".equalsIgnoreCase(this.dsDef.getPropertyValue("sql.keyword-default-escape", "true"));
    }

    @Override
    public boolean useUppercaseDefault() {
        return "true".equalsIgnoreCase(this.dsDef.getPropertyValue("sql.keyword-default-uppercase", "true"));
    }

    @Override
    public String fixAfterDefaultConvert(String orig) {
        if (this.adaptor == null) {
            return orig;
        }
        return this.adaptor.fixSql(orig);
    }

    @Override
    public SqlDialect getSqlDialect() {
        String dialectName = this.dsDef.getDialectName() == null ? this.dsDef.getId() : this.dsDef.getDialectName();
        SqlDialect sqlDialect = sqlDialectMap.get(dialectName.toLowerCase(Locale.ROOT));
        return sqlDialect == null ? sqlDialectMap.get("unknown") : sqlDialect;
    }

    @Override
    public boolean allowNoOffset() {
        return "true".equalsIgnoreCase(this.dsDef.getPropertyValue("sql.allow-no-offset", "true"));
    }

    @Override
    public boolean allowFetchNoRows() {
        return "true".equalsIgnoreCase(this.dsDef.getPropertyValue("sql.allow-fetch-no-rows", "true"));
    }

    @Override
    public boolean allowNoOrderByWithFetch() {
        return "true".equalsIgnoreCase(this.dsDef.getPropertyValue("sql.allow-no-orderby-with-fetch", "true"));
    }

    @Override
    public String getPagingType() {
        return this.dsDef.getPropertyValue("sql.paging-type", "AUTO");
    }

    @Override
    public boolean isCaseSensitive() {
        return "true".equalsIgnoreCase(this.dsDef.getPropertyValue("sql.case-sensitive", "true"));
    }

    @Override
    public boolean enableCache() {
        return "true".equalsIgnoreCase(this.dsDef.getPropertyValue("metadata.enable-cache", "true"));
    }

    @Override
    public boolean enableQuote() {
        return "true".equalsIgnoreCase(this.dsDef.getPropertyValue("sql.enable-quote-all-identifiers", "true"));
    }

    @Override
    public String fixIdentifierCaseSensitve(String orig) {
        if (this.adaptor == null || !this.isCaseSensitive()) {
            return orig;
        }
        return this.adaptor.fixIdentifierCaseSensitve(orig);
    }

    @Override
    public String getTransactionIsolationLevel() {
        return this.dsDef.getPropertyValue("transaction.isolation-level");
    }

    static {
        sqlDialectMap.put("default", SqlDialect.DatabaseProduct.CALCITE.getDialect());
        sqlDialectMap.put("calcite", SqlDialect.DatabaseProduct.CALCITE.getDialect());
        sqlDialectMap.put("greenplum", SqlDialect.DatabaseProduct.POSTGRESQL.getDialect());
        sqlDialectMap.put("postgresql", SqlDialect.DatabaseProduct.POSTGRESQL.getDialect());
        sqlDialectMap.put("mysql", SqlDialect.DatabaseProduct.MYSQL.getDialect());
        sqlDialectMap.put("mssql", SqlDialect.DatabaseProduct.MSSQL.getDialect());
        sqlDialectMap.put("oracle", SqlDialect.DatabaseProduct.ORACLE.getDialect());
        sqlDialectMap.put("vertica", SqlDialect.DatabaseProduct.VERTICA.getDialect());
        sqlDialectMap.put("redshift", SqlDialect.DatabaseProduct.REDSHIFT.getDialect());
        sqlDialectMap.put("hive", SqlDialect.DatabaseProduct.HIVE.getDialect());
        sqlDialectMap.put("h2", SqlDialect.DatabaseProduct.H2.getDialect());
        sqlDialectMap.put("unknown", SqlDialect.DatabaseProduct.UNKNOWN.getDialect());
    }
}

