/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.sdk.datasource.framework.conv;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.kylin.sdk.datasource.framework.conv.ParamNodeParser;
import org.apache.kylin.shaded.com.google.common.cache.Cache;
import org.apache.kylin.shaded.com.google.common.cache.CacheBuilder;
import org.apache.kylin.shaded.com.google.common.collect.Lists;

public class SqlParamsFinder {
    private static final Cache<SqlCall, Map<Integer, List<Integer>>> PATH_CACHE = CacheBuilder.newBuilder().expireAfterWrite(1L, TimeUnit.DAYS).maximumSize(100L).build();
    private Map<Integer, List<Integer>> paramPath;
    private SqlCall sourceTmpl;
    private SqlCall sqlCall;

    public SqlParamsFinder(SqlCall sourceTmpl, SqlCall sqlCall) {
        this.sourceTmpl = sourceTmpl;
        this.sqlCall = sqlCall;
    }

    public Map<Integer, SqlNode> getParamNodes() {
        this.paramPath = (Map)PATH_CACHE.getIfPresent((Object)this.sourceTmpl);
        if (this.paramPath == null) {
            this.paramPath = new TreeMap<Integer, List<Integer>>();
            this.genParamPath((SqlNode)this.sourceTmpl, new ArrayList<Integer>());
            PATH_CACHE.put((Object)this.sourceTmpl, this.paramPath);
        }
        HashMap<Integer, SqlNode> sqlNodes = new HashMap<Integer, SqlNode>();
        for (Map.Entry<Integer, List<Integer>> entry : this.paramPath.entrySet()) {
            List<Integer> path = entry.getValue();
            sqlNodes.put(entry.getKey(), this.getParamNode(path, (SqlNode)this.sqlCall, 0));
        }
        return sqlNodes;
    }

    private SqlNode getParamNode(List<Integer> path, SqlNode sqlNode, int level) {
        if (level == path.size() - 1) {
            return (SqlNode)((SqlCall)sqlNode).getOperandList().get(path.get(level));
        }
        return this.getParamNode(path, (SqlNode)((SqlCall)sqlNode).getOperandList().get(path.get(level)), ++level);
    }

    private void genParamPath(SqlNode sqlNode, List<Integer> path) {
        if (sqlNode instanceof SqlIdentifier) {
            int paramIdx = ParamNodeParser.parseParamIdx(sqlNode.toString());
            if (paramIdx >= 0 && path.size() > 0) {
                this.paramPath.put(paramIdx, path);
            }
        } else if (sqlNode instanceof SqlCall) {
            List operands = ((SqlCall)sqlNode).getOperandList();
            for (int i = 0; i < operands.size(); ++i) {
                ArrayList copiedPath = Lists.newArrayList(path);
                copiedPath.add(i);
                this.genParamPath((SqlNode)operands.get(i), copiedPath);
            }
        }
    }

    public static SqlParamsFinder newInstance(SqlCall sourceTmpl, final SqlCall sqlCall, boolean isWindowCall) {
        if (!isWindowCall) {
            return new SqlParamsFinder(sourceTmpl, sqlCall);
        }
        return new SqlParamsFinder(sourceTmpl, sqlCall){

            @Override
            public Map<Integer, SqlNode> getParamNodes() {
                HashMap<Integer, SqlNode> sqlNodes = new HashMap<Integer, SqlNode>();
                List sqlNodeList = sqlCall.getOperandList();
                SqlNode firstParam = (SqlNode)((SqlCall)sqlNodeList.get(0)).getOperandList().get(0);
                SqlCall secondParam = (SqlCall)sqlNodeList.get(1);
                sqlNodes.put(0, firstParam);
                sqlNodes.put(1, (SqlNode)secondParam);
                return sqlNodes;
            }
        };
    }
}

