/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.cluster.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.List;
import org.apache.kylin.cluster.AvailableResource;
import org.apache.kylin.cluster.ResourceInfo;
import org.apache.kylin.cluster.parser.SchedulerParser;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.spark.internal.Logging;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.DoubleRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001I3AAB\u0004\u0001%!)Q\u0004\u0001C\u0001=!)\u0001\u0005\u0001C!C!)1\u0007\u0001C\u0005i!)a\t\u0001C\u0005\u000f\")A\n\u0001C\u0005\u001b\n92)\u00199bG&$\u0018pU2iK\u0012,H.\u001a:QCJ\u001cXM\u001d\u0006\u0003\u0011%\ta\u0001]1sg\u0016\u0014(B\u0001\u0006\f\u0003\u001d\u0019G.^:uKJT!\u0001D\u0007\u0002\u000b-LH.\u001b8\u000b\u00059y\u0011AB1qC\u000eDWMC\u0001\u0011\u0003\ry'oZ\u0002\u0001'\r\u00011#\u0007\t\u0003)]i\u0011!\u0006\u0006\u0002-\u0005)1oY1mC&\u0011\u0001$\u0006\u0002\u0007\u0003:L(+\u001a4\u0011\u0005iYR\"A\u0004\n\u0005q9!aD*dQ\u0016$W\u000f\\3s!\u0006\u00148/\u001a:\u0002\rqJg.\u001b;?)\u0005y\u0002C\u0001\u000e\u0001\u0003E\tg/Y5mC\ndWMU3t_V\u00148-\u001a\u000b\u0003E\u0019\u0002\"a\t\u0013\u000e\u0003%I!!J\u0005\u0003#\u00053\u0018-\u001b7bE2,'+Z:pkJ\u001cW\rC\u0003(\u0005\u0001\u0007\u0001&A\u0005rk\u0016,XMT1nKB\u0011\u0011\u0006\r\b\u0003U9\u0002\"aK\u000b\u000e\u00031R!!L\t\u0002\rq\u0012xn\u001c;?\u0013\tyS#\u0001\u0004Qe\u0016$WMZ\u0005\u0003cI\u0012aa\u0015;sS:<'BA\u0018\u0016\u0003a\u0019G.^:uKJ\fe/Y5mC\ndWmQ1qC\u000eLG/\u001f\u000b\u0003ka\u0002\"\u0001\u0006\u001c\n\u0005]*\"A\u0002#pk\ndW\rC\u0003:\u0007\u0001\u0007!(\u0001\u0003o_\u0012,\u0007CA\u001eE\u001b\u0005a$BA\u001f?\u0003!!\u0017\r^1cS:$'BA A\u0003\u001dQ\u0017mY6t_:T!!\u0011\"\u0002\u0013\u0019\f7\u000f^3sq6d'\"A\"\u0002\u0007\r|W.\u0003\u0002Fy\tA!j]8o\u001d>$W-A\u0007rk\u0016,XmQ1qC\u000eLG/\u001f\u000b\u0003\u0011.\u0003B\u0001F%6k%\u0011!*\u0006\u0002\u0007)V\u0004H.\u001a\u001a\t\u000be\"\u0001\u0019\u0001\u001e\u0002!\r\fG\u000eV8uC2\u0014Vm]8ve\u000e,GC\u0001(R!\t\u0019s*\u0003\u0002Q\u0013\ta!+Z:pkJ\u001cW-\u00138g_\")\u0011(\u0002a\u0001u\u0001")
public class CapacitySchedulerParser
implements SchedulerParser {
    private JsonNode root;
    private ObjectMapper mapper;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile boolean bitmap$0;

    @Override
    public void parse(String schedulerInfo) {
        SchedulerParser.parse$(this, schedulerInfo);
    }

    @Override
    public String parseValue(JsonNode node) {
        return SchedulerParser.parseValue$(this, node);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public JsonNode root() {
        return this.root;
    }

    @Override
    public void root_$eq(JsonNode x$1) {
        this.root = x$1;
    }

    private ObjectMapper mapper$lzycompute() {
        CapacitySchedulerParser capacitySchedulerParser = this;
        synchronized (capacitySchedulerParser) {
            if (!this.bitmap$0) {
                this.mapper = SchedulerParser.mapper$(this);
                this.bitmap$0 = true;
            }
        }
        return this.mapper;
    }

    @Override
    public ObjectMapper mapper() {
        return !this.bitmap$0 ? this.mapper$lzycompute() : this.mapper;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public AvailableResource availableResource(String queueName) {
        None$ none$;
        List queues = this.root().findParents("queueName");
        Buffer nodes = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(queues).asScala()).filter((Function1 & Serializable & scala.Serializable)queue -> BoxesRunTime.boxToBoolean((boolean)CapacitySchedulerParser.$anonfun$availableResource$1(this, queueName, queue)));
        Predef$.MODULE$.require(nodes.size() == 1);
        Tuple2<Object, Object> tuple2 = this.queueCapacity((JsonNode)nodes.head());
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double queueAvailable = tuple2._1$mcD$sp();
        double queueMax = tuple2._2$mcD$sp();
        Tuple2.mcDD.sp sp2 = new Tuple2.mcDD.sp(queueAvailable, queueMax);
        Tuple2.mcDD.sp sp3 = sp2;
        DoubleRef queueAvailable2 = DoubleRef.create((double)sp3._1$mcD$sp());
        DoubleRef queueMax2 = DoubleRef.create((double)sp3._2$mcD$sp());
        ResourceInfo totalResource = this.calTotalResource((JsonNode)nodes.head());
        JsonNode clusterNode = this.root().findValue("schedulerInfo");
        double cluster = this.clusterAvailableCapacity(clusterNode);
        DoubleRef min = DoubleRef.create((double)Math.min(queueAvailable2.elem, cluster));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("queueAvailable is ").append(queueAvailable$1.elem).append(", min is ").append(min$1.elem).append(", queueMax is ").append(queueMax$1.elem).toString());
        if (KylinBuildEnv$.MODULE$.get().kylinConfig().useDynamicResourcePlan() && queueMax2.elem == 0.0) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "configure yarn queue using dynamic resource plan in capacity scheduler");
            queueMax2.elem = 1.0;
        }
        if (KylinBuildEnv$.MODULE$.get().kylinConfig().useDynamicResourcePlan() && min.elem == 0.0) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "configure yarn queue using dynamic resource plan in capacity scheduler");
            min.elem = 1.0;
        }
        ObjectRef resource = ObjectRef.create((Object)new AvailableResource(totalResource.percentage(min.elem), totalResource.percentage(queueMax2.elem)));
        try {
            ResourceInfo queueAvailableRes = KylinBuildEnv$.MODULE$.get().clusterManager().fetchQueueStatistics(queueName);
            resource.elem = new AvailableResource(queueAvailableRes, totalResource.percentage(queueMax2.elem));
            none$ = BoxedUnit.UNIT;
        }
        catch (Error e) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "The current hadoop version does not support QueueInfo.getQueueStatistics method.");
            none$ = None$.MODULE$;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Capacity actual available resource: ").append((AvailableResource)resource$1.elem).append(".").toString());
        return (AvailableResource)resource.elem;
    }

    private double clusterAvailableCapacity(JsonNode node) {
        double max = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("capacity")))).toDouble();
        double used = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("usedCapacity")))).toDouble();
        double capacity = (max - used) / (double)100;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Cluster available capacity: ").append(capacity).append(".").toString());
        return capacity;
    }

    private Tuple2<Object, Object> queueCapacity(JsonNode node) {
        double max = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("absoluteMaxCapacity")))).toDouble();
        double used = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("absoluteUsedCapacity")))).toDouble();
        double available = (max - used) / (double)100;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Queue available capacity: ").append(available).append(".").toString());
        return new Tuple2.mcDD.sp(available, max / (double)100);
    }

    private ResourceInfo calTotalResource(JsonNode node) {
        ResourceInfo resourceInfo;
        int usedMemory = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("resourcesUsed").get("memory")))).toInt();
        if (usedMemory != 0) {
            double usedCapacity = new StringOps(Predef$.MODULE$.augmentString(this.parseValue(node.get("absoluteUsedCapacity")))).toDouble() / (double)100;
            ResourceInfo resource = new ResourceInfo((int)Math.floor((double)usedMemory / usedCapacity), Integer.MAX_VALUE);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Estimate total cluster resource is ").append(resource).append(".").toString());
            resourceInfo = resource;
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Current queue used memory is 0, seem available resource as infinite.");
            resourceInfo = new ResourceInfo(Integer.MAX_VALUE, Integer.MAX_VALUE);
        }
        return resourceInfo;
    }

    public static final /* synthetic */ boolean $anonfun$availableResource$1(CapacitySchedulerParser $this, String queueName$1, JsonNode queue) {
        return $this.parseValue(queue.get("queueName")).equals(queueName$1);
    }

    public CapacitySchedulerParser() {
        Logging.$init$((Logging)this);
        SchedulerParser.$init$(this);
    }
}

