/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.engine.spark.job.NSparkCubingJob;
import org.apache.kylin.engine.spark.job.NSparkCubingStep;
import org.apache.kylin.engine.spark.job.NSparkMergingJob;
import org.apache.kylin.engine.spark.job.NSparkSnapshotJob;
import org.apache.kylin.job.execution.AbstractExecutable;

public class ExecutableUtils {
    public static ResourceStore getRemoteStore(KylinConfig config, AbstractExecutable buildTask) {
        String buildStepUrl = buildTask.getParam("outputMetaUrl");
        KylinConfig buildConfig = KylinConfig.createKylinConfig((KylinConfig)config);
        buildConfig.setMetadataUrl(buildStepUrl);
        return ResourceStore.getKylinMetaStore((KylinConfig)buildConfig);
    }

    public static String getDataflowId(AbstractExecutable buildTask) {
        return buildTask.getParam("dataflowId");
    }

    public static Set<String> getSegmentIds(AbstractExecutable buildTask) {
        return Stream.of(StringUtils.split((String)buildTask.getParam("segmentIds"), (String)",")).collect(Collectors.toSet());
    }

    public static Set<Long> getLayoutIds(AbstractExecutable buildTask) {
        return Stream.of(StringUtils.split((String)buildTask.getParam("layoutIds"), (String)",")).map(Long::parseLong).collect(Collectors.toSet());
    }

    public static Set<Long> getPartitionIds(AbstractExecutable buildTask) {
        if (CollectionUtils.isEmpty((Collection)buildTask.getTargetPartitions())) {
            return new HashSet<Long>();
        }
        return buildTask.getTargetPartitions();
    }

    public static boolean needBuildSnapshots(AbstractExecutable buildTask) {
        if (buildTask instanceof NSparkCubingStep) {
            String p = buildTask.getParam("needBuildSnapshots");
            return StringUtils.isBlank((String)p) || Boolean.parseBoolean(p);
        }
        return false;
    }

    public static void initJobFactory() {
        new NSparkCubingJob();
        new NSparkMergingJob();
        new NSparkSnapshotJob();
    }
}

