/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.application;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.AccessControlException;
import org.apache.kylin.cluster.IClusterManager;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.util.Application;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.TimeZoneUtils;
import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.engine.spark.job.BuildJobInfos;
import org.apache.kylin.engine.spark.job.EnviromentAdaptor;
import org.apache.kylin.engine.spark.job.IJobProgressReport;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.ResourceDetect;
import org.apache.kylin.engine.spark.job.RestfulJobProgressReport;
import org.apache.kylin.engine.spark.job.SegmentBuildJob;
import org.apache.kylin.engine.spark.job.StageType;
import org.apache.kylin.engine.spark.job.UdfManager;
import org.apache.kylin.engine.spark.job.stage.StageExec;
import org.apache.kylin.engine.spark.scheduler.ClusterMonitor;
import org.apache.kylin.engine.spark.utils.JobMetricsUtils;
import org.apache.kylin.engine.spark.utils.SparkConfHelper;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.view.LogicalView;
import org.apache.kylin.metadata.view.LogicalViewManager;
import org.apache.kylin.query.pushdown.SparkSubmitter;
import org.apache.kylin.query.util.PushDownUtil;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.application.NoRetryException;
import org.apache.spark.sql.KylinSession;
import org.apache.spark.sql.KylinSession$;
import org.apache.spark.sql.LogicalViewLoader;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.rules.Rule;
import org.apache.spark.sql.execution.datasource.AlignmentTableStats;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;
import org.apache.spark.util.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.runtime.AbstractFunction1;
import scala.runtime.BoxedUnit;

public abstract class SparkApplication
implements Application {
    private static final Logger logger = LoggerFactory.getLogger(SparkApplication.class);
    private Map<String, String> params = Maps.newHashMap();
    public static final String JOB_NAME_PREFIX = "job_step_";
    private IJobProgressReport report;
    protected volatile KylinConfig config;
    protected volatile String jobId;
    protected String project;
    protected int layoutSize = -1;
    protected BuildJobInfos infos;
    protected String path;
    private ClusterMonitor clusterMonitor;
    private final AtomicLong atomicDisconnectSparkMasterTimes = new AtomicLong(0L);
    private final AtomicBoolean atomicUnreachableSparkMaster = new AtomicBoolean(false);
    private final AtomicReference<SparkConf> atomicSparkConf = new AtomicReference<Object>(null);
    private final AtomicReference<SparkSession> atomicSparkSession = new AtomicReference<Object>(null);
    private final AtomicReference<KylinBuildEnv> atomicBuildEnv = new AtomicReference<Object>(null);
    protected SparkSession ss;

    public void execute(String[] args) {
        try {
            this.path = args[0];
            String argsLine = this.readArgsFromHDFS();
            this.params = JsonUtil.readValueAsMap((String)argsLine);
            logger.info("Execute {} with args : {}", (Object)this.getClass().getName(), (Object)argsLine);
            this.execute();
        }
        catch (Exception e) {
            throw new RuntimeException("Error execute " + this.getClass().getName(), e);
        }
    }

    public AtomicBoolean getAtomicUnreachableSparkMaster() {
        return this.atomicUnreachableSparkMaster;
    }

    public final Map<String, String> getParams() {
        return this.params;
    }

    public final String getParam(String key) {
        return this.params.get(key);
    }

    public final void setParam(String key, String value) {
        this.params.put(key, value);
    }

    public final boolean contains(String key) {
        return this.params.containsKey(key);
    }

    public String getJobId() {
        return this.jobId;
    }

    public String getProject() {
        return this.project;
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public IJobProgressReport getReport() {
        if (this.report == null) {
            return new RestfulJobProgressReport();
        }
        return this.report;
    }

    public SparkSession getSparkSession() throws NoRetryException {
        SparkSession sparkSession = this.atomicSparkSession.get();
        if (Objects.isNull(sparkSession)) {
            throw new NoRetryException("spark session shouldn't be null");
        }
        return sparkSession;
    }

    public String readArgsFromHDFS() {
        FileSystem fs = HadoopUtil.getFileSystem((String)this.path);
        String argsLine = null;
        Path filePath = new Path(this.path);
        try (FSDataInputStream inputStream = fs.open(filePath);){
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)inputStream, Charset.defaultCharset()));
            argsLine = br.readLine();
        }
        catch (IOException e) {
            logger.error("Error occurred when reading args file: {}", (Object)this.path, (Object)e);
        }
        return argsLine;
    }

    public String getTrackingUrl(IClusterManager clusterManager, SparkSession sparkSession) {
        return clusterManager.getBuildTrackingUrl(sparkSession);
    }

    private String tryReplaceHostAddress(String url) {
        String originHost = null;
        try {
            URI uri = URI.create(url);
            originHost = uri.getHost();
            String hostAddress = InetAddress.getByName(originHost).getHostAddress();
            return url.replace(originHost, hostAddress);
        }
        catch (UnknownHostException uhe) {
            logger.error("failed to get the ip address of {}, step back to use the origin tracking url.", (Object)originHost, (Object)uhe);
            return url;
        }
    }

    private Map<String, String> getTrackingInfo(SparkSession sparkSession, boolean ipAddressPreferred) {
        IClusterManager clusterManager = this.atomicBuildEnv.get().clusterManager();
        String applicationId = sparkSession.sparkContext().applicationId();
        HashMap<String, String> extraInfo = new HashMap<String, String>();
        extraInfo.put("yarn_app_id", applicationId);
        try {
            String trackingUrl = this.getTrackingUrl(clusterManager, sparkSession);
            if (StringUtils.isBlank((String)trackingUrl)) {
                logger.warn("Get tracking url of application {}, but empty url found.", (Object)applicationId);
                return extraInfo;
            }
            if (ipAddressPreferred) {
                trackingUrl = this.tryReplaceHostAddress(trackingUrl);
            }
            extraInfo.put("yarn_app_url", trackingUrl);
        }
        catch (Exception e) {
            logger.error("get tracking url failed!", (Throwable)e);
        }
        return extraInfo;
    }

    protected void exchangeSparkSession() {
        this.exchangeSparkSession(this.atomicSparkConf.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void execute() throws Exception {
        String hdfsMetalUrl = this.getParam("distMetaUrl");
        this.jobId = this.getParam("jobId");
        this.project = this.getParam("project");
        if (this.getParam("layoutIds") != null) {
            this.layoutSize = StringUtils.split((String)this.getParam("layoutIds"), (String)",").length;
        }
        try (KylinConfig.SetAndUnsetThreadLocalConfig autoCloseConfig = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)KylinConfig.loadKylinConfigFromHdfs((String)hdfsMetalUrl));){
            this.config = autoCloseConfig.get();
            this.report = (IJobProgressReport)ClassUtil.newInstance((String)this.config.getBuildJobProgressReporter());
            this.report.initArgsParams(this.getParams());
            KylinBuildEnv buildEnv = KylinBuildEnv.getOrCreate(this.config);
            this.atomicBuildEnv.set(buildEnv);
            this.infos = buildEnv.buildJobInfos();
            this.infos.recordJobId(this.jobId);
            this.infos.recordProject(this.project);
            this.infos.recordJobStepId(System.getProperty("spark.driver.param.taskId", this.jobId));
            this.monitorSparkMaster();
            HadoopUtil.setCurrentConfiguration((Configuration)new Configuration());
            this.exchangeSparkConf(buildEnv.sparkConf());
            TimeZoneUtils.setDefaultTimeZone((KylinConfig)this.config);
            this.waiteForResource(this.atomicSparkConf.get(), buildEnv);
            logger.info("Prepare job environment");
            this.prepareSparkSession();
            this.ss = this.getSparkSession();
            String master = this.ss.conf().get("spark.master", "");
            if (!master.equals("local")) {
                EnviromentAdaptor adaptor = (EnviromentAdaptor)ClassUtil.newInstance((String)this.config.getBuildJobEnviromentAdaptor());
                adaptor.prepareEnviroment(this.ss, this.params);
            }
            if (this.config.useDynamicS3RoleCredentialInTable()) {
                NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)this.config, (String)this.project);
                tableMetadataManager.listAllTables().forEach(tableDesc -> SparderEnv.addS3Credential((TableExtDesc.S3RoleCredentialInfo)tableMetadataManager.getOrCreateTableExt(tableDesc).getS3RoleCredentialInfo(), (SparkSession)this.ss));
            }
            if (!this.config.isUTEnv()) {
                Unsafe.setProperty((String)"kylin.env", (String)this.config.getDeployEnv());
            }
            logger.info("Start job");
            this.infos.startJob();
            this.extraInit();
            this.waiteForResourceSuccess();
            this.doExecute();
            ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)this.config);
            KylinConfig outputConfig = KylinConfig.createKylinConfig((KylinConfig)this.config);
            outputConfig.setMetadataUrl(this.getParam("outputMetaUrl"));
            MetadataStore.createMetadataStore((KylinConfig)outputConfig).dump(resourceStore);
        }
        catch (Exception e) {
            this.handleException(e);
        }
        finally {
            if (this.infos != null) {
                this.infos.jobEnd();
            }
            this.destroySparkSession();
            this.extraDestroy();
            this.executeFinish();
        }
    }

    protected void handleException(Exception e) throws Exception {
        Throwable rootCause;
        if (e instanceof AccessControlException) {
            this.interceptAccessControlException(e);
        }
        if (e instanceof RuntimeException && e.getCause() instanceof AccessControlException) {
            this.interceptAccessControlException(e.getCause());
        } else if (e instanceof RuntimeException && e.getCause() instanceof SparkException && (rootCause = this.extractRealRootCauseFromSparkException(e)) instanceof AccessControlException) {
            this.interceptAccessControlException(e);
        }
        throw e;
    }

    protected Throwable extractRealRootCauseFromSparkException(Exception e) {
        Throwable rootCause = e.getCause();
        while (rootCause instanceof SparkException) {
            rootCause = rootCause.getCause();
        }
        return rootCause;
    }

    protected void interceptAccessControlException(Throwable e) throws NoRetryException {
        logger.error("Permission denied.", e);
        throw new NoRetryException("Permission denied.");
    }

    private SparkSession createSpark(SparkConf sparkConf) {
        boolean createWithSparkSession;
        SparkSession.Builder sessionBuilder = SparkSession.builder().withExtensions((Function1)new AbstractFunction1<SparkSessionExtensions, BoxedUnit>(){

            public BoxedUnit apply(SparkSessionExtensions v1) {
                v1.injectPostHocResolutionRule((Function1)new AbstractFunction1<SparkSession, Rule<LogicalPlan>>(){

                    public Rule<LogicalPlan> apply(SparkSession session) {
                        return new AlignmentTableStats(session);
                    }
                });
                return BoxedUnit.UNIT;
            }
        }).enableHiveSupport().config(sparkConf).config("mapreduce.fileoutputcommitter.marksuccessfuljobs", "false");
        boolean bl = createWithSparkSession = !this.isJobOnCluster(sparkConf) && SparderEnv.isSparkAvailable();
        if (createWithSparkSession) {
            boolean isKylinSession = SparderEnv.getSparkSession() instanceof KylinSession;
            boolean bl2 = createWithSparkSession = !isKylinSession;
        }
        if (createWithSparkSession) {
            return sessionBuilder.getOrCreate();
        }
        return KylinSession$.MODULE$.KylinBuilder(sessionBuilder).buildCluster().getOrCreateKylinSession();
    }

    public boolean isJobOnCluster(SparkConf conf) {
        return !Utils.isLocalMaster((SparkConf)conf) && !this.config.isUTEnv();
    }

    protected void extraInit() {
        this.loadLogicalView();
    }

    public void extraDestroy() {
        if (this.clusterMonitor != null) {
            this.clusterMonitor.shutdown();
        }
    }

    protected abstract void doExecute() throws Exception;

    protected void onLayoutFinished(long layoutId) {
    }

    protected void onExecuteFinished() {
    }

    protected String calculateRequiredCores() throws Exception {
        return "1";
    }

    private void autoSetSparkConf(SparkConf sparkConf) throws Exception {
        SparkConfHelper helper = new SparkConfHelper();
        if (sparkConf.getAll() != null) {
            Arrays.stream(sparkConf.getAll()).forEach(config -> helper.setConf((String)config._1, (String)config._2));
        }
        helper.setClusterManager(KylinBuildEnv.get().clusterManager());
        this.chooseContentSize(helper);
        helper.setOption("layout_size", Integer.toString(this.layoutSize));
        helper.setOption("required_cores", this.calculateRequiredCores());
        helper.setConf("count_distinct", this.hasCountDistinct().toString());
        helper.generateSparkConf();
        helper.applySparkConf(sparkConf);
    }

    private void waiteForResource(SparkConf sparkConf, KylinBuildEnv buildEnv) throws Exception {
        StageExec waiteForResource = StageType.WAITE_FOR_RESOURCE.create(this, null, null);
        this.infos.recordStageId(waiteForResource.getId());
        waiteForResource.execute();
    }

    protected void waiteForResourceSuccess() throws Exception {
        StageExec waiteForResource = StageType.WAITE_FOR_RESOURCE.create(this, null, null);
        waiteForResource.onStageFinished(true);
        this.infos.recordStageId("");
    }

    protected void executeFinish() {
        try {
            this.getReport().executeFinish(this.getReportParams(), this.project, this.getJobId());
        }
        catch (Exception e) {
            logger.error("executeFinish failed", (Throwable)e);
        }
    }

    protected void chooseContentSize(SparkConfHelper helper) {
        Path shareDir = this.config.getJobTmpShareDir(this.project, this.jobId);
        helper.setOption("source_table_size", this.chooseContentSize(shareDir));
    }

    protected boolean checkRangePartitionTableIsExist(NDataModel modelDesc) {
        return modelDesc.getAllTableRefs().stream().anyMatch(p -> p.getTableDesc().isRangePartition());
    }

    protected String chooseContentSize(Path shareDir) {
        return ResourceDetectUtils.getMaxResourceSize((Path)shareDir) + "b";
    }

    protected Boolean hasCountDistinct() throws IOException {
        Boolean exist;
        Path countDistinct = new Path(this.config.getJobTmpShareDir(this.project, this.jobId), ResourceDetectUtils.countDistinctSuffix());
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        if (fileSystem.exists(countDistinct)) {
            exist = (Boolean)ResourceDetectUtils.readResourcePathsAs((Path)countDistinct);
        } else {
            exist = false;
            logger.info("File count_distinct.json doesn't exist, set hasCountDistinct to false.");
        }
        logger.info("Exist count distinct measure: {}", (Object)exist);
        return exist;
    }

    public void logJobInfo() {
        try {
            logger.info(this.generateInfo());
            if (KylinConfig.getInstanceFromEnv().skipRecordJobExecutionTime()) {
                logger.info("skip record job wait and run time");
                return;
            }
            HashMap<String, String> extraInfo = new HashMap<String, String>();
            extraInfo.put("yarn_job_wait_time", Long.valueOf(KylinBuildEnv.get().buildJobInfos().waitTime()).toString());
            extraInfo.put("yarn_job_run_time", Long.valueOf(KylinBuildEnv.get().buildJobInfos().buildTime()).toString());
            this.getReport().updateSparkJobExtraInfo(this.getReportParams(), "/kylin/api/jobs/wait_and_run_time", this.project, this.jobId, extraInfo);
        }
        catch (Exception e) {
            logger.warn("Error occurred when generate job info.", (Throwable)e);
        }
    }

    private Map<String, String> getReportParams() {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("time_out", String.valueOf(this.config.getUpdateJobInfoTimeout()));
        reportParams.put("job_tmp_dir", this.config.getJobTmpDir(this.project, true));
        return reportParams;
    }

    protected String generateInfo() {
        return LogJobInfoUtils.sparkApplicationInfo();
    }

    public Set<String> getIgnoredSnapshotTables() {
        return NSparkCubingUtil.toIgnoredTableSet((String)this.getParam("ignoredSnapshotTables"));
    }

    protected Map<String, String> getSparkConfigOverride(KylinConfig config) {
        return config.getSparkConfigOverride();
    }

    protected void checkDateFormatIfExist(String project, String modelId) throws Exception {
        if (this.config.isUTEnv()) {
            return;
        }
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)this.config, (String)project);
        NDataModel modelDesc = modelManager.getDataModelDesc(modelId);
        if (this.checkRangePartitionTableIsExist(modelDesc)) {
            logger.info("Range partitioned tables do not support pushdown, so do not need to perform subsequent logic");
            return;
        }
        PartitionDesc partitionDesc = modelDesc.getPartitionDesc();
        if (PartitionDesc.isEmptyPartitionDesc((PartitionDesc)partitionDesc) || StringUtils.isEmpty((String)partitionDesc.getPartitionDateFormat())) {
            return;
        }
        if (CatalogTableType.VIEW().name().equals(modelDesc.getRootFactTable().getTableDesc().getTableType())) {
            return;
        }
        String partitionColumn = modelDesc.getPartitionDesc().getPartitionDateColumnRef().getExpressionInSourceDB();
        SparkSession sparkSession = this.atomicSparkSession.get();
        try (SparkSubmitter.OverriddenSparkSession ignored2 = SparkSubmitter.getInstance().overrideSparkSession(sparkSession);){
            String dateString = PushDownUtil.getFormatIfNotExist((String)modelDesc.getRootFactTableName(), (String)partitionColumn, (String)project);
            SimpleDateFormat sdf = new SimpleDateFormat(modelDesc.getPartitionDesc().getPartitionDateFormat(), Locale.getDefault(Locale.Category.FORMAT));
            Date date = sdf.parse(dateString);
            if (date == null || !dateString.equals(sdf.format(date))) {
                throw new NoRetryException("date format not match");
            }
        }
        catch (KylinException ignored2) {
        }
        catch (ParseException | NoRetryException e) {
            throw new NoRetryException("date format not match");
        }
    }

    private void exchangeSparkConf(SparkConf sparkConf) throws Exception {
        if (this.isJobOnCluster(sparkConf) && !(this instanceof ResourceDetect)) {
            Map<String, String> baseSparkConf = this.getSparkConfigOverride(this.config);
            if (!baseSparkConf.isEmpty()) {
                baseSparkConf.forEach((arg_0, arg_1) -> ((SparkConf)sparkConf).set(arg_0, arg_1));
                String baseSparkConfStr = JsonUtil.writeValueAsString(baseSparkConf);
                logger.info("Override user-defined spark conf: {}", (Object)baseSparkConfStr);
            }
            if (this.config.isAutoSetSparkConf()) {
                logger.info("Set spark conf automatically.");
                try {
                    this.autoSetSparkConf(sparkConf);
                }
                catch (Exception e) {
                    logger.warn("Auto set spark conf failed. Load spark conf from system properties", (Throwable)e);
                }
            }
        }
        this.atomicSparkConf.set(sparkConf);
    }

    private void exchangeSparkSession(SparkConf sparkConf) {
        SparkSession sparkSession = this.atomicSparkSession.get();
        if (Objects.nonNull(sparkSession)) {
            this.destroySparkSession();
        }
        sparkSession = this.createSpark(sparkConf);
        if (!this.config.isUTEnv() && !sparkConf.get("spark.master").startsWith("k8s")) {
            this.getReport().updateSparkJobExtraInfo(this.getReportParams(), "/kylin/api/jobs/spark", this.project, this.jobId, this.getTrackingInfo(sparkSession, this.config.isTrackingUrlIpAddressEnabled()));
        }
        JobMetricsUtils.registerListener((SparkSession)sparkSession);
        SparderEnv.registerListener((SparkContext)sparkSession.sparkContext());
        SparderEnv.setSparkSession((SparkSession)sparkSession);
        UdfManager.create(sparkSession);
        this.atomicSparkSession.set(sparkSession);
    }

    private void prepareSparkSession() throws NoRetryException {
        SparkConf sparkConf = this.atomicSparkConf.get();
        if (Objects.isNull(sparkConf)) {
            throw new NoRetryException("spark conf shouldn't be null");
        }
        if (this.config.isSnapshotSpecifiedSparkConf() && this instanceof SegmentBuildJob) {
            SparkConf clonedSparkConf = sparkConf.clone();
            Map snapshotSparkConf = this.config.getSnapshotBuildingConfigOverride();
            snapshotSparkConf.forEach((arg_0, arg_1) -> ((SparkConf)clonedSparkConf).set(arg_0, arg_1));
            logger.info("exchange sparkSession using snapshot specified sparkConf");
            this.exchangeSparkSession(clonedSparkConf);
            return;
        }
        this.exchangeSparkSession(sparkConf);
    }

    private void destroySparkSession() {
        SparkSession sparkSession = this.atomicSparkSession.get();
        if (Objects.isNull(sparkSession)) {
            logger.info("no initialized sparkSession instance");
            return;
        }
        if (sparkSession.conf().get("spark.master").startsWith("local")) {
            return;
        }
        JobMetricsUtils.unRegisterListener((SparkSession)sparkSession);
        sparkSession.stop();
    }

    private void monitorSparkMaster() {
        this.clusterMonitor = new ClusterMonitor();
        this.clusterMonitor.monitorSparkMaster(this.atomicBuildEnv, this.atomicSparkSession, this.atomicDisconnectSparkMasterTimes, this.atomicUnreachableSparkMaster);
    }

    @VisibleForTesting
    public void loadLogicalView() {
        LogicalView view2;
        if (!this.config.isDDLLogicalViewEnabled()) {
            return;
        }
        String dataflowId = this.getParam("dataflowId");
        String tableName = this.getParam("table");
        LogicalViewManager viewManager = LogicalViewManager.getInstance((KylinConfig)this.config);
        if (StringUtils.isNotBlank((String)dataflowId)) {
            viewManager.findLogicalViewsInModel(this.project, dataflowId).forEach(view -> LogicalViewLoader.loadView((String)view.getTableName(), (boolean)true, (SparkSession)this.ss));
        }
        if (StringUtils.isNotBlank((String)tableName) && (view2 = viewManager.findLogicalViewInProject(this.getProject(), tableName)) != null) {
            LogicalViewLoader.loadView((String)view2.getTableName(), (boolean)true, (SparkSession)this.ss);
        }
    }
}

