/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import it.unimi.dsi.fastutil.objects.Object2LongMap;
import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import javax.security.auth.login.Configuration;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.builder.DictionaryBuilderHelper;
import org.apache.kylin.engine.spark.builder.ZKJaasConfiguration;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.utils.LogEx;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.SparkConf;
import org.apache.spark.TaskContext$;
import org.apache.spark.application.NoRetryException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.dict.NBucketDictionary;
import org.apache.spark.dict.NGlobalDictionaryV2;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Ee\u0001\u0002\n\u0014\u0001\u0001B\u0001\u0002\r\u0001\u0003\u0006\u0004%\t!\r\u0005\ty\u0001\u0011\t\u0011)A\u0005e!AQ\b\u0001BC\u0002\u0013\u0005a\b\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003@\u0011!q\u0005A!b\u0001\n\u0003y\u0005\u0002C*\u0001\u0005\u0003\u0005\u000b\u0011\u0002)\t\u0011Q\u0003!Q1A\u0005\u0002UC\u0001b\u0019\u0001\u0003\u0002\u0003\u0006IA\u0016\u0005\u0006I\u0002!\t!\u001a\u0005\u0006Y\u0002!\t!\u001c\u0005\n\u0003\u0007\u0002!\u0019!C\u0005\u0003'Aq!!\u0012\u0001A\u0003%A\u0010\u0003\u0004\u0002H\u0001!I!\u001c\u0005\t\u0003\u0013\u0002A\u0011A\n\u0002L!A\u0011Q\f\u0001\u0005\u0002M\ty\u0006C\u0004\u0002~\u0001!I!a \t\u000f\u0005\u0015\u0005\u0001\"\u0001\u0002\b\n\u0019BI\u0012#jGRLwN\\1ss\n+\u0018\u000e\u001c3fe*\u0011A#F\u0001\bEVLG\u000eZ3s\u0015\t1r#A\u0003ta\u0006\u00148N\u0003\u0002\u00193\u00051QM\\4j]\u0016T!AG\u000e\u0002\u000b-LH.\u001b8\u000b\u0005qi\u0012AB1qC\u000eDWMC\u0001\u001f\u0003\ry'oZ\u0002\u0001'\u0011\u0001\u0011eJ\u0017\u0011\u0005\t*S\"A\u0012\u000b\u0003\u0011\nQa]2bY\u0006L!AJ\u0012\u0003\r\u0005s\u0017PU3g!\tA3&D\u0001*\u0015\tQS#A\u0003vi&d7/\u0003\u0002-S\t)Aj\\4FqB\u0011!EL\u0005\u0003_\r\u0012AbU3sS\u0006d\u0017N_1cY\u0016\fq\u0001Z1uCN,G/F\u00013!\r\u0019t'O\u0007\u0002i)\u0011QGN\u0001\u0004gFd'B\u0001\f\u001c\u0013\tADGA\u0004ECR\f7/\u001a;\u0011\u0005MR\u0014BA\u001e5\u0005\r\u0011vn^\u0001\tI\u0006$\u0018m]3uA\u0005\u00191/Z4\u0016\u0003}\u0002\"\u0001Q$\u000e\u0003\u0005S!AQ\"\u0002\u000b5|G-\u001a7\u000b\u0005\u0011+\u0015\u0001B2vE\u0016T!AR\r\u0002\u00115,G/\u00193bi\u0006L!\u0001S!\u0003\u00199#\u0015\r^1TK\u001elWM\u001c;\u0002\tM,w\r\t\u0015\u0003\t-\u0003\"A\t'\n\u00055\u001b#!\u0003;sC:\u001c\u0018.\u001a8u\u0003\t\u00198/F\u0001Q!\t\u0019\u0014+\u0003\u0002Si\ta1\u000b]1sWN+7o]5p]\u0006\u00191o\u001d\u0011\u0002\u0013\r|GNU3g'\u0016$X#\u0001,\u0011\u0007]cf,D\u0001Y\u0015\tI&,\u0001\u0003vi&d'\"A.\u0002\t)\fg/Y\u0005\u0003;b\u00131aU3u!\ty\u0016-D\u0001a\u0015\t\u0011U)\u0003\u0002cA\nIAK\u00197D_2\u0014VMZ\u0001\u000bG>d'+\u001a4TKR\u0004\u0013A\u0002\u001fj]&$h\bF\u0003gQ&T7\u000e\u0005\u0002h\u00015\t1\u0003C\u00031\u0013\u0001\u0007!\u0007C\u0003>\u0013\u0001\u0007q\bC\u0003O\u0013\u0001\u0007\u0001\u000bC\u0003U\u0013\u0001\u0007a+\u0001\u0007ck&dG\rR5diN+G\u000fF\u0001o!\t\u0011s.\u0003\u0002qG\t!QK\\5uQ\rQ!o\u001f\t\u0004EM,\u0018B\u0001;$\u0005\u0019!\bN]8xgB\u0011a/_\u0007\u0002o*\u0011\u0001PW\u0001\u0003S>L!A_<\u0003\u0017%{U\t_2faRLwN\\\u0019\u0007=q\fy!!\u0011\u0011\u0007u\fIAD\u0002\u007f\u0003\u000b\u0001\"a`\u0012\u000e\u0005\u0005\u0005!bAA\u0002?\u00051AH]8pizJ1!a\u0002$\u0003\u0019\u0001&/\u001a3fM&!\u00111BA\u0007\u0005\u0019\u0019FO]5oO*\u0019\u0011qA\u00122\u0013\r\n\t\"!\u0007\u00028\u0005mQ\u0003BA\n\u0003+)\u0012\u0001 \u0003\b\u0003/y\"\u0019AA\u0011\u0005\u0005!\u0016\u0002BA\u000e\u0003;\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n$bAA\u0010G\u00051A\u000f\u001b:poN\fB!a\t\u0002*A\u0019!%!\n\n\u0007\u0005\u001d2EA\u0004O_RD\u0017N\\4\u0011\t\u0005-\u0012\u0011\u0007\b\u0004E\u00055\u0012bAA\u0018G\u00059\u0001/Y2lC\u001e,\u0017\u0002BA\u001a\u0003k\u0011\u0011\u0002\u00165s_^\f'\r\\3\u000b\u0007\u0005=2%M\u0005$\u0003s\tY$!\u0010\u0002 9\u0019!%a\u000f\n\u0007\u0005}1%M\u0003#E\r\nyDA\u0003tG\u0006d\u0017-\r\u0002'k\u0006a\u0011,\u0011*O?\u000ecUk\u0015+F%\u0006i\u0011,\u0011*O?\u000ecUk\u0015+F%\u0002\na\u0003\u001e:z5.S\u0015-Y:D_:4\u0017nZ;sCRLwN\\\u0001\ng\u00064WMQ;jY\u0012$2A\\A'\u0011\u0019\tyE\u0004a\u0001=\u0006\u0019!/\u001a4)\t9\u0011\u00181K\u0019\u0007=q\f)&a\u00172\u0013\r\n\t\"!\u0007\u0002X\u0005m\u0011'C\u0012\u0002:\u0005m\u0012\u0011LA\u0010c\u0015\u0011#eIA c\t1S/A\u0003ck&dG\rF\u0004o\u0003C\n\u0019'!\u001c\t\r\u0005=s\u00021\u0001_\u0011\u001d\t)g\u0004a\u0001\u0003O\n1CY;dW\u0016$\b+\u0019:uSRLwN\\*ju\u0016\u00042AIA5\u0013\r\tYg\t\u0002\u0004\u0013:$\bBBA8\u001f\u0001\u0007!'A\u0007bMR,'\u000fR5ti&t7\r\u001e\u0015\u0005\u001fI\f\u0019(\r\u0004\u001fy\u0006U\u00141P\u0019\nG\u0005E\u0011\u0011DA<\u00037\t\u0014bIA\u001d\u0003w\tI(a\b2\u000b\t\u00123%a\u00102\u0005\u0019*\u0018aC4fi2{7m\u001b)bi\"$2\u0001`AA\u0011\u0019\t\u0019\t\u0005a\u0001y\u0006A\u0001/\u0019;i\u001d\u0006lW-A\u0004xe\u0006\u00048i\u001c7\u0015\t\u0005%\u0015q\u0012\t\u0004g\u0005-\u0015bAAGi\t11i\u001c7v[:Da!a\u0014\u0012\u0001\u0004q\u0006")
public class DFDictionaryBuilder
implements LogEx,
scala.Serializable {
    private final Dataset<Row> dataset;
    private final transient NDataSegment seg;
    private final SparkSession ss;
    private final Set<TblColRef> colRefSet;
    private final String YARN_CLUSTER;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public <U> U logTime(String action, boolean debug, Function0<U> body) {
        return (U)LogEx.logTime$((LogEx)this, (String)action, (boolean)debug, body);
    }

    public <U> boolean logTime$default$2() {
        return LogEx.logTime$default$2$((LogEx)this);
    }

    public void logInfoIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logInfoIf$((LogEx)this, filter, msg);
    }

    public void logWarningIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logWarningIf$((LogEx)this, filter, msg);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> dataset() {
        return this.dataset;
    }

    public NDataSegment seg() {
        return this.seg;
    }

    public SparkSession ss() {
        return this.ss;
    }

    public Set<TblColRef> colRefSet() {
        return this.colRefSet;
    }

    public void buildDictSet() throws IOException {
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(this.colRefSet()).asScala()).foreach((Function1 & Serializable & scala.Serializable)col -> {
            this.safeBuild(col);
            return BoxedUnit.UNIT;
        });
    }

    private String YARN_CLUSTER() {
        return this.YARN_CLUSTER;
    }

    private void tryZKJaasConfiguration() {
        block0: {
            KapConfig kapConfig;
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            if (!this.YARN_CLUSTER().equals(config.getDeployMode()) || !"FI".equals((kapConfig = KapConfig.wrap((KylinConfig)config)).getKerberosPlatform()) && !"TDH".equals(kapConfig.getKerberosPlatform())) break block0;
            SparkConf sparkConf = this.ss().sparkContext().getConf();
            String principal = sparkConf.get("spark.kerberos.principal");
            String keytab = sparkConf.get("spark.kerberos.keytab");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("ZKJaasConfiguration principal: ").append(principal).append(", keyTab: ").append(keytab).toString());
            Configuration.setConfiguration(new ZKJaasConfiguration(principal, keytab));
        }
    }

    public void safeBuild(TblColRef ref) throws IOException {
        String sourceColumn = ref.getIdentity();
        this.tryZKJaasConfiguration();
        Lock lock = KylinConfig.getInstanceFromEnv().getDistributedLockFactory().getLockForCurrentThread(this.getLockPath(sourceColumn));
        lock.lock();
        try {
            Dataset dictColDistinct = this.dataset().select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{this.wrapCol(ref)})).distinct();
            this.ss().sparkContext().setJobDescription(new StringBuilder(22).append("Calculate bucket size ").append(ref.getIdentity()).toString());
            int bucketPartitionSize = BoxesRunTime.unboxToInt(this.logTime(new StringBuilder(28).append("calculating bucket size for ").append(sourceColumn).toString(), this.logTime$default$2(), (Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> DictionaryBuilderHelper.calculateBucketSize(this.seg(), ref, (Dataset<Row>)dictColDistinct)));
            this.build(ref, bucketPartitionSize, (Dataset<Row>)dictColDistinct);
        }
        finally {
            lock.unlock();
        }
    }

    public void build(TblColRef ref, int bucketPartitionSize, Dataset<Row> afterDistinct) throws IOException {
        this.logTime(new StringBuilder(36).append("building global dictionaries V2 for ").append(ref.getIdentity()).toString(), this.logTime$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                NGlobalDictionaryV2 globalDict = new NGlobalDictionaryV2(this.seg().getProject(), ref.getTable(), ref.getName(), this.seg().getConfig().getHdfsWorkingDirectory());
                globalDict.prepareWrite();
                Broadcast broadcastDict = this.ss().sparkContext().broadcast((Object)globalDict, ClassTag$.MODULE$.apply(NGlobalDictionaryV2.class));
                this.ss().sparkContext().setJobDescription(new StringBuilder(11).append("Build dict ").append(ref.getIdentity()).toString());
                Column dictCol = functions$.MODULE$.col(((StructField)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])afterDistinct.schema().fields())).head()).name());
                afterDistinct.filter(dictCol.isNotNull()).repartition(bucketPartitionSize, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{dictCol})).foreachPartition((Function1 & Serializable & scala.Serializable)iter -> {
                    DFDictionaryBuilder.$anonfun$build$2(this, ref, broadcastDict, iter);
                    return BoxedUnit.UNIT;
                });
                globalDict.writeMetaDict(bucketPartitionSize, this.seg().getConfig().getGlobalDictV2MaxVersions(), this.seg().getConfig().getGlobalDictV2VersionTTL());
                if (!this.seg().getConfig().isGlobalDictCheckEnabled()) break block0;
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(65).append("Start to check the correctness of the global dict, table: ").append(ref.getTableAlias()).append(", col: ").append(ref.getName()).toString());
                NGlobalDictionaryV2 latestGD = new NGlobalDictionaryV2(this.seg().getProject(), ref.getTable(), ref.getName(), this.seg().getConfig().getHdfsWorkingDirectory());
                RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), globalDict.getMetaInfo().getBucketSize()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)bid -> {
                    Object2LongMap dMap = latestGD.loadBucketDictionary(bid).getAbsoluteDictMap();
                    long vdCount = dMap.values().stream().distinct().count();
                    long kdCount = dMap.keySet().stream().distinct().count();
                    if (kdCount != vdCount) {
                        this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Global dict correctness check failed, table: ").append(ref.getTableAlias()).append(", col: ").append(ref.getName()).toString());
                        throw new NoRetryException(new StringBuilder(78).append("Global dict build error, bucket: ").append(bid).append(", key distinct count:").append(kdCount).append(", value distinct count: ").append(vdCount).toString());
                    }
                });
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(55).append("Global dict correctness check completed, table: ").append(ref.getTableAlias()).append(", col: ").append(ref.getName()).toString());
            }
        });
    }

    private String getLockPath(String pathName) {
        return new StringBuilder(24).append("/").append(this.seg().getProject()).append("/dict/global_dict").append("/").append(pathName).append("/lock").toString();
    }

    public Column wrapCol(TblColRef ref) {
        String colName = NSparkCubingUtil.convertFromDot((String)ref.getBackTickIdentity());
        return functions$.MODULE$.expr(colName).cast((DataType)StringType$.MODULE$);
    }

    public static final /* synthetic */ void $anonfun$build$2(DFDictionaryBuilder $this, TblColRef ref$2, Broadcast broadcastDict$1, Iterator iter) {
        int partitionID = TaskContext$.MODULE$.get().partitionId();
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Build partition dict col: ").append(ref$2.getIdentity()).append(", partitionId: ").append(partitionID).toString());
        NGlobalDictionaryV2 broadcastGlobalDict = (NGlobalDictionaryV2)broadcastDict$1.value();
        NBucketDictionary bucketDict = broadcastGlobalDict.loadBucketDictionary(partitionID);
        iter.foreach((Function1 & Serializable & scala.Serializable)r -> {
            bucketDict.addRelativeValue(r.getString(0));
            return BoxedUnit.UNIT;
        });
        bucketDict.saveBucketDict(partitionID);
    }

    public DFDictionaryBuilder(Dataset<Row> dataset, NDataSegment seg, SparkSession ss, Set<TblColRef> colRefSet) {
        this.dataset = dataset;
        this.seg = seg;
        this.ss = ss;
        this.colRefSet = colRefSet;
        Logging.$init$((Logging)this);
        LogEx.$init$((LogEx)this);
        this.YARN_CLUSTER = "cluster";
    }
}

