/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.io.Serializable;
import java.util.Set;
import org.apache.kylin.engine.spark.builder.DFBuilderHelper$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.dict.NGlobalDictionaryV2;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.KapFunctions$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple5;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Seq$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class DFTableEncoder$
implements Logging {
    public static DFTableEncoder$ MODULE$;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DFTableEncoder$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Dataset<Row> encodeTable(Dataset<Row> ds, NDataSegment seg, Set<TblColRef> cols) {
        StructType structType = ds.schema();
        ObjectRef partitionedDs = ObjectRef.create(ds);
        ds.sparkSession().sparkContext().setJobDescription("Encode count source data.");
        long sourceCnt = ds.count();
        int bucketThreshold = seg.getConfig().getGlobalDictV2ThresholdBucketSize();
        long minBucketSize = sourceCnt / (long)bucketThreshold;
        scala.collection.mutable.Set encodingCols = Set$.MODULE$.empty();
        if (seg.getIndexPlan().isSkipEncodeIntegerFamilyEnabled()) {
            encodingCols = (scala.collection.mutable.Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(cols).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DFTableEncoder$.$anonfun$encodeTable$1(x$1)));
            Seq noEncodeCols = ((SetLike)((scala.collection.SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(cols).asScala()).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)DFTableEncoder$.$anonfun$encodeTable$2(x$2)))).map((Function1 & Serializable & scala.Serializable)ref -> {
                String encodeColRef = NSparkCubingUtil.convertFromDot((String)ref.getBackTickIdentity());
                String aliasName = encodeColRef.concat(DFBuilderHelper$.MODULE$.ENCODE_SUFFIX());
                return functions$.MODULE$.col(encodeColRef).cast((DataType)LongType$.MODULE$).as(aliasName);
            }, Set$.MODULE$.canBuildFrom())).toSeq();
            partitionedDs.elem = ((Dataset)partitionedDs.elem).select((Seq)((TraversableLike)((Dataset)partitionedDs.elem).schema().map((Function1 & Serializable & scala.Serializable)ty -> functions$.MODULE$.col(ty.name()), scala.collection.Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)noEncodeCols, scala.collection.Seq$.MODULE$.canBuildFrom()));
        } else {
            encodingCols = (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(cols).asScala();
        }
        scala.collection.mutable.Set encodingArgs = (scala.collection.mutable.Set)encodingCols.map((Function1 & Serializable & scala.Serializable)ref -> {
            Column encodeCol;
            NGlobalDictionaryV2 globalDict = new NGlobalDictionaryV2(seg.getProject(), ref.getTable(), ref.getName(), seg.getConfig().getHdfsWorkingDirectory());
            int bucketSize = globalDict.getBucketSizeOrDefault(seg.getConfig().getGlobalDictV2MinHashPartitions());
            int enlargedBucketSize = (int)((minBucketSize / (long)bucketSize + 1L) * (long)bucketSize);
            String encodeColRef = NSparkCubingUtil.convertFromDot((String)ref.getBackTickIdentity());
            int columnIndex = structType.fieldIndex(encodeColRef);
            String dictParams = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new String[]{seg.getProject(), ref.getTable(), ref.getName(), seg.getConfig().getHdfsWorkingDirectory()})).mkString("_0_DOT_0_");
            String aliasName = structType.apply(columnIndex).name().concat(DFBuilderHelper$.MODULE$.ENCODE_SUFFIX());
            Column columns = encodeCol = KapFunctions$.MODULE$.dict_encode(functions$.MODULE$.col(encodeColRef).cast((DataType)StringType$.MODULE$), functions$.MODULE$.lit((Object)dictParams), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)bucketSize)).cast((DataType)StringType$.MODULE$)).as(aliasName);
            return new Tuple5((Object)BoxesRunTime.boxToInteger((int)enlargedBucketSize), (Object)functions$.MODULE$.col(encodeColRef).cast((DataType)StringType$.MODULE$), (Object)columns, (Object)aliasName, (Object)BoxesRunTime.boxToBoolean((bucketSize == 1 ? 1 : 0) != 0));
        }, Set$.MODULE$.canBuildFrom());
        encodingArgs.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            DFTableEncoder$.$anonfun$encodeTable$6(partitionedDs, x0$1);
            return BoxedUnit.UNIT;
        });
        ds.sparkSession().sparkContext().setJobDescription(null);
        return (Dataset)partitionedDs.elem;
    }

    public static final /* synthetic */ boolean $anonfun$encodeTable$1(TblColRef x$1) {
        return x$1.getType().isIntegerFamily();
    }

    public static final /* synthetic */ boolean $anonfun$encodeTable$2(TblColRef x$2) {
        return x$2.getType().isIntegerFamily();
    }

    /*
     * Enabled aggressive block sorting
     */
    public static final /* synthetic */ void $anonfun$encodeTable$6(ObjectRef partitionedDs$1, Tuple5 x0$1) {
        Tuple5 tuple5 = x0$1;
        if (tuple5 != null) {
            int enlargedBucketSize = BoxesRunTime.unboxToInt((Object)tuple5._1());
            Column repartitionColumn = (Column)tuple5._2();
            Column projects = (Column)tuple5._3();
            boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
            if (!bl) {
                partitionedDs$1.elem = ((Dataset)partitionedDs$1.elem).repartition(enlargedBucketSize, (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{repartitionColumn})).select((Seq)((TraversableLike)((Dataset)partitionedDs$1.elem).schema().map((Function1 & Serializable & scala.Serializable)ty -> functions$.MODULE$.col(ty.name()), scala.collection.Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{projects})), scala.collection.Seq$.MODULE$.canBuildFrom()));
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                return;
            }
        }
        if (tuple5 == null) throw new MatchError((Object)tuple5);
        Column projects = (Column)tuple5._3();
        boolean bl = BoxesRunTime.unboxToBoolean((Object)tuple5._5());
        if (true != bl) throw new MatchError((Object)tuple5);
        partitionedDs$1.elem = ((Dataset)partitionedDs$1.elem).select((Seq)((TraversableLike)((Dataset)partitionedDs$1.elem).schema().map((Function1 & Serializable & scala.Serializable)ty -> functions$.MODULE$.col(ty.name()), scala.collection.Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{projects})), scala.collection.Seq$.MODULE$.canBuildFrom()));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private DFTableEncoder$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

