/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import com.google.common.base.Preconditions;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NBuildSourceInfo {
    protected static final Logger logger = LoggerFactory.getLogger(NBuildSourceInfo.class);
    private Dataset<Row> flattableDS;
    private String viewFactTablePath;
    private SparkSession ss;
    private long byteSize;
    private long count;
    private long layoutId;
    private Dataset<Row> parentDF;
    private Collection<IndexEntity> toBuildCuboids = new LinkedHashSet<IndexEntity>();
    private List<TblColRef> allColumns;

    public List<TblColRef> getAllColumns() {
        return this.allColumns;
    }

    public void setAllColumns(List<TblColRef> allColumns) {
        this.allColumns = allColumns;
    }

    public long getByteSize() {
        return this.byteSize;
    }

    public void setByteSize(long byteSize) {
        this.byteSize = byteSize;
    }

    public Dataset<Row> getFlattableDS() {
        return this.flattableDS;
    }

    public void setFlattableDS(Dataset<Row> flattableDS) {
        this.flattableDS = flattableDS;
    }

    public Dataset<Row> getParentDS() {
        if (this.parentDF != null) {
            Preconditions.checkNotNull((Object)this.ss, (Object)"SparkSession is null is NBuildSourceInfo.");
            return this.parentDF;
        }
        Preconditions.checkState((this.flattableDS != null ? 1 : 0) != 0, (Object)"Path and DS can no be empty at the same time.");
        logger.info("parent storage path not exists, use flattable dataset.");
        return this.flattableDS;
    }

    public void setSparkSession(SparkSession ss) {
        this.ss = ss;
    }

    public String getViewFactTablePath() {
        return this.viewFactTablePath;
    }

    public void setViewFactTablePath(String viewFactTablePath) {
        this.viewFactTablePath = viewFactTablePath;
    }

    public long getCount() {
        return this.count;
    }

    public void setCount(long count) {
        this.count = count;
    }

    public long getLayoutId() {
        return this.layoutId;
    }

    public void setLayoutId(long layoutId) {
        this.layoutId = layoutId;
    }

    public Collection<IndexEntity> getToBuildCuboids() {
        return this.toBuildCuboids;
    }

    public void setToBuildCuboids(Collection<IndexEntity> toBuildCuboids) {
        this.toBuildCuboids = toBuildCuboids;
    }

    public void addCuboid(IndexEntity cuboid) {
        this.toBuildCuboids.add(cuboid);
    }

    public void setParentStorageDF(Dataset<Row> parentDF) {
        this.parentDF = parentDF;
    }
}

