/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.engine.spark.builder.SegmentFlatTable;
import org.apache.kylin.engine.spark.model.PartitionFlatTableDesc;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u001d3A\u0001C\u0005\u0001-!A1\u0004\u0001BC\u0002\u0013%A\u0004\u0003\u0005%\u0001\t\u0005\t\u0015!\u0003\u001e\u0011!)\u0003A!b\u0001\n\u00131\u0003\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0014\t\u000b9\u0002A\u0011A\u0018\t\u000bM\u0002A\u0011\u000b\u001b\t\u000bu\u0002A\u0011\u0001 \u0003%A\u000b'\u000f^5uS>tg\t\\1u)\u0006\u0014G.\u001a\u0006\u0003\u0015-\tqAY;jY\u0012,'O\u0003\u0002\r\u001b\u0005)1\u000f]1sW*\u0011abD\u0001\u0007K:<\u0017N\\3\u000b\u0005A\t\u0012!B6zY&t'B\u0001\n\u0014\u0003\u0019\t\u0007/Y2iK*\tA#A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001/A\u0011\u0001$G\u0007\u0002\u0013%\u0011!$\u0003\u0002\u0011'\u0016<W.\u001a8u\r2\fG\u000fV1cY\u0016\fAb\u001d9be.\u001cVm]:j_:,\u0012!\b\t\u0003=\tj\u0011a\b\u0006\u0003A\u0005\n1a]9m\u0015\ta\u0011#\u0003\u0002$?\ta1\u000b]1sWN+7o]5p]\u0006i1\u000f]1sWN+7o]5p]\u0002\n\u0011\u0002^1cY\u0016$Um]2\u0016\u0003\u001d\u0002\"\u0001K\u0016\u000e\u0003%R!AK\u0006\u0002\u000b5|G-\u001a7\n\u00051J#A\u0006)beRLG/[8o\r2\fG\u000fV1cY\u0016$Um]2\u0002\u0015Q\f'\r\\3EKN\u001c\u0007%\u0001\u0004=S:LGO\u0010\u000b\u0004aE\u0012\u0004C\u0001\r\u0001\u0011\u0015YR\u00011\u0001\u001e\u0011\u0015)S\u00011\u0001(\u0003I\t\u0007\u000f\u001d7z!\u0006\u0014H/\u001b;j_:$Um]2\u0015\u0005UZ\u0004c\u0001\u00107q%\u0011qg\b\u0002\b\t\u0006$\u0018m]3u!\tq\u0012(\u0003\u0002;?\t\u0019!k\\<\t\u000bq2\u0001\u0019A\u001b\u0002\u0011=\u0014\u0018nZ5o\tN\u000babZ3u!\u0006\u0014H/\u001b;j_:$5\u000b\u0006\u00026\u007f!)\u0001i\u0002a\u0001\u0003\u0006Y\u0001/\u0019:uSRLwN\\%e!\t\u0011U)D\u0001D\u0015\u0005!\u0015!B:dC2\f\u0017B\u0001$D\u0005\u0011auN\\4")
public class PartitionFlatTable
extends SegmentFlatTable {
    private final SparkSession sparkSession;
    private final PartitionFlatTableDesc tableDesc;

    private SparkSession sparkSession() {
        return this.sparkSession;
    }

    private PartitionFlatTableDesc tableDesc() {
        return this.tableDesc;
    }

    @Override
    public Dataset<Row> applyPartitionDesc(Dataset<Row> originDS) {
        MultiPartitionDesc descMLP = this.dataModel().getMultiPartitionDesc();
        Predef$.MODULE$.require(Objects.nonNull(descMLP));
        PartitionDesc descDRP = this.dataModel().getPartitionDesc();
        String condition = descMLP.getPartitionConditionBuilder().buildMultiPartitionCondition(descDRP, descMLP, new LinkedList<Long>(this.tableDesc().getPartitions()), null, this.segmentRange());
        if (StringUtils.isBlank((CharSequence)condition)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Segment ").append(this.segmentId()).append(" no available partition condition.").toString());
            return originDS;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Segment ").append(this.segmentId()).append(" apply partition condition ").append(condition).append(".").toString());
        return originDS.where(condition);
    }

    public Dataset<Row> getPartitionDS(long partitionId) {
        Buffer columnIds = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableDesc().getColumnIds()).asScala();
        Buffer columnName2Id = (Buffer)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableDesc().getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> column.getIdentity(), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)columnIds, Buffer$.MODULE$.canBuildFrom());
        Map column2IdMap = columnName2Id.toMap(Predef$.MODULE$.$conforms());
        Buffer partitionColumnIds = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.dataModel().getMultiPartitionDesc().getColumnRefs()).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getIdentity(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> (Integer)column2IdMap.apply(x), Buffer$.MODULE$.canBuildFrom());
        Seq values = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dataModel().getMultiPartitionDesc().getPartitionInfo(partitionId).getValues())).toSeq();
        String converted = ((TraversableOnce)((TraversableLike)partitionColumnIds.zip((GenIterable)values, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer k = (Integer)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(7).append("`").append(k).append("` = '").append(v).append("'").toString();
            return string;
        }, Buffer$.MODULE$.canBuildFrom())).mkString(" and ");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Segment ").append(this.segmentId()).append(" single partition condition: ").append(converted).toString());
        return this.FLAT_TABLE().where(converted);
    }

    public PartitionFlatTable(SparkSession sparkSession, PartitionFlatTableDesc tableDesc) {
        this.sparkSession = sparkSession;
        this.tableDesc = tableDesc;
        super(sparkSession, tableDesc);
    }
}

