/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.io.Serializable;
import java.util.Locale;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.CustomUtils$;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.logging.SetLogCategory;
import org.apache.kylin.engine.spark.builder.DFBuilderHelper$;
import org.apache.kylin.engine.spark.builder.NonEquiJoinConditionBuilder$;
import org.apache.kylin.engine.spark.job.FiltersUtil$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.TableMetaManager$;
import org.apache.kylin.engine.spark.model.SegmentFlatTableDesc;
import org.apache.kylin.engine.spark.utils.LogEx;
import org.apache.kylin.metadata.model.JoinDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.FutureAction;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD$;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.utils.ProxyThreadUtils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.StringBuilder;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.ParMap;
import scala.collection.parallel.TaskSupport;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.concurrent.duration.FiniteDuration;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class SegmentFlatTable$
implements LogEx {
    public static SegmentFlatTable$ MODULE$;
    private final KylinConfig conf;
    private boolean inferFiltersEnabled;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SegmentFlatTable$();
    }

    public <U> U logTime(String action, boolean debug, Function0<U> body) {
        return (U)LogEx.logTime$((LogEx)this, (String)action, (boolean)debug, body);
    }

    public <U> boolean logTime$default$2() {
        return LogEx.logTime$default$2$((LogEx)this);
    }

    public void logInfoIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logInfoIf$((LogEx)this, filter, msg);
    }

    public void logWarningIf(Function0<Object> filter, Function0<String> msg) {
        LogEx.logWarningIf$((LogEx)this, filter, msg);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private KylinConfig conf() {
        return this.conf;
    }

    public boolean inferFiltersEnabled() {
        return this.inferFiltersEnabled;
    }

    public void inferFiltersEnabled_$eq(boolean x$1) {
        this.inferFiltersEnabled = x$1;
    }

    public Dataset<Row> fulfillDS(Dataset<Row> originDS, Set<TblColRef> cols, TableRef tableRef) {
        Seq<Column> computedColumns = DFBuilderHelper$.MODULE$.chooseSuitableCols(originDS, (Iterable<TblColRef>)cols);
        Dataset<Row> newDS = this.wrapAlias(originDS, tableRef.getAlias());
        Column[] selectedColumns = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])newDS.schema().fields())).map((Function1 & Serializable & scala.Serializable)tp -> functions$.MODULE$.col(tp.name()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).$plus$plus(computedColumns, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(14).append("Table SCHEMA ").append(tableRef.getTableIdentity()).append(" ").append(newDS.schema().treeString()).toString());
        return newDS.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])selectedColumns));
    }

    public Dataset<Row> wrapAlias(Dataset<Row> originDS, String alias) {
        Seq newFields = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])originDS.schema().fields())).map((Function1 & Serializable & scala.Serializable)f -> NSparkCubingUtil.convertFromDot((String)new java.lang.StringBuilder(5).append("`").append(alias).append("`").append(".").append("`").append(f.name()).append("`").toString()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).toSeq();
        Dataset newDS = originDS.toDF(newFields);
        CustomUtils$.MODULE$.tryWithResourceIgnore((AutoCloseable)new SetLogCategory("build"), (Function1 & Serializable & scala.Serializable)x$14 -> {
            SegmentFlatTable$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(15).append("Wrap ALIAS ").append(originDS$1.schema().treeString()).append(" TO ").append(newDS$2.schema().treeString()).toString());
            return BoxedUnit.UNIT;
        });
        return newDS;
    }

    public Dataset<Row> joinFactTableWithLookupTables(Dataset<Row> rootFactDataset, scala.collection.mutable.Map<JoinTableDesc, Dataset<Row>> lookupTableDatasetMap, NDataModel model, SparkSession ss) {
        return (Dataset)lookupTableDatasetMap.foldLeft(rootFactDataset, (Function2 & Serializable & scala.Serializable)(joinedDataset, tuple) -> MODULE$.joinTableDataset(model.getRootFactTable().getTableDesc(), (JoinTableDesc)tuple._1(), (Dataset<Row>)joinedDataset, (Dataset<Row>)((Dataset)tuple._2()), ss));
    }

    public Dataset<Row> joinTableDataset(TableDesc rootFactDesc, JoinTableDesc lookupDesc, Dataset<Row> rootFactDataset, Dataset<Row> lookupDataset, SparkSession ss) {
        Dataset afterJoin;
        block4: {
            TblColRef[] fk;
            afterJoin = rootFactDataset;
            JoinDesc join = lookupDesc.getJoin();
            if (join == null || StringUtils.isEmpty((CharSequence)join.getType())) break block4;
            String joinType = join.getType().toUpperCase(Locale.ROOT);
            TblColRef[] pk = join.getPrimaryKeyColumns();
            if (pk.length != (fk = join.getForeignKeyColumns()).length) {
                throw new RuntimeException(new java.lang.StringBuilder(64).append("Invalid join condition of fact table: ").append(rootFactDesc).append(",fk: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fk)).mkString(",")).append(",").append(" lookup table:").append(lookupDesc).append(", pk: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pk)).mkString(",")).toString());
            }
            Column[] equiConditionColPairs = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fk)).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])pk), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).map((Function1 & Serializable & scala.Serializable)joinKey -> functions$.MODULE$.col(NSparkCubingUtil.convertFromDot((String)((TblColRef)joinKey._1()).getBackTickIdentity())).equalTo((Object)functions$.MODULE$.col(NSparkCubingUtil.convertFromDot((String)((TblColRef)joinKey._2()).getBackTickIdentity()))), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            CustomUtils$.MODULE$.tryWithResourceIgnore((AutoCloseable)new SetLogCategory("build"), (Function1 & Serializable & scala.Serializable)x$15 -> {
                SegmentFlatTable$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(20).append("Lookup table schema ").append(lookupDataset$1.schema().treeString()).toString());
                return BoxedUnit.UNIT;
            });
            if (join.getNonEquiJoinCondition() != null) {
                ObjectRef condition = ObjectRef.create((Object)NonEquiJoinConditionBuilder$.MODULE$.convert(join.getNonEquiJoinCondition()));
                if (!new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])equiConditionColPairs)).isEmpty()) {
                    condition.elem = ((Column)condition.elem).$amp$amp(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])equiConditionColPairs)).reduce((Function2 & Serializable & scala.Serializable)(x$16, x$17) -> x$16.$amp$amp(x$17)));
                }
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(46).append("Root table ").append(rootFactDesc.getIdentity()).append(", join table ").append(lookupDesc.getAlias()).append(", non-equi condition: ").append(((Column)condition$3.elem).toString()).toString());
                afterJoin = afterJoin.join(lookupDataset, (Column)condition.elem, joinType);
            } else {
                Column condition = (Column)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])equiConditionColPairs)).reduce((Function2 & Serializable & scala.Serializable)(x$18, x$19) -> x$18.$amp$amp(x$19));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append("Root table ").append(rootFactDesc.getIdentity()).append(", join table ").append(lookupDesc.getAlias()).append(", condition: ").append(condition.toString()).toString());
                afterJoin = this.inferFiltersEnabled() ? afterJoin.join(FiltersUtil$.MODULE$.inferFilters(pk, lookupDataset), condition, joinType) : afterJoin.join(lookupDataset, condition, joinType);
            }
        }
        return afterJoin;
    }

    public Dataset<Row> changeSchemeToColumnId(Dataset<Row> ds, SegmentFlatTableDesc tableDesc) {
        StructType structType = ds.schema();
        Buffer columnIds = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(tableDesc.getColumnIds()).asScala();
        Buffer columnName2Id = (Buffer)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(tableDesc.getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> NSparkCubingUtil.convertFromDot((String)column.getBackTickIdentity()), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)columnIds, Buffer$.MODULE$.canBuildFrom());
        scala.collection.immutable.Map columnName2IdMap = columnName2Id.toMap(Predef$.MODULE$.$conforms());
        Seq encodeSeq = (Seq)((TraversableLike)structType.filter((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)SegmentFlatTable$.$anonfun$changeSchemeToColumnId$2(x$20)))).map((Function1 & Serializable & scala.Serializable)tp -> {
            String columnName = new StringOps(Predef$.MODULE$.augmentString(tp.name())).stripSuffix(DFBuilderHelper$.MODULE$.ENCODE_SUFFIX());
            Integer columnId = (Integer)columnName2IdMap.apply((Object)columnName);
            return functions$.MODULE$.col(tp.name()).alias(new java.lang.StringBuilder(0).append(columnId.toString()).append(DFBuilderHelper$.MODULE$.ENCODE_SUFFIX()).toString());
        }, Seq$.MODULE$.canBuildFrom());
        Buffer columns = (Buffer)columnName2Id.map((Function1 & Serializable & scala.Serializable)tp -> functions$.MODULE$.expr(new java.lang.StringBuilder(2).append("`").append(tp._1()).append("`").toString()).alias(((Integer)tp._2()).toString()), Buffer$.MODULE$.canBuildFrom());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(23).append("Select model column is ").append(columns.mkString(",")).toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(32).append("Select model encoding column is ").append(encodeSeq.mkString(",")).toString());
        Buffer selectedColumns = columns.$plus$plus((GenTraversableOnce)encodeSeq);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(27).append("Select model all column is ").append(selectedColumns.mkString(",")).toString());
        return ds.select((Seq)selectedColumns);
    }

    public void org$apache$kylin$engine$spark$builder$SegmentFlatTable$$generateLookupTableMeta(String project, LinkedHashMap<JoinTableDesc, Dataset<Row>> lookupTables) {
        block1: {
            KapConfig config = KapConfig.getInstanceFromEnv();
            if (config.isRecordSourceUsage()) {
                lookupTables.keySet().foreach((Function1 & Serializable & scala.Serializable)joinTable -> {
                    SegmentFlatTable$.$anonfun$generateLookupTableMeta$1(config, project, joinTable);
                    return BoxedUnit.UNIT;
                });
            }
            Map noStatLookupTables = lookupTables.filterKeys((Function1 & Serializable & scala.Serializable)table -> BoxesRunTime.boxToBoolean((boolean)SegmentFlatTable$.$anonfun$generateLookupTableMeta$3(table)));
            if (!config.getKylinConfig().isNeedCollectLookupTableInfo() || !noStatLookupTables.nonEmpty()) break block1;
            ParMap lookupTablePar = (ParMap)noStatLookupTables.par();
            lookupTablePar.tasksupport_$eq((TaskSupport)new ForkJoinTaskSupport(new ForkJoinPool(lookupTablePar.size())));
            lookupTablePar.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                SegmentFlatTable$.$anonfun$generateLookupTableMeta$4(config, x0$1);
                return BoxedUnit.UNIT;
            });
        }
    }

    public long countTableInFiniteTimeOrDefault(Dataset<Row> dataset, String tableName, Duration duration, long defaultCount) {
        long l;
        FutureAction countTask = RDD$.MODULE$.rddToAsyncRDDActions(dataset.rdd(), ClassTag$.MODULE$.apply(Row.class)).countAsync();
        try {
            l = BoxesRunTime.unboxToLong(ProxyThreadUtils$.MODULE$.awaitResult(countTask, duration));
        }
        catch (Exception e) {
            countTask.cancel();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(37).append(tableName).append(" count fail, and return defaultCount ").append(defaultCount).toString(), e);
            l = defaultCount;
        }
        return l;
    }

    public String replaceDot(String original, NDataModel model) {
        StringBuilder sb = new StringBuilder(original);
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(model.getAllNamedColumns()).asScala()).foreach((Function1 & Serializable & scala.Serializable)namedColumn -> {
            SegmentFlatTable$.$anonfun$replaceDot$1(sb, namedColumn);
            return BoxedUnit.UNIT;
        });
        return sb.toString();
    }

    private void doReplaceDot(StringBuilder sb, String namedCol, String colAliasDotColumn) {
        int start = sb.toString().toLowerCase(Locale.ROOT).indexOf(namedCol);
        while (start != -1) {
            sb.replace(start, start + namedCol.length(), new java.lang.StringBuilder(2).append("`").append(NSparkCubingUtil.convertFromDot((String)colAliasDotColumn)).append("`").toString());
            start = sb.toString().toLowerCase(Locale.ROOT).indexOf(namedCol);
        }
    }

    public static final /* synthetic */ boolean $anonfun$changeSchemeToColumnId$2(StructField x$20) {
        return x$20.name().endsWith(DFBuilderHelper$.MODULE$.ENCODE_SUFFIX());
    }

    public static final /* synthetic */ void $anonfun$generateLookupTableMeta$1(KapConfig config$1, String project$1, JoinTableDesc joinTable) {
        block0: {
            NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)config$1.getKylinConfig(), (String)project$1);
            TableExtDesc table = tableManager.getOrCreateTableExt(joinTable.getTable());
            if (table.getTotalRows() <= 0L) break block0;
            TableMetaManager$.MODULE$.putTableMeta(joinTable.getTable(), 0L, table.getTotalRows());
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(25).append("put meta table: ").append(joinTable.getTable()).append(", count: ").append(table.getTotalRows()).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$generateLookupTableMeta$3(JoinTableDesc table) {
        return TableMetaManager$.MODULE$.getTableMeta(table.getTable()).isEmpty();
    }

    public static final /* synthetic */ void $anonfun$generateLookupTableMeta$4(KapConfig config$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        JoinTableDesc joinTableDesc = (JoinTableDesc)tuple2._1();
        Dataset dataset = (Dataset)tuple2._2();
        String tableIdentity = joinTableDesc.getTable();
        BoxedUnit boxedUnit = (BoxedUnit)MODULE$.logTime(new java.lang.StringBuilder(6).append("count ").append(tableIdentity).toString(), MODULE$.logTime$default$2(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            FiniteDuration maxTime = Duration$.MODULE$.apply(config$1.getKylinConfig().getCountLookupTableMaxTime(), TimeUnit.MILLISECONDS);
            long defaultCount = config$1.getKylinConfig().getLookupTableCountDefaultValue();
            long rowCount = MODULE$.countTableInFiniteTimeOrDefault((Dataset<Row>)dataset, tableIdentity, (Duration)maxTime, defaultCount);
            TableMetaManager$.MODULE$.putTableMeta(tableIdentity, 0L, rowCount);
            MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new java.lang.StringBuilder(26).append("put meta table: ").append(tableIdentity).append(" , count: ").append(rowCount).toString());
        });
    }

    public static final /* synthetic */ void $anonfun$replaceDot$1(StringBuilder sb$1, NDataModel.NamedColumn namedColumn) {
        block0: {
            String colName = namedColumn.getAliasDotColumn().toLowerCase(Locale.ROOT);
            MODULE$.doReplaceDot(sb$1, colName, namedColumn.getAliasDotColumn());
            String quotedColName = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(colName)).split('.'))).mkString("`", "`.`", "`");
            if (!new StringOps(Predef$.MODULE$.augmentString(quotedColName)).nonEmpty()) break block0;
            MODULE$.doReplaceDot(sb$1, quotedColName, new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(namedColumn.getAliasDotColumn())).split('.'))).mkString("`", "`.`", "`"));
        }
    }

    private SegmentFlatTable$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        LogEx.$init$((LogEx)this);
        this.conf = KylinConfig.getInstanceFromEnv();
        this.inferFiltersEnabled = this.conf().inferFiltersEnabled();
    }
}

