/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.security.AccessControlException;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.builder.SnapshotBuilder;
import org.apache.kylin.engine.spark.builder.SnapshotBuilder$Result$;
import org.apache.kylin.engine.spark.builder.StepCheckpointSnapshot;
import org.apache.kylin.engine.spark.job.DFChooser$;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.kylin.engine.spark.utils.FileNames$;
import org.apache.kylin.engine.spark.utils.LogUtils$;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.source.SourceFactory;
import org.apache.spark.SparkException;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils$;
import org.apache.spark.utils.ProxyThreadUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.LazyRef;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.control.Breaks$;

@ScalaSignature(bytes="\u0006\u0001\u0011%a\u0001\u0002#F\u0001IC\u0001b\u0019\u0001\u0003\u0002\u0004%\t\u0001\u001a\u0005\ta\u0002\u0011\t\u0019!C\u0001c\"Aq\u000f\u0001B\u0001B\u0003&Q\rC\u0003y\u0001\u0011\u0005\u0011\u0010C\u0003y\u0001\u0011\u0005Q\u0010C\u0004\u007f\u0001\t\u0007I\u0011B@\t\u0011\u0005=\u0001\u0001)A\u0005\u0003\u0003A\u0001\"!\u0005\u0001\u0005\u0004%Ia \u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\u0002!I\u0011Q\u0003\u0001C\u0002\u0013%\u0011q\u0003\u0005\t\u0003?\u0001\u0001\u0015!\u0003\u0002\u001a!I\u0011\u0011\u0005\u0001C\u0002\u0013E\u00111\u0005\u0005\t\u0003c\u0001\u0001\u0015!\u0003\u0002&!I\u00111\u0007\u0001C\u0002\u0013E\u0011Q\u0007\u0005\t\u0003{\u0001\u0001\u0015!\u0003\u00028!I\u0011q\b\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003'\u0002\u0001\u0015!\u0003\u0002D!I\u0011Q\f\u0001C\u0002\u0013%\u0011\u0011\t\u0005\t\u0003?\u0002\u0001\u0015!\u0003\u0002D!9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0004bBA2\u0001\u0011\u0005\u0011q\u001c\u0005\b\u0003G\u0002A\u0011BA\u007f\u0011\u001d\u0011)\u0002\u0001C\u0005\u0005/AqAa,\u0001\t\u0013\u0011\t\fC\u0004\u0003>\u0002!IAa0\t\u000f\t%\u0007\u0001\"\u0001\u0003L\"9!q\u001c\u0001\u0005\u0002\t\u0005\bb\u0002Bw\u0001\u0011\u0005!q\u001e\u0005\b\u0007+\u0001A\u0011AB\f\u0011\u001d\u0019\u0019\u0004\u0001C\u0001\u0007kAqaa\u0011\u0001\t\u0013\u0019)\u0005C\u0004\u0004L\u0001!Ia!\u0014\t\u000f\rM\u0003\u0001\"\u0001\u0004V!911\f\u0001\u0005\u0002\ru\u0003bBB8\u0001\u0011\u00051\u0011\u000f\u0005\b\u0007{\u0002A\u0011AB@\u0011\u001d\u0019Y\t\u0001C\u0001\u0007\u001bC\u0001ba&\u0001\t\u0003)5\u0011\u0014\u0005\t\u0007K\u0003A\u0011A#\u0004(\"A11\u0019\u0001\u0005\u0002\u0015\u001b)\rC\u0004\u0004R\u0002!Iaa5\u0007\r\t-\u0002\u0001\u0011B\u0017\u0011%\u0011)D\u000bBK\u0002\u0013\u0005A\rC\u0005\u00038)\u0012\t\u0012)A\u0005K\"Q!\u0011\b\u0016\u0003\u0016\u0004%\tAa\u000f\t\u0015\t\r#F!E!\u0002\u0013\u0011i\u0004\u0003\u0006\u0003F)\u0012)\u001a!C\u0001\u0005wA!Ba\u0012+\u0005#\u0005\u000b\u0011\u0002B\u001f\u0011\u0019A(\u0006\"\u0001\u0003J!I!\u0011\u000b\u0016\u0002\u0002\u0013\u0005!1\u000b\u0005\n\u00057R\u0013\u0013!C\u0001\u0005;B\u0011Ba\u001d+#\u0003%\tA!\u001e\t\u0013\te$&%A\u0005\u0002\tU\u0004\u0002\u0003B>U\u0005\u0005I\u0011I@\t\u0013\tu$&!A\u0005\u0002\u0005]\u0001\"\u0003B@U\u0005\u0005I\u0011\u0001BA\u0011%\u0011YIKA\u0001\n\u0003\u0012i\tC\u0005\u0003\u001c*\n\t\u0011\"\u0001\u0003\u001e\"I!\u0011\u0015\u0016\u0002\u0002\u0013\u0005#1\u0015\u0005\n\u0005KS\u0013\u0011!C!\u0005OC\u0011B!++\u0003\u0003%\tEa+\b\u0013\rm\u0007!!A\t\u0002\rug!\u0003B\u0016\u0001\u0005\u0005\t\u0012ABp\u0011\u0019Ax\b\"\u0001\u0004n\"I!QU \u0002\u0002\u0013\u0015#q\u0015\u0005\n\u0007_|\u0014\u0011!CA\u0007cD\u0011b!?@\u0003\u0003%\tia?\u0003\u001fMs\u0017\r]:i_R\u0014U/\u001b7eKJT!AR$\u0002\u000f\t,\u0018\u000e\u001c3fe*\u0011\u0001*S\u0001\u0006gB\f'o\u001b\u0006\u0003\u0015.\u000ba!\u001a8hS:,'B\u0001'N\u0003\u0015Y\u0017\u0010\\5o\u0015\tqu*\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002!\u0006\u0019qN]4\u0004\u0001M!\u0001aU-a!\t!v+D\u0001V\u0015\u00051\u0016!B:dC2\f\u0017B\u0001-V\u0005\u0019\te.\u001f*fMB\u0011!LX\u0007\u00027*\u0011A,X\u0001\tS:$XM\u001d8bY*\u0011\u0001*T\u0005\u0003?n\u0013q\u0001T8hO&tw\r\u0005\u0002UC&\u0011!-\u0016\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0006U>\u0014\u0017\nZ\u000b\u0002KB\u0011a-\u001c\b\u0003O.\u0004\"\u0001[+\u000e\u0003%T!A[)\u0002\rq\u0012xn\u001c;?\u0013\taW+\u0001\u0004Qe\u0016$WMZ\u0005\u0003]>\u0014aa\u0015;sS:<'B\u00017V\u0003%QwNY%e?\u0012*\u0017\u000f\u0006\u0002skB\u0011Ak]\u0005\u0003iV\u0013A!\u00168ji\"9aOAA\u0001\u0002\u0004)\u0017a\u0001=%c\u00051!n\u001c2JI\u0002\na\u0001P5oSRtDC\u0001>}!\tY\b!D\u0001F\u0011\u0015\u0019G\u00011\u0001f)\u0005Q\u0018AC'Ek}\u001bVK\u0012$J1V\u0011\u0011\u0011\u0001\t\u0005\u0003\u0007\ti!\u0004\u0002\u0002\u0006)!\u0011qAA\u0005\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0011\u0001\u00026bm\u0006L1A\\A\u0003\u0003-iE)N0T+\u001a3\u0015\n\u0017\u0011\u0002\u001dA\u000b%+U+F)~\u001bVK\u0012$J1\u0006y\u0001+\u0011*R+\u0016#vlU+G\r&C\u0006%\u0001\u0002N\u0005V\u0011\u0011\u0011\u0004\t\u0004)\u0006m\u0011bAA\u000f+\n\u0019\u0011J\u001c;\u0002\u00075\u0013\u0005%A\u0006ls2LgnQ8oM&<WCAA\u0013!\u0011\t9#!\f\u000e\u0005\u0005%\"bAA\u0016\u0017\u000611m\\7n_:LA!a\f\u0002*\tY1*\u001f7j]\u000e{gNZ5h\u00031Y\u0017\u0010\\5o\u0007>tg-[4!\u0003=qW-\u001a3D_2dWm\u0019;Ti\u0006$XCAA\u001c!\r!\u0016\u0011H\u0005\u0004\u0003w)&a\u0002\"p_2,\u0017M\\\u0001\u0011]\u0016,GmQ8mY\u0016\u001cGo\u0015;bi\u0002\n\u0011\u0003]1scV,G\u000fU1uQ\u001aKG\u000e^3s+\t\t\u0019\u0005\u0005\u0003\u0002F\u0005=SBAA$\u0015\u0011\tI%a\u0013\u0002\u0005\u0019\u001c(bAA'\u001b\u00061\u0001.\u00193p_BLA!!\u0015\u0002H\tQ\u0001+\u0019;i\r&dG/\u001a:\u0002%A\f'/];fiB\u000bG\u000f\u001b$jYR,'\u000f\t\u0015\u0004#\u0005]\u0003c\u0001+\u0002Z%\u0019\u00111L+\u0003\u0013Q\u0014\u0018M\\:jK:$\u0018!D7ekA\u000bG\u000f\u001b$jYR,'/\u0001\bnIV\u0002\u0016\r\u001e5GS2$XM\u001d\u0011)\u0007M\t9&A\u0007ck&dGm\u00158baNDw\u000e\u001e\u000b\u0006e\u0006\u001d\u0014q\u000f\u0005\b\u0003S\"\u0002\u0019AA6\u0003\t\u00198\u000f\u0005\u0003\u0002n\u0005MTBAA8\u0015\r\t\t(X\u0001\u0004gFd\u0017\u0002BA;\u0003_\u0012Ab\u00159be.\u001cVm]:j_:Dq!!\u001f\u0015\u0001\u0004\tY(A\u0007u_\n+\u0018\u000e\u001c3UC\ndWm\u001d\t\u0007\u0003{\n\u0019)a\"\u000e\u0005\u0005}$\u0002BAA\u0003\u0013\tA!\u001e;jY&!\u0011QQA@\u0005\r\u0019V\r\u001e\t\u0005\u0003\u0013\u000b\u0019*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u0015iw\u000eZ3m\u0015\r\t\tjS\u0001\t[\u0016$\u0018\rZ1uC&!\u0011QSAF\u0005%!\u0016M\u00197f\t\u0016\u001c8\rK\u0003\u0015\u00033\u000bY\u000bE\u0003U\u00037\u000by*C\u0002\u0002\u001eV\u0013a\u0001\u001e5s_^\u001c\b\u0003BAQ\u0003Ok!!a)\u000b\t\u0005\u0015\u0016\u0011B\u0001\u0003S>LA!!+\u0002$\nY\u0011jT#yG\u0016\u0004H/[8oc\u0019qR-!,\u0002^FJ1%a,\u00026\u0006M\u0017qW\u000b\u0004I\u0006EFaBAZ#\n\u0007\u0011Q\u0018\u0002\u0002)&!\u0011qWA]\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%c)\u0019\u00111X+\u0002\rQD'o\\<t#\u0011\ty,!2\u0011\u0007Q\u000b\t-C\u0002\u0002DV\u0013qAT8uQ&tw\r\u0005\u0003\u0002H\u00065gb\u0001+\u0002J&\u0019\u00111Z+\u0002\u000fA\f7m[1hK&!\u0011qZAi\u0005%!\u0006N]8xC\ndWMC\u0002\u0002LV\u000b\u0014bIAk\u0003/\fI.a/\u000f\u0007Q\u000b9.C\u0002\u0002<V\u000bTA\t+V\u00037\u0014Qa]2bY\u0006\f4AJAP)\u001d\u0011\u0018\u0011]Ar\u0003WDq!!\u001b\u0016\u0001\u0004\tY\u0007C\u0004\u0002\u000eV\u0001\r!!:\u0011\t\u0005%\u0015q]\u0005\u0005\u0003S\fYI\u0001\u0006O\t\u0006$\u0018-T8eK2Dq!!<\u0016\u0001\u0004\ty/A\u000bjO:|'/\u001a3T]\u0006\u00048\u000f[8u)\u0006\u0014G.Z:\u0011\u000b\u0005u\u00141Q3)\u000bU\tI*a=2\ry)\u0017Q_A~c%\u0019\u0013qVA[\u0003o\f9,M\u0005$\u0003+\f9.!?\u0002<F*!\u0005V+\u0002\\F\u001aa%a(\u0015\u000bI\fyP!\u0001\t\u000f\u0005%d\u00031\u0001\u0002l!9!1\u0001\fA\u0002\t\u0015\u0011A\u0002;bE2,7\u000fE\u0003g\u0005\u000f\t9)C\u0002\u0002\u0006>DSAFAM\u0005\u0017\tdAH3\u0003\u000e\tM\u0011'C\u0012\u00020\u0006U&qBA\\c%\u0019\u0013Q[Al\u0005#\tY,M\u0003#)V\u000bY.M\u0002'\u0003?\u000b!\"\u001e9eCR,W*\u001a;b)\u0015\u0011(\u0011\u0004B\u000f\u0011\u001d\u0011Yb\u0006a\u0001\u0005\u000b\t\u0001\u0003^8Ck&dG\rV1cY\u0016$Um]2\t\u000f\t}q\u00031\u0001\u0003\"\u0005I!/Z:vYRl\u0015\r\u001d\t\b\u0003{\u0012\u0019#\u001aB\u0014\u0013\u0011\u0011)#a \u0003\u00075\u000b\u0007\u000fE\u0002\u0003*)j\u0011\u0001\u0001\u0002\u0007%\u0016\u001cX\u000f\u001c;\u0014\u000b)\u001a&q\u00061\u0011\u0007Q\u0013\t$C\u0002\u00034U\u0013q\u0001\u0015:pIV\u001cG/\u0001\u0003qCRD\u0017!\u00029bi\"\u0004\u0013\u0001D8sS\u001eLg.\u00197TSj,WC\u0001B\u001f!\r!&qH\u0005\u0004\u0005\u0003*&\u0001\u0002'p]\u001e\fQb\u001c:jO&t\u0017\r\\*ju\u0016\u0004\u0013!\u0003;pi\u0006d'k\\<t\u0003)!x\u000e^1m%><8\u000f\t\u000b\t\u0005O\u0011YE!\u0014\u0003P!1!QG\u0019A\u0002\u0015DqA!\u000f2\u0001\u0004\u0011i\u0004C\u0004\u0003FE\u0002\rA!\u0010\u0002\t\r|\u0007/\u001f\u000b\t\u0005O\u0011)Fa\u0016\u0003Z!A!Q\u0007\u001a\u0011\u0002\u0003\u0007Q\rC\u0005\u0003:I\u0002\n\u00111\u0001\u0003>!I!Q\t\u001a\u0011\u0002\u0003\u0007!QH\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yFK\u0002f\u0005CZ#Aa\u0019\u0011\t\t\u0015$qN\u0007\u0003\u0005ORAA!\u001b\u0003l\u0005IQO\\2iK\u000e\\W\r\u001a\u0006\u0004\u0005[*\u0016AC1o]>$\u0018\r^5p]&!!\u0011\u000fB4\u0005E)hn\u00195fG.,GMV1sS\u0006t7-Z\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u00119H\u000b\u0003\u0003>\t\u0005\u0014AD2paf$C-\u001a4bk2$HeM\u0001\u000eaJ|G-^2u!J,g-\u001b=\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!1\u0011BE!\r!&QQ\u0005\u0004\u0005\u000f+&aA!os\"Aa\u000fOA\u0001\u0002\u0004\tI\"A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011y\t\u0005\u0004\u0003\u0012\n]%1Q\u0007\u0003\u0005'S1A!&V\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u00053\u0013\u0019J\u0001\u0005Ji\u0016\u0014\u0018\r^8s\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA\u001c\u0005?C\u0001B\u001e\u001e\u0002\u0002\u0003\u0007!1Q\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011D\u0001\ti>\u001cFO]5oOR\u0011\u0011\u0011A\u0001\u0007KF,\u0018\r\\:\u0015\t\u0005]\"Q\u0016\u0005\tmv\n\t\u00111\u0001\u0003\u0004\u0006\u0019R\u000f\u001d3bi\u0016$\u0016M\u00197f':\f\u0007o\u001d5piR9!Oa-\u00038\nm\u0006B\u0002B[1\u0001\u0007Q-A\u0004qe>TWm\u0019;\t\u000f\te\u0006\u00041\u0001\u0002\b\u0006)A/\u00192mK\"9!q\u0004\rA\u0002\t\u0005\u0012aC;qI\u0006$X\rV1cY\u0016$rA\u001dBa\u0005\u0007\u0014)\r\u0003\u0004\u00036f\u0001\r!\u001a\u0005\u0007\u0005sK\u0002\u0019A3\t\u000f\t\u001d\u0017\u00041\u0001\u0003\"\u0005\u0019Q.\u00199\u0002%\r\fGnY;mCR,Gk\u001c;bYJ{wo\u001d\u000b\be\n5'q\u001aBi\u0011\u001d\tIG\u0007a\u0001\u0003WBq!!$\u001b\u0001\u0004\t)\u000fC\u0004\u0002nj\u0001\r!a<)\u000bi\tIJ!62\ry)'q\u001bBoc%\u0019\u0013qVA[\u00053\f9,M\u0005$\u0003+\f9Na7\u0002<F*!\u0005V+\u0002\\F\u001aa%a(\u0002/\r\fGnY;mCR,G+\u00192mKR{G/\u00197S_^\u001cH\u0003\u0003B\u001f\u0005G\u00149Oa;\t\r\t\u00158\u00041\u0001f\u00031\u0019h.\u00199tQ>$\b+\u0019;i\u0011\u001d\u0011Io\u0007a\u0001\u0003\u000f\u000b\u0011\u0002^1cY\u0016$Um]2\t\u000f\u0005%4\u00041\u0001\u0002l\u0005aR\r_3dkR,\u0007+\u0019:bY2,GNQ;jY\u0012\u001cf.\u00199tQ>$H#\u0004:\u0003r\nM(Q\u001fB}\u0007\u0013\u0019\t\u0002C\u0004\u0002jq\u0001\r!a\u001b\t\u000f\tmA\u00041\u0001\u0003\u0006!1!q\u001f\u000fA\u0002\u0015\fqAY1tK\u0012K'\u000fC\u0004\u0003|r\u0001\rA!@\u0002\u0017Mt\u0017\r]*ju\u0016l\u0015\r\u001d\t\b\u0005\u007f\u001c)!\u001aB\u0014\u001b\t\u0019\tA\u0003\u0003\u0004\u0004\u0005}\u0014AC2p]\u000e,(O]3oi&!1qAB\u0001\u00055\u0019uN\\2veJ,g\u000e^'ba\"9\u0011\u0011\n\u000fA\u0002\r-\u0001\u0003BA#\u0007\u001bIAaa\u0004\u0002H\tQa)\u001b7f'f\u001cH/Z7\t\u000f\rMA\u00041\u0001\u0002\u001a\u0005\u00193O\\1qg\"|G\u000fU1sC2dW\r\u001c\"vS2$G+[7f_V$8+Z2p]\u0012\u001c\u0018AG3yK\u000e,H/Z*fe&\fGNQ;jY\u0012\u001cf.\u00199tQ>$H#\u0004:\u0004\u001a\rm1QDB\u0010\u0007C\u0019\u0019\u0003C\u0004\u0002ju\u0001\r!a\u001b\t\u000f\tmQ\u00041\u0001\u0003\u0006!1!q_\u000fA\u0002\u0015DqAa?\u001e\u0001\u0004\u0011i\u0010C\u0004\u0002Ju\u0001\raa\u0003\t\u000f\r\u0015R\u00041\u0001\u0004(\u0005q1\u000f^3q\u0007\",7m\u001b9pS:$\b#\u0002+\u0004*\r5\u0012bAB\u0016+\n1q\n\u001d;j_:\u00042a_B\u0018\u0013\r\u0019\t$\u0012\u0002\u0017'R,\u0007o\u00115fG.\u0004x.\u001b8u':\f\u0007o\u001d5pi\u0006!R\r_3dkR,')^5mINs\u0017\r]:i_R$BB!\t\u00048\re21HB\u001f\u0007\u0003Bq!!\u001b\u001f\u0001\u0004\tY\u0007C\u0004\u0003\u001cy\u0001\rA!\u0002\t\r\t]h\u00041\u0001f\u0011\u001d\u0019yD\ba\u0001\u0003o\tq\"[:QCJ\fG\u000e\\3m\u0005VLG\u000e\u001a\u0005\b\u0007'q\u0002\u0019AA\r\u0003YI7/S4o_J,Gm\u00158baNDw\u000e\u001e+bE2,GCBA\u001c\u0007\u000f\u001aI\u0005C\u0004\u0003j~\u0001\r!a\"\t\u000f\u00055x\u00041\u0001\u0002p\u00061Bo\u001c\"f\u0007\u0006d7-\u001e7bi\u0016$\u0016M\u00197f\t\u0016\u001c8\r\u0006\u0004\u0003\u0006\r=3\u0011\u000b\u0005\b\u0003\u001b\u0003\u0003\u0019AAs\u0011\u001d\ti\u000f\ta\u0001\u0003_\f\u0011\u0003Z5ti&t7\r\u001e+bE2,G)Z:d)\u0019\u0011)aa\u0016\u0004Z!9\u0011QR\u0011A\u0002\u0005\u0015\bbBAwC\u0001\u0007\u0011q^\u0001\u000eO\u0016$8k\\;sG\u0016$\u0015\r^1\u0015\r\r}31NB7!\u0019\tig!\u0019\u0004f%!11MA8\u0005\u001d!\u0015\r^1tKR\u0004B!!\u001c\u0004h%!1\u0011NA8\u0005\r\u0011vn\u001e\u0005\b\u0003S\u0012\u0003\u0019AA6\u0011\u001d\u0011IO\ta\u0001\u0003\u000f\u000b!bZ3u\r&dW-\u001436)\r)71\u000f\u0005\b\u0007k\u001a\u0003\u0019AB<\u0003\u00111\u0017\u000e\\3\u0011\t\u0005\u00153\u0011P\u0005\u0005\u0007w\n9E\u0001\u0006GS2,7\u000b^1ukN\f1CY;jY\u0012\u001c\u0016N\\4mKNs\u0017\r]:i_R$2B]BA\u0007\u0007\u001b)ia\"\u0004\n\"9\u0011\u0011\u000e\u0013A\u0002\u0005-\u0004b\u0002BuI\u0001\u0007\u0011q\u0011\u0005\u0007\u0005o$\u0003\u0019A3\t\u000f\u0005%C\u00051\u0001\u0004\f!9!q\u0004\u0013A\u0002\t\u0005\u0012!\b2vS2$7+\u001b8hY\u0016\u001cf.\u00199tQ>$x+\u001b;i_V$X\nZ\u001b\u0015\u0013I\u001cyi!%\u0004\u0014\u000eU\u0005bBA5K\u0001\u0007\u00111\u000e\u0005\b\u0005S,\u0003\u0019AAD\u0011\u0019\u001190\na\u0001K\"9!qD\u0013A\u0002\tu\u0018aE2p[B,H/Z*oCB\u001c\bn\u001c;TSj,G\u0003BBN\u0007C\u0003r\u0001VBO\u0005{\u0011i$C\u0002\u0004 V\u0013a\u0001V;qY\u0016\u0014\u0004bBBRM\u0001\u00071qL\u0001\u000bg>,(oY3ECR\f\u0017!E<sCB\u001cuN\u001c4jO\u0016CXmY;uKV!1\u0011VBX)\u0019\u0019Yk!.\u0004@B!1QVBX\u0019\u0001!qa!-(\u0005\u0004\u0019\u0019LA\u0001S#\u0011\tyLa!\t\u000f\r]v\u00051\u0001\u0004:\u0006A1-\u00197mC\ndW\rE\u0003U\u0007w\u001bY+C\u0002\u0004>V\u0013\u0011BR;oGRLwN\u001c\u0019\t\r\r\u0005w\u00051\u0001f\u0003!!\u0018m]6J]\u001a|\u0017!\u00053fG&$Wm\u00159be.TuNY!sOR!1qYBh!\u001d!6QTA\r\u0007\u0013\u00042\u0001VBf\u0013\r\u0019i-\u0016\u0002\u0007\t>,(\r\\3\t\u000f\r\r\u0006\u00061\u0001\u0004`\u0005\tr-\u001a;Ti\u0016\u00048\t[3dWB|\u0017N\u001c;\u0015\r\r\u001d2Q[Bm\u0011\u0019\u00199.\u000ba\u0001K\u00061!n\u001c2U[BDq!!\u0013*\u0001\u0004\u0019Y!\u0001\u0004SKN,H\u000e\u001e\t\u0004\u0005Sy4\u0003B \u0004b\u0002\u00042ba9\u0004j\u0016\u0014iD!\u0010\u0003(5\u00111Q\u001d\u0006\u0004\u0007O,\u0016a\u0002:v]RLW.Z\u0005\u0005\u0007W\u001c)OA\tBEN$(/Y2u\rVt7\r^5p]N\"\"a!8\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0011\t\u001d21_B{\u0007oDaA!\u000eC\u0001\u0004)\u0007b\u0002B\u001d\u0005\u0002\u0007!Q\b\u0005\b\u0005\u000b\u0012\u0005\u0019\u0001B\u001f\u0003\u001d)h.\u00199qYf$Ba!@\u0005\u0006A)Ak!\u000b\u0004\u0000BAA\u000b\"\u0001f\u0005{\u0011i$C\u0002\u0005\u0004U\u0013a\u0001V;qY\u0016\u001c\u0004\"\u0003C\u0004\u0007\u0006\u0005\t\u0019\u0001B\u0014\u0003\rAH\u0005\r")
public class SnapshotBuilder
implements Logging,
scala.Serializable {
    private volatile SnapshotBuilder$Result$ Result$module;
    private String jobId;
    private final String org$apache$kylin$engine$spark$builder$SnapshotBuilder$$MD5_SUFFIX;
    private final String org$apache$kylin$engine$spark$builder$SnapshotBuilder$$PARQUET_SUFFIX;
    private final int MB;
    private final KylinConfig kylinConfig;
    private final boolean needCollectStat;
    private final transient PathFilter parquetPathFilter;
    private final transient PathFilter md5PathFilter;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public SnapshotBuilder$Result$ Result() {
        if (this.Result$module == null) {
            this.Result$lzycompute$1();
        }
        return this.Result$module;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String jobId() {
        return this.jobId;
    }

    public void jobId_$eq(String x$1) {
        this.jobId = x$1;
    }

    public String org$apache$kylin$engine$spark$builder$SnapshotBuilder$$MD5_SUFFIX() {
        return this.org$apache$kylin$engine$spark$builder$SnapshotBuilder$$MD5_SUFFIX;
    }

    public String org$apache$kylin$engine$spark$builder$SnapshotBuilder$$PARQUET_SUFFIX() {
        return this.org$apache$kylin$engine$spark$builder$SnapshotBuilder$$PARQUET_SUFFIX;
    }

    private int MB() {
        return this.MB;
    }

    public KylinConfig kylinConfig() {
        return this.kylinConfig;
    }

    public boolean needCollectStat() {
        return this.needCollectStat;
    }

    private PathFilter parquetPathFilter() {
        return this.parquetPathFilter;
    }

    private PathFilter md5PathFilter() {
        return this.md5PathFilter;
    }

    public void buildSnapshot(SparkSession ss, Set<TableDesc> toBuildTables) throws IOException {
        this.buildSnapshot(ss, (scala.collection.immutable.Set<TableDesc>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(toBuildTables).asScala()).toSet());
    }

    public void buildSnapshot(SparkSession ss, NDataModel model, Set<String> ignoredSnapshotTables) throws IOException {
        scala.collection.immutable.Set<TableDesc> toBuildTableDesc = this.distinctTableDesc(model, ignoredSnapshotTables);
        this.buildSnapshot(ss, toBuildTableDesc);
    }

    private void buildSnapshot(SparkSession ss, scala.collection.immutable.Set<TableDesc> tables) throws IOException {
        String baseDir = KapConfig.getInstanceFromEnv().getMetadataWorkingDirectory();
        scala.collection.immutable.Set<TableDesc> toBuildTables = tables;
        KylinConfig kylinConf = KylinConfig.getInstanceFromEnv();
        if (toBuildTables.isEmpty()) {
            return;
        }
        Map<String, Result> resultMap = this.executeBuildSnapshot(ss, toBuildTables, baseDir, kylinConf.isSnapshotParallelBuildEnabled(), kylinConf.snapshotParallelBuildTimeoutSeconds());
        if (resultMap.isEmpty()) {
            return;
        }
        this.updateMeta((scala.collection.immutable.Set<TableDesc>)((scala.collection.immutable.Set)toBuildTables.filter((Function1 & Serializable & scala.Serializable)tbl -> BoxesRunTime.boxToBoolean((boolean)resultMap.containsKey(tbl.getIdentity())))), resultMap);
    }

    private void updateMeta(scala.collection.immutable.Set<TableDesc> toBuildTableDesc, Map<String, Result> resultMap) {
        String project = ((TableDesc)toBuildTableDesc.iterator().next()).getProject();
        toBuildTableDesc.foreach((Function1 & Serializable & scala.Serializable)table -> {
            SnapshotBuilder.$anonfun$updateMeta$1(this, project, resultMap, table);
            return BoxedUnit.UNIT;
        });
    }

    private void updateTableSnapshot(String project, TableDesc table, Map<String, Result> resultMap) {
        public class Org_apache_kylin_engine_spark_builder_SnapshotBuilder$TableUpdateOps$1
        implements UnitOfWork.Callback<TableDesc> {
            private final /* synthetic */ SnapshotBuilder $outer;
            private final String project$2;
            private final TableDesc table$1;
            private final Map resultMap$3;

            public void preProcess() {
                super.preProcess();
            }

            public void onProcessError(Throwable x$1) {
                super.onProcessError(x$1);
            }

            /*
             * WARNING - void declaration
             */
            public TableDesc process() {
                void var2_2;
                NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project$2);
                TableDesc copy = tableMetadataManager.copyForWrite(this.table$1);
                copy.setLastSnapshotPath(((Result)this.resultMap$3.get(copy.getIdentity())).path());
                FileSystem fs = HadoopUtil.getWorkingFileSystem();
                String baseDir = KapConfig.getInstanceFromEnv().getMetadataWorkingDirectory();
                long snapshotSize = 0L;
                String fullSnapShotPath = new StringBuilder(0).append(baseDir).append(copy.getLastSnapshotPath()).toString();
                try {
                    snapshotSize = HadoopUtil.getContentSummary((FileSystem)fs, (Path)new Path(fullSnapShotPath)).getLength();
                }
                catch (Throwable e) {
                    this.$outer.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Fetch snapshot size for ").append(copy.getIdentity()).append(" from ").append(fullSnapShotPath).toString(), e);
                }
                copy.setLastSnapshotSize(snapshotSize);
                copy.setSnapshotLastModified(System.currentTimeMillis());
                tableMetadataManager.updateTableDesc(copy);
                return var2_2;
            }

            public Org_apache_kylin_engine_spark_builder_SnapshotBuilder$TableUpdateOps$1(SnapshotBuilder $outer, String project$2, TableDesc table$1, Map resultMap$3) {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.project$2 = project$2;
                this.table$1 = table$1;
                this.resultMap$3 = resultMap$3;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$process$1(org.apache.kylin.metadata.model.TableDesc java.lang.String )}, serializedLambda);
            }
        }
        UnitOfWork.doInTransactionWithRetry((UnitOfWork.Callback)new Org_apache_kylin_engine_spark_builder_SnapshotBuilder$TableUpdateOps$1(this, project, table, resultMap), (String)project);
    }

    private void updateTable(String project, String table, Map<String, Result> map) {
        public class Org_apache_kylin_engine_spark_builder_SnapshotBuilder$TableUpdateOps$2
        implements UnitOfWork.Callback<TableExtDesc> {
            private final String project$3;
            private final String table$2;
            private final Map map$1;

            public void preProcess() {
                super.preProcess();
            }

            public void onProcessError(Throwable x$1) {
                super.onProcessError(x$1);
            }

            /*
             * WARNING - void declaration
             */
            public TableExtDesc process() {
                void var2_2;
                NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project$3);
                TableExtDesc tableExt = tableMetadataManager.getOrCreateTableExt(this.table$2);
                tableExt = tableMetadataManager.copyForWrite(tableExt);
                TableDesc tableDesc = tableMetadataManager.getTableDesc(this.table$2);
                TableDesc tableDescCopy = tableMetadataManager.copyForWrite(tableDesc);
                Result result = (Result)this.map$1.get(tableDescCopy.getIdentity());
                if (result.totalRows() != -1L) {
                    tableExt.setOriginalSize(result.originalSize());
                    tableExt.setTotalRows(result.totalRows());
                    tableDescCopy.setSnapshotTotalRows(result.totalRows());
                }
                tableMetadataManager.saveTableExt(tableExt);
                tableMetadataManager.updateTableDesc(tableDescCopy);
                return var2_2;
            }

            public Org_apache_kylin_engine_spark_builder_SnapshotBuilder$TableUpdateOps$2(SnapshotBuilder $outer, String project$3, String table$2, Map map$1) {
                this.project$3 = project$3;
                this.table$2 = table$2;
                this.map$1 = map$1;
            }
        }
        UnitOfWork.doInTransactionWithRetry((UnitOfWork.Callback)new Org_apache_kylin_engine_spark_builder_SnapshotBuilder$TableUpdateOps$2(null, project, table, map), (String)project);
    }

    public void calculateTotalRows(SparkSession ss, NDataModel model, Set<String> ignoredSnapshotTables) throws IOException {
        if (!this.needCollectStat()) {
            return;
        }
        scala.collection.immutable.Set<TableDesc> toCalculateTableDesc = this.toBeCalculateTableDesc(model, ignoredSnapshotTables);
        ConcurrentHashMap map = new ConcurrentHashMap();
        toCalculateTableDesc.foreach((Function1 & Serializable & scala.Serializable)tableDesc -> {
            long totalRows = this.calculateTableTotalRows(tableDesc.getLastSnapshotPath(), (TableDesc)tableDesc, ss);
            return map.put(tableDesc.getIdentity(), new Result(this, "", -1L, totalRows));
        });
        toCalculateTableDesc.foreach((Function1 & Serializable & scala.Serializable)table -> {
            this.updateTable(model.getProject(), table.getIdentity(), map);
            return BoxedUnit.UNIT;
        });
    }

    public long calculateTableTotalRows(String snapshotPath, TableDesc tableDesc, SparkSession ss) {
        String baseDir = KapConfig.getInstanceFromEnv().getMetadataWorkingDirectory();
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        try {
            Path path;
            if (snapshotPath != null && fs.exists(path = new Path(baseDir, snapshotPath))) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Calculate table ").append(tableDesc.getIdentity()).append("'s total rows from snapshot ").append(path).toString());
                long totalRows = ss.read().parquet(path.toString()).count();
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Table ").append(tableDesc.getIdentity()).append("'s total rows is ").append(totalRows).append("'").toString());
                return totalRows;
            }
        }
        catch (Throwable e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Calculate table ").append(tableDesc.getIdentity()).append("'s total rows exception").toString(), e);
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("Calculate table ").append(tableDesc.getIdentity()).append("'s total rows from source data").toString());
        Dataset<Row> sourceData = this.getSourceData(ss, tableDesc);
        long totalRows = sourceData.count();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(24).append("Table ").append(tableDesc.getIdentity()).append("'s total rows is ").append(totalRows).append("'").toString());
        return totalRows;
    }

    public void executeParallelBuildSnapshot(SparkSession ss, scala.collection.immutable.Set<TableDesc> toBuildTableDesc, String baseDir, ConcurrentMap<String, Result> snapSizeMap, FileSystem fs, int snapshotParallelBuildTimeoutSeconds) {
        KylinConfig kylinConf = KylinConfig.getInstanceFromEnv();
        String project = ((TableDesc)toBuildTableDesc.iterator().next()).getProject();
        Option<StepCheckpointSnapshot> stepCheckpoint = this.getStepCheckpoint(kylinConf.getJobTmpDir(project), fs);
        ExecutorService service = Executors.newCachedThreadPool();
        ExecutionContextExecutorService executorContext = ExecutionContext$.MODULE$.fromExecutorService(service);
        scala.collection.immutable.Set futures = (scala.collection.immutable.Set)toBuildTableDesc.map((Function1 & Serializable & scala.Serializable)tableDesc -> Future$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            try (KylinConfig.SetAndUnsetThreadLocalConfig config = null;){
                try {
                    if (stepCheckpoint.exists((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.canSkip(tableDesc)))) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Skip snapshot ").append(tableDesc.getIdentity()).toString());
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        config = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)kylinConf);
                        this.buildSingleSnapshotWithoutMd5(ss, (TableDesc)tableDesc, baseDir, snapSizeMap);
                        boxedUnit = stepCheckpoint.map((Function1 & Serializable & scala.Serializable)x$2 -> {
                            x$2.checkpoint(tableDesc);
                            return BoxedUnit.UNIT;
                        });
                    }
                }
                catch (Exception exception) {
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error for build snapshot table with ").append(tableDesc).toString(), exception);
                    throw exception;
                }
            }
            return boxedUnit;
        }, (ExecutionContext)executorContext), Set$.MODULE$.canBuildFrom());
        try {
            Future eventualTuples = Future$.MODULE$.sequence((TraversableOnce)futures.toList(), List$.MODULE$.canBuildFrom(), (ExecutionContext)executorContext);
            ProxyThreadUtils$.MODULE$.awaitResult(eventualTuples, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(snapshotParallelBuildTimeoutSeconds)).seconds());
        }
        catch (SparkException e) {
            ProxyThreadUtils$.MODULE$.shutdown(service, ProxyThreadUtils$.MODULE$.shutdown$default$2());
            Throwable throwable = e.getCause();
            if (throwable instanceof AccessControlException) {
                AccessControlException accessControlException = (AccessControlException)throwable;
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error for await snapshot table result due to AccessControlException", (Throwable)accessControlException);
                throw accessControlException;
            }
            throw e;
        }
        catch (Exception e) {
            ProxyThreadUtils$.MODULE$.shutdown(service, ProxyThreadUtils$.MODULE$.shutdown$default$2());
            throw e;
        }
    }

    public void executeSerialBuildSnapshot(SparkSession ss, scala.collection.immutable.Set<TableDesc> toBuildTableDesc, String baseDir, ConcurrentMap<String, Result> snapSizeMap, FileSystem fs, Option<StepCheckpointSnapshot> stepCheckpoint) {
        toBuildTableDesc.foreach((Function1 & Serializable & scala.Serializable)tableDesc -> {
            BoxedUnit boxedUnit;
            if (stepCheckpoint.exists((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)x$3.canSkip(tableDesc)))) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Skip snapshot ").append(tableDesc.getIdentity()).toString());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                this.buildSingleSnapshot(ss, (TableDesc)tableDesc, baseDir, fs, (Map<String, Result>)snapSizeMap);
                boxedUnit = stepCheckpoint.map((Function1 & Serializable & scala.Serializable)x$4 -> {
                    x$4.checkpoint(tableDesc);
                    return BoxedUnit.UNIT;
                });
            }
            return boxedUnit;
        });
    }

    public Map<String, Result> executeBuildSnapshot(SparkSession ss, scala.collection.immutable.Set<TableDesc> toBuildTableDesc, String baseDir, boolean isParallelBuild, int snapshotParallelBuildTimeoutSeconds) {
        ConcurrentMap snapSizeMap = Maps.newConcurrentMap();
        FileSystem fs = HadoopUtil.getWorkingFileSystem();
        KylinConfig kylinConf = KylinConfig.getInstanceFromEnv();
        String project = ((TableDesc)toBuildTableDesc.iterator().next()).getProject();
        Option<StepCheckpointSnapshot> stepCheckpoint = this.getStepCheckpoint(kylinConf.getJobTmpDir(project), fs);
        if (isParallelBuild) {
            this.executeParallelBuildSnapshot(ss, toBuildTableDesc, baseDir, snapSizeMap, fs, snapshotParallelBuildTimeoutSeconds);
        } else {
            this.executeSerialBuildSnapshot(ss, toBuildTableDesc, baseDir, snapSizeMap, fs, stepCheckpoint);
        }
        return snapSizeMap;
    }

    private boolean isIgnoredSnapshotTable(TableDesc tableDesc, Set<String> ignoredSnapshotTables) {
        if (ignoredSnapshotTables == null || tableDesc.getLastSnapshotPath() == null) {
            return false;
        }
        return ignoredSnapshotTables.contains(tableDesc.getIdentity());
    }

    private scala.collection.immutable.Set<TableDesc> toBeCalculateTableDesc(NDataModel model, Set<String> ignoredSnapshotTables) {
        String project = model.getRootFactTable().getTableDesc().getProject();
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        scala.collection.immutable.Set toBuildTableDesc = ((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(model.getJoinTables()).asScala()).filter((Function1 & Serializable & scala.Serializable)lookupDesc -> BoxesRunTime.boxToBoolean((boolean)SnapshotBuilder.$anonfun$toBeCalculateTableDesc$1(this, model, ignoredSnapshotTables, lookupDesc)))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getTableRef().getTableDesc(), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)tableDesc -> BoxesRunTime.boxToBoolean((boolean)SnapshotBuilder.$anonfun$toBeCalculateTableDesc$3(tableManager, tableDesc)))).toSet();
        scala.collection.immutable.Set toBuildTableDescTableName = (scala.collection.immutable.Set)toBuildTableDesc.map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getIdentity(), Set$.MODULE$.canBuildFrom());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("table to be calculate total rows: ").append(toBuildTableDescTableName).toString());
        return toBuildTableDesc;
    }

    /*
     * WARNING - void declaration
     */
    public scala.collection.immutable.Set<TableDesc> distinctTableDesc(NDataModel model, Set<String> ignoredSnapshotTables) {
        void var3_3;
        scala.collection.immutable.Set toBuildTableDesc = ((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(model.getJoinTables()).asScala()).filter((Function1 & Serializable & scala.Serializable)lookupDesc -> BoxesRunTime.boxToBoolean((boolean)SnapshotBuilder.$anonfun$distinctTableDesc$1(this, model, ignoredSnapshotTables, lookupDesc)))).map((Function1 & Serializable & scala.Serializable)x$7 -> x$7.getTableRef().getTableDesc(), Buffer$.MODULE$.canBuildFrom())).toSet();
        scala.collection.immutable.Set toBuildTableDescTableName = (scala.collection.immutable.Set)toBuildTableDesc.map((Function1 & Serializable & scala.Serializable)x$8 -> x$8.getIdentity(), Set$.MODULE$.canBuildFrom());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("table snapshot to be build: ").append(toBuildTableDescTableName).toString());
        return var3_3;
    }

    public Dataset<Row> getSourceData(SparkSession ss, TableDesc tableDesc) {
        Map params = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(tableDesc.getProject()).getLegalOverrideKylinProps();
        return ((NSparkCubingEngine.NSparkCubingSource)SourceFactory.createEngineAdapter((ISourceAware)tableDesc, NSparkCubingEngine.NSparkCubingSource.class)).getSourceData(tableDesc, ss, params);
    }

    public String getFileMd5(FileStatus file) {
        FileSystem dfs = HadoopUtil.getWorkingFileSystem();
        FSDataInputStream in = dfs.open(file.getPath());
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> DigestUtils.md5Hex((InputStream)in));
        if (!(try_ instanceof Success)) {
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable error = failure.exception();
                in.close();
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("building snapshot get file: ").append(file.getPath()).append(" md5 error,msg: ").append(error.getMessage()).toString());
                throw new IOException(new StringBuilder(30).append("Failed to generate file: ").append(file.getPath()).append(" md5 ").toString(), error);
            }
            throw new MatchError((Object)try_);
        }
        Success success = (Success)try_;
        String md5 = (String)success.value();
        in.close();
        String string = md5;
        return string;
    }

    public void buildSingleSnapshot(SparkSession ss, TableDesc tableDesc, String baseDir, FileSystem fs, Map<String, Result> resultMap) {
        Dataset<Row> sourceData = this.getSourceData(ss, tableDesc);
        Path tablePath = FileNames$.MODULE$.snapshotFile(tableDesc);
        ObjectRef snapshotTablePath = ObjectRef.create((Object)new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tablePath), "/")).append(UUID.randomUUID()).toString());
        String resourcePath = new StringBuilder(1).append(baseDir).append("/").append((String)snapshotTablePath.elem).toString();
        sourceData.coalesce(1).write().parquet(resourcePath);
        Tuple2<Object, Object> tuple2 = this.computeSnapshotSize(sourceData);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        long originSize = tuple2._1$mcJ$sp();
        long totalRows = tuple2._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(originSize, totalRows);
        Tuple2.mcJJ.sp sp3 = sp2;
        long originSize2 = sp3._1$mcJ$sp();
        long totalRows2 = sp3._2$mcJ$sp();
        FileStatus currSnapFile = (FileStatus)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(resourcePath), this.parquetPathFilter()))).head();
        String currSnapMd5 = this.getFileMd5(currSnapFile);
        String md5Path = new StringBuilder(2).append(resourcePath).append("/").append("_").append(currSnapMd5).append(this.org$apache$kylin$engine$spark$builder$SnapshotBuilder$$MD5_SUFFIX()).toString();
        BooleanRef isReuseSnap = BooleanRef.create((boolean)false);
        String existPath = new StringBuilder(1).append(baseDir).append("/").append(tablePath).toString();
        FileStatus[] existSnaps = (FileStatus[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fs.listStatus(new Path(existPath)))).filterNot((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)SnapshotBuilder.$anonfun$buildSingleSnapshot$1(snapshotTablePath, x$10)));
        Breaks$.MODULE$.breakable((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])existSnaps)).foreach((Function1 & Serializable & scala.Serializable)snap -> {
            SnapshotBuilder.$anonfun$buildSingleSnapshot$3(this, fs, currSnapMd5, snapshotTablePath, tablePath, resourcePath, isReuseSnap, snap);
            return BoxedUnit.UNIT;
        }));
        if (!isReuseSnap.elem) {
            fs.createNewFile(new Path(md5Path));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Create md5 file: ").append(md5Path).append(" for snap: ").append(currSnapFile).toString());
        }
        resultMap.put(tableDesc.getIdentity(), new Result(this, (String)snapshotTablePath.elem, originSize2, totalRows2));
    }

    public void buildSingleSnapshotWithoutMd5(SparkSession ss, TableDesc tableDesc, String baseDir, ConcurrentMap<String, Result> resultMap) {
        Tuple2 tuple2;
        LazyRef snapshotInfo$lzy = new LazyRef();
        Dataset<Row> sourceData = this.getSourceData(ss, tableDesc);
        Path tablePath = FileNames$.MODULE$.snapshotFile(tableDesc);
        String snapshotTablePath = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tablePath), "/")).append(UUID.randomUUID()).toString();
        String resourcePath = new StringBuilder(1).append(baseDir).append("/").append(snapshotTablePath).toString();
        ObjectRef hadoopConf = ObjectRef.create((Object)SparderEnv$.MODULE$.getHadoopConfiguration());
        if (this.kylinConfig().getClusterManagerClassName().contains("AWSServerless")) {
            hadoopConf.elem = ss.sparkContext().hadoopConfiguration();
        }
        if ((tuple2 = this.liftedTree1$1(sourceData, hadoopConf)) == null) {
            throw new MatchError((Object)tuple2);
        }
        int repartitionNum = tuple2._1$mcI$sp();
        Object sizeMB = tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)repartitionNum), sizeMB);
        Tuple2 tuple23 = tuple22;
        int repartitionNum2 = tuple23._1$mcI$sp();
        Object sizeMB2 = tuple23._2();
        ss.sparkContext().setJobDescription(new StringBuilder(22).append("Build table snapshot ").append(tableDesc.getIdentity()).append(".").toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Building snapshot: ").append(LogUtils$.MODULE$.jsonMap(SnapshotBuilder.snapshotInfo$1(snapshotInfo$lzy, tableDesc, snapshotTablePath, sizeMB2, repartitionNum2))).toString());
        if (repartitionNum2 == 0) {
            sourceData.write().parquet(resourcePath);
        } else {
            sourceData.repartition(repartitionNum2).write().parquet(resourcePath);
        }
        Tuple2<Object, Object> tuple24 = this.computeSnapshotSize(sourceData);
        if (tuple24 == null) {
            throw new MatchError(tuple24);
        }
        long originSize = tuple24._1$mcJ$sp();
        long totalRows = tuple24._2$mcJ$sp();
        Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(originSize, totalRows);
        Tuple2.mcJJ.sp sp3 = sp2;
        long originSize2 = sp3._1$mcJ$sp();
        long totalRows2 = sp3._2$mcJ$sp();
        resultMap.put(tableDesc.getIdentity(), new Result(this, snapshotTablePath, originSize2, totalRows2));
    }

    public Tuple2<Object, Object> computeSnapshotSize(Dataset<Row> sourceData) {
        if (!this.needCollectStat()) {
            return new Tuple2.mcJJ.sp(-1L, -1L);
        }
        int columnSize = sourceData.columns().length;
        Dataset ds = sourceData.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            LongRef totalSize = LongRef.create((long)0L);
            LongRef totalRows = LongRef.create((long)0L);
            iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                SnapshotBuilder.$anonfun$computeSnapshotSize$2(columnSize, totalSize, totalRows, row);
                return BoxedUnit.UNIT;
            });
            return new .colon.colon((Object)new Tuple2.mcJJ.sp(totalSize.elem, totalRows.elem), (List)Nil$.MODULE$).toIterator();
        }, Encoders$.MODULE$.tuple(Encoders$.MODULE$.scalaLong(), Encoders$.MODULE$.scalaLong()));
        return ds.isEmpty() ? new Tuple2.mcJJ.sp(0L, 0L) : (Tuple2)ds.reduce((Function2 & Serializable & scala.Serializable)(a, b) -> new Tuple2.mcJJ.sp(a._1$mcJ$sp() + b._1$mcJ$sp(), a._2$mcJ$sp() + b._2$mcJ$sp()));
    }

    public <R> R wrapConfigExecute(Function0<R> callable, String taskInfo) {
        Object object;
        try (KylinConfig.SetAndUnsetThreadLocalConfig config = null;){
            try {
                config = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)this.kylinConfig());
                object = callable.apply();
            }
            catch (Exception exception) {
                this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Error for build snapshot table with ").append(taskInfo).toString(), exception);
                throw exception;
            }
        }
        return (R)object;
    }

    public Tuple2<Object, Object> decideSparkJobArg(Dataset<Row> sourceData) {
        Tuple2.mcID.sp sp2;
        Configuration hadoopConf = SparderEnv$.MODULE$.getHadoopConfiguration();
        if (this.kylinConfig().getClusterManagerClassName().contains("AWSServerless")) {
            hadoopConf = sourceData.sparkSession().sparkContext().hadoopConfiguration();
        }
        try {
            ObjectRef hadoopConf2 = ObjectRef.create((Object)SparderEnv$.MODULE$.getHadoopConfiguration());
            if (this.kylinConfig().getClusterManagerClassName().contains("AWSServerless")) {
                hadoopConf2.elem = sourceData.sparkSession().sparkContext().hadoopConfiguration();
            }
            double sizeInMB = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)ResourceDetectUtils$.MODULE$.getPaths(sourceData.queryExecution().sparkPlan()).map((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToLong((long)SnapshotBuilder.$anonfun$decideSparkJobArg$1(hadoopConf2, path)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) * 1.0 / (double)this.MB();
            int num = (int)Math.ceil(sizeInMB / (double)KylinBuildEnv$.MODULE$.get().kylinConfig().getSnapshotShardSizeMB());
            sp2 = new Tuple2.mcID.sp(num, sizeInMB);
        }
        catch (Throwable t) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred when estimate repartition number.", t);
            sp2 = new Tuple2.mcID.sp(0, 0.0);
        }
        return sp2;
    }

    private Option<StepCheckpointSnapshot> getStepCheckpoint(String jobTmp, FileSystem fs) {
        None$ none$;
        if (Objects.isNull(this.jobId())) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "jobId is null, wouldn't checkpoint snapshot step.");
            none$ = None$.MODULE$;
        } else {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("jobId ").append(this.jobId()).append(", would checkpoint snapshot step.").toString());
            none$ = new Some((Object)new StepCheckpointSnapshot(new StringBuilder(0).append(jobTmp).append(this.jobId()).toString(), fs));
        }
        return none$;
    }

    private final void Result$lzycompute$1() {
        SnapshotBuilder snapshotBuilder = this;
        synchronized (snapshotBuilder) {
            if (this.Result$module == null) {
                this.Result$module = new SnapshotBuilder$Result$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$updateMeta$1(SnapshotBuilder $this, String project$1, Map resultMap$2, TableDesc table) {
        $this.updateTableSnapshot(project$1, table, resultMap$2);
        $this.updateTable(project$1, table.getIdentity(), resultMap$2);
    }

    public static final /* synthetic */ boolean $anonfun$toBeCalculateTableDesc$1(SnapshotBuilder $this, NDataModel model$2, Set ignoredSnapshotTables$1, JoinTableDesc lookupDesc) {
        TableDesc tableDesc = lookupDesc.getTableRef().getTableDesc();
        boolean isLookupTable = model$2.isLookupTable(lookupDesc.getTableRef());
        return isLookupTable && !$this.isIgnoredSnapshotTable(tableDesc, ignoredSnapshotTables$1);
    }

    public static final /* synthetic */ boolean $anonfun$toBeCalculateTableDesc$3(NTableMetadataManager tableManager$1, TableDesc tableDesc) {
        TableExtDesc tableExtDesc = tableManager$1.getTableExtIfExists(tableDesc);
        return tableExtDesc == null || tableExtDesc.getTotalRows() == 0L;
    }

    public static final /* synthetic */ boolean $anonfun$distinctTableDesc$1(SnapshotBuilder $this, NDataModel model$3, Set ignoredSnapshotTables$2, JoinTableDesc lookupDesc) {
        TableDesc tableDesc = lookupDesc.getTableRef().getTableDesc();
        boolean isLookupTable = model$3.isLookupTable(lookupDesc.getTableRef());
        return isLookupTable && !$this.isIgnoredSnapshotTable(tableDesc, ignoredSnapshotTables$2);
    }

    public static final /* synthetic */ boolean $anonfun$buildSingleSnapshot$1(ObjectRef snapshotTablePath$1, FileStatus x$10) {
        String string = x$10.getPath().getName();
        String string2 = new Path((String)snapshotTablePath$1.elem).getName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ void $anonfun$buildSingleSnapshot$3(SnapshotBuilder $this, FileSystem fs$2, String currSnapMd5$1, ObjectRef snapshotTablePath$1, Path tablePath$1, String resourcePath$1, BooleanRef isReuseSnap$1, FileStatus snap) {
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> fs$2.listStatus(snap.getPath(), $this.md5PathFilter()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            FileStatus[] list = (FileStatus[])success.value();
            Option option = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])list)).headOption();
            if (option instanceof Some) {
                Some some = (Some)option;
                FileStatus file = (FileStatus)some.value();
                String md5Snap = file.getPath().getName().replace($this.org$apache$kylin$engine$spark$builder$SnapshotBuilder$$MD5_SUFFIX(), "").replace("_", "");
                String string = currSnapMd5$1;
                String string2 = md5Snap;
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    snapshotTablePath$1.elem = new StringBuilder(0).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd((Object)tablePath$1), "/")).append(snap.getPath().getName()).toString();
                    fs$2.delete(new Path(resourcePath$1), true);
                    isReuseSnap$1.elem = true;
                    throw Breaks$.MODULE$.break();
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(option)) {
                $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(40).append("Snapshot path: ").append(snap.getPath()).append(" not exists snapshot file").toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                throw new MatchError((Object)option);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable error = failure.exception();
            $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "File not found", error);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError((Object)try_);
        }
    }

    public static final /* synthetic */ long $anonfun$buildSingleSnapshotWithoutMd5$1(ObjectRef hadoopConf$1, Path path) {
        return HadoopUtil.getContentSummary((FileSystem)path.getFileSystem((Configuration)hadoopConf$1.elem), (Path)path).getLength();
    }

    private final /* synthetic */ Tuple2 liftedTree1$1(Dataset sourceData$1, ObjectRef hadoopConf$1) {
        Tuple2.mcII.sp sp2;
        try {
            double sizeInMB = (double)BoxesRunTime.unboxToLong((Object)((TraversableOnce)ResourceDetectUtils$.MODULE$.getPaths(sourceData$1.queryExecution().sparkPlan()).map((Function1 & Serializable & scala.Serializable)path -> BoxesRunTime.boxToLong((long)SnapshotBuilder.$anonfun$buildSingleSnapshotWithoutMd5$1(hadoopConf$1, path)), Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)) * 1.0 / (double)this.MB();
            int num = (int)Math.ceil(sizeInMB / (double)KylinBuildEnv$.MODULE$.get().kylinConfig().getSnapshotShardSizeMB());
            sp2 = new Tuple2.mcID.sp(num, sizeInMB);
        }
        catch (Throwable t) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred when estimate repartition number.", t);
            sp2 = new Tuple2.mcII.sp(0, 0);
        }
        return sp2;
    }

    private static final /* synthetic */ scala.collection.immutable.Map snapshotInfo$lzycompute$1(LazyRef snapshotInfo$lzy$1, TableDesc tableDesc$4, String snapshotTablePath$2, Object sizeMB$1, int repartitionNum$1) {
        scala.collection.immutable.Map map;
        LazyRef lazyRef = snapshotInfo$lzy$1;
        synchronized (lazyRef) {
            map = snapshotInfo$lzy$1.initialized() ? (scala.collection.immutable.Map)snapshotInfo$lzy$1.value() : (scala.collection.immutable.Map)snapshotInfo$lzy$1.initialize((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source"), (Object)tableDesc$4.getIdentity()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"snapshot"), (Object)snapshotTablePath$2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sizeMB"), sizeMB$1), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)repartitionNum$1))})));
        }
        return map;
    }

    private static final scala.collection.immutable.Map snapshotInfo$1(LazyRef snapshotInfo$lzy$1, TableDesc tableDesc$4, String snapshotTablePath$2, Object sizeMB$1, int repartitionNum$1) {
        return snapshotInfo$lzy$1.initialized() ? (scala.collection.immutable.Map)snapshotInfo$lzy$1.value() : SnapshotBuilder.snapshotInfo$lzycompute$1(snapshotInfo$lzy$1, tableDesc$4, snapshotTablePath$2, sizeMB$1, repartitionNum$1);
    }

    public static final /* synthetic */ void $anonfun$computeSnapshotSize$2(int columnSize$1, LongRef totalSize$1, LongRef totalRows$3, Row row) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), columnSize$1).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            Object value = row.get(i);
            String strValue = value == null ? null : value.toString();
            totalSize$1.elem += (long)DFChooser$.MODULE$.utf8Length(strValue);
        });
        ++totalRows$3.elem;
    }

    public static final /* synthetic */ long $anonfun$decideSparkJobArg$1(ObjectRef hadoopConf$2, Path path) {
        return HadoopUtil.getContentSummary((FileSystem)path.getFileSystem((Configuration)hadoopConf$2.elem), (Path)path).getLength();
    }

    public SnapshotBuilder(String jobId) {
        this.jobId = jobId;
        Logging.$init$((Logging)this);
        this.org$apache$kylin$engine$spark$builder$SnapshotBuilder$$MD5_SUFFIX = ".md5";
        this.org$apache$kylin$engine$spark$builder$SnapshotBuilder$$PARQUET_SUFFIX = ".parquet";
        this.MB = 0x100000;
        this.kylinConfig = KylinConfig.getInstanceFromEnv();
        this.needCollectStat = KapConfig.getInstanceFromEnv().isRecordSourceUsage();
        this.parquetPathFilter = new PathFilter(this){
            private final /* synthetic */ SnapshotBuilder $outer;

            public boolean accept(Path path) {
                return path.getName().endsWith(this.$outer.org$apache$kylin$engine$spark$builder$SnapshotBuilder$$PARQUET_SUFFIX());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
        this.md5PathFilter = new PathFilter(this){
            private final /* synthetic */ SnapshotBuilder $outer;

            public boolean accept(Path path) {
                return path.getName().endsWith(this.$outer.org$apache$kylin$engine$spark$builder$SnapshotBuilder$$MD5_SUFFIX());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        };
    }

    public SnapshotBuilder() {
        this(null);
    }

    public class Result
    implements Product,
    scala.Serializable {
        private final String path;
        private final long originalSize;
        private final long totalRows;
        public final /* synthetic */ SnapshotBuilder $outer;

        public String path() {
            return this.path;
        }

        public long originalSize() {
            return this.originalSize;
        }

        public long totalRows() {
            return this.totalRows;
        }

        public Result copy(String path, long originalSize, long totalRows) {
            return new Result(this.org$apache$kylin$engine$spark$builder$SnapshotBuilder$Result$$$outer(), path, originalSize, totalRows);
        }

        public String copy$default$1() {
            return this.path();
        }

        public long copy$default$2() {
            return this.originalSize();
        }

        public long copy$default$3() {
            return this.totalRows();
        }

        public String productPrefix() {
            return "Result";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.path();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToLong((long)this.originalSize());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToLong((long)this.totalRows());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof Result;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.path()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.originalSize()));
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.totalRows()));
            return Statics.finalizeHash((int)n, (int)3);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Result)) return false;
            if (((Result)object).org$apache$kylin$engine$spark$builder$SnapshotBuilder$Result$$$outer() != this.org$apache$kylin$engine$spark$builder$SnapshotBuilder$Result$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            Result result = (Result)x$1;
            String string = this.path();
            String string2 = result.path();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (this.originalSize() != result.originalSize()) return false;
            if (this.totalRows() != result.totalRows()) return false;
            if (!result.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ SnapshotBuilder org$apache$kylin$engine$spark$builder$SnapshotBuilder$Result$$$outer() {
            return this.$outer;
        }

        public Result(SnapshotBuilder $outer, String path, long originalSize, long totalRows) {
            this.path = path;
            this.originalSize = originalSize;
            this.totalRows = totalRows;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

