/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder;

import java.io.IOException;
import java.io.Serializable;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.engine.spark.builder.SnapshotBuilder;
import org.apache.kylin.engine.spark.builder.SnapshotPartitionBuilder;
import org.apache.kylin.engine.spark.utils.LogUtils$;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.utils.ProxyThreadUtils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ArrayOps;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.ExecutionContextExecutorService;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005}b\u0001B\u0004\t\u0001UAQA\u0007\u0001\u0005\u0002mAQ!\b\u0001\u0005\u0002yAQ\u0001\u001e\u0001\u0005\u0002UDq!!\u0002\u0001\t\u0003\t9\u0001C\u0004\u0002\u0016\u0001!\t!a\u0006\t\u000f\u00055\u0002\u0001\"\u0001\u00020\tA2K\\1qg\"|G\u000fU1si&$\u0018n\u001c8Ck&dG-\u001a:\u000b\u0005%Q\u0011a\u00022vS2$WM\u001d\u0006\u0003\u00171\tQa\u001d9be.T!!\u0004\b\u0002\r\u0015tw-\u001b8f\u0015\ty\u0001#A\u0003ls2LgN\u0003\u0002\u0012%\u00051\u0011\r]1dQ\u0016T\u0011aE\u0001\u0004_J<7\u0001A\n\u0003\u0001Y\u0001\"a\u0006\r\u000e\u0003!I!!\u0007\u0005\u0003\u001fMs\u0017\r]:i_R\u0014U/\u001b7eKJ\fa\u0001P5oSRtD#\u0001\u000f\u0011\u0005]\u0001\u0011!\u00042vS2$7K\\1qg\"|G\u000fF\u0003 K9BT\t\u0005\u0002!G5\t\u0011EC\u0001#\u0003\u0015\u00198-\u00197b\u0013\t!\u0013E\u0001\u0003V]&$\b\"\u0002\u0014\u0003\u0001\u00049\u0013AA:t!\tAC&D\u0001*\u0015\tQ3&A\u0002tc2T!a\u0003\t\n\u00055J#\u0001D*qCJ\\7+Z:tS>t\u0007\"B\u0018\u0003\u0001\u0004\u0001\u0014!\u0002;bE2,\u0007CA\u00197\u001b\u0005\u0011$BA\u001a5\u0003\u0015iw\u000eZ3m\u0015\t)d\"\u0001\u0005nKR\fG-\u0019;b\u0013\t9$GA\u0005UC\ndW\rR3tG\")\u0011H\u0001a\u0001u\u0005a\u0001/\u0019:uSRLwN\\\"pYB\u00111H\u0011\b\u0003y\u0001\u0003\"!P\u0011\u000e\u0003yR!a\u0010\u000b\u0002\rq\u0012xn\u001c;?\u0013\t\t\u0015%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA!\"\u0011\u00151%\u00011\u0001H\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\t\u0004\u00116ST\"A%\u000b\u0005)[\u0015\u0001B;uS2T\u0011\u0001T\u0001\u0005U\u00064\u0018-\u0003\u0002O\u0013\n\u00191+\u001a;)\u0007\t\u0001\u0016\fE\u0002!#NK!AU\u0011\u0003\rQD'o\\<t!\t!v+D\u0001V\u0015\t16*\u0001\u0002j_&\u0011\u0001,\u0016\u0002\f\u0013>+\u0005pY3qi&|g.\r\u0003\u001fui\u001b\u0018'B\u0012\\?:\u0004WC\u0001/^+\u0005QD!\u00020\u0015\u0005\u0004\u0019'!\u0001+\n\u0005\u0001\f\u0017a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0013G\u0003\u0002cC\u00051A\u000f\u001b:poN\f\"\u0001Z4\u0011\u0005\u0001*\u0017B\u00014\"\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"\u0001[6\u000f\u0005\u0001J\u0017B\u00016\"\u0003\u001d\u0001\u0018mY6bO\u0016L!\u0001\\7\u0003\u0013QC'o\\<bE2,'B\u00016\"c\u0015\u0019s\u000e]9c\u001d\t\u0001\u0003/\u0003\u0002cCE\"!\u0005I\u0011s\u0005\u0015\u00198-\u00197bc\t13+\u0001\fdQ\u0016\u001c7\u000eU8j]R4uN\u001d)beRLG/[8o)\u0015yb\u000f\u001f>}\u0011\u001598\u00011\u0001;\u0003\u001d\u0001(o\u001c6fGRDQ!_\u0002A\u0002i\n\u0011\u0002^1cY\u0016t\u0015-\\3\t\u000bm\u001c\u0001\u0019\u0001\u001e\u0002\u0013A\f'\u000f^5uS>t\u0007\"B?\u0004\u0001\u0004q\u0018A\u0002:fgVdG\u000fE\u0002\u0000\u0003\u0003i\u0011\u0001A\u0005\u0004\u0003\u0007A\"A\u0002*fgVdG/\u0001\u000bfq\u0016\u001cW\u000f^3Ck&dGm\u00158baNDw\u000e\u001e\u000b\n?\u0005%\u00111BA\u0007\u0003\u001fAQA\n\u0003A\u0002\u001dBQa\f\u0003A\u0002ABQ!\u000f\u0003A\u0002iBaA\u0012\u0003A\u0002\u0005E\u0001\u0003B\u001e\u0002\u0014iJ!A\u0014#\u0002\u00139,wOR5mi\u0016\u0014Hc\u0002\u001e\u0002\u001a\u0005m\u0011Q\u0004\u0005\u0006s\u0015\u0001\rA\u000f\u0005\u0006w\u0016\u0001\rA\u000f\u0005\b\u0003?)\u0001\u0019AA\u0011\u0003\u001d\u0019w\u000e\u001c+za\u0016\u0004B!a\t\u0002*5\u0011\u0011Q\u0005\u0006\u0004\u0003O!\u0014\u0001\u00033bi\u0006$\u0018\u0010]3\n\t\u0005-\u0012Q\u0005\u0002\t\t\u0006$\u0018\rV=qK\u0006i\"-^5mINKgn\u001a7f':\f\u0007o\u001d5pi^KG\u000f[8vi6#W\u0007F\u0006\u007f\u0003c\t\u0019$a\u000e\u0002:\u0005m\u0002\"\u0002\u0014\u0007\u0001\u00049\u0003BBA\u001b\r\u0001\u0007\u0001'A\u0005uC\ndW\rR3tG\")\u0011H\u0002a\u0001u!)1P\u0002a\u0001u!1\u0011Q\b\u0004A\u0002i\n\u0011c\u001d8baNDw\u000e\u001e+bE2,\u0007+\u0019;i\u0001")
public class SnapshotPartitionBuilder
extends SnapshotBuilder {
    public void buildSnapshot(SparkSession ss, TableDesc table, String partitionCol, Set<String> partitions) throws IOException {
        this.executeBuildSnapshot(ss, table, partitionCol, (scala.collection.immutable.Set<String>)((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(partitions).asScala()).toSet());
    }

    public void checkPointForPartition(String project, String tableName, String partition, SnapshotBuilder.Result result) {
        public class Org_apache_kylin_engine_spark_builder_SnapshotPartitionBuilder$TableUpdateOps$1
        implements UnitOfWork.Callback<TableDesc> {
            private final String project$1;
            private final String tableName$1;
            private final SnapshotBuilder.Result result$1;
            private final String partition$1;

            public void preProcess() {
                super.preProcess();
            }

            public void onProcessError(Throwable x$1) {
                super.onProcessError(x$1);
            }

            /*
             * WARNING - void declaration
             */
            public TableDesc process() {
                void var2_2;
                NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project$1);
                TableDesc copyTable = tableMetadataManager.copyForWrite(tableMetadataManager.getTableDesc(this.tableName$1));
                TableExtDesc copyExt = tableMetadataManager.copyForWrite(tableMetadataManager.getOrCreateTableExt(this.tableName$1));
                if (this.result$1.totalRows() != -1L) {
                    copyExt.setTotalRows(copyExt.getTotalRows() + this.result$1.totalRows() - copyTable.getPartitionRow(this.partition$1));
                    copyTable.putPartitionSize(this.partition$1, this.result$1.originalSize());
                    copyTable.setSnapshotTotalRows(copyTable.getSnapshotTotalRows() + this.result$1.totalRows() - copyTable.getPartitionRow(this.partition$1));
                    copyTable.putPartitionRow(this.partition$1, this.result$1.totalRows());
                } else {
                    copyTable.putPartitionSize(this.partition$1, 0L);
                    copyTable.putPartitionRow(this.partition$1, 0L);
                }
                tableMetadataManager.updateTableDesc(copyTable);
                tableMetadataManager.saveTableExt(copyExt);
                return var2_2;
            }

            public Org_apache_kylin_engine_spark_builder_SnapshotPartitionBuilder$TableUpdateOps$1(SnapshotPartitionBuilder $outer, String project$1, String tableName$1, SnapshotBuilder.Result result$1, String partition$1) {
                this.project$1 = project$1;
                this.tableName$1 = tableName$1;
                this.result$1 = result$1;
                this.partition$1 = partition$1;
            }
        }
        UnitOfWork.doInTransactionWithRetry((UnitOfWork.Callback)new Org_apache_kylin_engine_spark_builder_SnapshotPartitionBuilder$TableUpdateOps$1(null, project, tableName, result, partition), (String)project);
        this.log().info(new StringBuilder(40).append("check point partitions for ").append(tableName).append(" , partition ").append(partition).toString());
    }

    public void executeBuildSnapshot(SparkSession ss, TableDesc table, String partitionCol, scala.collection.immutable.Set<String> partitions) {
        String baseDir = KapConfig.getInstanceFromEnv().getMetadataWorkingDirectory();
        String resourcePath = table.getTempSnapshotPath();
        String snapshotTablePath = new StringBuilder(0).append(baseDir).append('/').append(resourcePath).toString();
        KylinConfig kylinConf = KylinConfig.getInstanceFromEnv();
        int snapshotParallelBuildTimeoutSeconds = kylinConf.snapshotParallelBuildTimeoutSeconds();
        int maxThread = kylinConf.snapshotPartitionBuildMaxThread() >= 2 ? kylinConf.snapshotPartitionBuildMaxThread() : 2;
        ExecutorService service = Executors.newFixedThreadPool(maxThread);
        ExecutionContextExecutorService executorContext = ExecutionContext$.MODULE$.fromExecutorService(service);
        scala.collection.immutable.Set futures = (scala.collection.immutable.Set)partitions.map((Function1 & Serializable & scala.Serializable)partition -> Future$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.wrapConfigExecute((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            SnapshotBuilder.Result result = this.buildSingleSnapshotWithoutMd5(ss, table, partitionCol, (String)partition, snapshotTablePath);
            this.checkPointForPartition(table.getProject(), table.getIdentity(), (String)partition, result);
        }, new StringBuilder(1).append(table.getIdentity()).append(":").append((String)partition).toString()), (ExecutionContext)executorContext), Set$.MODULE$.canBuildFrom());
        try {
            Future eventualTuples = Future$.MODULE$.sequence((TraversableOnce)futures.toList(), List$.MODULE$.canBuildFrom(), (ExecutionContext)executorContext);
            ProxyThreadUtils$.MODULE$.awaitResult(eventualTuples, (Duration)new package.DurationInt(package$.MODULE$.DurationInt(snapshotParallelBuildTimeoutSeconds)).seconds());
        }
        finally {
            ProxyThreadUtils$.MODULE$.shutdown(service, ProxyThreadUtils$.MODULE$.shutdown$default$2());
        }
    }

    public String newFilter(String partitionCol, String partition, DataType colType) {
        return colType.isDate() ? new StringBuilder(20).append("`").append(partitionCol).append("`").append("= cast('").append(partition).append("' as date)").toString() : (colType.isNumberFamily() ? new StringBuilder(4).append("`").append(partitionCol).append("`").append("= ").append(partition).toString() : new StringBuilder(6).append("`").append(partitionCol).append("`").append("= '").append(partition).append("'").toString());
    }

    public SnapshotBuilder.Result buildSingleSnapshotWithoutMd5(SparkSession ss, TableDesc tableDesc, String partitionCol, String partition, String snapshotTablePath) {
        LazyRef snapshotInfo$lzy = new LazyRef();
        Dataset sourceData = this.getSourceData(ss, tableDesc);
        sourceData = sourceData.filter(this.newFilter(partitionCol, partition, tableDesc.findColumnByName(partitionCol).getType()));
        sourceData = sourceData.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceData.columns())).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)SnapshotPartitionBuilder.$anonfun$buildSingleSnapshotWithoutMd5$1(partitionCol, x$1))))).map((Function1 & Serializable & scala.Serializable)x$2 -> new StringBuilder(2).append("`").append((String)x$2).append("`").toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))));
        String newPartition = partition.replaceAll(" ", "_");
        newPartition = newPartition.replaceAll(":", "_");
        String partitionName = new StringBuilder(0).append(partitionCol).append('=').append(newPartition).toString();
        String resourcePath = new StringBuilder(1).append(snapshotTablePath).append("/").append(partitionName).toString();
        Tuple2<Object, Object> tuple2 = this.decideSparkJobArg((Dataset<Row>)sourceData);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int repartitionNum = tuple2._1$mcI$sp();
        double sizeMB = tuple2._2$mcD$sp();
        Tuple2.mcID.sp sp2 = new Tuple2.mcID.sp(repartitionNum, sizeMB);
        Tuple2.mcID.sp sp3 = sp2;
        int repartitionNum2 = sp3._1$mcI$sp();
        double sizeMB2 = sp3._2$mcD$sp();
        ss.sparkContext().setJobDescription(new StringBuilder(22).append("Build table snapshot ").append(tableDesc.getIdentity()).append(".").toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Building snapshot: ").append(LogUtils$.MODULE$.jsonMap(SnapshotPartitionBuilder.snapshotInfo$1(snapshotInfo$lzy, tableDesc, snapshotTablePath, sizeMB2, repartitionNum2, partition))).toString());
        if (repartitionNum2 == 0) {
            sourceData.write().mode(SaveMode.Overwrite).parquet(resourcePath);
        } else {
            sourceData.repartition(repartitionNum2).write().mode(SaveMode.Overwrite).parquet(resourcePath);
        }
        Tuple2<Object, Object> tuple22 = this.computeSnapshotSize((Dataset<Row>)sourceData);
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        long originSize = tuple22._1$mcJ$sp();
        long totalRows = tuple22._2$mcJ$sp();
        Tuple2.mcJJ.sp sp4 = new Tuple2.mcJJ.sp(originSize, totalRows);
        Tuple2.mcJJ.sp sp5 = sp4;
        long originSize2 = sp5._1$mcJ$sp();
        long totalRows2 = sp5._2$mcJ$sp();
        return new SnapshotBuilder.Result(this, snapshotTablePath, originSize2, totalRows2);
    }

    public static final /* synthetic */ boolean $anonfun$buildSingleSnapshotWithoutMd5$1(String partitionCol$2, String x$1) {
        return !x$1.equals(partitionCol$2);
    }

    private static final /* synthetic */ Map snapshotInfo$lzycompute$1(LazyRef snapshotInfo$lzy$1, TableDesc tableDesc$1, String snapshotTablePath$2, double sizeMB$1, int repartitionNum$1, String partition$3) {
        Map map;
        LazyRef lazyRef = snapshotInfo$lzy$1;
        synchronized (lazyRef) {
            map = snapshotInfo$lzy$1.initialized() ? (Map)snapshotInfo$lzy$1.value() : (Map)snapshotInfo$lzy$1.initialize((Object)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"source"), (Object)tableDesc$1.getIdentity()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"snapshot"), (Object)snapshotTablePath$2), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"sizeMB"), (Object)BoxesRunTime.boxToDouble((double)sizeMB$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"partition"), (Object)BoxesRunTime.boxToInteger((int)repartitionNum$1)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"buildPartition"), (Object)partition$3)})));
        }
        return map;
    }

    private static final Map snapshotInfo$1(LazyRef snapshotInfo$lzy$1, TableDesc tableDesc$1, String snapshotTablePath$2, double sizeMB$1, int repartitionNum$1, String partition$3) {
        return snapshotInfo$lzy$1.initialized() ? (Map)snapshotInfo$lzy$1.value() : SnapshotPartitionBuilder.snapshotInfo$lzycompute$1(snapshotInfo$lzy$1, tableDesc$1, snapshotTablePath$2, sizeMB$1, repartitionNum$1, partition$3);
    }
}

