/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.builder.v3dict;

import io.delta.tables.DeltaTable;
import io.delta.tables.DeltaTable$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.builder.v3dict.DictionaryContext;
import org.apache.kylin.engine.spark.builder.v3dict.GlobalDictionaryPlaceHolder;
import org.apache.kylin.engine.spark.builder.v3dict.PreCountDistinctTransformer;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.dict.NBucketDictionary;
import org.apache.spark.dict.NGlobalDictMetaInfo;
import org.apache.spark.dict.NGlobalDictionaryV2;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkInternalAgent$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.encoders.RowEncoder$;
import org.apache.spark.sql.catalyst.expressions.Alias;
import org.apache.spark.sql.catalyst.expressions.Alias$;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.EqualTo;
import org.apache.spark.sql.catalyst.expressions.ExprId;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Project;
import org.apache.spark.sql.catalyst.plans.logical.Window;
import org.apache.spark.sql.expressions.Window$;
import org.apache.spark.sql.expressions.WindowSpec;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ListBuffer;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0;
import util.retry.blocking.Failure;
import util.retry.blocking.Retry;
import util.retry.blocking.Retry$;
import util.retry.blocking.RetryStrategy;
import util.retry.blocking.RetryStrategy$;
import util.retry.blocking.Success;

public final class DictionaryBuilder$
implements Logging {
    public static DictionaryBuilder$ MODULE$;
    private final Function0<RetryStrategy> retryStrategy;
    private final KylinConfig config;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new DictionaryBuilder$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public Function0<RetryStrategy> retryStrategy() {
        return this.retryStrategy;
    }

    private KylinConfig config() {
        return this.config;
    }

    public LogicalPlan buildGlobalDict(String project, SparkSession spark, LogicalPlan plan) {
        return (LogicalPlan)this.transformCountDistinct(spark, plan).transform((PartialFunction)new scala.Serializable(spark, project){
            public static final long serialVersionUID = 0L;
            private final SparkSession spark$1;
            private final String project$1;

            /*
             * Enabled aggressive block sorting
             */
            public final <A1 extends LogicalPlan, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                if (A1 instanceof GlobalDictionaryPlaceHolder) {
                    GlobalDictionaryPlaceHolder globalDictionaryPlaceHolder = (GlobalDictionaryPlaceHolder)A1;
                    String expr = globalDictionaryPlaceHolder.exprName();
                    LogicalPlan child = globalDictionaryPlaceHolder.child();
                    if (expr != null) {
                        String string = expr;
                        if (child != null) {
                            LogicalPlan logicalPlan = child;
                            this.spark$1.sparkContext().setJobDescription(new StringBuilder(14).append("Build v3 dict ").append(string).toString());
                            String tableName = string.split("_0_DOT_0_")[0];
                            String columnName = string.split("_0_DOT_0_")[1];
                            DictionaryContext context = new DictionaryContext(this.project$1, tableName, columnName, string);
                            Retry retry = Retry$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> DictionaryBuilder$.MODULE$.org$apache$kylin$engine$spark$builder$v3dict$DictionaryBuilder$$incrementBuildDict($this.spark$1, logicalPlan, context), DictionaryBuilder$.MODULE$.retryStrategy());
                            if (retry instanceof Success) {
                                DictionaryBuilder$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Incremental persist global dictionary for: ").append(string).append(" success.").toString());
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                if (!(retry instanceof Failure)) throw new MatchError((Object)retry);
                                Failure failure = (Failure)retry;
                                Throwable e = failure.exception();
                                DictionaryBuilder$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Incremental persist global dictionary for: ").append(string).append(" failure.").toString(), e);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                            this.spark$1.sparkContext().setJobDescription(null);
                            String dictPath = DictionaryBuilder$.MODULE$.getDictionaryPath(context);
                            LogicalPlan dictPlan = SparkInternalAgent$.MODULE$.getLogicalPlan((Dataset<Row>)this.spark$1.read().format("delta").load(dictPath));
                            Tuple2 tuple2 = new Tuple2(dictPlan.output().head(), dictPlan.output().apply(1));
                            if (tuple2 == null) throw new MatchError((Object)tuple2);
                            Attribute key = (Attribute)tuple2._1();
                            Attribute value = (Attribute)tuple2._2();
                            Tuple2 tuple22 = new Tuple2((Object)key, (Object)value);
                            Tuple2 tuple23 = tuple22;
                            Attribute key2 = (Attribute)tuple23._1();
                            Attribute value2 = (Attribute)tuple23._2();
                            Tuple2 tuple24 = new Tuple2(logicalPlan.output().head(), logicalPlan.output().apply(1));
                            if (tuple24 == null) throw new MatchError((Object)tuple24);
                            Attribute existKey = (Attribute)tuple24._1();
                            Attribute existValue = (Attribute)tuple24._2();
                            Tuple2 tuple25 = new Tuple2((Object)existKey, (Object)existValue);
                            Tuple2 tuple26 = tuple25;
                            Attribute existKey2 = (Attribute)tuple26._1();
                            Attribute existValue2 = (Attribute)tuple26._2();
                            Attribute x$1 = key2;
                            String x$2 = existKey2.name();
                            ExprId x$3 = existKey2.exprId();
                            Seq x$4 = Alias$.MODULE$.apply$default$4((Expression)x$1, x$2);
                            Option x$5 = Alias$.MODULE$.apply$default$5((Expression)x$1, x$2);
                            Seq x$6 = Alias$.MODULE$.apply$default$6((Expression)x$1, x$2);
                            Alias keyAlias = new Alias((Expression)x$1, x$2, x$3, x$4, x$5, x$6);
                            Attribute x$7 = value2;
                            String x$8 = existValue2.name();
                            ExprId x$9 = existValue2.exprId();
                            Seq x$10 = Alias$.MODULE$.apply$default$4((Expression)x$7, x$8);
                            Option x$11 = Alias$.MODULE$.apply$default$5((Expression)x$7, x$8);
                            Seq x$12 = Alias$.MODULE$.apply$default$6((Expression)x$7, x$8);
                            Alias valueAlias = new Alias((Expression)x$7, x$8, x$9, x$10, x$11, x$12);
                            object = new Project((Seq)new .colon.colon((Object)keyAlias, (List)new .colon.colon((Object)valueAlias, (List)Nil$.MODULE$)), dictPlan);
                            return (B1)object;
                        }
                    }
                }
                object = function1.apply(x1);
                return (B1)object;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final boolean isDefinedAt(LogicalPlan x1) {
                LogicalPlan logicalPlan = x1;
                if (!(logicalPlan instanceof GlobalDictionaryPlaceHolder)) return false;
                GlobalDictionaryPlaceHolder globalDictionaryPlaceHolder = (GlobalDictionaryPlaceHolder)logicalPlan;
                String expr = globalDictionaryPlaceHolder.exprName();
                LogicalPlan child = globalDictionaryPlaceHolder.child();
                if (expr == null) return false;
                if (child == null) return false;
                return true;
            }
            {
                this.spark$1 = spark$1;
                this.project$1 = project$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$applyOrElse$1(org.apache.kylin.engine.spark.builder.v3dict.DictionaryBuilder$$anonfun$buildGlobalDict$1 org.apache.spark.sql.catalyst.plans.logical.LogicalPlan org.apache.kylin.engine.spark.builder.v3dict.DictionaryContext ), $anonfun$applyOrElse$2(java.lang.String ), $anonfun$applyOrElse$3(java.lang.String )}, serializedLambda);
            }
        });
    }

    private LogicalPlan transformerDictPlan(SparkSession spark, DictionaryContext context, LogicalPlan plan) {
        LogicalPlan logicalPlan;
        Project project;
        LogicalPlan logicalPlan2;
        Project project2;
        LogicalPlan logicalPlan3;
        String dictPath = this.getDictionaryPath(context);
        DeltaTable dictTable = DeltaTable$.MODULE$.forPath(dictPath);
        long maxOffset = dictTable.toDF().count();
        LogicalPlan logicalPlan4 = plan;
        if (logicalPlan4 instanceof Project && (logicalPlan3 = (project2 = (Project)logicalPlan4).child()) instanceof Project && (logicalPlan2 = (project = (Project)logicalPlan3).child()) instanceof Window) {
            Window window = (Window)logicalPlan2;
            LogicalPlan windowChild = window.child();
            String column = context.expr();
            WindowSpec windowSpec = Window$.MODULE$.orderBy((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(column)}));
            Column joinCondition = SparkInternalAgent$.MODULE$.createColumn((Expression)new EqualTo(functions$.MODULE$.col(column).cast((DataType)StringType$.MODULE$).expr(), (Expression)SparkInternalAgent$.MODULE$.getLogicalPlan((Dataset<Row>)dictTable.toDF()).output().head()));
            String filterKey = ((NamedExpression)SparkInternalAgent$.MODULE$.getLogicalPlan((Dataset<Row>)dictTable.toDF()).output().head()).name();
            Dataset antiJoinDF = SparkInternalAgent$.MODULE$.getDataFrame(spark, windowChild).filter(functions$.MODULE$.col(filterKey).isNotNull()).join(dictTable.toDF(), joinCondition, "left_anti").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(column).cast((DataType)StringType$.MODULE$).as("dict_key"), functions$.MODULE$.row_number().over(windowSpec).$plus((Object)functions$.MODULE$.lit((Object)BoxesRunTime.boxToLong((long)maxOffset))).cast((DataType)LongType$.MODULE$).as("dict_value")}));
            logicalPlan = SparkInternalAgent$.MODULE$.getLogicalPlan((Dataset<Row>)antiJoinDF);
        } else {
            logicalPlan = plan;
        }
        return logicalPlan;
    }

    public void org$apache$kylin$engine$spark$builder$v3dict$DictionaryBuilder$$incrementBuildDict(SparkSession spark, LogicalPlan plan, DictionaryContext context) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String dictPath = this.getDictionaryPath(context);
        if (DeltaTable$.MODULE$.isDeltaTable(spark, dictPath)) {
            this.mergeIncrementDict(spark, context, plan);
        } else if (config.isConvertV3DictEnable() && this.isExistsV2Dict(context) && !this.isExistsV3Dict(context)) {
            Dataset<Row> existsV2DictDF = this.fetchExistsV2Dict(spark, context);
            this.appendDictDF(existsV2DictDF, context);
            this.mergeIncrementDict(spark, context, plan);
        } else {
            Dataset<Row> incrementDictDF = SparkInternalAgent$.MODULE$.getDataFrame(spark, plan);
            this.appendDictDF(incrementDictDF, context);
        }
    }

    private void appendDictDF(Dataset<Row> dictDF, DictionaryContext context) {
        String dictPath = this.getDictionaryPath(context);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Append dict values into path ").append(dictPath).append(".").toString());
        dictDF.write().mode(SaveMode.Overwrite).format("delta").save(dictPath);
    }

    private void mergeIncrementDict(SparkSession spark, DictionaryContext context, LogicalPlan plan) {
        LogicalPlan dictPlan = this.transformerDictPlan(spark, context, plan);
        Dataset<Row> incrementDictDF = SparkInternalAgent$.MODULE$.getDataFrame(spark, dictPlan);
        String dictPath = this.getDictionaryPath(context);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("increment build global dict ").append(dictPath).toString());
        DeltaTable dictTable = DeltaTable$.MODULE$.forPath(dictPath);
        dictTable.alias("dict").merge(incrementDictDF.alias("incre_dict"), "incre_dict.dict_key = dict.dict_key and incre_dict.dict_value != dict.dict_value").whenNotMatched().insertAll().execute();
    }

    private boolean isExistsV2Dict(DictionaryContext context) {
        NGlobalDictionaryV2 globalDict = new NGlobalDictionaryV2(context.project(), context.tableName(), context.columnName(), this.config().getHdfsWorkingDirectory());
        NGlobalDictMetaInfo dictV2Meta = globalDict.getMetaInfo();
        return dictV2Meta != null;
    }

    private boolean isExistsV3Dict(DictionaryContext context) {
        String dictPath = this.getDictionaryPath(context);
        return HadoopUtil.getWorkingFileSystem().exists(new Path(dictPath));
    }

    private Dataset<Row> fetchExistsV2Dict(SparkSession spark, DictionaryContext context) {
        NGlobalDictionaryV2 globalDict = new NGlobalDictionaryV2(context.project(), context.tableName(), context.columnName(), this.config().getHdfsWorkingDirectory());
        NGlobalDictMetaInfo dictV2Meta = globalDict.getMetaInfo();
        Broadcast broadcastDict = spark.sparkContext().broadcast((Object)globalDict, ClassTag$.MODULE$.apply(NGlobalDictionaryV2.class));
        StructType dictSchema = new StructType((StructField[])((Object[])new StructField[]{new StructField("dict_key", (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4()), new StructField("dict_value", (DataType)LongType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        return dictV2Meta != null ? spark.createDataset((Seq)RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), dictV2Meta.getBucketSize()), spark.implicits().newIntEncoder()).flatMap((Function1 & Serializable & scala.Serializable)bucketId -> DictionaryBuilder$.$anonfun$fetchExistsV2Dict$1(broadcastDict, BoxesRunTime.unboxToInt((Object)bucketId)), (Encoder)RowEncoder$.MODULE$.apply(dictSchema)) : spark.emptyDataset((Encoder)RowEncoder$.MODULE$.apply(dictSchema));
    }

    private LogicalPlan transformCountDistinct(SparkSession session, LogicalPlan plan) {
        PreCountDistinctTransformer transformer = new PreCountDistinctTransformer(session);
        return transformer.apply(plan);
    }

    public String getDictionaryPath(DictionaryContext context) {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String workingDir = config.getHdfsWorkingDirectory();
        Path dictDir = new Path(context.project(), new Path("/dict/global_dict_v3", new Path(new Path(context.tableName()), context.columnName())));
        return new StringBuilder(0).append(workingDir).append(dictDir).toString();
    }

    public String wrapCol(TblColRef ref) {
        return NSparkCubingUtil.convertFromDot((String)ref.getColumnDesc().getBackTickIdentity());
    }

    public static final /* synthetic */ Iterator $anonfun$fetchExistsV2Dict$1(Broadcast broadcastDict$1, int bucketId) {
        NGlobalDictionaryV2 gDict = (NGlobalDictionaryV2)broadcastDict$1.value();
        NBucketDictionary bucketDict = gDict.loadBucketDictionary(bucketId);
        ListBuffer tupleList = new ListBuffer();
        bucketDict.getAbsoluteDictMap().object2LongEntrySet().forEach(dictTuple -> tupleList.append((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Row[]{Row$.MODULE$.fromTuple((Product)new Tuple2(dictTuple.getKey(), (Object)BoxesRunTime.boxToLong((long)dictTuple.getLongValue())))})));
        return tupleList.iterator();
    }

    private DictionaryBuilder$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.retryStrategy = RetryStrategy$.MODULE$.fixedBackOff(new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds(), 5);
        this.config = KylinConfig.getInstanceFromEnv();
    }
}

