/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.base.Preconditions;
import java.util.LinkedHashSet;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.merger.AfterBuildResourceMerger;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutableAddCuboidHandler
extends ExecutableHandler {
    private static final Logger logger = LoggerFactory.getLogger(ExecutableAddCuboidHandler.class);

    public ExecutableAddCuboidHandler(DefaultExecutableOnModel job) {
        this(job.getProject(), job.getTargetSubject(), job.getSubmitter(), null, job.getId());
    }

    public ExecutableAddCuboidHandler(String project, String modelId, String owner, String segmentId, String jobId) {
        super(project, modelId, owner, segmentId, jobId);
    }

    public void handleFinished() {
        String project = this.getProject();
        String jobId = this.getJobId();
        String modelId = this.getModelId();
        DefaultExecutableOnModel executable = this.getExecutable();
        Preconditions.checkState((executable.getTasks().size() > 1 ? 1 : 0) != 0, (Object)("job " + jobId + " steps is not enough"));
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        AfterBuildResourceMerger merger = new AfterBuildResourceMerger(kylinConfig, project);
        executable.getTasks().stream().filter(task -> task instanceof NSparkExecutable).filter(task -> ((NSparkExecutable)((Object)task)).needMergeMetadata()).forEach(task -> ((NSparkExecutable)((Object)task)).mergerMetadata(merger));
        Optional.ofNullable(executable.getParams()).ifPresent(params -> {
            String toBeDeletedLayoutIdsStr = (String)params.get("toBeDeletedLayoutIds");
            if (StringUtils.isNotBlank((String)toBeDeletedLayoutIdsStr)) {
                logger.info("Try to delete the toBeDeletedLayoutIdsStr: {}, jobId: {}", (Object)toBeDeletedLayoutIdsStr, (Object)jobId);
                LinkedHashSet<Long> toBeDeletedLayoutIds = new LinkedHashSet<Long>();
                for (String id : toBeDeletedLayoutIdsStr.split(",")) {
                    toBeDeletedLayoutIds.add(Long.parseLong(id));
                }
                NIndexPlanManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project).updateIndexPlan(modelId, copyForWrite -> copyForWrite.removeLayouts(toBeDeletedLayoutIds, true, true));
            }
        });
        this.markDFStatus();
    }

    public void handleDiscardOrSuicidal() {
        DefaultExecutableOnModel job = this.getExecutable();
        if (!job.checkCuttingInJobByModel() || !job.checkAnyTargetSegmentAndPartitionExists()) {
            return;
        }
    }
}

