/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.base.Preconditions;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.merger.AfterBuildResourceMerger;
import org.apache.kylin.job.common.SegmentUtil;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.execution.NExecutableManager;
import org.apache.kylin.metadata.cube.model.NDataLoadingRange;
import org.apache.kylin.metadata.cube.model.NDataLoadingRangeManager;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.model.ManagementType;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.Segments;
import org.apache.kylin.metadata.realization.RealizationStatusEnum;

public class ExecutableAddSegmentHandler
extends ExecutableHandler {
    public ExecutableAddSegmentHandler(String project, String modelId, String owner, String segmentId, String jobId) {
        super(project, modelId, owner, segmentId, jobId);
    }

    public void handleFinished() {
        String project = this.getProject();
        DefaultExecutableOnModel executable = this.getExecutable();
        String jobId = executable.getId();
        Preconditions.checkState((executable.getTasks().size() > 1 ? 1 : 0) != 0, (Object)("job " + jobId + " steps is not enough"));
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        AfterBuildResourceMerger merger = new AfterBuildResourceMerger(kylinConfig, project);
        executable.getTasks().stream().filter(task -> task instanceof NSparkExecutable).filter(task -> ((NSparkExecutable)((Object)task)).needMergeMetadata()).forEach(task -> ((NSparkExecutable)((Object)task)).mergerMetadata(merger));
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project);
        this.markDFStatus(dfMgr);
    }

    public void handleDiscardOrSuicidal() {
        if (this.getExecutable().checkAnyLayoutExists()) {
            return;
        }
        this.makeSegmentReady();
    }

    private void makeSegmentReady() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String segmentId = this.getSegmentId();
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)this.getProject());
        NDataflow df = dfMgr.getDataflow(this.getModelId());
        NDataflowUpdate dfUpdate = new NDataflowUpdate(this.getModelId());
        NDataSegment seg = df.copy().getSegment(segmentId);
        seg.setStatus(SegmentStatusEnum.READY);
        dfUpdate.setToUpdateSegs(new NDataSegment[]{seg});
        dfMgr.updateDataflow(dfUpdate);
        this.markDFStatus(dfMgr);
    }

    private void markDFStatus(NDataflowManager dfManager) {
        super.markDFStatus();
        NDataflow df = dfManager.getDataflow(this.getModelId());
        RealizationStatusEnum status = df.getStatus();
        if (RealizationStatusEnum.LAG_BEHIND == status) {
            NDataModel model = df.getModel();
            Preconditions.checkState((ManagementType.TABLE_ORIENTED == model.getManagementType() ? 1 : 0) != 0);
            if (this.checkOnline(model) && !df.getIndexPlan().isOfflineManually()) {
                dfManager.updateDataflowStatus(df.getId(), RealizationStatusEnum.ONLINE);
            }
        }
    }

    private boolean checkOnline(NDataModel model) {
        NExecutableManager executableManager = this.getExecutableManager(model.getProject(), KylinConfig.getInstanceFromEnv());
        int count = executableManager.listExecByModelAndStatus(model.getId(), ExecutableState::isNotProgressing, new JobTypeEnum[]{JobTypeEnum.INC_BUILD}).size();
        if (count > 0) {
            return false;
        }
        NDataflowManager dfManager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject());
        NDataflow df = dfManager.getDataflow(model.getId());
        NDataLoadingRangeManager dataLoadingRangeManager = NDataLoadingRangeManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)model.getProject());
        NDataLoadingRange dataLoadingRange = dataLoadingRangeManager.getDataLoadingRange(model.getRootFactTableName());
        Preconditions.checkState((dataLoadingRange != null ? 1 : 0) != 0);
        SegmentRange querableSegmentRange = dataLoadingRangeManager.getQuerableSegmentRange(dataLoadingRange);
        Preconditions.checkState((querableSegmentRange != null ? 1 : 0) != 0);
        Segments segments = SegmentUtil.getSegmentsExcludeRefreshingAndMerging((Segments)df.getSegments().getSegmentsByRange(querableSegmentRange));
        for (NDataSegment segment : segments) {
            if (SegmentStatusEnum.NEW != segment.getStatus()) continue;
            return false;
        }
        return true;
    }
}

