/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Collection;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.ExecutableHandlerFactory;
import org.apache.kylin.engine.spark.job.NResourceDetectStep;
import org.apache.kylin.engine.spark.job.NSparkCleanupAfterMergeStep;
import org.apache.kylin.engine.spark.job.NSparkCubingStep;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.job.NSparkMergingStep;
import org.apache.kylin.engine.spark.job.NSparkSnapshotBuildingStep;
import org.apache.kylin.engine.spark.job.NSparkUpdateMetadataStep;
import org.apache.kylin.engine.spark.job.NTableSamplingJob;
import org.apache.kylin.engine.spark.job.SparkCleanupTransactionalTableStep;
import org.apache.kylin.engine.spark.job.StageType;
import org.apache.kylin.job.SecondStorageStepFactory;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum JobStepType {
    RESOURCE_DETECT{

        @Override
        public AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            if (config.getSparkEngineBuildStepsToSkip().contains(NResourceDetectStep.class.getName())) {
                return null;
            }
            return new NResourceDetectStep(parent);
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
        }
    }
    ,
    CLEAN_UP_AFTER_MERGE{

        @Override
        public AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            NSparkCleanupAfterMergeStep step = new NSparkCleanupAfterMergeStep();
            return step;
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
        }
    }
    ,
    CUBING{

        @Override
        public AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            return new NSparkCubingStep(config.getSparkBuildClassName());
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
            StageType.WAITE_FOR_RESOURCE.createStage(parent, config);
            StageType.REFRESH_SNAPSHOTS.createStage(parent, config);
            StageType.MATERIALIZED_FACT_TABLE.createStage(parent, config);
            StageType.BUILD_DICT.createStage(parent, config);
            StageType.GENERATE_FLAT_TABLE.createStage(parent, config);
            String enablePlanner = parent.getParam("enablePlanner");
            if (enablePlanner != null && Boolean.valueOf(enablePlanner).booleanValue()) {
                StageType.COST_BASED_PLANNER.createStage(parent, config);
            }
            StageType.GATHER_FLAT_TABLE_STATS.createStage(parent, config);
            StageType.BUILD_LAYER.createStage(parent, config);
            StageType.REFRESH_COLUMN_BYTES.createStage(parent, config);
        }
    }
    ,
    MERGING{

        @Override
        public AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            return new NSparkMergingStep(config.getSparkMergeClassName());
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
            StageType.WAITE_FOR_RESOURCE.createStage(parent, config);
            StageType.MERGE_FLAT_TABLE.createStage(parent, config);
            StageType.MERGE_INDICES.createStage(parent, config);
            StageType.MERGE_COLUMN_BYTES.createStage(parent, config);
        }
    }
    ,
    BUILD_SNAPSHOT{

        @Override
        public AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            return new NSparkSnapshotBuildingStep(config.getSnapshotBuildClassName());
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
            StageType.WAITE_FOR_RESOURCE.createStage(parent, config);
            StageType.SNAPSHOT_BUILD.createStage(parent, config);
        }
    }
    ,
    SAMPLING{

        @Override
        public AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            return new NTableSamplingJob.SamplingStep(config.getSparkTableSamplingClassName());
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
            StageType.WAITE_FOR_RESOURCE.createStage(parent, config);
            StageType.TABLE_SAMPLING.createStage(parent, config);
        }
    }
    ,
    UPDATE_METADATA{

        @Override
        public AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            if (!(parent instanceof DefaultExecutableOnModel)) {
                throw new IllegalArgumentException();
            }
            ((DefaultExecutableOnModel)parent).setHandler(ExecutableHandlerFactory.createExecutableHandler((DefaultExecutableOnModel)parent));
            return new NSparkUpdateMetadataStep();
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
        }
    }
    ,
    SECOND_STORAGE_EXPORT{

        @Override
        protected AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            return SecondStorageStepFactory.create(SecondStorageStepFactory.SecondStorageLoadStep.class, step -> {
                step.setProject(parent.getProject());
                step.setParams(parent.getParams());
            });
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
        }
    }
    ,
    SECOND_STORAGE_REFRESH{

        @Override
        protected AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            return SecondStorageStepFactory.create(SecondStorageStepFactory.SecondStorageRefreshStep.class, step -> {
                step.setProject(parent.getProject());
                step.setParams(parent.getParams());
            });
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
        }
    }
    ,
    SECOND_STORAGE_MERGE{

        @Override
        protected AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            return SecondStorageStepFactory.create(SecondStorageStepFactory.SecondStorageMergeStep.class, step -> {
                step.setProject(parent.getProject());
                step.setParams(parent.getParams());
            });
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
        }
    }
    ,
    SECOND_STORAGE_INDEX_CLEAN{

        @Override
        protected AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            return SecondStorageStepFactory.create(SecondStorageStepFactory.SecondStorageIndexClean.class, step -> {
                step.setProject(parent.getProject());
                step.setParams(parent.getParams());
            });
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
        }
    }
    ,
    CLEAN_UP_TRANSACTIONAL_TABLE{

        @Override
        public AbstractExecutable create(DefaultExecutable parent, KylinConfig config) {
            return new SparkCleanupTransactionalTableStep();
        }

        @Override
        protected void addSubStage(NSparkExecutable parent, KylinConfig config) {
        }
    };

    @Generated
    private static final Logger log;

    protected abstract AbstractExecutable create(DefaultExecutable var1, KylinConfig var2);

    protected abstract void addSubStage(NSparkExecutable var1, KylinConfig var2);

    public AbstractExecutable createStep(DefaultExecutable parent, KylinConfig config) {
        AbstractExecutable step = this.create(parent, config);
        if (step == null) {
            log.info("{} skipped", (Object)this);
        } else {
            this.addParam(parent, step);
        }
        return step;
    }

    protected void addParam(DefaultExecutable parent, AbstractExecutable step) {
        step.setParams(parent.getParams());
        step.setProject(parent.getProject());
        step.setTargetSubject(parent.getTargetSubject());
        step.setJobType(parent.getJobType());
        parent.addTask(step);
        if (step instanceof NSparkExecutable) {
            this.addSubStage((NSparkExecutable)step, KylinConfig.readSystemKylinConfig());
            ((NSparkExecutable)step).setStageMap();
            ((NSparkExecutable)step).setDistMetaUrl(KylinConfig.readSystemKylinConfig().getJobTmpMetaStoreUrl(parent.getProject(), step.getId()));
        }
        if (CollectionUtils.isNotEmpty((Collection)parent.getTargetPartitions())) {
            step.setTargetPartitions(parent.getTargetPartitions());
        }
    }

    static {
        log = LoggerFactory.getLogger(JobStepType.class);
    }
}

