/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.merger.MetadataMerger;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableDesc;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkCubingStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkCubingStep.class);

    public NSparkCubingStep(String sparkSubmitClassName) {
        this.setSparkSubmitClassName(sparkSubmitClassName);
        this.setName("Load Data To Index");
    }

    public NSparkCubingStep(Object notSetId) {
        super(notSetId);
    }

    @Override
    protected Set<String> getMetadataDumpList(KylinConfig config) {
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        NDataflow df = NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject()).getDataflow(this.getDataflowId());
        dumpList.addAll(df.collectPrecalculationResource());
        dumpList.addAll(this.getLogicalViewMetaDumpList(config));
        return dumpList;
    }

    @Override
    public void mergerMetadata(MetadataMerger merger) {
        merger.merge(this);
    }

    @Override
    public boolean needMergeMetadata() {
        return true;
    }

    public Set<String> getDependencies(KylinConfig config) {
        String dataflowId = this.getDataflowId();
        Set<String> segmentIds = this.getSegmentIds();
        NDataflowManager dfMgr = NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject());
        NDataflow dataflow = dfMgr.getDataflow(dataflowId);
        IndexPlan indexPlan = dataflow.getIndexPlan();
        HashSet result = Sets.newHashSet();
        for (String segId : segmentIds) {
            NDataSegment seg = dfMgr.getDataflow(dataflowId).getSegment(segId);
            for (LayoutEntity layout : indexPlan.getAllLayouts()) {
                String path = "/" + NSparkCubingUtil.getStoragePathWithoutPrefix((String)this.project, (String)dataflowId, (String)segId, (Long)layout.getId());
                result.add(new Path(path).getParent().toString());
            }
        }
        NDataModel model = indexPlan.getModel();
        model.getJoinTables().forEach(lookupDesc -> {
            TableDesc tableDesc = lookupDesc.getTableRef().getTableDesc();
            boolean isLookupTable = model.isLookupTable(lookupDesc.getTableRef());
            if (isLookupTable) {
                String tablePath = "/" + tableDesc.getProject() + "/table_snapshot" + "/" + tableDesc.getName();
                result.add(tablePath);
            }
        });
        return result;
    }

    @Generated
    public NSparkCubingStep() {
    }

    public static class Mockup {
        public static void main(String[] args) {
            logger.info(Mockup.class + ".main() invoked, args: " + Arrays.toString(args));
        }
    }
}

