/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.ExecutableUtils;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.model.SnapshotBuildFinishedEvent;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkSnapshotBuildingStep
extends NSparkExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkSnapshotBuildingStep.class);

    public NSparkSnapshotBuildingStep(String sparkSubmitClassName) {
        this.setSparkSubmitClassName(sparkSubmitClassName);
        this.setName("Build Snapshot");
    }

    public NSparkSnapshotBuildingStep(Object notSetId) {
        super(notSetId);
    }

    @Override
    protected Set<String> getMetadataDumpList(KylinConfig config) {
        HashSet dumpList = Sets.newHashSet();
        String table = this.getParam("table");
        NTableMetadataManager tblMgr = NTableMetadataManager.getInstance((KylinConfig)config, (String)this.getProject());
        TableDesc tableDesc = tblMgr.getTableDesc(table);
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)config).getProject(this.getProject());
        TableExtDesc tableExtDesc = tblMgr.getTableExtIfExists(tableDesc);
        if (tableExtDesc != null) {
            dumpList.add(tableExtDesc.getResourcePath());
        }
        dumpList.add(tableDesc.getResourcePath());
        dumpList.add(projectInstance.getResourcePath());
        dumpList.addAll(this.getLogicalViewMetaDumpList(config));
        return dumpList;
    }

    @Override
    public ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        ExecuteResult result = super.doWork(context);
        if (!result.succeed()) {
            return result;
        }
        try (ResourceStore remoteStore = ExecutableUtils.getRemoteStore(KylinConfig.getInstanceFromEnv(), this);){
            String tableName = this.getParam("table");
            String selectPartCol = this.getParam("selectedPartitionCol");
            boolean incrementBuild = "true".equals(this.getParam("incrementalBuild"));
            NTableMetadataManager remoteTblMgr = NTableMetadataManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)this.getProject());
            TableDesc remoteTbDesc = remoteTblMgr.getTableDesc(tableName);
            TableExtDesc remoteTblExtDesc = remoteTblMgr.getOrCreateTableExt(remoteTbDesc);
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            String baseDir = KapConfig.getInstanceFromEnv().getMetadataWorkingDirectory();
            if (selectPartCol != null && !incrementBuild) {
                remoteTbDesc.setLastSnapshotPath(remoteTbDesc.getTempSnapshotPath());
            }
            long snapshotSize = 0L;
            try {
                snapshotSize = HadoopUtil.getContentSummary((FileSystem)fs, (Path)new Path(baseDir + remoteTbDesc.getLastSnapshotPath())).getLength();
            }
            catch (IOException e) {
                logger.warn("Fetch snapshot size for {} from {} failed", (Object)remoteTbDesc.getIdentity(), (Object)(baseDir + remoteTbDesc.getLastSnapshotPath()));
            }
            remoteTbDesc.setLastSnapshotSize(snapshotSize);
            EventBusFactory.getInstance().postSync((Object)new SnapshotBuildFinishedEvent(remoteTbDesc, selectPartCol, incrementBuild));
            this.wrapWithCheckQuit(() -> this.mergeRemoteMetaAfterBuilding(remoteTbDesc, remoteTblExtDesc));
        }
        return result;
    }

    private void mergeRemoteMetaAfterBuilding(TableDesc remoteTbDesc, TableExtDesc remoteTblExtDesc) {
        String tableName = this.getParam("table");
        String selectPartCol = this.getParam("selectedPartitionCol");
        NTableMetadataManager localTblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
        TableDesc localTbDesc = localTblMgr.getTableDesc(tableName);
        TableDesc copy = localTblMgr.copyForWrite(localTbDesc);
        TableExtDesc copyExt = localTblMgr.copyForWrite(localTblMgr.getOrCreateTableExt(localTbDesc));
        copy.setLastSnapshotPath(remoteTbDesc.getLastSnapshotPath());
        copy.setLastSnapshotSize(remoteTbDesc.getLastSnapshotSize());
        copy.setSnapshotLastModified(System.currentTimeMillis());
        copy.setSnapshotHasBroken(false);
        if (selectPartCol == null) {
            copyExt.setOriginalSize(remoteTblExtDesc.getOriginalSize());
            copy.setSnapshotPartitionCol(null);
            copy.resetSnapshotPartitions((Set)Sets.newHashSet());
            copy.setSnapshotTotalRows(remoteTbDesc.getSnapshotTotalRows());
        } else {
            copyExt.setOriginalSize(remoteTbDesc.getSnapshotPartitions().values().stream().mapToLong(i -> i).sum());
            copy.setSnapshotPartitionCol(selectPartCol);
            copy.setSnapshotPartitions(remoteTbDesc.getSnapshotPartitions());
            copy.setSnapshotPartitionsInfo(remoteTbDesc.getSnapshotPartitionsInfo());
            copy.setSnapshotTotalRows(remoteTbDesc.getSnapshotTotalRows());
        }
        copyExt.setTotalRows(remoteTblExtDesc.getTotalRows());
        localTblMgr.saveTableExt(copyExt);
        localTblMgr.updateTableDesc(copy);
    }

    @Generated
    public NSparkSnapshotBuildingStep() {
    }

    public static class Mockup {
        public static void main(String[] args) {
            String msg = String.format(Locale.ROOT, "%s.main() invoked, args: %s", Mockup.class, Arrays.toString(args));
            logger.info(msg);
        }
    }
}

