/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.engine.spark.job.JobStepType;
import org.apache.kylin.engine.spark.job.NSparkSnapshotBuildingStep;
import org.apache.kylin.engine.spark.stats.utils.HiveTableRefChecker;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnTable;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.sparkproject.guava.base.Preconditions;

public class NSparkSnapshotJob
extends DefaultExecutableOnTable {
    public NSparkSnapshotJob() {
    }

    public NSparkSnapshotJob(Object notSetId) {
        super(notSetId);
    }

    public static NSparkSnapshotJob create(TableDesc tableDesc, String submitter, String partitionCol, boolean incrementBuild, Set<String> partitionToBuild, boolean isRefresh, String yarnQueue, Object tag) {
        JobTypeEnum jobType = isRefresh ? JobTypeEnum.SNAPSHOT_REFRESH : JobTypeEnum.SNAPSHOT_BUILD;
        return NSparkSnapshotJob.create(tableDesc, submitter, jobType, RandomUtil.randomUUIDStr(), partitionCol, incrementBuild, partitionToBuild, yarnQueue, tag);
    }

    public static NSparkSnapshotJob create(TableDesc tableDesc, String submitter, boolean isRefresh, String yarnQueue) {
        JobTypeEnum jobType = isRefresh ? JobTypeEnum.SNAPSHOT_REFRESH : JobTypeEnum.SNAPSHOT_BUILD;
        return NSparkSnapshotJob.create(tableDesc, submitter, jobType, RandomUtil.randomUUIDStr(), null, false, null, yarnQueue, null);
    }

    public static NSparkSnapshotJob create(TableDesc tableDesc, String submitter, JobTypeEnum jobType, String jobId, String partitionCol, boolean incrementalBuild, Set<String> partitionToBuild, String yarnQueue, Object tag) {
        Preconditions.checkArgument((submitter != null ? 1 : 0) != 0);
        NSparkSnapshotJob job = new NSparkSnapshotJob();
        String project = tableDesc.getProject();
        job.setId(jobId);
        job.setProject(project);
        job.setName(jobType.toString());
        job.setJobType(jobType);
        job.setSubmitter(submitter);
        job.setTargetSubject(tableDesc.getIdentity());
        job.setParam("project", project);
        job.setParam("jobId", jobId);
        job.setParam("table", tableDesc.getIdentity());
        job.setParam("incrementalBuild", incrementalBuild + "");
        job.setParam("selectedPartitionCol", partitionCol);
        if (partitionToBuild != null) {
            job.setParam("selectedPartition", JsonUtil.writeValueAsString(partitionToBuild));
        }
        job.setSparkYarnQueueIfEnabled(project, yarnQueue);
        job.setTag(tag);
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        JobStepType.BUILD_SNAPSHOT.createStep((DefaultExecutable)job, config);
        if (HiveTableRefChecker.isNeedCleanUpTransactionalTableJob(tableDesc.isTransactional(), tableDesc.isRangePartition(), config.isReadTransactionalTableEnabled())) {
            JobStepType.CLEAN_UP_TRANSACTIONAL_TABLE.createStep((DefaultExecutable)job, config);
        }
        return job;
    }

    public NSparkSnapshotBuildingStep getSnapshotBuildingStep() {
        return (NSparkSnapshotBuildingStep)this.getTask(NSparkSnapshotBuildingStep.class);
    }
}

