/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.ExecutableUtils;
import org.apache.kylin.engine.spark.cleanup.SnapshotChecker;
import org.apache.kylin.engine.spark.utils.FileNames;
import org.apache.kylin.engine.spark.utils.HDFSUtils;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnModel;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecutableHandler;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkUpdateMetadataStep
extends AbstractExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkUpdateMetadataStep.class);

    public NSparkUpdateMetadataStep() {
        this.setName("Update Metadata");
    }

    public NSparkUpdateMetadataStep(Object notSetId) {
        super(notSetId);
    }

    public ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
        AbstractExecutable parent = this.getParent();
        Preconditions.checkArgument((boolean)(parent instanceof DefaultExecutableOnModel));
        ExecutableHandler handler = ((DefaultExecutableOnModel)parent).getHandler();
        try {
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                handler.handleFinished();
                return null;
            }, (long)context.getEpochId(), (String)handler.getProject());
            this.cleanExpiredSnapshot();
            return ExecuteResult.createSucceed();
        }
        catch (Throwable throwable) {
            logger.warn("");
            return ExecuteResult.createError((Throwable)throwable);
        }
    }

    private void cleanExpiredSnapshot() {
        try {
            long startDelete = System.currentTimeMillis();
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            String workingDir = KapConfig.wrap((KylinConfig)config).getMetadataWorkingDirectory();
            long survivalTimeThreshold = config.getTimeMachineEnabled() != false ? config.getStorageResourceSurvivalTimeThreshold().longValue() : config.getSnapshotVersionTTL();
            String dfId = ExecutableUtils.getDataflowId(this);
            NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)config, (String)this.getProject()).getDataflow(dfId);
            Set tables = dataflow.getModel().getLookupTables();
            for (TableRef table : tables) {
                Path path;
                if (table.getTableDesc().getLastSnapshotPath() == null || !HDFSUtils.exists(path = FileNames.snapshotFileWithWorkingDir(this.project, table.getTableIdentity(), workingDir)) && config.isUTEnv()) continue;
                FileStatus lastFile = HDFSUtils.findLastFile(path);
                HDFSUtils.deleteFilesWithCheck(path, new SnapshotChecker(config.getSnapshotMaxVersions(), survivalTimeThreshold, lastFile.getModificationTime()));
            }
            logger.info("Delete expired snapshot table for dataflow {} cost: {} ms.", (Object)dfId, (Object)(System.currentTimeMillis() - startDelete));
        }
        catch (Exception e) {
            logger.error("error happen in cleaning expired snapshot ", (Throwable)e);
        }
    }
}

