/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.RandomUtil;
import org.apache.kylin.engine.spark.ExecutableUtils;
import org.apache.kylin.engine.spark.job.JobStepType;
import org.apache.kylin.engine.spark.job.NResourceDetectStep;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.stats.utils.HiveTableRefChecker;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.execution.DefaultExecutable;
import org.apache.kylin.job.execution.DefaultExecutableOnTable;
import org.apache.kylin.job.execution.ExecutableContext;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.EnhancedUnitOfWork;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NTableSamplingJob
extends DefaultExecutableOnTable {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(NTableSamplingJob.class);

    public NTableSamplingJob() {
    }

    public NTableSamplingJob(Object notSetId) {
        super(notSetId);
    }

    public static NTableSamplingJob create(TableDesc tableDesc, String project, String submitter, int rows) {
        return NTableSamplingJob.create(tableDesc, project, submitter, rows, 3, null, null);
    }

    public static NTableSamplingJob create(TableDesc tableDesc, String project, String submitter, int rows, int priority, String yarnQueue, Object tag) {
        Preconditions.checkArgument((tableDesc != null ? 1 : 0) != 0, (Object)"Create table sampling job failed for table not exist!");
        log.info("start creating a table sampling job on table {}", (Object)tableDesc.getIdentity());
        NTableSamplingJob job = new NTableSamplingJob();
        job.setId(RandomUtil.randomUUIDStr());
        job.setName(JobTypeEnum.TABLE_SAMPLING.toString());
        job.setProject(project);
        job.setJobType(JobTypeEnum.TABLE_SAMPLING);
        job.setTargetSubject(tableDesc.getIdentity());
        job.setSubmitter(submitter);
        job.setParam("project", project);
        job.setParam("jobId", job.getId());
        job.setParam("table", tableDesc.getIdentity());
        job.setParam("samplingRows", String.valueOf(rows));
        job.setPriority(priority);
        job.setSparkYarnQueueIfEnabled(project, yarnQueue);
        job.setTag(tag);
        KylinConfig globalConfig = KylinConfig.getInstanceFromEnv();
        KylinConfigExt config = NProjectManager.getInstance((KylinConfig)globalConfig).getProject(project).getConfig();
        JobStepType.RESOURCE_DETECT.createStep((DefaultExecutable)job, (KylinConfig)config);
        JobStepType.SAMPLING.createStep((DefaultExecutable)job, (KylinConfig)config);
        if (HiveTableRefChecker.isNeedCleanUpTransactionalTableJob(tableDesc.isTransactional(), tableDesc.isRangePartition(), config.isReadTransactionalTableEnabled())) {
            JobStepType.CLEAN_UP_TRANSACTIONAL_TABLE.createStep((DefaultExecutable)job, (KylinConfig)config);
        }
        log.info("sampling job create success on table {}", (Object)tableDesc.getIdentity());
        return job;
    }

    public Set<String> getMetadataDumpList(KylinConfig config) {
        String table = this.getParam("table");
        TableDesc tableDesc = NTableMetadataManager.getInstance((KylinConfig)config, (String)this.getProject()).getTableDesc(table);
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)config).getProject(this.getProject());
        HashSet dumpList = Sets.newHashSet((Object[])new String[]{tableDesc.getResourcePath(), projectInstance.getResourcePath()});
        TableExtDesc tableExtDesc = NTableMetadataManager.getInstance((KylinConfig)config, (String)this.getProject()).getTableExtIfExists(tableDesc);
        if (tableExtDesc != null) {
            dumpList.add(tableExtDesc.getResourcePath());
        }
        return dumpList;
    }

    public boolean checkSuicide() {
        return null == NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject()).getTableDesc(this.getTableIdentity());
    }

    public NResourceDetectStep getResourceDetectStep() {
        return (NResourceDetectStep)this.getTask(NResourceDetectStep.class);
    }

    public SamplingStep getSamplingStep() {
        return (SamplingStep)this.getTask(SamplingStep.class);
    }

    public static class SamplingStep
    extends NSparkExecutable {
        public SamplingStep() {
        }

        public SamplingStep(Object notSetId) {
            super(notSetId);
        }

        public SamplingStep(String sparkSubmitClassName) {
            this.setSparkSubmitClassName(sparkSubmitClassName);
            this.setName("Table Sampling");
        }

        private String getTableIdentity() {
            return this.getParam("table");
        }

        @Override
        public ExecuteResult doWork(ExecutableContext context) throws ExecuteException {
            ExecuteResult result = super.doWork(context);
            if (!result.succeed()) {
                return result;
            }
            EnhancedUnitOfWork.doInTransactionWithCheckAndRetry(() -> {
                if (this.checkSuicide()) {
                    log.info("This Table Sampling job seems meaningless now, quit before mergeRemoteMetaAfterSampling()");
                    return null;
                }
                this.mergeRemoteMetaAfterSampling();
                return null;
            }, (String)this.getProject());
            return result;
        }

        private void mergeRemoteMetaAfterSampling() {
            try (ResourceStore remoteStore = ExecutableUtils.getRemoteStore(KylinConfig.getInstanceFromEnv(), this);){
                NTableMetadataManager remoteTblMgr = NTableMetadataManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)this.getProject());
                NTableMetadataManager localTblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
                localTblMgr.mergeAndUpdateTableExt(localTblMgr.getOrCreateTableExt(this.getTableIdentity()), remoteTblMgr.getOrCreateTableExt(this.getTableIdentity()));
                TableDesc tableDesc = localTblMgr.getTableDesc(this.getTableIdentity());
                TableExtDesc tableExt = localTblMgr.getTableExtIfExists(tableDesc);
                TableExtDesc copyForWrite = localTblMgr.copyForWrite(tableExt);
                copyForWrite.setCreateTime(this.getCreateTime());
                localTblMgr.saveTableExt(copyForWrite);
            }
        }

        @Override
        protected Set<String> getMetadataDumpList(KylinConfig config) {
            TableDesc table;
            HashSet dumpList = Sets.newHashSet();
            ProjectInstance instance = NProjectManager.getInstance((KylinConfig)config).getProject(this.getProject());
            dumpList.add(instance.getResourcePath());
            NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)config, (String)this.getProject());
            TableExtDesc tableExtDesc = tableMetadataManager.getTableExtIfExists(tableMetadataManager.getTableDesc(this.getTableIdentity()));
            if (tableExtDesc != null) {
                dumpList.add(tableExtDesc.getResourcePath());
            }
            if ((table = tableMetadataManager.getTableDesc(this.getTableIdentity())) != null) {
                dumpList.add(table.getResourcePath());
            }
            dumpList.addAll(this.getLogicalViewMetaDumpList(config));
            return dumpList;
        }
    }
}

