/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Set;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.builder.SegmentFlatTable;
import org.apache.kylin.engine.spark.job.RDSegmentBuildJob;
import org.apache.kylin.engine.spark.model.SegmentFlatTableDesc;
import org.apache.kylin.metadata.cube.cuboid.AdaptiveSpanningTree;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SparderEnv$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.datasource.storage.StorageStoreUtils$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0005d\u0001\u0002\u000e\u001c\u0001!B\u0001B\u000e\u0001\u0003\u0006\u0004%Ia\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005q!AQ\b\u0001BC\u0002\u0013%a\b\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003@\u0011\u0015Q\u0005\u0001\"\u0001L\u0011\u001dy\u0005A1A\u0005\u0016ACa!\u0017\u0001!\u0002\u001b\t\u0006b\u0002.\u0001\u0005\u0004%)b\u0017\u0005\u0007E\u0002\u0001\u000bQ\u0002/\t\u000f\r\u0004!\u0019!C\u000b!\"1A\r\u0001Q\u0001\u000eECq!\u001a\u0001C\u0002\u0013Ua\r\u0003\u0004n\u0001\u0001\u0006ia\u001a\u0005\b]\u0002\u0011\r\u0011\"\u0006p\u0011\u0019A\b\u0001)A\u0007a\"9\u0011\u0010\u0001b\u0001\n+Q\bbBA\u0005\u0001\u0001\u0006ia\u001f\u0005\t\u0003\u0017\u0001!\u0019!C\u000b!\"9\u0011Q\u0002\u0001!\u0002\u001b\t\u0006\u0002CA\b\u0001\t\u0007IQ\u0003)\t\u000f\u0005E\u0001\u0001)A\u0007#\"Q\u00111\u0003\u0001\t\u0006\u0004%I!!\u0006\t\u0015\u0005\r\u0002\u0001#b\u0001\n\u0013\t)\u0003\u0003\u0006\u00022\u0001A)\u0019!C\u0005\u0003gAq!!\u0011\u0001\t\u0003\t\u0019E\u0001\nS\tN+w-\\3oi\n+\u0018\u000e\u001c3Fq\u0016\u001c'B\u0001\u000f\u001e\u0003\rQwN\u0019\u0006\u0003=}\tQa\u001d9be.T!\u0001I\u0011\u0002\r\u0015tw-\u001b8f\u0015\t\u00113%A\u0003ls2LgN\u0003\u0002%K\u00051\u0011\r]1dQ\u0016T\u0011AJ\u0001\u0004_J<7\u0001A\n\u0004\u0001%z\u0003C\u0001\u0016.\u001b\u0005Y#\"\u0001\u0017\u0002\u000bM\u001c\u0017\r\\1\n\u00059Z#AB!osJ+g\r\u0005\u00021i5\t\u0011G\u0003\u00023g\u0005A\u0011N\u001c;fe:\fGN\u0003\u0002\u001fG%\u0011Q'\r\u0002\b\u0019><w-\u001b8h\u0003)QwNY\"p]R,\u0007\u0010^\u000b\u0002qA\u0011\u0011HO\u0007\u00027%\u00111h\u0007\u0002\u0012%\u0012\u001bVmZ7f]R\u0014U/\u001b7e\u0015>\u0014\u0017a\u00036pE\u000e{g\u000e^3yi\u0002\n1\u0002Z1uCN+w-\\3oiV\tq\b\u0005\u0002A\u000f6\t\u0011I\u0003\u0002C\u0007\u0006)Qn\u001c3fY*\u0011A)R\u0001\u0005GV\u0014WM\u0003\u0002GC\u0005AQ.\u001a;bI\u0006$\u0018-\u0003\u0002I\u0003\naa\nR1uCN+w-\\3oi\u0006aA-\u0019;b'\u0016<W.\u001a8uA\u00051A(\u001b8jiz\"2\u0001T'O!\tI\u0004\u0001C\u00037\u000b\u0001\u0007\u0001\bC\u0003>\u000b\u0001\u0007q(A\u0003k_\nLE-F\u0001R!\t\u0011v+D\u0001T\u0015\t!V+\u0001\u0003mC:<'\"\u0001,\u0002\t)\fg/Y\u0005\u00031N\u0013aa\u0015;sS:<\u0017A\u00026pE&#\u0007%\u0001\u0004d_:4\u0017nZ\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011q,I\u0001\u0007G>lWn\u001c8\n\u0005\u0005t&aC&zY&t7i\u001c8gS\u001e\fqaY8oM&<\u0007%\u0001\u0006eCR\fg\r\\8x\u0013\u0012\f1\u0002Z1uC\u001adwn^%eA\u0005a1\u000f]1sWN+7o]5p]V\tq\r\u0005\u0002iW6\t\u0011N\u0003\u0002kg\u0005\u00191/\u001d7\n\u00051L'\u0001D*qCJ\\7+Z:tS>t\u0017!D:qCJ\\7+Z:tS>t\u0007%\u0001\u0007sINC\u0017M]3e!\u0006$\b.F\u0001q!\t\th/D\u0001s\u0015\t\u0019H/\u0001\u0002gg*\u0011QoI\u0001\u0007Q\u0006$wn\u001c9\n\u0005]\u0014(\u0001\u0002)bi\"\fQB\u001d3TQ\u0006\u0014X\r\u001a)bi\"\u0004\u0013a\u0004:fC\u0012|e\u000e\\=MCf|W\u000f^:\u0016\u0003m\u0004B\u0001`@\u0002\u00045\tQP\u0003\u0002\u007f+\u0006!Q\u000f^5m\u0013\r\t\t! \u0002\u0004'\u0016$\bc\u0001!\u0002\u0006%\u0019\u0011qA!\u0003\u00191\u000b\u0017p\\;u\u000b:$\u0018\u000e^=\u0002!I,\u0017\rZ(oYfd\u0015-_8viN\u0004\u0013!C:fO6,g\u000e^%e\u0003)\u0019XmZ7f]RLE\rI\u0001\baJ|'.Z2u\u0003!\u0001(o\u001c6fGR\u0004\u0013\u0001D:qC:t\u0017N\\4Ue\u0016,WCAA\f!\u0011\tI\"a\b\u000e\u0005\u0005m!bAA\u000f\u0007\u000611-\u001e2pS\u0012LA!!\t\u0002\u001c\t!\u0012\tZ1qi&4Xm\u00159b]:Lgn\u001a+sK\u0016\fQB\u001a7biR\u000b'\r\\3EKN\u001cWCAA\u0014!\u0011\tI#!\f\u000e\u0005\u0005-\"B\u0001\"\u001e\u0013\u0011\ty#a\u000b\u0003)M+w-\\3oi\u001ac\u0017\r\u001e+bE2,G)Z:d\u0003%1G.\u0019;UC\ndW-\u0006\u0002\u00026A!\u0011qGA\u001f\u001b\t\tIDC\u0002\u0002<u\tqAY;jY\u0012,'/\u0003\u0003\u0002@\u0005e\"\u0001E*fO6,g\u000e\u001e$mCR$\u0016M\u00197f\u00039!W\r^3diJ+7o\\;sG\u0016$\"!!\u0012\u0011\u0007)\n9%C\u0002\u0002J-\u0012A!\u00168ji\"*\u0011$!\u0014\u0002`A)!&a\u0014\u0002T%\u0019\u0011\u0011K\u0016\u0003\rQD'o\\<t!\u0011\t)&a\u0017\u000e\u0005\u0005]#bAA-+\u0006\u0011\u0011n\\\u0005\u0005\u0003;\n9FA\u0006J\u001f\u0016C8-\u001a9uS>t7EAA*\u0001")
public class RDSegmentBuildExec
implements Logging {
    private AdaptiveSpanningTree spanningTree;
    private SegmentFlatTableDesc flatTableDesc;
    private SegmentFlatTable flatTable;
    private final RDSegmentBuildJob jobContext;
    private final NDataSegment dataSegment;
    private final String jobId;
    private final KylinConfig config;
    private final String dataflowId;
    private final SparkSession sparkSession;
    private final Path rdSharedPath;
    private final Set<LayoutEntity> readOnlyLayouts;
    private final String segmentId;
    private final String project;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private RDSegmentBuildJob jobContext() {
        return this.jobContext;
    }

    private NDataSegment dataSegment() {
        return this.dataSegment;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final KylinConfig config() {
        return this.config;
    }

    public final String dataflowId() {
        return this.dataflowId;
    }

    public final SparkSession sparkSession() {
        return this.sparkSession;
    }

    public final Path rdSharedPath() {
        return this.rdSharedPath;
    }

    public final Set<LayoutEntity> readOnlyLayouts() {
        return this.readOnlyLayouts;
    }

    public final String segmentId() {
        return this.segmentId;
    }

    public final String project() {
        return this.project;
    }

    private AdaptiveSpanningTree spanningTree$lzycompute() {
        RDSegmentBuildExec rDSegmentBuildExec = this;
        synchronized (rDSegmentBuildExec) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.spanningTree = new AdaptiveSpanningTree(this.config(), new AdaptiveSpanningTree.AdaptiveTreeBuilder(this.dataSegment(), this.readOnlyLayouts()));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.spanningTree;
    }

    private AdaptiveSpanningTree spanningTree() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.spanningTree$lzycompute() : this.spanningTree;
    }

    private SegmentFlatTableDesc flatTableDesc$lzycompute() {
        RDSegmentBuildExec rDSegmentBuildExec = this;
        synchronized (rDSegmentBuildExec) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.flatTableDesc = new SegmentFlatTableDesc(this.config(), this.dataSegment(), this.spanningTree());
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.flatTableDesc;
    }

    private SegmentFlatTableDesc flatTableDesc() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.flatTableDesc$lzycompute() : this.flatTableDesc;
    }

    private SegmentFlatTable flatTable$lzycompute() {
        RDSegmentBuildExec rDSegmentBuildExec = this;
        synchronized (rDSegmentBuildExec) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.flatTable = new SegmentFlatTable(this.sparkSession(), this.flatTableDesc());
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.flatTable;
    }

    private SegmentFlatTable flatTable() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.flatTable$lzycompute() : this.flatTable;
    }

    public void detectResource() throws IOException {
        Seq flatTableExecutions = this.spanningTree().fromFlatTable() ? (Seq)new .colon.colon((Object)new Tuple2((Object)BoxesRunTime.boxToLong((long)-1L), (Object)this.flatTable().getFlatTablePartDS().queryExecution()), (List)Nil$.MODULE$) : (Seq)Nil$.MODULE$;
        Buffer layoutExecutions = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.spanningTree().getRootNodes()).asScala()).map((Function1 & Serializable & scala.Serializable)node -> {
            LayoutEntity layout = node.getLayout();
            QueryExecution execution = StorageStoreUtils$.MODULE$.toDF(this.dataSegment(), layout, this.sparkSession()).queryExecution();
            return new Tuple2((Object)BoxesRunTime.boxToLong((long)layout.getId()), (Object)execution);
        }, Buffer$.MODULE$.canBuildFrom());
        HashMap sourceSize = Maps.newHashMap();
        HashMap sourceLeaves = Maps.newHashMap();
        ((IterableLike)flatTableExecutions.$plus$plus((GenTraversableOnce)layoutExecutions, Seq$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> BoxesRunTime.boxToInteger((int)RDSegmentBuildExec.$anonfun$detectResource$2(this, sourceSize, sourceLeaves, x0$1)));
        ResourceDetectUtils$.MODULE$.write(new Path(this.rdSharedPath(), new StringBuilder(1).append(this.segmentId()).append("_").append(ResourceDetectUtils$.MODULE$.fileName()).toString()), (Object)sourceSize);
        ResourceDetectUtils$.MODULE$.write(new Path(this.rdSharedPath(), new StringBuilder(1).append(this.segmentId()).append("_").append(ResourceDetectUtils$.MODULE$.cubingDetectItemFileSuffix()).toString()), (Object)sourceLeaves);
    }

    public static final /* synthetic */ int $anonfun$detectResource$2(RDSegmentBuildExec $this, HashMap sourceSize$1, HashMap sourceLeaves$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long parentId = tuple2._1$mcJ$sp();
        QueryExecution execution = (QueryExecution)tuple2._2();
        String sourceName = String.valueOf(parentId);
        int leaves = Integer.parseInt(ResourceDetectUtils$.MODULE$.getPartitions(execution.executedPlan()));
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Leaf nodes: ").append(leaves).toString());
        java.util.List paths = (java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)ResourceDetectUtils$.MODULE$.getPaths(execution.sparkPlan()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.toString(), Seq$.MODULE$.canBuildFrom())).asJava();
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Detected source: ").append(sourceName).append(" ").append(leaves).append(" ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(paths).asScala()).mkString(",")).toString());
        long startTime = System.currentTimeMillis();
        long resourceSize = ResourceDetectUtils$.MODULE$.getResourceSize(SparderEnv$.MODULE$.getHadoopConfiguration(), $this.config().isConcurrencyFetchDataSourceSize(), (Seq)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(paths).asScala()).map((Function1 & Serializable & scala.Serializable)path -> new Path(path), Buffer$.MODULE$.canBuildFrom()));
        long endTime = System.currentTimeMillis();
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Detect source size cost time is ").append(endTime - startTime).append(" ms.").toString());
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Detect source size ").append(resourceSize).toString());
        sourceSize$1.put(sourceName, BoxesRunTime.boxToLong((long)resourceSize));
        int n = BoxesRunTime.unboxToInt((Object)sourceLeaves$1.put(sourceName, BoxesRunTime.boxToInteger((int)leaves)));
        return n;
    }

    public RDSegmentBuildExec(RDSegmentBuildJob jobContext, NDataSegment dataSegment) {
        this.jobContext = jobContext;
        this.dataSegment = dataSegment;
        Logging.$init$((Logging)this);
        this.jobId = jobContext.getJobId();
        this.config = jobContext.getConfig();
        this.dataflowId = jobContext.getDataflowId();
        this.sparkSession = jobContext.getSparkSession();
        this.rdSharedPath = jobContext.getRdSharedPath();
        this.readOnlyLayouts = jobContext.getReadOnlyLayouts();
        this.segmentId = dataSegment.getId();
        this.project = dataSegment.getProject();
    }
}

