/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.engine.spark.job.LogJobInfoUtils;
import org.apache.kylin.engine.spark.job.RDPartitionBuildExec;
import org.apache.kylin.engine.spark.job.RDSegmentBuildExec;
import org.apache.kylin.engine.spark.job.ResourceDetect;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;

public class RDSegmentBuildJob
extends SegmentJob
implements ResourceDetect {
    public static void main(String[] args) {
        RDSegmentBuildJob segmentBuildJob = new RDSegmentBuildJob();
        segmentBuildJob.execute(args);
    }

    @Override
    protected final void doExecute() throws Exception {
        this.writeCountDistinct();
        if (this.isPartitioned()) {
            this.detectPartition();
        } else {
            this.detect();
        }
    }

    private void detectPartition() throws IOException {
        for (NDataSegment dataSegment : this.readOnlySegments) {
            RDPartitionBuildExec exec = new RDPartitionBuildExec(this, dataSegment);
            ((RDSegmentBuildExec)exec).detectResource();
        }
    }

    private void detect() throws IOException {
        for (NDataSegment dataSegment : this.readOnlySegments) {
            RDSegmentBuildExec exec = new RDSegmentBuildExec(this, dataSegment);
            exec.detectResource();
        }
    }

    @Override
    protected String generateInfo() {
        return LogJobInfoUtils.resourceDetectBeforeCubingJobInfo();
    }

    private void writeCountDistinct() {
        ResourceDetectUtils.write((Path)new Path(this.rdSharedPath, ResourceDetectUtils.countDistinctSuffix()), (Object)ResourceDetectUtils.findCountDistinctMeasure(this.getReadOnlyLayouts()));
    }
}

