/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.ResourceDetect;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.source.SourceFactory;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.execution.SparkPlan;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.collection.Iterator;
import scala.collection.JavaConversions;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class ResourceDetectBeforeSampling
extends SparkApplication
implements ResourceDetect {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceDetectBeforeSampling.class);

    public static void main(String[] args) {
        ResourceDetectBeforeSampling detect = new ResourceDetectBeforeSampling();
        detect.execute(args);
    }

    @Override
    protected void doExecute() {
        String tableName = this.getParam("table");
        TableDesc tableDesc = NTableMetadataManager.getInstance((KylinConfig)this.config, (String)this.project).getTableDesc(tableName);
        Map params = NProjectManager.getInstance((KylinConfig)this.config).getProject(this.project).getLegalOverrideKylinProps();
        long rowCount = Long.parseLong(this.getParam("samplingRows"));
        params.put("sampleRowCount", String.valueOf(rowCount));
        Dataset<Row> dataset = ((NSparkCubingEngine.NSparkCubingSource)SourceFactory.createEngineAdapter((ISourceAware)tableDesc, NSparkCubingEngine.NSparkCubingSource.class)).getSourceData(tableDesc, this.ss, params);
        List paths = JavaConversions.seqAsJavaList((Seq)ResourceDetectUtils.getPaths((SparkPlan)dataset.queryExecution().sparkPlan()));
        HashMap resourceSize = Maps.newHashMap();
        resourceSize.put(String.valueOf(tableName), ResourceDetectUtils.getResourceSize((Configuration)SparderEnv.getHadoopConfiguration(), (boolean)this.config.isConcurrencyFetchDataSourceSize(), (Seq)((Iterator)JavaConverters.asScalaIteratorConverter(paths.iterator()).asScala()).toSeq()));
        HashMap tableLeafTaskNums = Maps.newHashMap();
        tableLeafTaskNums.put(tableName, ResourceDetectUtils.getPartitions((SparkPlan)dataset.queryExecution().executedPlan()));
        ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), tableName + "_" + ResourceDetectUtils.fileName()), (Object)resourceSize);
        ResourceDetectUtils.write((Path)new Path(this.config.getJobTmpShareDir(this.project, this.jobId), tableName + "_" + ResourceDetectUtils.samplingDetectItemFileSuffix()), (Object)tableLeafTaskNums);
    }
}

