/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.engine.spark.job.CuboidAggregator$;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.SegmentExec;
import org.apache.kylin.engine.spark.job.SegmentExec$;
import org.apache.kylin.engine.spark.job.stage.merge.MergeStage;
import org.apache.kylin.engine.spark.scheduler.JobRuntime;
import org.apache.kylin.metadata.cube.model.DimensionRangeInfo;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.datasource.storage.StorageListener;
import org.apache.spark.sql.datasource.storage.StorageStore;
import org.apache.spark.sql.datasource.storage.StorageStoreFactory$;
import org.apache.spark.sql.datasource.storage.WriteTaskStats;
import org.apache.spark.sql.functions$;
import org.apache.spark.tracker.BuildContext;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function3;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.Set$;
import scala.collection.mutable.SetLike;
import scala.collection.parallel.ForkJoinTaskSupport;
import scala.collection.parallel.TaskSupport;
import scala.collection.parallel.mutable.ParArray;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.Tuple3Zipped;
import scala.runtime.Tuple3Zipped$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011mfa\u00023f!\u0003\r\tA\u001d\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0011%\tY\u0001\u0001b\u0001\u000e#\ti\u0001C\u0005\u0002&\u0001\u0011\rQ\"\u0005\u0002\u000e!I\u0011q\u0005\u0001C\u0002\u001bE\u0011Q\u0002\u0005\n\u0003S\u0001!\u0019!D\t\u0003\u001bA\u0011\"a\u000b\u0001\u0005\u00045\t\"!\f\t\u0013\u0005m\u0002A1A\u0007\u0012\u0005u\u0002\"CA&\u0001\t\u0007i\u0011CA'\u0011%\ty\u0006\u0001b\u0001\u000e#\t\t\u0007C\u0005\u0002j\u0001\u0011\rQ\"\u0005\u0002l!I\u0011\u0011\u0010\u0001C\u0002\u001bE\u00111\u0010\u0005\n\u0003\u0013\u0003\u0001\u0019!C\t\u0003\u0017C\u0011\"!,\u0001\u0001\u0004%\t\"a,\t\u0015\u0005U\u0006\u0001#b\u0001\n+\t9\f\u0003\u0006\u0004*\u0001A)\u0019!C\u000b\u0007W1\u0011ba\f\u0001!\u0003\r\nb!\r\t\u000f\rM\u0002C\"\u0001\u0002\u000e!91Q\u0007\u0001\u0005\u0012\r]\u0002bBB!\u0001\u0011E\u00111\u0001\u0005\b\u0007\u0007\u0002A\u0011CB#\u0011\u001d\u0019Y\u0007\u0001C\u0005\u0007[Bqa! \u0001\t\u0013\u0019y\bC\u0004\u0004\n\u0002!)\"a\u0001\t\u000f\r-\u0005\u0001\"\u0006\u0004\u000e\"I1Q\u0014\u0001\u0012\u0002\u0013U!Q\u0005\u0005\n\u0007?\u0003\u0011\u0013!C\u000b\u0007CCqa!*\u0001\t+\u00199\u000bC\u0004\u0004.\u0002!)\"a\u0001\t\u000f\r=\u0006\u0001\"\u0005\u00042\"I1q\u0017\u0001\u0012\u0002\u0013E!Q\u0005\u0005\n\u0007s\u0003\u0011\u0013!C\t\u0007CCqaa/\u0001\t+\u0019i\fC\u0004\u0004b\u0002!\t\"a\u0001\t\u000f\r\r\b\u0001\"\u0006\u0004f\"9A\u0011\u0001\u0001\u0005\n\u0011\r\u0001b\u0002C\u0005\u0001\u0019EA1\u0002\u0005\b\t/\u0001A\u0011\u0002C\r\u0011\u001d!y\u0002\u0001C\u000b\tCAq\u0001b\u0011\u0001\t#!)\u0005C\u0004\u0005P\u0001!\t\u0002\"\u0015\t\u0013\u0011\r\u0004A1A\u0007\u0012\u00055\u0001b\u0002C3\u0001\u0011UAq\r\u0005\b\tk\u0002A\u0011\u0002C<\u0011\u001d!\t\t\u0001C\t\t\u0007Cq\u0001\"&\u0001\t#\t\u0019\u0001C\u0004\u0005\u0018\u0002!\t\u0002\"'\t\u000f\u0011\r\u0006\u0001\"\u0005\u0005&\u001e9\u0011\u0011^3\t\u0002\u0005-hA\u00023f\u0011\u0003\ty\u000fC\u0004\u0002rF\"\t!a=\u0007\u0013\u0005U\u0018\u0007%A\u0012\u0002\u0005]hABA}c\u0001\u000bY\u0010\u0003\u0006\u0003\nQ\u0012)\u001a!C\u0001\u0005\u0017A!Ba\u00055\u0005#\u0005\u000b\u0011\u0002B\u0007\u0011\u001d\t\t\u0010\u000eC\u0001\u0005+A\u0011B!\b5\u0003\u0003%\tAa\b\t\u0013\t\rB'%A\u0005\u0002\t\u0015\u0002\"\u0003B\u001ei\u0005\u0005I\u0011\tB\u001f\u0011%\u0011I\u0005NA\u0001\n\u0003\t\t\u0007C\u0005\u0003LQ\n\t\u0011\"\u0001\u0003N!I!q\u000b\u001b\u0002\u0002\u0013\u0005#\u0011\f\u0005\n\u0005O\"\u0014\u0011!C\u0001\u0005SB\u0011Ba\u001d5\u0003\u0003%\tE!\u001e\t\u0013\t]D'!A\u0005B\te\u0004\"\u0003B>i\u0005\u0005I\u0011\tB?\u000f%\u0011\t)MA\u0001\u0012\u0003\u0011\u0019IB\u0005\u0002zF\n\t\u0011#\u0001\u0003\u0006\"9\u0011\u0011_\"\u0005\u0002\tE\u0005\"\u0003B<\u0007\u0006\u0005IQ\tB=\u0011%\u0011\u0019jQA\u0001\n\u0003\u0013)\nC\u0005\u0003\u001a\u000e\u000b\t\u0011\"!\u0003\u001c\"I!1U\"\u0002\u0002\u0013%!Q\u0015\u0004\u0007\u0005[\u000b\u0004Ia,\t\u0015\tM\u0016J!f\u0001\n\u0003\u0011)\f\u0003\u0006\u0003<&\u0013\t\u0012)A\u0005\u0005oC!B!0J\u0005+\u0007I\u0011\u0001B`\u0011)\u0011\t.\u0013B\tB\u0003%!\u0011\u0019\u0005\u000b\u0005'L%Q3A\u0005\u0002\tU\u0007B\u0003Bl\u0013\nE\t\u0015!\u0003\u0003\u0018!9\u0011\u0011_%\u0005\u0002\te\u0007\"\u0003B\u000f\u0013\u0006\u0005I\u0011\u0001Br\u0011%\u0011\u0019#SI\u0001\n\u0003\u0011Y\u000fC\u0005\u0003p&\u000b\n\u0011\"\u0001\u0003r\"I!Q_%\u0012\u0002\u0013\u0005!q\u001f\u0005\n\u0005wI\u0015\u0011!C!\u0005{A\u0011B!\u0013J\u0003\u0003%\t!!\u0019\t\u0013\t-\u0013*!A\u0005\u0002\tm\b\"\u0003B,\u0013\u0006\u0005I\u0011\tB-\u0011%\u00119'SA\u0001\n\u0003\u0011y\u0010C\u0005\u0003t%\u000b\t\u0011\"\u0011\u0003v!I!qO%\u0002\u0002\u0013\u0005#\u0011\u0010\u0005\n\u0005wJ\u0015\u0011!C!\u0007\u00079\u0011ba\u00022\u0003\u0003E\ta!\u0003\u0007\u0013\t5\u0016'!A\t\u0002\r-\u0001bBAy=\u0012\u000511\u0003\u0005\n\u0005or\u0016\u0011!C#\u0005sB\u0011Ba%_\u0003\u0003%\ti!\u0006\t\u0013\tee,!A\u0005\u0002\u000eu\u0001\"\u0003BR=\u0006\u0005I\u0011\u0002BS\u0005-\u0019VmZ7f]R,\u00050Z2\u000b\u0005\u0019<\u0017a\u00016pE*\u0011\u0001.[\u0001\u0006gB\f'o\u001b\u0006\u0003U.\fa!\u001a8hS:,'B\u00017n\u0003\u0015Y\u0017\u0010\\5o\u0015\tqw.\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002a\u0006\u0019qN]4\u0004\u0001M\u0019\u0001a]=\u0011\u0005Q<X\"A;\u000b\u0003Y\fQa]2bY\u0006L!\u0001_;\u0003\r\u0005s\u0017PU3g!\tQh0D\u0001|\u0015\taX0\u0001\u0005j]R,'O\\1m\u0015\tAW.\u0003\u0002\u0000w\n9Aj\\4hS:<\u0017A\u0002\u0013j]&$H\u0005\u0006\u0002\u0002\u0006A\u0019A/a\u0002\n\u0007\u0005%QO\u0001\u0003V]&$\u0018!\u00026pE&#WCAA\b!\u0011\t\t\"a\b\u000f\t\u0005M\u00111\u0004\t\u0004\u0003+)XBAA\f\u0015\r\tI\"]\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005uQ/\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003C\t\u0019C\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003;)\u0018a\u00029s_*,7\r^\u0001\ng\u0016<W.\u001a8u\u0013\u0012\f!\u0002Z1uC\u001adwn^%e\u0003\u0019\u0019wN\u001c4jOV\u0011\u0011q\u0006\t\u0005\u0003c\t9$\u0004\u0002\u00024)\u0019\u0011QG6\u0002\r\r|W.\\8o\u0013\u0011\tI$a\r\u0003\u0017-KH.\u001b8D_:4\u0017nZ\u0001\rgB\f'o[*fgNLwN\\\u000b\u0003\u0003\u007f\u0001B!!\u0011\u0002H5\u0011\u00111\t\u0006\u0004\u0003\u000bj\u0018aA:rY&!\u0011\u0011JA\"\u00051\u0019\u0006/\u0019:l'\u0016\u001c8/[8o\u0003%!\u0017\r^1N_\u0012,G.\u0006\u0002\u0002PA!\u0011\u0011KA.\u001b\t\t\u0019F\u0003\u0003\u0002V\u0005]\u0013!B7pI\u0016d'bAA-W\u0006AQ.\u001a;bI\u0006$\u0018-\u0003\u0003\u0002^\u0005M#A\u0003(ECR\fWj\u001c3fY\u0006Y1\u000f^8sC\u001e,G+\u001f9f+\t\t\u0019\u0007E\u0002u\u0003KJ1!a\u001av\u0005\rIe\u000e^\u0001\u0010e\u0016\u001cx.\u001e:dK\u000e{g\u000e^3yiV\u0011\u0011Q\u000e\t\u0005\u0003_\n)(\u0004\u0002\u0002r)\u0019\u00111O?\u0002\u000fQ\u0014\u0018mY6fe&!\u0011qOA9\u00051\u0011U/\u001b7e\u0007>tG/\u001a=u\u0003\u001d\u0011XO\u001c;j[\u0016,\"!! \u0011\t\u0005}\u0014QQ\u0007\u0003\u0003\u0003S1!a!h\u0003%\u00198\r[3ek2,'/\u0003\u0003\u0002\b\u0006\u0005%A\u0003&pEJ+h\u000e^5nK\u0006\u0001\u0012M\\8os6|Wo\u001d$bS2,(/Z\u000b\u0003\u0003\u001b\u0003R\u0001^AH\u0003'K1!!%v\u0005\u0019y\u0005\u000f^5p]B!\u0011QSAP\u001d\u0011\t9*a'\u000f\t\u0005U\u0011\u0011T\u0005\u0002m&\u0019\u0011QT;\u0002\u000fA\f7m[1hK&!\u0011\u0011UAR\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\u001eVD3\u0001DAT!\r!\u0018\u0011V\u0005\u0004\u0003W+(\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002)\u0005twN\\=n_V\u001ch)Y5mkJ,w\fJ3r)\u0011\t)!!-\t\u0013\u0005MV\"!AA\u0002\u00055\u0015a\u0001=%c\u0005!\u0001/\u001b9f+\t\tI\f\u0005\u0004\u0002<\u0006%\u0017QZ\u0007\u0003\u0003{SA!a0\u0002B\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\r\u0017QY\u0001\u0005kRLGN\u0003\u0002\u0002H\u0006!!.\u0019<b\u0013\u0011\tY-!0\u0003'1Kgn[3e\u00052|7m[5oOF+X-^3\u0011\u0007\u0005=7GD\u0002\u0002RBrA!a5\u0002h:!\u0011Q[As\u001d\u0011\t9.a9\u000f\t\u0005e\u0017\u0011\u001d\b\u0005\u00037\fyN\u0004\u0003\u0002\u0016\u0005u\u0017\"\u00019\n\u00059|\u0017B\u00017n\u0013\tQ7.\u0003\u0002iS&\u0011amZ\u0001\f'\u0016<W.\u001a8u\u000bb,7\rE\u0002\u0002nFj\u0011!Z\n\u0003cM\fa\u0001P5oSRtDCAAv\u0005)\u0011Vm];miRK\b/Z\n\u0003gM\u00141bU8ve\u000e,7\u000b^1ugN1Ag]A\u007f\u0005\u0007\u00012\u0001^A\u0000\u0013\r\u0011\t!\u001e\u0002\b!J|G-^2u!\r!(QA\u0005\u0004\u0005\u000f)(\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001\u0002:poN,\"A!\u0004\u0011\u0007Q\u0014y!C\u0002\u0003\u0012U\u0014A\u0001T8oO\u0006)!o\\<tAQ!!q\u0003B\u000e!\r\u0011I\u0002N\u0007\u0002c!9!\u0011B\u001cA\u0002\t5\u0011\u0001B2paf$BAa\u0006\u0003\"!I!\u0011\u0002\u001d\u0011\u0002\u0003\u0007!QB\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119C\u000b\u0003\u0003\u000e\t%2F\u0001B\u0016!\u0011\u0011iCa\u000e\u000e\u0005\t=\"\u0002\u0002B\u0019\u0005g\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tUR/\u0001\u0006b]:|G/\u0019;j_:LAA!\u000f\u00030\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u0011y\u0004\u0005\u0003\u0003B\t\u001dSB\u0001B\"\u0015\u0011\u0011)%!2\u0002\t1\fgnZ\u0005\u0005\u0003C\u0011\u0019%\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\t=#Q\u000b\t\u0004i\nE\u0013b\u0001B*k\n\u0019\u0011I\\=\t\u0013\u0005MF(!AA\u0002\u0005\r\u0014a\u00049s_\u0012,8\r^%uKJ\fGo\u001c:\u0016\u0005\tm\u0003C\u0002B/\u0005G\u0012y%\u0004\u0002\u0003`)\u0019!\u0011M;\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0003f\t}#\u0001C%uKJ\fGo\u001c:\u0002\u0011\r\fg.R9vC2$BAa\u001b\u0003rA\u0019AO!\u001c\n\u0007\t=TOA\u0004C_>dW-\u00198\t\u0013\u0005Mf(!AA\u0002\t=\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0005\u0005\r\u0014\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0005\t}\u0012AB3rk\u0006d7\u000f\u0006\u0003\u0003l\t}\u0004\"CAZ\u0003\u0006\u0005\t\u0019\u0001B(\u0003-\u0019v.\u001e:dKN#\u0018\r^:\u0011\u0007\te1iE\u0003D\u0005\u000f\u0013\u0019\u0001\u0005\u0005\u0003\n\n5%Q\u0002B\f\u001b\t\u0011YIC\u0002\u0002zULAAa$\u0003\f\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\t\r\u0015!B1qa2LH\u0003\u0002B\f\u0005/CqA!\u0003G\u0001\u0004\u0011i!A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\tu%q\u0014\t\u0006i\u0006=%Q\u0002\u0005\n\u0005C;\u0015\u0011!a\u0001\u0005/\t1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\t\u001d\u0006\u0003\u0002B!\u0005SKAAa+\u0003D\t1qJ\u00196fGR\u0014A\u0002T1z_V$(+Z:vYR\u001c\u0002\"S:\u00032\u0006u(1\u0001\t\u0004\u00053\u0019\u0014\u0001\u00037bs>,H/\u00133\u0016\u0005\t]\u0006\u0003\u0002B!\u0005sKAA!\u0005\u0003D\u0005IA.Y=pkRLE\rI\u0001\u0006gR\fGo]\u000b\u0003\u0005\u0003\u0004BAa1\u0003N6\u0011!Q\u0019\u0006\u0005\u0005\u000f\u0014I-A\u0004ti>\u0014\u0018mZ3\u000b\t\t-\u00171I\u0001\u000bI\u0006$\u0018m]8ve\u000e,\u0017\u0002\u0002Bh\u0005\u000b\u0014ab\u0016:ji\u0016$\u0016m]6Ti\u0006$8/\u0001\u0004ti\u0006$8\u000fI\u0001\fg>,(oY3Ti\u0006$8/\u0006\u0002\u0003\u0018\u0005a1o\\;sG\u0016\u001cF/\u0019;tAQA!1\u001cBo\u0005?\u0014\t\u000fE\u0002\u0003\u001a%CqAa-Q\u0001\u0004\u00119\fC\u0004\u0003>B\u0003\rA!1\t\u000f\tM\u0007\u000b1\u0001\u0003\u0018QA!1\u001cBs\u0005O\u0014I\u000fC\u0005\u00034F\u0003\n\u00111\u0001\u00038\"I!QX)\u0011\u0002\u0003\u0007!\u0011\u0019\u0005\n\u0005'\f\u0006\u0013!a\u0001\u0005/)\"A!<+\t\t]&\u0011F\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00133+\t\u0011\u0019P\u000b\u0003\u0003B\n%\u0012AD2paf$C-\u001a4bk2$HeM\u000b\u0003\u0005sTCAa\u0006\u0003*Q!!q\nB\u007f\u0011%\t\u0019lVA\u0001\u0002\u0004\t\u0019\u0007\u0006\u0003\u0003l\r\u0005\u0001\"CAZ3\u0006\u0005\t\u0019\u0001B()\u0011\u0011Yg!\u0002\t\u0013\u0005MF,!AA\u0002\t=\u0013\u0001\u0004'bs>,HOU3tk2$\bc\u0001B\r=N)al!\u0004\u0003\u0004Aa!\u0011RB\b\u0005o\u0013\tMa\u0006\u0003\\&!1\u0011\u0003BF\u0005E\t%m\u001d;sC\u000e$h)\u001e8di&|gn\r\u000b\u0003\u0007\u0013!\u0002Ba7\u0004\u0018\re11\u0004\u0005\b\u0005g\u000b\u0007\u0019\u0001B\\\u0011\u001d\u0011i,\u0019a\u0001\u0005\u0003DqAa5b\u0001\u0004\u00119\u0002\u0006\u0003\u0004 \r\u001d\u0002#\u0002;\u0002\u0010\u000e\u0005\u0002#\u0003;\u0004$\t]&\u0011\u0019B\f\u0013\r\u0019)#\u001e\u0002\u0007)V\u0004H.Z\u001a\t\u0013\t\u0005&-!AA\u0002\tm\u0017!\u00044bS24\u0015m\u001d;Rk\u0016,X-\u0006\u0002\u0004.A1\u00111XAe\u0003\u001b\u0013A\u0001V1tWN\u0011\u0001c]\u0001\fO\u0016$H+Y:l\t\u0016\u001c8-\u0001\bsK\u000e|'\u000f\u001a+bg.LeNZ8\u0015\t\u0005\u00151\u0011\b\u0005\b\u0007w\u0011\u0002\u0019AB\u001f\u0003\u0005!\bcAB !5\t\u0001!\u0001\nsKB|'\u000f\u001e+bg.\u0004&o\\4sKN\u001c\u0018!D:m_^\u001cF/\u0019:u\u000bb,7-\u0006\u0003\u0004H\rUCCBA\u0003\u0007\u0013\u001a\t\u0007C\u0004\u0004LQ\u0001\ra!\u0014\u0002\u0011Q\f7o[%uKJ\u0004b!!&\u0004P\rE\u0013\u0002\u0002B3\u0003G\u0003Baa\u0015\u0004V1\u0001AaBB,)\t\u00071\u0011\f\u0002\u0002)F!11LB\u001f!\r!8QL\u0005\u0004\u0007?*(a\u0002(pi\"Lgn\u001a\u0005\b\u0007G\"\u0002\u0019AB3\u0003!!\u0018m]6Fq\u0016\u001c\u0007c\u0002;\u0004h\rE\u0013QA\u0005\u0004\u0007S*(!\u0003$v]\u000e$\u0018n\u001c82\u00039\u0019XOY7jiR\u000b7o[#yK\u000e,Baa\u001c\u0004xQ1\u0011QAB9\u0007sBqaa\u001d\u0016\u0001\u0004\u0019)(\u0001\u0003uCN\\\u0007\u0003BB*\u0007o\"qaa\u0016\u0016\u0005\u0004\u0019I\u0006C\u0004\u0004dU\u0001\raa\u001f\u0011\u000fQ\u001c9g!\u001e\u0002\u0006\u0005Q\u0011\r\u001a6vgR\u001cuO\u001c3\u0015\r\u0005\r4\u0011QBC\u0011\u001d\u0019\u0019I\u0006a\u0001\u0003G\nAaY<oI\"91q\u0011\fA\u0002\u0005\r\u0014\u0001C:ti\"\u0014Xm\u001d5\u0002\u001b\u0019\f\u0017\u000e\u001c$bgR\u001c\u0005.Z2l\u000311\u0017-\u001b7GCN$\bk\u001c7m)\u0019\t\u0019ga$\u0004\u0014\"I1\u0011\u0013\r\u0011\u0002\u0003\u0007!QB\u0001\bi&lWm\\;u\u0011%\u0019)\n\u0007I\u0001\u0002\u0004\u00199*\u0001\u0003v]&$\b\u0003BA^\u00073KAaa'\u0002>\nAA+[7f+:LG/\u0001\fgC&dg)Y:u!>dG\u000e\n3fM\u0006,H\u000e\u001e\u00132\u0003Y1\u0017-\u001b7GCN$\bk\u001c7mI\u0011,g-Y;mi\u0012\u0012TCABRU\u0011\u00199J!\u000b\u0002\u001b!\fg\u000e\u001a7f\r\u0006LG.\u001e:f)\u0011\t)a!+\t\u000f\r-6\u00041\u0001\u0002\u000e\u00069a-Y5mkJ,\u0017aF:fi\u000e{gNZ5hi\r+(O]3oiRC'/Z1e\u0003\u0015!'/Y5o)\u0019\t)aa-\u00046\"I1\u0011S\u000f\u0011\u0002\u0003\u0007!Q\u0002\u0005\n\u0007+k\u0002\u0013!a\u0001\u0007/\u000bq\u0002\u001a:bS:$C-\u001a4bk2$H%M\u0001\u0010IJ\f\u0017N\u001c\u0013eK\u001a\fW\u000f\u001c;%e\u0005\tR\u000f\u001d3bi\u0016$\u0015\r^1MCf|W\u000f^:\u0015\r\u0005\r4qXBi\u0011\u001d\u0019\t\r\ta\u0001\u0007\u0007\fq!\\1oC\u001e,'\u000f\u0005\u0003\u0004F\u000e5WBABd\u0015\u0011\t)f!3\u000b\t\r-\u0017qK\u0001\u0005GV\u0014W-\u0003\u0003\u0004P\u000e\u001d'\u0001\u0005(ECR\fg\r\\8x\u001b\u0006t\u0017mZ3s\u0011\u001d\u0019\u0019\u000e\ta\u0001\u0007+\f1\u0002Z1uC2\u000b\u0017p\\;ugB1\u0011QSBl\u00077LAa!7\u0002$\n\u00191+Z9\u0011\t\r\u00157Q\\\u0005\u0005\u0007?\u001c9MA\u0006O\t\u0006$\u0018\rT1z_V$\u0018AE:dQ\u0016$W\u000f\\3DQ\u0016\u001c7\u000e]8j]R\fAb\u001e:ba2\u000b\u0017p\\;u\tN#baa:\u0004t\u000eu\bCBA!\u0007S\u001ci/\u0003\u0003\u0004l\u0006\r#a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003\u0003\u001ay/\u0003\u0003\u0004r\u0006\r#a\u0001*po\"91Q\u001f\u0012A\u0002\r]\u0018A\u00027bs>,H\u000f\u0005\u0003\u0004F\u000ee\u0018\u0002BB~\u0007\u000f\u0014A\u0002T1z_V$XI\u001c;jifDqaa@#\u0001\u0004\u00199/\u0001\u0005qCJ,g\u000e\u001e#T\u0003=9(/\u00199UE2d\u0015-_8vi\u0012\u001bFCBBt\t\u000b!9\u0001C\u0004\u0004v\u000e\u0002\raa>\t\u000f\r}8\u00051\u0001\u0004h\u0006a1m\u001c7v[:LEMR;oGR!\u0011q\u0002C\u0007\u0011\u001d!y\u0001\na\u0001\t#\taaY8m%\u00164\u0007\u0003BA)\t'IA\u0001\"\u0006\u0002T\tIAK\u00197D_2\u0014VMZ\u0001\u0010oJ\f\u0007/Q4h\u0019\u0006Lx.\u001e;E'R11q\u001dC\u000e\t;Aqa!>&\u0001\u0004\u00199\u0010C\u0004\u0004\u0000\u0016\u0002\raa:\u0002\u001b9,w\u000fR1uC2\u000b\u0017p\\;u)1\t)\u0001b\t\u0005.\u0011=B1\u0007C\u001c\u0011\u001d!)C\na\u0001\tO\tqa]3h[\u0016tG\u000f\u0005\u0003\u0004F\u0012%\u0012\u0002\u0002C\u0016\u0007\u000f\u0014AB\u0014#bi\u0006\u001cVmZ7f]RDqa!>'\u0001\u0004\u00199\u0010C\u0004\u00052\u0019\u0002\raa:\u0002\u00111\f\u0017p\\;u\tNCq\u0001\"\u000e'\u0001\u0004\ty!\u0001\u0007sK\u0006$\u0017M\u00197f\t\u0016\u001c8\rC\u0004\u0005:\u0019\u0002\r\u0001b\u000f\u0002\u001fM$xN]1hK2K7\u000f^3oKJ\u0004R\u0001^AH\t{\u0001BAa1\u0005@%!A\u0011\tBc\u0005=\u0019Fo\u001c:bO\u0016d\u0015n\u001d;f]\u0016\u0014\u0018A\u00048foN{WO]2f'R\fGo\u001d\u000b\u0007\t\u000f\"I\u0005b\u0013\u0011\u0007\u0005=G\u0007C\u0004\u0004v\u001e\u0002\raa>\t\u000f\u00115s\u00051\u0001\u0003B\u0006IA/Y:l'R\fGo]\u0001\u000foJ\f\u0007\u000fR5nK:\u001c\u0018n\u001c8t)\u0011!\u0019\u0006\"\u0019\u0011\r\u0011UCq\u000bC.\u001b\t\t\t-\u0003\u0003\u0005Z\u0005\u0005'aA*fiB!!\u0011\tC/\u0013\u0011!yFa\u0011\u0003\u000f%sG/Z4fe\"91Q\u001f\u0015A\u0002\r]\u0018AE:qCJ\\7k\u00195fIVdWM\u001d)p_2\f!c]1wK^KG\u000f[*uCRL7\u000f^5dgRa!\u0011\u0019C5\tW\"i\u0007\"\u001d\u0005t!91Q\u001f\u0016A\u0002\r]\bb\u0002C\u0019U\u0001\u00071q\u001d\u0005\b\t_R\u0003\u0019AA\b\u0003-\u0019Ho\u001c:bO\u0016\u0004\u0016\r\u001e5\t\u000f\u0011U\"\u00061\u0001\u0002\u0010!9A\u0011\b\u0016A\u0002\u0011m\u0012aE5oi\u0016\u00148/Z2u\t&lWM\\:j_:\u001cHC\u0002C*\ts\"i\bC\u0004\u0005|-\u0002\r\u0001b\u0015\u0002\u0015\u0011LW.\u001a8tS>t7\u000fC\u0004\u0005\u0000-\u0002\raa:\u0002\u0005\u0011\u001c\u0018aC2bY\u0012KWNU1oO\u0016$b\u0001\"\"\u0005\u0012\u0012M\u0005\u0003\u0003C+\t\u000f\u000by\u0001b#\n\t\u0011%\u0015\u0011\u0019\u0002\b\u0011\u0006\u001c\b.T1q!\u0011\u0019)\r\"$\n\t\u0011=5q\u0019\u0002\u0013\t&lWM\\:j_:\u0014\u0016M\\4f\u0013:4w\u000eC\u0004\u0005&1\u0002\r\u0001b\n\t\u000f\u0011}D\u00061\u0001\u0004h\u000691\r\\3b]V\u0004\u0018!F2mK\u0006tW\u000f\u001d'bs>,H\u000fV3na\u0012\u000bG/\u0019\u000b\u0007\u0003\u000b!Y\n\"(\t\u000f\u0011\u0015b\u00061\u0001\u0005(!9Aq\u0014\u0018A\u0002\u0011\u0005\u0016a\u00027bs>,Ho\u001d\t\u0007\u0003+\u001b9na>\u0002\u001fA|G\u000e\\3e%\u0016\u001cX\u000f\u001c;TKF,B\u0001b*\u0005.R!A\u0011\u0016CY!\u0019\t)ja6\u0005,B!11\u000bCW\t\u001d\u00199f\fb\u0001\t_\u000bBaa\u0017\u0003P!9A1W\u0018A\u0002\u0011U\u0016a\u0003:fgVdG/U;fk\u0016\u0004b!a/\u00058\u0012-\u0016\u0002\u0002C]\u0003{\u0013QB\u00117pG.LgnZ)vKV,\u0007")
public interface SegmentExec
extends Logging {
    public String jobId();

    public String project();

    public String segmentId();

    public String dataflowId();

    public KylinConfig config();

    public SparkSession sparkSession();

    public NDataModel dataModel();

    public int storageType();

    public BuildContext resourceContext();

    public JobRuntime runtime();

    public Option<Throwable> anonymousFailure();

    public void anonymousFailure_$eq(Option<Throwable> var1);

    public static /* synthetic */ LinkedBlockingQueue pipe$(SegmentExec $this) {
        return $this.pipe();
    }

    default public LinkedBlockingQueue<ResultType> pipe() {
        return Queues.newLinkedBlockingQueue();
    }

    public static /* synthetic */ LinkedBlockingQueue failFastQueue$(SegmentExec $this) {
        return $this.failFastQueue();
    }

    default public LinkedBlockingQueue<Option<Throwable>> failFastQueue() {
        return Queues.newLinkedBlockingQueue();
    }

    public static /* synthetic */ void recordTaskInfo$(SegmentExec $this, Task t) {
        $this.recordTaskInfo(t);
    }

    default public void recordTaskInfo(Task t) {
    }

    public static /* synthetic */ void reportTaskProgress$(SegmentExec $this) {
        $this.reportTaskProgress();
    }

    default public void reportTaskProgress() {
    }

    public static /* synthetic */ void slowStartExec$(SegmentExec $this, Iterator taskIter, Function1 taskExec) {
        $this.slowStartExec(taskIter, taskExec);
    }

    default public <T extends Task> void slowStartExec(Iterator<T> taskIter, Function1<T, BoxedUnit> taskExec) {
        int cwnd = 1;
        int ssthresh = 10;
        int inflight = 0;
        boolean shrinkable = true;
        boolean reportable = false;
        while (taskIter.hasNext()) {
            if (this.resourceContext().isAvailable()) {
                shrinkable = true;
                while (taskIter.hasNext() && inflight < cwnd) {
                    Task task = (Task)taskIter.next();
                    this.submitTaskExec(task, taskExec);
                    ++inflight;
                    this.recordTaskInfo(task);
                    reportable = true;
                }
                cwnd = this.adjustCwnd(cwnd, ssthresh);
            } else if (shrinkable) {
                ssthresh = Math.max(1, cwnd >> 1);
                cwnd = 1;
                shrinkable = false;
            }
            if (reportable) {
                this.reportTaskProgress();
                reportable = false;
            }
            inflight -= this.failFastPoll(3L, TimeUnit.SECONDS);
        }
        while (inflight > 0) {
            inflight -= this.failFastPoll(this.failFastPoll$default$1(), this.failFastPoll$default$2());
        }
        this.drain(this.drain$default$1(), this.drain$default$2());
    }

    private <T extends Task> void submitTaskExec(T task, Function1<T, BoxedUnit> taskExec) {
        this.runtime().submit((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                this.setConfig4CurrentThread();
                taskExec.apply((Object)task);
                this.failFastQueue().offer((Option<Throwable>)None$.MODULE$);
            }
            catch (Throwable t) {
                this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(25).append("Segment ").append(this.segmentId()).append(" task exec failed").toString(), t);
                this.failFastQueue().offer((Option<Throwable>)new Some((Object)t));
            }
        });
    }

    private int adjustCwnd(int cwnd, int ssthresh) {
        return cwnd << 1 < ssthresh ? cwnd << 1 : (cwnd < ssthresh ? ssthresh : cwnd + 1);
    }

    public static /* synthetic */ void failFastCheck$(SegmentExec $this) {
        $this.failFastCheck();
    }

    default public void failFastCheck() {
        this.handleFailure(this.anonymousFailure());
        java.util.Iterator<Option<Throwable>> iter = this.failFastQueue().iterator();
        while (iter.hasNext()) {
            this.handleFailure(iter.next());
        }
    }

    public static /* synthetic */ int failFastPoll$(SegmentExec $this, long timeout, TimeUnit unit) {
        return $this.failFastPoll(timeout, unit);
    }

    default public int failFastPoll(long timeout, TimeUnit unit) {
        this.handleFailure(this.anonymousFailure());
        Predef$.MODULE$.assert(unit.toSeconds(timeout) > 0L, (Function0 & Serializable & scala.Serializable)() -> "Timeout should be positive seconds to avoid a busy loop.");
        int count = 0;
        Option<Throwable> failure = this.failFastQueue().poll(timeout, unit);
        while (Objects.nonNull(failure)) {
            this.handleFailure(failure);
            ++count;
            failure = this.failFastQueue().poll();
        }
        return count;
    }

    public static /* synthetic */ long failFastPoll$default$1$(SegmentExec $this) {
        return $this.failFastPoll$default$1();
    }

    default public long failFastPoll$default$1() {
        return 1L;
    }

    public static /* synthetic */ TimeUnit failFastPoll$default$2$(SegmentExec $this) {
        return $this.failFastPoll$default$2();
    }

    default public TimeUnit failFastPoll$default$2() {
        return TimeUnit.SECONDS;
    }

    public static /* synthetic */ void handleFailure$(SegmentExec $this, Option failure) {
        $this.handleFailure((Option<Throwable>)failure);
    }

    default public void handleFailure(Option<Throwable> failure) {
        if (Objects.isNull(failure) || failure.isEmpty()) {
            return;
        }
        this.logError((Function0 & Serializable & scala.Serializable)() -> "Fail fast.", (Throwable)failure.get());
        this.drain(this.drain$default$1(), this.drain$default$2());
        throw (Throwable)failure.get();
    }

    public static /* synthetic */ void setConfig4CurrentThread$(SegmentExec $this) {
        $this.setConfig4CurrentThread();
    }

    default public void setConfig4CurrentThread() {
        if (KylinConfig.isKylinConfigThreadLocal()) {
            return;
        }
        KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)this.config());
    }

    public static /* synthetic */ void drain$(SegmentExec $this, long timeout, TimeUnit unit) {
        $this.drain(timeout, unit);
    }

    default public void drain(long timeout, TimeUnit unit) {
        block5: {
            SegmentExec segmentExec = this;
            synchronized (segmentExec) {
                block4: {
                    ResultType entry = this.pipe().poll(timeout, unit);
                    if (Objects.isNull(entry)) break block4;
                    ArrayList results = Lists.newArrayList((Object[])new LayoutResult[]{(LayoutResult)entry});
                    entry = this.pipe().poll();
                    while (Objects.nonNull(entry)) {
                        results.add((LayoutResult)entry);
                        entry = this.pipe().poll();
                    }
                    this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Segment ").append(this.segmentId()).append(" drained layouts: ").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)results).asScala()).map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.layoutId(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ",", "]")).toString());
                    public class Org_apache_kylin_engine_spark_job_SegmentExec$DFUpdate$1
                    implements UnitOfWork.Callback<Object> {
                        private final /* synthetic */ SegmentExec $outer;
                        private final ArrayList results$1;

                        public void preProcess() {
                            super.preProcess();
                        }

                        public void onProcessError(Throwable x$1) {
                            super.onProcessError(x$1);
                        }

                        public int process() {
                            NDataflowManager manager = NDataflowManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.$outer.project());
                            NDataflow copiedDataflow = manager.getDataflow(this.$outer.dataflowId()).copy();
                            Buffer dataLayouts = (Buffer)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.results$1).asScala()).map((Function1 & Serializable & scala.Serializable)lr -> {
                                Long layoutId = lr.layoutId();
                                WriteTaskStats taskStats = lr.stats();
                                SourceStats sourceStats = lr.sourceStats();
                                NDataLayout dataLayout = NDataLayout.newDataLayout((NDataflow)copiedDataflow, (String)$this.$outer.segmentId(), (long)Predef$.MODULE$.Long2long(layoutId));
                                dataLayout.setBuildJobId($this.$outer.jobId());
                                if (taskStats.numRows() == -1L) {
                                    KylinBuildEnv$.MODULE$.get().buildJobInfos().recordAbnormalLayouts(Predef$.MODULE$.Long2long(layoutId), "Total row count -1.");
                                    $this.$outer.logWarning((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Segment ").append($this.$outer.segmentId()).append(" layout ").append(layoutId).append(" total row count -1.").toString());
                                }
                                dataLayout.setSourceRows(sourceStats.rows());
                                dataLayout.setRows(taskStats.numRows());
                                dataLayout.setPartitionNum(taskStats.numBucket());
                                dataLayout.setPartitionValues(taskStats.partitionValues());
                                dataLayout.setFileCount(taskStats.numFiles());
                                dataLayout.setByteSize(taskStats.numBytes());
                                return dataLayout;
                            }, Buffer$.MODULE$.canBuildFrom());
                            this.$outer.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Segment ").append($this.$outer.segmentId()).append(" update the data layouts ").append(dataLayouts).toString());
                            return this.$outer.updateDataLayouts(manager, (Seq<NDataLayout>)dataLayouts);
                        }

                        public Org_apache_kylin_engine_spark_job_SegmentExec$DFUpdate$1(SegmentExec $outer, ArrayList results$1) {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.results$1 = results$1;
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$process$1(org.apache.kylin.engine.spark.job.SegmentExec$DFUpdate$1 org.apache.kylin.metadata.cube.model.NDataflow org.apache.kylin.engine.spark.job.SegmentExec$LayoutResult ), $anonfun$process$3(org.apache.kylin.engine.spark.job.SegmentExec$DFUpdate$1 scala.collection.mutable.Buffer ), $anonfun$process$2(org.apache.kylin.engine.spark.job.SegmentExec$DFUpdate$1 java.lang.Long )}, serializedLambda);
                        }
                    }
                    UnitOfWork.doInTransactionWithRetry((UnitOfWork.Callback)new Org_apache_kylin_engine_spark_job_SegmentExec$DFUpdate$1(this, results), (String)this.project());
                    this.logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(26).append("Segment ").append(this.segmentId()).append(" update metadata ").append(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)results).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.layoutId(), Buffer$.MODULE$.canBuildFrom())).mkString("[", ",", "]")).append(".").toString());
                    break block5;
                }
                return;
            }
        }
    }

    public static /* synthetic */ long drain$default$1$(SegmentExec $this) {
        return $this.drain$default$1();
    }

    default public long drain$default$1() {
        return 1L;
    }

    public static /* synthetic */ TimeUnit drain$default$2$(SegmentExec $this) {
        return $this.drain$default$2();
    }

    default public TimeUnit drain$default$2() {
        return TimeUnit.SECONDS;
    }

    public static /* synthetic */ int updateDataLayouts$(SegmentExec $this, NDataflowManager manager, Seq dataLayouts) {
        return $this.updateDataLayouts(manager, (Seq<NDataLayout>)dataLayouts);
    }

    default public int updateDataLayouts(NDataflowManager manager, Seq<NDataLayout> dataLayouts) {
        NDataflowUpdate updates = new NDataflowUpdate(this.dataflowId());
        updates.setToAddOrUpdateLayouts((NDataLayout[])dataLayouts.toArray(ClassTag$.MODULE$.apply(NDataLayout.class)));
        manager.updateDataflow(updates);
        return 0;
    }

    public static /* synthetic */ void scheduleCheckpoint$(SegmentExec $this) {
        $this.scheduleCheckpoint();
    }

    default public void scheduleCheckpoint() {
        this.runtime().scheduleCheckpoint((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            try {
                this.setConfig4CurrentThread();
                this.drain(this.drain$default$1(), this.drain$default$2());
            }
            catch (Throwable t) {
                this.logError((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Segment ").append(this.segmentId()).append(" checkpoint failed.").toString(), t);
                this.anonymousFailure_$eq((Option<Throwable>)new Some((Object)t));
                throw t;
            }
        });
    }

    public static /* synthetic */ Dataset wrapLayoutDS$(SegmentExec $this, LayoutEntity layout, Dataset parentDS) {
        return $this.wrapLayoutDS(layout, (Dataset<Row>)parentDS);
    }

    default public Dataset<Row> wrapLayoutDS(LayoutEntity layout, Dataset<Row> parentDS) {
        Dataset<Row> dataset;
        if (IndexEntity.isTableIndex((long)layout.getId())) {
            Predef$.MODULE$.require(layout.getIndex().getMeasures().isEmpty());
            dataset = this.wrapTblLayoutDS(layout, parentDS);
        } else {
            dataset = this.wrapAggLayoutDS(layout, parentDS);
        }
        return dataset;
    }

    private Dataset<Row> wrapTblLayoutDS(LayoutEntity layout, Dataset<Row> parentDS) {
        Predef$.MODULE$.require(layout.getIndex().getMeasures().isEmpty());
        java.util.Set<Integer> dimensions = this.wrapDimensions(layout);
        Column[] columns = NSparkCubingUtil.getColumns((java.util.Set[])new java.util.Set[]{dimensions});
        return parentDS.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns)).sortWithinPartitions((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns));
    }

    public String columnIdFunc(TblColRef var1);

    private Dataset<Row> wrapAggLayoutDS(LayoutEntity layout, Dataset<Row> parentDS) {
        java.util.Set<Integer> dimensions = this.wrapDimensions(layout);
        ImmutableSet measures = layout.getOrderedMeasures().keySet();
        Column[] sortColumns = NSparkCubingUtil.getColumns((java.util.Set[])new java.util.Set[]{dimensions});
        Column[] selectColumns = NSparkCubingUtil.getColumns((java.util.Set[])new java.util.Set[]{NSparkCubingUtil.combineIndices((java.util.Set[])new java.util.Set[]{dimensions, measures})});
        Dataset<Row> aggregated = CuboidAggregator$.MODULE$.aggregate(parentDS, dimensions, (Map<Integer, NDataModel.Measure>)layout.getIndex().getEffectiveMeasures(), (Function1<TblColRef, String>)(Function1 & Serializable & scala.Serializable)colRef -> this.columnIdFunc((TblColRef)colRef), CuboidAggregator$.MODULE$.aggregate$default$5());
        return aggregated.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])selectColumns)).sortWithinPartitions((Seq)Predef$.MODULE$.wrapRefArray((Object[])sortColumns));
    }

    public static /* synthetic */ void newDataLayout$(SegmentExec $this, NDataSegment segment, LayoutEntity layout, Dataset layoutDS, String readableDesc, Option storageListener) {
        $this.newDataLayout(segment, layout, (Dataset<Row>)layoutDS, readableDesc, (Option<StorageListener>)storageListener);
    }

    default public void newDataLayout(NDataSegment segment, LayoutEntity layout, Dataset<Row> layoutDS, String readableDesc, Option<StorageListener> storageListener) {
        String storagePath = NSparkCubingUtil.getStoragePath((NDataSegment)segment, (Long)Predef$.MODULE$.long2Long(layout.getId()));
        WriteTaskStats taskStats = this.saveWithStatistics(layout, layoutDS, storagePath, readableDesc, storageListener);
        SourceStats sourceStats = this.newSourceStats(layout, taskStats);
        this.pipe().offer(new LayoutResult(Predef$.MODULE$.long2Long(layout.getId()), taskStats, sourceStats));
    }

    public static /* synthetic */ SourceStats newSourceStats$(SegmentExec $this, LayoutEntity layout, WriteTaskStats taskStats) {
        return $this.newSourceStats(layout, taskStats);
    }

    default public SourceStats newSourceStats(LayoutEntity layout, WriteTaskStats taskStats) {
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Segment ").append(this.segmentId()).append(" layout source rows ").append(layout.getId()).append(" ").append(taskStats.sourceRows()).toString());
        return new SourceStats(taskStats.sourceRows());
    }

    public static /* synthetic */ java.util.Set wrapDimensions$(SegmentExec $this, LayoutEntity layout) {
        return $this.wrapDimensions(layout);
    }

    /*
     * WARNING - void declaration
     */
    default public java.util.Set<Integer> wrapDimensions(LayoutEntity layout) {
        void var2_2;
        ImmutableSet dimensions = layout.getOrderedDimensions().keySet();
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(28).append("Segment ").append(this.segmentId()).append(" layout dimensions ").append(layout.getId()).append(" ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)dimensions).asScala()).mkString("[", ",", "]")).toString());
        return var2_2;
    }

    public String sparkSchedulerPool();

    public static /* synthetic */ WriteTaskStats saveWithStatistics$(SegmentExec $this, LayoutEntity layout, Dataset layoutDS, String storagePath, String readableDesc, Option storageListener) {
        return $this.saveWithStatistics(layout, (Dataset<Row>)layoutDS, storagePath, readableDesc, (Option<StorageListener>)storageListener);
    }

    default public WriteTaskStats saveWithStatistics(LayoutEntity layout, Dataset<Row> layoutDS, String storagePath, String readableDesc, Option<StorageListener> storageListener) {
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> readableDesc);
        this.sparkSession().sparkContext().setJobDescription(readableDesc);
        this.sparkSession().sparkContext().setLocalProperty("spark.scheduler.pool", this.sparkSchedulerPool());
        StorageStore store = StorageStoreFactory$.MODULE$.create(this.storageType());
        Option<StorageListener> option = storageListener;
        if (option instanceof Some) {
            Some some = (Some)option;
            StorageListener x = (StorageListener)some.value();
            store.setStorageListener(x);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (None$.MODULE$.equals(option)) {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(option);
        }
        WriteTaskStats stats = store.save(layout, new Path(storagePath), KapConfig.wrap((KylinConfig)this.config()), layoutDS);
        this.sparkSession().sparkContext().setJobDescription(null);
        return stats;
    }

    private java.util.Set<Integer> intersectDimensions(java.util.Set<Integer> dimensions, Dataset<Row> ds) {
        if (this instanceof MergeStage) {
            scala.collection.immutable.Set fieldNames = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ds.schema().fieldNames())).toSet();
            scala.collection.immutable.Set dimensionsStrings = ((TraversableOnce)((scala.collection.SetLike)JavaConverters$.MODULE$.asScalaSetConverter(dimensions).asScala()).map((Function1 & Serializable & scala.Serializable)dim -> String.valueOf(dim), Set$.MODULE$.canBuildFrom())).toSet();
            scala.collection.immutable.Set intersection = (scala.collection.immutable.Set)((scala.collection.SetLike)fieldNames.intersect((GenSet)dimensionsStrings)).map((Function1 & Serializable & scala.Serializable)dim -> Integer.valueOf(dim), scala.collection.immutable.Set$.MODULE$.canBuildFrom());
            return (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)intersection).asJava();
        }
        return dimensions;
    }

    public static /* synthetic */ HashMap calDimRange$(SegmentExec $this, NDataSegment segment, Dataset ds) {
        return $this.calDimRange(segment, (Dataset<Row>)ds);
    }

    default public HashMap<String, DimensionRangeInfo> calDimRange(NDataSegment segment, Dataset<Row> ds) {
        HashMap<String, DimensionRangeInfo> dimRangeInfo;
        block0: {
            java.util.Set dimensions = segment.getDataflow().getIndexPlan().getEffectiveDimCols().keySet();
            dimRangeInfo = new HashMap<String, DimensionRangeInfo>();
            if (!Objects.isNull(segment.getModel().getMultiPartitionDesc()) || !this.config().isDimensionRangeFilterEnabled() || dimensions.isEmpty()) break block0;
            long start = System.currentTimeMillis();
            java.util.Set<Integer> intersectionDimensions = this.intersectDimensions(dimensions, ds);
            Column[] columns = NSparkCubingUtil.getColumns((java.util.Set[])new java.util.Set[]{intersectionDimensions});
            Dataset dimDS = ds.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])columns));
            Column[] minCols = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dimDS.columns())).map((Function1 & Serializable & scala.Serializable)columnName -> functions$.MODULE$.min(columnName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            Column[] maxCols = (Column[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])dimDS.columns())).map((Function1 & Serializable & scala.Serializable)columnName -> functions$.MODULE$.max(columnName), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class)));
            Column[] cols = (Column[])Array$.MODULE$.concat((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[][]{minCols, maxCols}), ClassTag$.MODULE$.apply(Column.class));
            Tuple2 row = ((Row)dimDS.agg((Column)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cols)).head(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cols)).tail())).head()).toSeq().splitAt(columns.length);
            Tuple3Zipped$.MODULE$.map$extension(Tuple3Zipped.Ops$.MODULE$.zipped$extension(Predef$.MODULE$.tuple3ToZippedOps(new Tuple3((Object)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(intersectionDimensions).asScala()).toSeq(), row._1(), row._2())), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms(), (Function1)Predef$.MODULE$.$conforms()), (Function3 & Serializable & scala.Serializable)(x0$1, x1$1, x2$1) -> {
                Tuple3 tuple3 = new Tuple3(x0$1, x1$1, x2$1);
                if (tuple3 != null) {
                    Object object = tuple3._2();
                    Object object2 = tuple3._3();
                    if (object == null && object2 == null) {
                        return BoxedUnit.UNIT;
                    }
                }
                if (tuple3 == null) throw new MatchError((Object)tuple3);
                Integer column = (Integer)tuple3._1();
                Object min = tuple3._2();
                Object max = tuple3._3();
                return dimRangeInfo.put(column.toString(), new DimensionRangeInfo(min.toString(), max.toString()));
            }, Seq$.MODULE$.canBuildFrom());
            long timeCost = System.currentTimeMillis() - start;
            this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Segment ").append(this.segmentId()).append(" calculate dimension range cost ").append(timeCost).append(" ms").toString());
        }
        return dimRangeInfo;
    }

    public static /* synthetic */ void cleanup$(SegmentExec $this) {
        $this.cleanup();
    }

    default public void cleanup() {
        this.drain(this.drain$default$1(), this.drain$default$2());
    }

    public static /* synthetic */ void cleanupLayoutTempData$(SegmentExec $this, NDataSegment segment, Seq layouts) {
        $this.cleanupLayoutTempData(segment, (Seq<LayoutEntity>)layouts);
    }

    default public void cleanupLayoutTempData(NDataSegment segment, Seq<LayoutEntity> layouts) {
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Segment ").append(this.segmentId()).append(" cleanup layout temp data.").toString());
        Seq prefixes = (Seq)((TraversableLike)layouts.map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getId()), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)id -> SegmentExec.$anonfun$cleanupLayoutTempData$3(BoxesRunTime.unboxToLong((Object)id)), Seq$.MODULE$.canBuildFrom());
        Path segmentPath = new Path(NSparkCubingUtil.getStoragePath((NDataSegment)segment));
        FileSystem fileSystem = segmentPath.getFileSystem(this.sparkSession().sparkContext().hadoopConfiguration());
        if (!fileSystem.exists(segmentPath)) {
            return;
        }
        Path[] cleanups = (Path[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])fileSystem.listStatus(segmentPath, new PathFilter(null, prefixes){
            private final Seq prefixes$1;

            public boolean accept(Path destPath) {
                String name = destPath.getName();
                return this.prefixes$1.exists((Function1 & Serializable & scala.Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)$anon$1.$anonfun$accept$1(name, prefix)));
            }

            public static final /* synthetic */ boolean $anonfun$accept$1(String name$1, String prefix) {
                return name$1.startsWith(prefix);
            }
            {
                this.prefixes$1 = prefixes$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$accept$1$adapted(java.lang.String java.lang.String )}, serializedLambda);
            }
        }))).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getPath(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Path.class)));
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cleanups)).isEmpty()) {
            return;
        }
        int processors = Runtime.getRuntime().availableProcessors();
        ParArray parallel = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cleanups)).par();
        ForkJoinPool forkJoinPool = new ForkJoinPool(Math.max(processors, cleanups.length / 2));
        try {
            parallel.tasksupport_$eq((TaskSupport)new ForkJoinTaskSupport(forkJoinPool));
            parallel.foreach((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)fileSystem.delete(p, true)));
        }
        finally {
            forkJoinPool.shutdownNow();
        }
        this.logInfo((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Segment ").append(this.segmentId()).append(" cleanup layout temp data: ").append(new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])cleanups)).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getName(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString("[", ",", "]")).toString());
    }

    public static /* synthetic */ Seq polledResultSeq$(SegmentExec $this, BlockingQueue resultQueue) {
        return $this.polledResultSeq(resultQueue);
    }

    default public <T> Seq<T> polledResultSeq(BlockingQueue<T> resultQueue) {
        ArrayList collected = Lists.newArrayList();
        Object entry = resultQueue.poll();
        while (Objects.nonNull(entry)) {
            collected.add(entry);
            entry = resultQueue.poll();
        }
        return (Seq)JavaConverters$.MODULE$.asScalaBufferConverter((List)collected).asScala();
    }

    public static /* synthetic */ String $anonfun$cleanupLayoutTempData$3(long id) {
        return new StringBuilder(5).append(id).append("_temp").toString();
    }

    public static void $init$(SegmentExec $this) {
        $this.anonymousFailure_$eq((Option<Throwable>)None$.MODULE$);
    }

    public static class LayoutResult
    implements ResultType,
    Product,
    scala.Serializable {
        private final Long layoutId;
        private final WriteTaskStats stats;
        private final SourceStats sourceStats;

        public Long layoutId() {
            return this.layoutId;
        }

        public WriteTaskStats stats() {
            return this.stats;
        }

        public SourceStats sourceStats() {
            return this.sourceStats;
        }

        public LayoutResult copy(Long layoutId, WriteTaskStats stats, SourceStats sourceStats) {
            return new LayoutResult(layoutId, stats, sourceStats);
        }

        public Long copy$default$1() {
            return this.layoutId();
        }

        public WriteTaskStats copy$default$2() {
            return this.stats();
        }

        public SourceStats copy$default$3() {
            return this.sourceStats();
        }

        public String productPrefix() {
            return "LayoutResult";
        }

        public int productArity() {
            return 3;
        }

        public Object productElement(int x$1) {
            Object object;
            int n = x$1;
            switch (n) {
                case 0: {
                    object = this.layoutId();
                    break;
                }
                case 1: {
                    object = this.stats();
                    break;
                }
                case 2: {
                    object = this.sourceStats();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return object;
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LayoutResult;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof LayoutResult)) return false;
            boolean bl = true;
            if (!bl) return false;
            LayoutResult layoutResult = (LayoutResult)x$1;
            Long l = this.layoutId();
            Long l2 = layoutResult.layoutId();
            if (l == null) {
                if (l2 != null) {
                    return false;
                }
            } else if (!((Object)l).equals(l2)) return false;
            WriteTaskStats writeTaskStats = this.stats();
            WriteTaskStats writeTaskStats2 = layoutResult.stats();
            if (writeTaskStats == null) {
                if (writeTaskStats2 != null) {
                    return false;
                }
            } else if (!writeTaskStats.equals(writeTaskStats2)) return false;
            SourceStats sourceStats = this.sourceStats();
            SourceStats sourceStats2 = layoutResult.sourceStats();
            if (sourceStats == null) {
                if (sourceStats2 != null) {
                    return false;
                }
            } else if (!((Object)sourceStats).equals(sourceStats2)) return false;
            if (!layoutResult.canEqual(this)) return false;
            return true;
        }

        public LayoutResult(Long layoutId, WriteTaskStats stats, SourceStats sourceStats) {
            this.layoutId = layoutId;
            this.stats = stats;
            this.sourceStats = sourceStats;
            Product.$init$((Product)this);
        }
    }

    public static interface ResultType {
    }

    public static class SourceStats
    implements Product,
    scala.Serializable {
        private final long rows;

        public long rows() {
            return this.rows;
        }

        public SourceStats copy(long rows) {
            return new SourceStats(rows);
        }

        public long copy$default$1() {
            return this.rows();
        }

        public String productPrefix() {
            return "SourceStats";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return BoxesRunTime.boxToLong((long)this.rows());
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof SourceStats;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)Statics.longHash((long)this.rows()));
            return Statics.finalizeHash((int)n, (int)1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof SourceStats)) return false;
            boolean bl = true;
            if (!bl) return false;
            SourceStats sourceStats = (SourceStats)x$1;
            if (this.rows() != sourceStats.rows()) return false;
            if (!sourceStats.canEqual(this)) return false;
            return true;
        }

        public SourceStats(long rows) {
            this.rows = rows;
            Product.$init$((Product)this);
        }
    }

    public interface Task {
        public String getTaskDesc();
    }
}

