/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.NSparkExecutable;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.engine.spark.job.SnapshotBuildJob;
import org.apache.kylin.engine.spark.job.exec.BuildExec;
import org.apache.kylin.engine.spark.job.stage.BuildParam;
import org.apache.kylin.engine.spark.job.stage.StageExec;
import org.apache.kylin.engine.spark.job.stage.WaiteForResource;
import org.apache.kylin.engine.spark.job.stage.build.BuildDict;
import org.apache.kylin.engine.spark.job.stage.build.BuildLayer;
import org.apache.kylin.engine.spark.job.stage.build.CostBasedPlanner;
import org.apache.kylin.engine.spark.job.stage.build.GatherFlatTableStats;
import org.apache.kylin.engine.spark.job.stage.build.GenerateFlatTable;
import org.apache.kylin.engine.spark.job.stage.build.MaterializedFactTableView;
import org.apache.kylin.engine.spark.job.stage.build.RefreshColumnBytes;
import org.apache.kylin.engine.spark.job.stage.build.RefreshSnapshots;
import org.apache.kylin.engine.spark.job.stage.build.partition.PartitionBuildDict;
import org.apache.kylin.engine.spark.job.stage.build.partition.PartitionBuildLayer;
import org.apache.kylin.engine.spark.job.stage.build.partition.PartitionCostBasedPlanner;
import org.apache.kylin.engine.spark.job.stage.build.partition.PartitionGatherFlatTableStats;
import org.apache.kylin.engine.spark.job.stage.build.partition.PartitionGenerateFlatTable;
import org.apache.kylin.engine.spark.job.stage.build.partition.PartitionMaterializedFactTableView;
import org.apache.kylin.engine.spark.job.stage.build.partition.PartitionRefreshColumnBytes;
import org.apache.kylin.engine.spark.job.stage.merge.MergeColumnBytes;
import org.apache.kylin.engine.spark.job.stage.merge.MergeFlatTable;
import org.apache.kylin.engine.spark.job.stage.merge.MergeIndices;
import org.apache.kylin.engine.spark.job.stage.merge.partition.PartitionMergeColumnBytes;
import org.apache.kylin.engine.spark.job.stage.merge.partition.PartitionMergeFlatTable;
import org.apache.kylin.engine.spark.job.stage.merge.partition.PartitionMergeIndices;
import org.apache.kylin.engine.spark.job.stage.snapshots.SnapshotsBuild;
import org.apache.kylin.engine.spark.job.stage.tablesampling.AnalyzerTable;
import org.apache.kylin.engine.spark.job.step.NStageForBuild;
import org.apache.kylin.engine.spark.job.step.NStageForMerge;
import org.apache.kylin.engine.spark.job.step.NStageForSnapshot;
import org.apache.kylin.engine.spark.job.step.NStageForTableSampling;
import org.apache.kylin.engine.spark.job.step.NStageForWaitingForYarnResource;
import org.apache.kylin.engine.spark.stats.analyzer.TableAnalyzerJob;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.StageBase;
import org.apache.kylin.metadata.cube.model.NDataSegment;

public enum StageType {
    WAITE_FOR_RESOURCE{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            return new WaiteForResource(jobContext);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForWaitingForYarnResource("Waiting for yarn resources");
        }
    }
    ,
    REFRESH_SNAPSHOTS{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            return new RefreshSnapshots((SegmentJob)jobContext);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForBuild("Build or refresh snapshot");
        }
    }
    ,
    MATERIALIZED_FACT_TABLE{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            if (this.isPartitioned(jobContext)) {
                return new PartitionMaterializedFactTableView((SegmentJob)jobContext, dataSegment, buildParam);
            }
            return new MaterializedFactTableView((SegmentJob)jobContext, dataSegment, buildParam);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForBuild("Materialize fact table view");
        }
    }
    ,
    BUILD_DICT{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            if (this.isPartitioned(jobContext)) {
                return new PartitionBuildDict((SegmentJob)jobContext, dataSegment, buildParam);
            }
            return new BuildDict((SegmentJob)jobContext, dataSegment, buildParam);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForBuild("Generate global dictionary");
        }
    }
    ,
    GENERATE_FLAT_TABLE{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            if (this.isPartitioned(jobContext)) {
                return new PartitionGenerateFlatTable((SegmentJob)jobContext, dataSegment, buildParam);
            }
            return new GenerateFlatTable((SegmentJob)jobContext, dataSegment, buildParam);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForBuild("Generate flat table");
        }
    }
    ,
    COST_BASED_PLANNER{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            if (this.isPartitioned(jobContext)) {
                return new PartitionCostBasedPlanner((SegmentJob)jobContext, dataSegment, buildParam);
            }
            return new CostBasedPlanner((SegmentJob)jobContext, dataSegment, buildParam);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForBuild("Cost based planner");
        }
    }
    ,
    GATHER_FLAT_TABLE_STATS{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            if (this.isPartitioned(jobContext)) {
                return new PartitionGatherFlatTableStats((SegmentJob)jobContext, dataSegment, buildParam);
            }
            return new GatherFlatTableStats((SegmentJob)jobContext, dataSegment, buildParam);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForBuild("Get flat table statistics");
        }
    }
    ,
    BUILD_LAYER{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            if (this.isPartitioned(jobContext)) {
                return new PartitionBuildLayer((SegmentJob)jobContext, dataSegment, buildParam);
            }
            return new BuildLayer((SegmentJob)jobContext, dataSegment, buildParam);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForBuild("Build indexes by layer");
        }
    }
    ,
    REFRESH_COLUMN_BYTES{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            if (this.isPartitioned(jobContext)) {
                return new PartitionRefreshColumnBytes((SegmentJob)jobContext, dataSegment, buildParam);
            }
            return new RefreshColumnBytes((SegmentJob)jobContext, dataSegment, buildParam);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForBuild("Update flat table statistics");
        }
    }
    ,
    MERGE_FLAT_TABLE{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            if (this.isPartitioned(jobContext)) {
                return new PartitionMergeFlatTable((SegmentJob)jobContext, dataSegment);
            }
            return new MergeFlatTable((SegmentJob)jobContext, dataSegment);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForMerge("Merge flat table");
        }
    }
    ,
    MERGE_INDICES{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            if (this.isPartitioned(jobContext)) {
                return new PartitionMergeIndices((SegmentJob)jobContext, dataSegment);
            }
            return new MergeIndices((SegmentJob)jobContext, dataSegment);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForMerge("Merge indexes");
        }
    }
    ,
    MERGE_COLUMN_BYTES{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            if (this.isPartitioned(jobContext)) {
                return new PartitionMergeColumnBytes((SegmentJob)jobContext, dataSegment);
            }
            return new MergeColumnBytes((SegmentJob)jobContext, dataSegment);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForMerge("Merge flat table statistics");
        }
    }
    ,
    TABLE_SAMPLING{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            return new AnalyzerTable((TableAnalyzerJob)jobContext);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForTableSampling("Sample Table Data");
        }
    }
    ,
    SNAPSHOT_BUILD{

        @Override
        public StageExec create(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam) {
            return new SnapshotsBuild((SnapshotBuildJob)jobContext);
        }

        @Override
        protected StageBase create(NSparkExecutable parent, KylinConfig config) {
            return new NStageForSnapshot("Build Snapshot");
        }
    };


    protected boolean isPartitioned(SparkApplication jobContext) {
        return ((SegmentJob)jobContext).isPartitioned();
    }

    public abstract StageExec create(SparkApplication var1, NDataSegment var2, BuildParam var3);

    protected abstract StageBase create(NSparkExecutable var1, KylinConfig var2);

    public StageExec createStage(SparkApplication jobContext, NDataSegment dataSegment, BuildParam buildParam, BuildExec exec) {
        StageExec step = this.create(jobContext, dataSegment, buildParam);
        exec.addStage(step);
        return step;
    }

    public StageBase createStage(NSparkExecutable parent, KylinConfig config) {
        StageBase step = this.create(parent, config);
        parent.addStage((AbstractExecutable)step);
        return step;
    }
}

