/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.builder.CreateFlatTable$;
import org.apache.kylin.engine.spark.job.TableMetaManager$;
import org.apache.kylin.engine.spark.source.SparkSqlUtil;
import org.apache.kylin.engine.spark.stats.analyzer.TableAnalyzerJob;
import org.apache.kylin.metadata.model.ISourceAware;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.source.SourceFactory;
import org.apache.spark.SparkConf;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.DataFrameEnhancement$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalog.Table;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType$;
import org.apache.spark.sql.functions$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.GenTraversableOnce;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001u4A\u0001D\u0007\u00015!A1\u0006\u0001B\u0001B\u0003%A\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u00036\u0011!\u0001\u0005A!A!\u0002\u0013\t\u0005\u0002\u0003#\u0001\u0005\u0003\u0005\u000b\u0011B#\t\u0011-\u0003!\u0011!Q\u0001\nUBQ\u0001\u0014\u0001\u0005\u00025Cq!\u0016\u0001C\u0002\u0013\u0005a\u000b\u0003\u0004[\u0001\u0001\u0006Ia\u0016\u0005\u00067\u0002!\t\u0001\u0018\u0005\u0006G\u0002!\t\u0001\u001a\u0005\u0006U\u0002!\ta\u001b\u0002\u0011)\u0006\u0014G.Z!oC2L8/[:K_\nT!AD\b\u0002\u0007)|'M\u0003\u0002\u0011#\u0005)1\u000f]1sW*\u0011!cE\u0001\u0007K:<\u0017N\\3\u000b\u0005Q)\u0012!B6zY&t'B\u0001\f\u0018\u0003\u0019\t\u0007/Y2iK*\t\u0001$A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u00017\u0005\"\u0003C\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\"AB!osJ+g\r\u0005\u0002\u001dE%\u00111%\b\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\t\u0003K%j\u0011A\n\u0006\u0003O!\n\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0003!UI!A\u000b\u0014\u0003\u000f1{wmZ5oO\u0006IA/\u00192mK\u0012+7o\u0019\t\u0003[Ij\u0011A\f\u0006\u0003_A\nQ!\\8eK2T!!M\n\u0002\u00115,G/\u00193bi\u0006L!a\r\u0018\u0003\u0013Q\u000b'\r\\3EKN\u001c\u0017a\u00029s_*,7\r\u001e\t\u0003mur!aN\u001e\u0011\u0005ajR\"A\u001d\u000b\u0005iJ\u0012A\u0002\u001fs_>$h(\u0003\u0002=;\u00051\u0001K]3eK\u001aL!AP \u0003\rM#(/\u001b8h\u0015\taT$\u0001\u0005s_^\u001cu.\u001e8u!\ta\")\u0003\u0002D;\t!Aj\u001c8h\u0003\t\u00198\u000f\u0005\u0002G\u00136\tqI\u0003\u0002IQ\u0005\u00191/\u001d7\n\u0005);%\u0001D*qCJ\\7+Z:tS>t\u0017!\u00026pE&#\u0017A\u0002\u001fj]&$h\b\u0006\u0004O!F\u00136\u000b\u0016\t\u0003\u001f\u0002i\u0011!\u0004\u0005\u0006W\u0019\u0001\r\u0001\f\u0005\u0006i\u0019\u0001\r!\u000e\u0005\u0006\u0001\u001a\u0001\r!\u0011\u0005\u0006\t\u001a\u0001\r!\u0012\u0005\u0006\u0017\u001a\u0001\r!N\u0001\u000bi\u0006\u001c8NR1di>\u0014X#A,\u0011\u0005qA\u0016BA-\u001e\u0005\rIe\u000e^\u0001\fi\u0006\u001c8NR1di>\u0014\b%\u0001\u0007b]\u0006d\u0017P_3UC\ndW\rF\u0001^!\rab\fY\u0005\u0003?v\u0011Q!\u0011:sCf\u0004\"AR1\n\u0005\t<%a\u0001*po\u0006Q2-\u00197dk2\fG/\u001a,jK^lU\r^1t\u0013\u001atU-\u001a3fIR\u0011Q\r\u001b\t\u00039\u0019L!aZ\u000f\u0003\tUs\u0017\u000e\u001e\u0005\u0006S*\u0001\r!N\u0001\ni\u0006\u0014G.\u001a(b[\u0016\f\u0001CY;jY\u0012\u001cF/\u0019;t\u001b\u0016$(/[2\u0015\u00051D\bcA7sk:\u0011a\u000e\u001d\b\u0003q=L\u0011AH\u0005\u0003cv\tq\u0001]1dW\u0006<W-\u0003\u0002ti\n!A*[:u\u0015\t\tX\u0004\u0005\u0002Gm&\u0011qo\u0012\u0002\u0007\u0007>dW/\u001c8\t\u000be\\\u0001\u0019\u0001>\u0002\u0017M|WO]2f)\u0006\u0014G.\u001a\t\u0004\rn\u0004\u0017B\u0001?H\u0005\u001d!\u0015\r^1tKR\u0004")
public class TableAnalysisJob
implements scala.Serializable,
Logging {
    private final TableDesc tableDesc;
    private final long rowCount;
    private final SparkSession ss;
    private final int taskFactor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int taskFactor() {
        return this.taskFactor;
    }

    public Row[] analyzeTable() {
        SparkConf sparkConf = this.ss.sparkContext().getConf();
        int instances = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.instances", "1"))).toInt();
        int cores = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.cores", "1"))).toInt();
        int numPartitions = instances * cores;
        long rowsTakenInEachPartition = this.rowCount / (long)numPartitions;
        Map params = NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).getProject(this.tableDesc.getProject()).getLegalOverrideKylinProps();
        params.put("sampleRowCount", String.valueOf(this.rowCount));
        Dataset dataFrame = ((NSparkCubingEngine.NSparkCubingSource)SourceFactory.createEngineAdapter((ISourceAware)this.tableDesc, NSparkCubingEngine.NSparkCubingSource.class)).getSourceData(this.tableDesc, this.ss, params).coalesce(numPartitions);
        this.calculateViewMetasIfNeeded(this.tableDesc.getBackTickIdentity());
        Dataset dat = DataFrameEnhancement$.MODULE$.Functions(dataFrame).localLimit(rowsTakenInEachPartition);
        Dataset<Row> sampledDataset = CreateFlatTable$.MODULE$.changeSchemaToAliasDotName((Dataset<Row>)dat, this.tableDesc.getBackTickIdentity());
        List<Column> statsMetrics = this.buildStatsMetric(sampledDataset);
        Row[] aggData = (Row[])sampledDataset.agg(functions$.MODULE$.count(functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)1))), statsMetrics).collect();
        return (Row[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])aggData)).$plus$plus((GenTraversableOnce)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sampledDataset.limit(10).collect())), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Row.class)));
    }

    public void calculateViewMetasIfNeeded(String tableName) {
        block1: {
            Set<String> tables;
            String string = this.ss.conf().get("spark.sql.catalogImplementation");
            String string2 = "hive";
            if ((string != null ? !string.equals(string2) : string2 != null) || !this.ss.catalog().tableExists(tableName)) break block1;
            Table sparkTable = this.ss.catalog().getTable(tableName);
            String string3 = sparkTable.tableType();
            String string4 = CatalogTableType$.MODULE$.VIEW().name();
            if (!(string3 != null ? !string3.equals(string4) : string4 != null) && ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(tables = SparkSqlUtil.getViewOrignalTables(tableName, this.ss)).asScala()).size() > 1) {
                ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter(tables).asScala()).foreach((Function1 & Serializable & scala.Serializable)t -> {
                    TableAnalysisJob.$anonfun$calculateViewMetasIfNeeded$1(this, sparkTable, t);
                    return BoxedUnit.UNIT;
                });
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("Table type ").append(sparkTable.tableType()).append(", orignal table num is ").append(((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(tables).asScala()).size()).toString());
            }
        }
    }

    public List<Column> buildStatsMetric(Dataset<Row> sourceTable) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sourceTable.schema().fieldNames())).flatMap((Function1 & Serializable & scala.Serializable)name -> (Seq)((TraversableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray(TableAnalyzerJob.TABLE_STATS_METRICS.toArray()))).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Column column;
            Object object = x0$1;
            if ("COUNT".equals(object)) {
                column = functions$.MODULE$.count(functions$.MODULE$.col(name));
            } else if ("COUNT_DISTINCT".equals(object)) {
                column = functions$.MODULE$.approx_count_distinct(functions$.MODULE$.col(name));
            } else if ("MAX".equals(object)) {
                column = functions$.MODULE$.max(functions$.MODULE$.col(name));
            } else if ("MIN".equals(object)) {
                column = functions$.MODULE$.min(functions$.MODULE$.col(name));
            } else {
                throw new IllegalArgumentException("Unsupported metric in TableSampling ");
            }
            return column;
        }, Seq$.MODULE$.canBuildFrom()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Column.class))))).toList();
    }

    public static final /* synthetic */ void $anonfun$calculateViewMetasIfNeeded$1(TableAnalysisJob $this, Table sparkTable$1, String t) {
        ObjectRef oriTable = ObjectRef.create((Object)t);
        if (!t.contains(".")) {
            oriTable.elem = new StringBuilder(1).append(sparkTable$1.database()).append(".").append(t).toString();
        }
        long rowCnt = $this.ss.table((String)oriTable.elem).count();
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Table ").append((String)oriTable$1.elem).append(" true number of rows is ").append(rowCnt).toString());
        TableMetaManager$.MODULE$.putTableMeta(t, 0L, rowCnt);
    }

    public TableAnalysisJob(TableDesc tableDesc, String project, long rowCount, SparkSession ss, String jobId) {
        this.tableDesc = tableDesc;
        this.rowCount = rowCount;
        this.ss = ss;
        Logging.$init$((Logging)this);
        this.taskFactor = 4;
    }
}

