/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job.stage;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.kylin.engine.spark.job.stage.StageExec;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.spark.SparkConf;
import org.apache.spark.application.NoRetryException;
import org.apache.spark.internal.Logging;
import org.apache.spark.utils.ResourceUtils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001=4Aa\u0004\t\u0001?!A!\u0006\u0001B\u0001B\u0003%1\u0006C\u00032\u0001\u0011\u0005!\u0007C\u00036\u0001\u0011\u0005c\u0007C\u00038\u0001\u0011\u0005\u0003\bC\u0003D\u0001\u0011\u0005C\tC\u0003Q\u0001\u0011\u0005C\tC\u0004R\u0001\t\u0007I\u0011\u0002*\t\re\u0003\u0001\u0015!\u0003T\u0011\u001dQ\u0006A1A\u0005\nmCa\u0001\u0019\u0001!\u0002\u0013a\u0006bB1\u0001\u0005\u0004%IA\u0019\u0005\u0007Q\u0002\u0001\u000b\u0011B2\t\u000b%\u0004A\u0011\t6\t\u000b9\u0004A\u0011\t#\u0003!]\u000b\u0017\u000e^3G_J\u0014Vm]8ve\u000e,'BA\t\u0013\u0003\u0015\u0019H/Y4f\u0015\t\u0019B#A\u0002k_\nT!!\u0006\f\u0002\u000bM\u0004\u0018M]6\u000b\u0005]A\u0012AB3oO&tWM\u0003\u0002\u001a5\u0005)1.\u001f7j]*\u00111\u0004H\u0001\u0007CB\f7\r[3\u000b\u0003u\t1a\u001c:h\u0007\u0001\u00192\u0001\u0001\u0011'!\t\tC%D\u0001#\u0015\u0005\u0019\u0013!B:dC2\f\u0017BA\u0013#\u0005\u0019\te.\u001f*fMB\u0011q\u0005K\u0007\u0002!%\u0011\u0011\u0006\u0005\u0002\n'R\fw-Z#yK\u000e\f!B[8c\u0007>tG/\u001a=u!\tas&D\u0001.\u0015\tqC#A\u0006baBd\u0017nY1uS>t\u0017B\u0001\u0019.\u0005A\u0019\u0006/\u0019:l\u0003B\u0004H.[2bi&|g.\u0001\u0004=S:LGO\u0010\u000b\u0003gQ\u0002\"a\n\u0001\t\u000b)\u0012\u0001\u0019A\u0016\u0002\u001b\u001d,GOS8c\u0007>tG/\u001a=u+\u0005Y\u0013AD4fi\u0012\u000bG/Y*fO6,g\u000e^\u000b\u0002sA\u0011!(Q\u0007\u0002w)\u0011A(P\u0001\u0006[>$W\r\u001c\u0006\u0003}}\nAaY;cK*\u0011\u0001\tG\u0001\t[\u0016$\u0018\rZ1uC&\u0011!i\u000f\u0002\r\u001d\u0012\u000bG/Y*fO6,g\u000e^\u0001\rO\u0016$8+Z4nK:$\u0018\nZ\u000b\u0002\u000bB\u0011a)\u0014\b\u0003\u000f.\u0003\"\u0001\u0013\u0012\u000e\u0003%S!A\u0013\u0010\u0002\rq\u0012xn\u001c;?\u0013\ta%%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u001d>\u0013aa\u0015;sS:<'B\u0001'#\u0003\u00159W\r^%e\u0003\u0019\u0019wN\u001c4jOV\t1\u000b\u0005\u0002U/6\tQK\u0003\u0002W1\u000511m\\7n_:L!\u0001W+\u0003\u0017-KH.\u001b8D_:4\u0017nZ\u0001\bG>tg-[4!\u0003!\u0011W/\u001b7e\u000b:4X#\u0001/\u0011\u0005usV\"\u0001\n\n\u0005}\u0013\"!D&zY&t')^5mI\u0016sg/A\u0005ck&dG-\u00128wA\u0005I1\u000f]1sW\u000e{gNZ\u000b\u0002GB\u0011AMZ\u0007\u0002K*\u0011QCG\u0005\u0003O\u0016\u0014\u0011b\u00159be.\u001cuN\u001c4\u0002\u0015M\u0004\u0018M]6D_:4\u0007%A\u0004fq\u0016\u001cW\u000f^3\u0015\u0003-\u0004\"!\t7\n\u00055\u0014#\u0001B+oSR\fAbZ3u'R\fw-\u001a(b[\u0016\u0004")
public class WaiteForResource
implements StageExec {
    private final SparkApplication jobContext;
    private final KylinConfig config;
    private final KylinBuildEnv buildEnv;
    private final SparkConf sparkConf;
    private String id;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public void onStageStart() {
        StageExec.onStageStart$(this);
    }

    @Override
    public void updateStageInfo(String taskId, String segmentId, String project, String status, String errMsg, HashMap<String, String> updateInfo) {
        StageExec.updateStageInfo$(this, taskId, segmentId, project, status, errMsg, updateInfo);
    }

    @Override
    public void onStageFinished(boolean result) {
        StageExec.onStageFinished$(this, result);
    }

    @Override
    public void onBuildLayoutSuccess(int layoutCount) {
        StageExec.onBuildLayoutSuccess$(this, layoutCount);
    }

    @Override
    public void onStageSkipped() {
        StageExec.onStageSkipped$(this);
    }

    @Override
    public void toWork() {
        StageExec.toWork$(this);
    }

    @Override
    public void toWorkWithoutFinally() {
        StageExec.toWorkWithoutFinally$(this);
    }

    @Override
    public void setId(String id) {
        StageExec.setId$(this, id);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void id_$eq(String x$1) {
        this.id = x$1;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public SparkApplication getJobContext() {
        return this.jobContext;
    }

    @Override
    public NDataSegment getDataSegment() {
        return null;
    }

    @Override
    public String getSegmentId() {
        return null;
    }

    @Override
    public String getId() {
        String jobStepId = StringUtils.replace((String)this.buildEnv().buildJobInfos().getJobStepId(), (String)"job_step_", (String)"");
        return new StringBuilder(3).append(jobStepId).append("_00").toString();
    }

    private KylinConfig config() {
        return this.config;
    }

    private KylinBuildEnv buildEnv() {
        return this.buildEnv;
    }

    private SparkConf sparkConf() {
        return this.sparkConf;
    }

    @Override
    public void execute() {
        block8: {
            Tuple3 tuple3;
            Tuple3 tuple32;
            if (!this.jobContext.isJobOnCluster(this.sparkConf())) break block8;
            long sleepSeconds = (long)(Math.random() * (double)60L);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Sleep ").append(sleepSeconds).append(" seconds to avoid submitting too many spark job at the same time.").toString());
            KylinBuildEnv$.MODULE$.get().buildJobInfos().startWait();
            Thread.sleep(sleepSeconds * 1000L);
            boolean checkEnabled = this.config().getCheckResourceEnabled();
            if (checkEnabled) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(46).append("CheckResource timeout limit was set: ").append(this.config().getCheckResourceTimeLimit()).append(" minutes.").toString());
                tuple32 = new Tuple3((Object)BoxesRunTime.boxToLong((long)TimeUnit.NANOSECONDS.convert(this.config().getCheckResourceTimeLimit(), TimeUnit.MINUTES)), (Object)BoxesRunTime.boxToLong((long)System.nanoTime()), (Object)BoxesRunTime.boxToLong((long)0L));
            } else {
                tuple32 = tuple3 = new Tuple3((Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToLong((long)-1L), (Object)BoxesRunTime.boxToLong((long)-1L));
            }
            if (tuple3 == null) {
                throw new MatchError((Object)tuple3);
            }
            long timeoutLimitNs = BoxesRunTime.unboxToLong((Object)tuple3._1());
            long startTime = BoxesRunTime.unboxToLong((Object)tuple3._2());
            long timeTaken = BoxesRunTime.unboxToLong((Object)tuple3._3());
            long l = timeoutLimitNs;
            long l2 = startTime;
            long l3 = timeTaken;
            Tuple3 tuple33 = new Tuple3((Object)BoxesRunTime.boxToLong((long)l), (Object)BoxesRunTime.boxToLong((long)l2), (Object)BoxesRunTime.boxToLong((long)l3));
            Tuple3 tuple34 = tuple33;
            long timeoutLimitNs2 = BoxesRunTime.unboxToLong((Object)tuple34._1());
            long startTime2 = BoxesRunTime.unboxToLong((Object)tuple34._2());
            long timeTaken2 = BoxesRunTime.unboxToLong((Object)tuple34._3());
            try {
                while (!ResourceUtils$.MODULE$.checkResource(this.sparkConf(), this.buildEnv().clusterManager(), this.config().isSkipResourceCheck())) {
                    if (checkEnabled && (timeTaken2 = System.nanoTime()) - startTime2 > timeoutLimitNs2) {
                        long timeout = TimeUnit.MINUTES.convert(timeTaken2 - startTime2, TimeUnit.NANOSECONDS);
                        throw new NoRetryException(new StringBuilder(45).append("CheckResource exceed timeout limit: ").append(timeout).append(" minutes.").toString());
                    }
                    long waitTime = (long)(Math.random() * (double)10 * (double)60);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(71).append("Current available resource in cluster is not sufficient, wait ").append(waitTime).append(" seconds.").toString());
                    Thread.sleep(waitTime * 1000L);
                }
            }
            catch (NoRetryException e) {
                throw e;
            }
            catch (Exception e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error occurred when check resource. Ignore it and try to submit this job.", e);
            }
            KylinBuildEnv$.MODULE$.get().buildJobInfos().endWait();
        }
    }

    @Override
    public String getStageName() {
        return "WaiteForResource";
    }

    public WaiteForResource(SparkApplication jobContext) {
        this.jobContext = jobContext;
        Logging.$init$((Logging)this);
        StageExec.$init$(this);
        this.config = jobContext.getConfig();
        this.buildEnv = KylinBuildEnv$.MODULE$.getOrCreate(this.config());
        this.sparkConf = this.buildEnv().sparkConf();
    }
}

