/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job.stage.build.partition;

import java.io.Serializable;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.engine.spark.builder.DictionaryBuilderHelper;
import org.apache.kylin.engine.spark.builder.PartitionDictionaryBuilderHelper;
import org.apache.kylin.engine.spark.job.PartitionExec;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.engine.spark.job.stage.BuildParam;
import org.apache.kylin.engine.spark.job.stage.build.FlatTableAndDictBase;
import org.apache.kylin.engine.spark.model.PartitionFlatTableDesc;
import org.apache.kylin.metadata.cube.cuboid.PartitionSpanningTree;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.SegmentPartition;
import org.apache.kylin.metadata.job.JobBucket;
import org.apache.kylin.metadata.model.MultiPartitionDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.datasource.storage.StorageListener;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.GenIterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001dd!\u0002\t\u0012\u0003\u0003!\u0003\u0002C\u0017\u0001\u0005\u000b\u0007I\u0011\u0002\u0018\t\u0011I\u0002!\u0011!Q\u0001\n=B\u0001b\r\u0001\u0003\u0006\u0004%I\u0001\u000e\u0005\t\u007f\u0001\u0011\t\u0011)A\u0005k!A\u0001\t\u0001BC\u0002\u0013%\u0011\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003C\u0011\u00159\u0005\u0001\"\u0001I\u0011\u001dq\u0005A1A\u0005\u0016=Ca!\u0018\u0001!\u0002\u001b\u0001\u0006\u0002\u00030\u0001\u0011\u000b\u0007I\u0011K0\t\u0011\u0019\u0004\u0001R1A\u0005R\u001dDQ!\u001c\u0001\u0005R9DQa\u001f\u0001\u0005\u0002qDq!!\u0010\u0001\t\u0003\ty\u0004C\u0004\u0002D\u0001!\t%!\u0012\u0003;A\u000b'\u000f^5uS>tg\t\\1u)\u0006\u0014G.Z!oI\u0012K7\r\u001e\"bg\u0016T!AE\n\u0002\u0013A\f'\u000f^5uS>t'B\u0001\u000b\u0016\u0003\u0015\u0011W/\u001b7e\u0015\t1r#A\u0003ti\u0006<WM\u0003\u0002\u00193\u0005\u0019!n\u001c2\u000b\u0005iY\u0012!B:qCJ\\'B\u0001\u000f\u001e\u0003\u0019)gnZ5oK*\u0011adH\u0001\u0006Wfd\u0017N\u001c\u0006\u0003A\u0005\na!\u00199bG\",'\"\u0001\u0012\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001)\u0013\u0006\u0005\u0002'O5\t1#\u0003\u0002)'\t!b\t\\1u)\u0006\u0014G.Z!oI\u0012K7\r\u001e\"bg\u0016\u0004\"AK\u0016\u000e\u0003]I!\u0001L\f\u0003\u001bA\u000b'\u000f^5uS>tW\t_3d\u0003)QwNY\"p]R,\u0007\u0010^\u000b\u0002_A\u0011!\u0006M\u0005\u0003c]\u0011!bU3h[\u0016tGOS8c\u0003-QwNY\"p]R,\u0007\u0010\u001e\u0011\u0002\u0017\u0011\fG/Y*fO6,g\u000e^\u000b\u0002kA\u0011a'P\u0007\u0002o)\u0011\u0001(O\u0001\u0006[>$W\r\u001c\u0006\u0003um\nAaY;cK*\u0011A(H\u0001\t[\u0016$\u0018\rZ1uC&\u0011ah\u000e\u0002\r\u001d\u0012\u000bG/Y*fO6,g\u000e^\u0001\rI\u0006$\u0018mU3h[\u0016tG\u000fI\u0001\u000bEVLG\u000e\u001a)be\u0006lW#\u0001\"\u0011\u0005\r#U\"A\u000b\n\u0005\u0015+\"A\u0003\"vS2$\u0007+\u0019:b[\u0006Y!-^5mIB\u000b'/Y7!\u0003\u0019a\u0014N\\5u}Q!\u0011j\u0013'N!\tQ\u0005!D\u0001\u0012\u0011\u0015is\u00011\u00010\u0011\u0015\u0019t\u00011\u00016\u0011\u0015\u0001u\u00011\u0001C\u0003)qWm\u001e\"vG.,Go]\u000b\u0002!B\u0019\u0011K\u0016-\u000e\u0003IS!a\u0015+\u0002\u0015\r|G\u000e\\3di&|gNC\u0001V\u0003\u0015\u00198-\u00197b\u0013\t9&KA\u0002TKF\u0004\"!W.\u000e\u0003iS!\u0001G\u001e\n\u0005qS&!\u0003&pE\n+8m[3u\u0003-qWm\u001e\"vG.,Go\u001d\u0011\u0002\u0019M\u0004\u0018M\u001c8j]\u001e$&/Z3\u0016\u0003\u0001\u0004\"!\u00193\u000e\u0003\tT!aY\u001d\u0002\r\r,(m\\5e\u0013\t)'MA\u000bQCJ$\u0018\u000e^5p]N\u0003\u0018M\u001c8j]\u001e$&/Z3\u0002\u0013Q\f'\r\\3EKN\u001cW#\u00015\u0011\u0005%\\W\"\u00016\u000b\u0005aJ\u0012B\u00017k\u0005Y\u0001\u0016M\u001d;ji&|gN\u00127biR\u000b'\r\\3EKN\u001c\u0017AE1qa2L\b+\u0019:uSRLwN\u001c#fg\u000e$\"a\\=\u0011\u0007A$h/D\u0001r\u0015\t\u00118/A\u0002tc2T!AG\u0010\n\u0005U\f(a\u0002#bi\u0006\u001cX\r\u001e\t\u0003a^L!\u0001_9\u0003\u0007I{w\u000fC\u0003{\u0019\u0001\u0007q.\u0001\u0005pe&<\u0017N\u001c#T\u0003e9\u0017\r\u001e5feB\u000b'\u000f^5uS>t7\u000b^1uSN$\u0018nY:\u0015\u000bu\fy#!\u000f\u0011\u0007y\fICD\u0002\u0000\u0003KqA!!\u0001\u0002$9!\u00111AA\u0011\u001d\u0011\t)!a\b\u000f\t\u0005\u001d\u0011Q\u0004\b\u0005\u0003\u0013\tYB\u0004\u0003\u0002\f\u0005ea\u0002BA\u0007\u0003/qA!a\u0004\u0002\u00165\u0011\u0011\u0011\u0003\u0006\u0004\u0003'\u0019\u0013A\u0002\u001fs_>$h(C\u0001#\u0013\t\u0001\u0013%\u0003\u0002\u001f?%\u0011A$H\u0005\u00035mI!\u0001G\r\n\u0005Y9\u0012B\u0001\u000b\u0016\u0013\r\t9cE\u0001\u0015\r2\fG\u000fV1cY\u0016\fe\u000e\u001a#jGR\u0014\u0015m]3\n\t\u0005-\u0012Q\u0006\u0002\u000b'R\fG/[:uS\u000e\u001c(bAA\u0014'!1!#\u0004a\u0001\u0003c\u0001B!a\r\u000265\tA+C\u0002\u00028Q\u0013A\u0001T8oO\"1\u00111H\u0007A\u0002=\fq\u0001^1cY\u0016$5+\u0001\bhKR\u0004\u0016M\u001d;ji&|g\u000eR*\u0015\u0007=\f\t\u0005\u0003\u0004\u0013\u001d\u0001\u0007\u0011\u0011G\u0001\u000faJ,\u0007/\u0019:f\r>\u0014H)[2u)\t\t9\u0005\u0005\u0007\u00024\u0005%\u0013QJA'\u0003\u001b\ni%C\u0002\u0002LQ\u0013a\u0001V;qY\u0016$\u0004CBA(\u0003/\niF\u0004\u0003\u0002R\u0005M\u0003cAA\b)&\u0019\u0011Q\u000b+\u0002\rA\u0013X\rZ3g\u0013\u0011\tI&a\u0017\u0003\u0007M+GOC\u0002\u0002VQ\u0003B!a\u0018\u0002d5\u0011\u0011\u0011\r\u0006\u0003qmJA!!\u001a\u0002b\tIAK\u00197D_2\u0014VM\u001a")
public abstract class PartitionFlatTableAndDictBase
extends FlatTableAndDictBase
implements PartitionExec {
    private PartitionSpanningTree spanningTree;
    private PartitionFlatTableDesc tableDesc;
    private final SegmentJob jobContext;
    private final NDataSegment dataSegment;
    private final BuildParam buildParam;
    private final Seq<JobBucket> newBuckets;
    private List<Long> partitions;
    private Set<Integer> partitionColumns;
    private volatile byte bitmap$0;

    @Override
    public final void newLayoutPartition(NDataSegment dataSegment, LayoutEntity layout, Long partitionId, Dataset<Row> layoutDS, String readableDesc, Option<StorageListener> storageListener) {
        PartitionExec.newLayoutPartition$(this, dataSegment, layout, partitionId, layoutDS, readableDesc, storageListener);
    }

    @Override
    public Set<Integer> wrapDimensions(LayoutEntity layout) {
        return PartitionExec.wrapDimensions$(this, layout);
    }

    @Override
    public void drain(long timeout, TimeUnit unit) {
        PartitionExec.drain$(this, timeout, unit);
    }

    @Override
    public long drain$default$1() {
        return PartitionExec.drain$default$1$(this);
    }

    @Override
    public TimeUnit drain$default$2() {
        return PartitionExec.drain$default$2$(this);
    }

    @Override
    public final SegmentPartition newSegmentPartition(NDataSegment copiedSegment, long partitionId, List<SegmentPartition> newAdds) {
        return PartitionExec.newSegmentPartition$(this, copiedSegment, partitionId, newAdds);
    }

    @Override
    public final void mergeSegmentStatistics(NDataSegment copiedSegment) {
        PartitionExec.mergeSegmentStatistics$(this, copiedSegment);
    }

    private List<Long> partitions$lzycompute() {
        PartitionFlatTableAndDictBase partitionFlatTableAndDictBase = this;
        synchronized (partitionFlatTableAndDictBase) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.partitions = PartitionExec.partitions$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.partitions;
    }

    @Override
    public final List<Long> partitions() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.partitions$lzycompute() : this.partitions;
    }

    private Set<Integer> partitionColumns$lzycompute() {
        PartitionFlatTableAndDictBase partitionFlatTableAndDictBase = this;
        synchronized (partitionFlatTableAndDictBase) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.partitionColumns = PartitionExec.partitionColumns$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.partitionColumns;
    }

    @Override
    public final Set<Integer> partitionColumns() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.partitionColumns$lzycompute() : this.partitionColumns;
    }

    private SegmentJob jobContext() {
        return this.jobContext;
    }

    private NDataSegment dataSegment() {
        return this.dataSegment;
    }

    private BuildParam buildParam() {
        return this.buildParam;
    }

    @Override
    public final Seq<JobBucket> newBuckets() {
        return this.newBuckets;
    }

    private PartitionSpanningTree spanningTree$lzycompute() {
        PartitionFlatTableAndDictBase partitionFlatTableAndDictBase = this;
        synchronized (partitionFlatTableAndDictBase) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.spanningTree = this.buildParam().getPartitionSpanningTree();
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.spanningTree;
    }

    public PartitionSpanningTree spanningTree() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.spanningTree$lzycompute() : this.spanningTree;
    }

    private PartitionFlatTableDesc tableDesc$lzycompute() {
        PartitionFlatTableAndDictBase partitionFlatTableAndDictBase = this;
        synchronized (partitionFlatTableAndDictBase) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.tableDesc = this.buildParam().getTableDesc();
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.tableDesc;
    }

    @Override
    public PartitionFlatTableDesc tableDesc() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.tableDesc$lzycompute() : this.tableDesc;
    }

    @Override
    public Dataset<Row> applyPartitionDesc(Dataset<Row> originDS) {
        MultiPartitionDesc descMLP = this.dataModel().getMultiPartitionDesc();
        Predef$.MODULE$.require(Objects.nonNull(descMLP));
        PartitionDesc descDRP = this.dataModel().getPartitionDesc();
        String condition = descMLP.getPartitionConditionBuilder().buildMultiPartitionCondition(descDRP, descMLP, new LinkedList<Long>(this.tableDesc().getPartitions()), null, this.segmentRange());
        if (StringUtils.isBlank((CharSequence)condition)) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(42).append("Segment ").append(this.segmentId()).append(" no available partition condition.").toString());
            return originDS;
        }
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Segment ").append(this.segmentId()).append(" apply partition condition ").append(condition).append(".").toString());
        return originDS.where(condition);
    }

    public FlatTableAndDictBase.Statistics gatherPartitionStatistics(long partition, Dataset<Row> tableDS) {
        String desc = new StringBuilder(49).append("Segment ").append(this.segmentId()).append(" collect partition flat table statistics ").append(partition).toString();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> desc);
        this.sparkSession().sparkContext().setJobDescription(desc);
        FlatTableAndDictBase.Statistics statistics = this.gatherStatistics(tableDS);
        this.sparkSession().sparkContext().setJobDescription(null);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(1).append(desc).append(" ").append(statistics).toString());
        return statistics;
    }

    public Dataset<Row> getPartitionDS(long partition) {
        Buffer columnIds = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableDesc().getColumnIds()).asScala();
        Buffer columnName2Id = (Buffer)((IterableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.tableDesc().getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)column -> column.getIdentity(), Buffer$.MODULE$.canBuildFrom())).zip((GenIterable)columnIds, Buffer$.MODULE$.canBuildFrom());
        Map column2IdMap = columnName2Id.toMap(Predef$.MODULE$.$conforms());
        Buffer partitionColumnIds = (Buffer)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)this.dataModel().getMultiPartitionDesc().getColumnRefs()).asScala()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getIdentity(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x -> (Integer)column2IdMap.apply(x), Buffer$.MODULE$.canBuildFrom());
        Seq values = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.dataModel().getMultiPartitionDesc().getPartitionInfo(partition).getValues())).toSeq();
        String converted = ((TraversableOnce)((TraversableLike)partitionColumnIds.zip((GenIterable)values, Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Integer k = (Integer)tuple2._1();
            String v = (String)tuple2._2();
            String string = new StringBuilder(7).append("`").append(k).append("` = '").append(v).append("'").toString();
            return string;
        }, Buffer$.MODULE$.canBuildFrom())).mkString(" and ");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Segment ").append(this.segmentId()).append(" single partition condition: ").append(converted).toString());
        return this.FLAT_TABLE().where(converted);
    }

    @Override
    public Tuple4<scala.collection.immutable.Set<TblColRef>, scala.collection.immutable.Set<TblColRef>, scala.collection.immutable.Set<TblColRef>, scala.collection.immutable.Set<TblColRef>> prepareForDict() {
        scala.collection.immutable.Set dictCols = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(PartitionDictionaryBuilderHelper.extractTreeRelatedGlobalDictToBuild(this.dataSegment(), this.spanningTree().getIndices())).asScala()).toSet();
        scala.collection.immutable.Set encodeCols = ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(DictionaryBuilderHelper.extractTreeRelatedGlobalDicts(this.dataSegment(), this.spanningTree().getIndices())).asScala()).toSet();
        scala.collection.immutable.Set dictColsWithoutCc = (scala.collection.immutable.Set)dictCols.filter((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)PartitionFlatTableAndDictBase.$anonfun$prepareForDict$1(x$3)));
        scala.collection.immutable.Set encodeColsWithoutCc = (scala.collection.immutable.Set)encodeCols.filter((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)PartitionFlatTableAndDictBase.$anonfun$prepareForDict$2(x$4)));
        return new Tuple4((Object)dictCols, (Object)encodeCols, (Object)dictColsWithoutCc, (Object)encodeColsWithoutCc);
    }

    public static final /* synthetic */ boolean $anonfun$newBuckets$1(PartitionFlatTableAndDictBase $this, JobBucket x$1) {
        return x$1.getSegmentId().equals($this.segmentId());
    }

    public static final /* synthetic */ boolean $anonfun$prepareForDict$1(TblColRef x$3) {
        return !x$3.getColumnDesc().isComputedColumn();
    }

    public static final /* synthetic */ boolean $anonfun$prepareForDict$2(TblColRef x$4) {
        return !x$4.getColumnDesc().isComputedColumn();
    }

    public PartitionFlatTableAndDictBase(SegmentJob jobContext, NDataSegment dataSegment, BuildParam buildParam) {
        this.jobContext = jobContext;
        this.dataSegment = dataSegment;
        this.buildParam = buildParam;
        super(jobContext, dataSegment, buildParam);
        PartitionExec.$init$(this);
        this.newBuckets = ((SetLike)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(jobContext.getReadOnlyBuckets()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)PartitionFlatTableAndDictBase.$anonfun$newBuckets$1(this, x$1)))).toSeq();
    }
}

