/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job.stage.merge;

import com.google.common.collect.BiMap;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.SegmentExec;
import org.apache.kylin.engine.spark.job.SegmentJob;
import org.apache.kylin.engine.spark.job.stage.StageExec;
import org.apache.kylin.engine.spark.job.stage.merge.MergeStage$;
import org.apache.kylin.engine.spark.job.stage.merge.MergeStage$LayoutMergeTask$;
import org.apache.kylin.engine.spark.model.SegmentFlatTableDesc;
import org.apache.kylin.engine.spark.scheduler.JobRuntime;
import org.apache.kylin.metadata.cube.model.DimensionRangeInfo;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.sourceusage.SourceUsageManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.datasource.storage.StorageListener;
import org.apache.spark.sql.datasource.storage.StorageStoreUtils$;
import org.apache.spark.sql.datasource.storage.WriteTaskStats;
import org.apache.spark.tracker.BuildContext;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map$;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.SetLike;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\r\u0005c!B!C\u0003\u0003\u0019\u0006\u0002\u00032\u0001\u0005\u000b\u0007I\u0011B2\t\u0011\u001d\u0004!\u0011!Q\u0001\n\u0011D\u0001\u0002\u001b\u0001\u0003\u0006\u0004%I!\u001b\u0005\ti\u0002\u0011\t\u0011)A\u0005U\")Q\u000f\u0001C\u0001m\")1\u0010\u0001C!y\"1\u0011q\u0001\u0001\u0005B%Dq!!\u0003\u0001\t\u0003\nY\u0001C\u0005\u0002$\u0001\u0011\r\u0011\"\u0006\u0002&!A\u0011Q\u0007\u0001!\u0002\u001b\t9\u0003C\u0005\u00028\u0001\u0011\r\u0011\"\u0006\u0002:!A\u0011q\t\u0001!\u0002\u001b\tY\u0004C\u0005\u0002J\u0001\u0011\r\u0011\"\u0006\u0002&!A\u00111\n\u0001!\u0002\u001b\t9\u0003C\u0005\u0002N\u0001\u0011\r\u0011\"\u0006\u0002P!A\u0011q\f\u0001!\u0002\u001b\t\t\u0006C\u0005\u0002b\u0001\u0011\r\u0011\"\u0006\u0002d!A\u0011\u0011\u000f\u0001!\u0002\u001b\t)\u0007C\u0005\u0002t\u0001\u0011\r\u0011\"\u0006\u0002v!A\u00111\u0011\u0001!\u0002\u001b\t9\bC\u0005\u0002\u0006\u0002\u0011\r\u0011\"\u0006\u0002&!A\u0011q\u0011\u0001!\u0002\u001b\t9\u0003C\u0005\u0002\n\u0002\u0011\r\u0011\"\u0006\u0002&!A\u00111\u0012\u0001!\u0002\u001b\t9\u0003C\u0005\u0002\u000e\u0002\u0011\r\u0011\"\u0006\u0002\u0010\"A\u00111\u0014\u0001!\u0002\u001b\t\t\nC\u0005\u0002\u001e\u0002\u0011\r\u0011\"\u0006\u0002 \"A\u0011q\u0015\u0001!\u0002\u001b\t\t\u000bC\u0005\u0002*\u0002\u0011\r\u0011\"\u0006\u0002,\"A\u0011Q\u0018\u0001!\u0002\u001b\tiK\u0002\u0004\u0002@\u0002A\u0015\u0011\u0019\u0005\u000b\u0003/|\"Q3A\u0005\u0002\u0005e\u0007BCAz?\tE\t\u0015!\u0003\u0002\\\"1Qo\bC\u0001\u0003kDq!a? \t\u0003\nY\u0001C\u0005\u0002~~\t\t\u0011\"\u0001\u0002\u0000\"I!1A\u0010\u0012\u0002\u0013\u0005!Q\u0001\u0005\n\u00057y\u0012\u0011!C!\u0003KA\u0011B!\b \u0003\u0003%\t!a(\t\u0013\t}q$!A\u0005\u0002\t\u0005\u0002\"\u0003B\u0017?\u0005\u0005I\u0011\tB\u0018\u0011%\u0011IdHA\u0001\n\u0003\u0011Y\u0004C\u0005\u0003F}\t\t\u0011\"\u0011\u0003H!I!\u0011J\u0010\u0002\u0002\u0013\u0005#1\n\u0005\n\u0005\u001bz\u0012\u0011!C!\u0005\u001f:\u0011Ba\u0015\u0001\u0003\u0003E\tB!\u0016\u0007\u0013\u0005}\u0006!!A\t\u0012\t]\u0003BB;0\t\u0003\u0011\u0019\u0007C\u0005\u0003J=\n\t\u0011\"\u0012\u0003L!I!QM\u0018\u0002\u0002\u0013\u0005%q\r\u0005\n\u0005Wz\u0013\u0011!CA\u0005[BqA!\u001f\u0001\t#\u0011Y\bC\u0004\u0003\u0004\u0002!\tF!\"\t\u000f\t-\u0005\u0001\"\u0003\u0003\u000e\"9!1\u0013\u0001\u0005\n\tU\u0005b\u0002BW\u0001\u0011%!q\u0016\u0005\b\u0005\u007f\u0003A\u0011\u000bBa\u0011%\u0011y\u0010\u0001b\u0001\n#\tY\u0001\u0003\u0005\u0004\u0002\u0001\u0001\u000b\u0011BA\u0007\u0011\u001d\u0019\u0019\u0001\u0001C)\u0007\u000bAqa!\u0005\u0001\t#\u0011Y\bC\u0004\u0004\u0014\u0001!\tb!\u0006\t\u000f\r%\u0002\u0001\"\u0003\u0004,!91q\b\u0001\u0005\u0012\tm$AC'fe\u001e,7\u000b^1hK*\u00111\tR\u0001\u0006[\u0016\u0014x-\u001a\u0006\u0003\u000b\u001a\u000bQa\u001d;bO\u0016T!a\u0012%\u0002\u0007)|'M\u0003\u0002J\u0015\u0006)1\u000f]1sW*\u00111\nT\u0001\u0007K:<\u0017N\\3\u000b\u00055s\u0015!B6zY&t'BA(Q\u0003\u0019\t\u0007/Y2iK*\t\u0011+A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001)js\u0006CA+Y\u001b\u00051&\"A,\u0002\u000bM\u001c\u0017\r\\1\n\u0005e3&AB!osJ+g\r\u0005\u0002\\96\ta)\u0003\u0002^\r\nY1+Z4nK:$X\t_3d!\ty\u0006-D\u0001E\u0013\t\tGIA\u0005Ti\u0006<W-\u0012=fG\u0006Q!n\u001c2D_:$X\r\u001f;\u0016\u0003\u0011\u0004\"aW3\n\u0005\u00194%AC*fO6,g\u000e\u001e&pE\u0006Y!n\u001c2D_:$X\r\u001f;!\u0003-!\u0017\r^1TK\u001elWM\u001c;\u0016\u0003)\u0004\"a\u001b:\u000e\u00031T!!\u001c8\u0002\u000b5|G-\u001a7\u000b\u0005=\u0004\u0018\u0001B2vE\u0016T!!\u001d'\u0002\u00115,G/\u00193bi\u0006L!a\u001d7\u0003\u00199#\u0015\r^1TK\u001elWM\u001c;\u0002\u0019\u0011\fG/Y*fO6,g\u000e\u001e\u0011\u0002\rqJg.\u001b;?)\r9\u0018P\u001f\t\u0003q\u0002i\u0011A\u0011\u0005\u0006E\u0016\u0001\r\u0001\u001a\u0005\u0006Q\u0016\u0001\rA[\u0001\u000eO\u0016$(j\u001c2D_:$X\r\u001f;\u0016\u0003u\u00042A`A\u0002\u001b\u0005y(bAA\u0001\u0011\u0006Y\u0011\r\u001d9mS\u000e\fG/[8o\u0013\r\t)a \u0002\u0011'B\f'o[!qa2L7-\u0019;j_:\fabZ3u\t\u0006$\u0018mU3h[\u0016tG/\u0001\u0007hKR\u001cVmZ7f]RLE-\u0006\u0002\u0002\u000eA!\u0011qBA\u000f\u001d\u0011\t\t\"!\u0007\u0011\u0007\u0005Ma+\u0004\u0002\u0002\u0016)\u0019\u0011q\u0003*\u0002\rq\u0012xn\u001c;?\u0013\r\tYBV\u0001\u0007!J,G-\u001a4\n\t\u0005}\u0011\u0011\u0005\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005ma+A\u0003k_\nLE-\u0006\u0002\u0002(A!\u0011\u0011FA\u001a\u001b\t\tYC\u0003\u0003\u0002.\u0005=\u0012\u0001\u00027b]\u001eT!!!\r\u0002\t)\fg/Y\u0005\u0005\u0003?\tY#\u0001\u0004k_\nLE\rI\u0001\u0007G>tg-[4\u0016\u0005\u0005m\u0002\u0003BA\u001f\u0003\u0007j!!a\u0010\u000b\u0007\u0005\u0005C*\u0001\u0004d_6lwN\\\u0005\u0005\u0003\u000b\nyDA\u0006Ls2LgnQ8oM&<\u0017aB2p]\u001aLw\rI\u0001\u000bI\u0006$\u0018M\u001a7po&#\u0017a\u00033bi\u00064Gn\\<JI\u0002\nAb\u001d9be.\u001cVm]:j_:,\"!!\u0015\u0011\t\u0005M\u00131L\u0007\u0003\u0003+RA!a\u0016\u0002Z\u0005\u00191/\u001d7\u000b\u0005%s\u0015\u0002BA/\u0003+\u0012Ab\u00159be.\u001cVm]:j_:\fQb\u001d9be.\u001cVm]:j_:\u0004\u0013a\u0004:fg>,(oY3D_:$X\r\u001f;\u0016\u0005\u0005\u0015\u0004\u0003BA4\u0003[j!!!\u001b\u000b\t\u0005-\u0014\u0011L\u0001\biJ\f7m[3s\u0013\u0011\ty'!\u001b\u0003\u0019\t+\u0018\u000e\u001c3D_:$X\r\u001f;\u0002!I,7o\\;sG\u0016\u001cuN\u001c;fqR\u0004\u0013a\u0002:v]RLW.Z\u000b\u0003\u0003o\u0002B!!\u001f\u0002\u00005\u0011\u00111\u0010\u0006\u0004\u0003{B\u0015!C:dQ\u0016$W\u000f\\3s\u0013\u0011\t\t)a\u001f\u0003\u0015){'MU;oi&lW-\u0001\u0005sk:$\u0018.\\3!\u0003\u001d\u0001(o\u001c6fGR\f\u0001\u0002\u001d:pU\u0016\u001cG\u000fI\u0001\ng\u0016<W.\u001a8u\u0013\u0012\f!b]3h[\u0016tG/\u00133!\u0003%!\u0017\r^1N_\u0012,G.\u0006\u0002\u0002\u0012B!\u00111SAL\u001b\t\t)J\u0003\u0002na&!\u0011\u0011TAK\u0005)qE)\u0019;b\u001b>$W\r\\\u0001\u000bI\u0006$\u0018-T8eK2\u0004\u0013aC:u_J\fw-\u001a+za\u0016,\"!!)\u0011\u0007U\u000b\u0019+C\u0002\u0002&Z\u00131!\u00138u\u00031\u0019Ho\u001c:bO\u0016$\u0016\u0010]3!\u0003!)h.\\3sO\u0016$WCAAW!\u0015\ty+!/k\u001b\t\t\tL\u0003\u0003\u00024\u0006U\u0016aB7vi\u0006\u0014G.\u001a\u0006\u0004\u0003o3\u0016AC2pY2,7\r^5p]&!\u00111XAY\u0005\u0019\u0011UO\u001a4fe\u0006IQO\\7fe\u001e,G\r\t\u0002\u0010\u0019\u0006Lx.\u001e;NKJ<W\rV1tWNAq\u0004VAb\u0003\u0017\f\t\u000e\u0005\u0003\u0002F\u0006\u001dW\"\u0001\u0001\n\u0007\u0005%GL\u0001\u0003UCN\\\u0007cA+\u0002N&\u0019\u0011q\u001a,\u0003\u000fA\u0013x\u000eZ;diB\u0019Q+a5\n\u0007\u0005UgK\u0001\u0007TKJL\u0017\r\\5{C\ndW-A\u0004he>,\b/\u001a3\u0016\u0005\u0005m\u0007CBAo\u0003O\fiO\u0004\u0003\u0002`\u0006\rh\u0002BA\n\u0003CL\u0011aV\u0005\u0004\u0003K4\u0016a\u00029bG.\fw-Z\u0005\u0005\u0003S\fYOA\u0002TKFT1!!:W!\rY\u0017q^\u0005\u0004\u0003cd'a\u0003(ECR\fG*Y=pkR\f\u0001b\u001a:pkB,G\r\t\u000b\u0005\u0003o\fI\u0010E\u0002\u0002F~Aq!a6#\u0001\u0004\tY.A\u0006hKR$\u0016m]6EKN\u001c\u0017\u0001B2paf$B!a>\u0003\u0002!I\u0011q\u001b\u0013\u0011\u0002\u0003\u0007\u00111\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00132+\t\u00119A\u000b\u0003\u0002\\\n%1F\u0001B\u0006!\u0011\u0011iAa\u0006\u000e\u0005\t=!\u0002\u0002B\t\u0005'\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tUa+\u0001\u0006b]:|G/\u0019;j_:LAA!\u0007\u0003\u0010\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u00039\u0001(o\u001c3vGR,E.Z7f]R$BAa\t\u0003*A\u0019QK!\n\n\u0007\t\u001dbKA\u0002B]fD\u0011Ba\u000b)\u0003\u0003\u0005\r!!)\u0002\u0007a$\u0013'A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011\t\u0004\u0005\u0004\u00034\tU\"1E\u0007\u0003\u0003kKAAa\u000e\u00026\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\u0011\u0011iDa\u0011\u0011\u0007U\u0013y$C\u0002\u0003BY\u0013qAQ8pY\u0016\fg\u000eC\u0005\u0003,)\n\t\u00111\u0001\u0003$\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u0002\"\u0006AAo\\*ue&tw\r\u0006\u0002\u0002(\u00051Q-];bYN$BA!\u0010\u0003R!I!1F\u0017\u0002\u0002\u0003\u0007!1E\u0001\u0010\u0019\u0006Lx.\u001e;NKJ<W\rV1tWB\u0019\u0011QY\u0018\u0014\u000b=\u0012I&!5\u0011\u0011\tm#qLAn\u0003ol!A!\u0018\u000b\u0007\u0005Md+\u0003\u0003\u0003b\tu#!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8ocQ\u0011!QK\u0001\u0006CB\u0004H.\u001f\u000b\u0005\u0003o\u0014I\u0007C\u0004\u0002XJ\u0002\r!a7\u0002\u000fUt\u0017\r\u001d9msR!!q\u000eB;!\u0015)&\u0011OAn\u0013\r\u0011\u0019H\u0016\u0002\u0007\u001fB$\u0018n\u001c8\t\u0013\t]4'!AA\u0002\u0005]\u0018a\u0001=%a\u0005aQ.\u001a:hK&sG-[2fgR\u0011!Q\u0010\t\u0004+\n}\u0014b\u0001BA-\n!QK\\5u\u00039\u0011XmY8sIR\u000b7o[%oM>$BA! \u0003\b\"9!\u0011R\u001bA\u0002\u0005\r\u0017!\u0001;\u0002\u00175,'oZ3MCf|W\u000f\u001e\u000b\u0005\u0005{\u0012y\tC\u0004\u0003\u0012Z\u0002\r!a>\u0002\tQ\f7o[\u0001\f]\u0016<XK\\5uK\u0012$5\u000b\u0006\u0003\u0003\u0018\n\r\u0006CBA*\u00053\u0013i*\u0003\u0003\u0003\u001c\u0006U#a\u0002#bi\u0006\u001cX\r\u001e\t\u0005\u0003'\u0012y*\u0003\u0003\u0003\"\u0006U#a\u0001*po\"9!QU\u001cA\u0002\t\u001d\u0016\u0001\u00037bs>,H/\u00133\u0011\t\u0005%\"\u0011V\u0005\u0005\u0005W\u000bYC\u0001\u0003M_:<\u0017aD7fe\u001e,G)\u0019;b\u0019\u0006Lx.\u001e;\u0015\r\tu$\u0011\u0017B^\u0011\u001d\u0011\u0019\f\u000fa\u0001\u0005k\u000ba\u0001\\1z_V$\bcA6\u00038&\u0019!\u0011\u00187\u0003\u00191\u000b\u0017p\\;u\u000b:$\u0018\u000e^=\t\u000f\tu\u0006\b1\u0001\u0003\u0018\u0006AQO\\5uK\u0012$5+\u0001\boK^\u001cv.\u001e:dKN#\u0018\r^:\u0015\r\t\r'\u0011\u001eBv!\u0011\u0011)Ma9\u000f\t\t\u001d'q\u001c\b\u0005\u0005\u0013\u0014iN\u0004\u0003\u0003L\nmg\u0002\u0002Bg\u00053tAAa4\u0003X:!!\u0011\u001bBk\u001d\u0011\t\u0019Ba5\n\u0003EK!a\u0014)\n\u00055s\u0015BA&M\u0013\tI%*\u0003\u0002H\u0011&\u0019!\u0011\u001d$\u0002\u0017M+w-\\3oi\u0016CXmY\u0005\u0005\u0005K\u00149OA\u0006T_V\u00148-Z*uCR\u001c(b\u0001Bq\r\"9!1W\u001dA\u0002\tU\u0006b\u0002Bws\u0001\u0007!q^\u0001\u0007_JLw-\u001b8\u0011\t\tE(1`\u0007\u0003\u0005gTAA!>\u0003x\u000691\u000f^8sC\u001e,'\u0002\u0002B}\u0003+\n!\u0002Z1uCN|WO]2f\u0013\u0011\u0011iPa=\u0003\u001d]\u0013\u0018\u000e^3UCN\\7\u000b^1ug\u0006\u00112\u000f]1sWN\u001b\u0007.\u001a3vY\u0016\u0014\bk\\8m\u0003M\u0019\b/\u0019:l'\u000eDW\rZ;mKJ\u0004vn\u001c7!\u00031\u0019w\u000e\\;n]&#g)\u001e8d)\u0011\tiaa\u0002\t\u000f\r%A\b1\u0001\u0004\f\u000511m\u001c7SK\u001a\u0004B!a%\u0004\u000e%!1qBAK\u0005%!&\r\\\"pYJ+g-\u0001\bnKJ<WM\u00127biR\u000b'\r\\3\u0002%\u001d,G/\u00168nKJ<W\r\u001a$U!\u0006$\bn]\u000b\u0003\u0007/\u0001b!!8\u0002h\u000ee\u0001\u0003BB\u000e\u0007Ki!a!\b\u000b\t\r}1\u0011E\u0001\u0003MNT1aa\tO\u0003\u0019A\u0017\rZ8pa&!1qEB\u000f\u0005\u0011\u0001\u0016\r\u001e5\u0002\u001b5,'oZ3ES6\u0014\u0016M\\4f)\t\u0019i\u0003\u0005\u0005\u00040\rU\u0012QBB\u001d\u001b\t\u0019\tD\u0003\u0003\u00044\u0005=\u0012\u0001B;uS2LAaa\u000e\u00042\t\u0019Q*\u00199\u0011\u0007-\u001cY$C\u0002\u0004>1\u0014!\u0003R5nK:\u001c\u0018n\u001c8SC:<W-\u00138g_\u0006\u0001R.\u001a:hK\u000e{G.^7o\u0005f$Xm\u001d")
public abstract class MergeStage
implements SegmentExec,
StageExec {
    private volatile MergeStage$LayoutMergeTask$ LayoutMergeTask$module;
    private final SegmentJob jobContext;
    private final NDataSegment dataSegment;
    private final String jobId;
    private final KylinConfig config;
    private final String dataflowId;
    private final SparkSession sparkSession;
    private final BuildContext resourceContext;
    private final JobRuntime runtime;
    private final String project;
    private final String segmentId;
    private final NDataModel dataModel;
    private final int storageType;
    private final Buffer<NDataSegment> unmerged;
    private final String sparkSchedulerPool;
    private String id;
    private volatile Option<Throwable> anonymousFailure;
    private LinkedBlockingQueue<SegmentExec.ResultType> pipe;
    private LinkedBlockingQueue<Option<Throwable>> failFastQueue;
    private transient Logger org$apache$spark$internal$Logging$$log_;
    private volatile byte bitmap$0;

    @Override
    public String getId() {
        return StageExec.getId$(this);
    }

    @Override
    public void onStageStart() {
        StageExec.onStageStart$(this);
    }

    @Override
    public void updateStageInfo(String taskId, String segmentId, String project, String status, String errMsg, HashMap<String, String> updateInfo) {
        StageExec.updateStageInfo$(this, taskId, segmentId, project, status, errMsg, updateInfo);
    }

    @Override
    public void onStageFinished(boolean result) {
        StageExec.onStageFinished$(this, result);
    }

    @Override
    public void onBuildLayoutSuccess(int layoutCount) {
        StageExec.onBuildLayoutSuccess$(this, layoutCount);
    }

    @Override
    public void onStageSkipped() {
        StageExec.onStageSkipped$(this);
    }

    @Override
    public void toWork() {
        StageExec.toWork$(this);
    }

    @Override
    public void toWorkWithoutFinally() {
        StageExec.toWorkWithoutFinally$(this);
    }

    @Override
    public void setId(String id) {
        StageExec.setId$(this, id);
    }

    @Override
    public void reportTaskProgress() {
        SegmentExec.reportTaskProgress$(this);
    }

    @Override
    public <T extends SegmentExec.Task> void slowStartExec(Iterator<T> taskIter, Function1<T, BoxedUnit> taskExec) {
        SegmentExec.slowStartExec$(this, taskIter, taskExec);
    }

    @Override
    public final void failFastCheck() {
        SegmentExec.failFastCheck$(this);
    }

    @Override
    public final int failFastPoll(long timeout, TimeUnit unit) {
        return SegmentExec.failFastPoll$(this, timeout, unit);
    }

    @Override
    public final long failFastPoll$default$1() {
        return SegmentExec.failFastPoll$default$1$(this);
    }

    @Override
    public final TimeUnit failFastPoll$default$2() {
        return SegmentExec.failFastPoll$default$2$(this);
    }

    @Override
    public final void handleFailure(Option<Throwable> failure) {
        SegmentExec.handleFailure$(this, failure);
    }

    @Override
    public final void setConfig4CurrentThread() {
        SegmentExec.setConfig4CurrentThread$(this);
    }

    @Override
    public void drain(long timeout, TimeUnit unit) {
        SegmentExec.drain$(this, timeout, unit);
    }

    @Override
    public long drain$default$1() {
        return SegmentExec.drain$default$1$(this);
    }

    @Override
    public TimeUnit drain$default$2() {
        return SegmentExec.drain$default$2$(this);
    }

    @Override
    public final int updateDataLayouts(NDataflowManager manager, Seq<NDataLayout> dataLayouts) {
        return SegmentExec.updateDataLayouts$(this, manager, dataLayouts);
    }

    @Override
    public void scheduleCheckpoint() {
        SegmentExec.scheduleCheckpoint$(this);
    }

    @Override
    public final Dataset<Row> wrapLayoutDS(LayoutEntity layout, Dataset<Row> parentDS) {
        return SegmentExec.wrapLayoutDS$(this, layout, parentDS);
    }

    @Override
    public final void newDataLayout(NDataSegment segment, LayoutEntity layout, Dataset<Row> layoutDS, String readableDesc, Option<StorageListener> storageListener) {
        SegmentExec.newDataLayout$(this, segment, layout, layoutDS, readableDesc, storageListener);
    }

    @Override
    public Set<Integer> wrapDimensions(LayoutEntity layout) {
        return SegmentExec.wrapDimensions$(this, layout);
    }

    @Override
    public final WriteTaskStats saveWithStatistics(LayoutEntity layout, Dataset<Row> layoutDS, String storagePath, String readableDesc, Option<StorageListener> storageListener) {
        return SegmentExec.saveWithStatistics$(this, layout, layoutDS, storagePath, readableDesc, storageListener);
    }

    @Override
    public HashMap<String, DimensionRangeInfo> calDimRange(NDataSegment segment, Dataset<Row> ds) {
        return SegmentExec.calDimRange$(this, segment, ds);
    }

    @Override
    public void cleanup() {
        SegmentExec.cleanup$(this);
    }

    @Override
    public void cleanupLayoutTempData(NDataSegment segment, Seq<LayoutEntity> layouts) {
        SegmentExec.cleanupLayoutTempData$(this, segment, layouts);
    }

    @Override
    public <T> Seq<T> polledResultSeq(BlockingQueue<T> resultQueue) {
        return SegmentExec.polledResultSeq$(this, resultQueue);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public MergeStage$LayoutMergeTask$ LayoutMergeTask() {
        if (this.LayoutMergeTask$module == null) {
            this.LayoutMergeTask$lzycompute$1();
        }
        return this.LayoutMergeTask$module;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public void id_$eq(String x$1) {
        this.id = x$1;
    }

    @Override
    public Option<Throwable> anonymousFailure() {
        return this.anonymousFailure;
    }

    @Override
    public void anonymousFailure_$eq(Option<Throwable> x$1) {
        this.anonymousFailure = x$1;
    }

    private LinkedBlockingQueue<SegmentExec.ResultType> pipe$lzycompute() {
        MergeStage mergeStage = this;
        synchronized (mergeStage) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.pipe = SegmentExec.pipe$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.pipe;
    }

    @Override
    public final LinkedBlockingQueue<SegmentExec.ResultType> pipe() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.pipe$lzycompute() : this.pipe;
    }

    private LinkedBlockingQueue<Option<Throwable>> failFastQueue$lzycompute() {
        MergeStage mergeStage = this;
        synchronized (mergeStage) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.failFastQueue = SegmentExec.failFastQueue$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.failFastQueue;
    }

    @Override
    public final LinkedBlockingQueue<Option<Throwable>> failFastQueue() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.failFastQueue$lzycompute() : this.failFastQueue;
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private SegmentJob jobContext() {
        return this.jobContext;
    }

    private NDataSegment dataSegment() {
        return this.dataSegment;
    }

    @Override
    public SparkApplication getJobContext() {
        return this.jobContext();
    }

    @Override
    public NDataSegment getDataSegment() {
        return this.dataSegment();
    }

    @Override
    public String getSegmentId() {
        return this.dataSegment().getId();
    }

    @Override
    public final String jobId() {
        return this.jobId;
    }

    @Override
    public final KylinConfig config() {
        return this.config;
    }

    @Override
    public final String dataflowId() {
        return this.dataflowId;
    }

    @Override
    public final SparkSession sparkSession() {
        return this.sparkSession;
    }

    @Override
    public final BuildContext resourceContext() {
        return this.resourceContext;
    }

    @Override
    public final JobRuntime runtime() {
        return this.runtime;
    }

    @Override
    public final String project() {
        return this.project;
    }

    @Override
    public final String segmentId() {
        return this.segmentId;
    }

    @Override
    public final NDataModel dataModel() {
        return this.dataModel;
    }

    @Override
    public final int storageType() {
        return this.storageType;
    }

    public final Buffer<NDataSegment> unmerged() {
        return this.unmerged;
    }

    public void mergeIndices() {
        this.cleanupLayoutTempData(this.dataSegment(), (Seq<LayoutEntity>)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(this.jobContext().getReadOnlyLayouts()).asScala()).toSeq());
        Iterable tasks = (Iterable)((TraversableLike)this.unmerged().flatMap((Function1 & Serializable & scala.Serializable)segment -> (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(segment.getSegDetails().getLayouts()).asScala(), Buffer$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.getLayoutId())).values().map((Function1)this.LayoutMergeTask(), Iterable$.MODULE$.canBuildFrom());
        this.slowStartExec(tasks.iterator(), (Function1 & Serializable & scala.Serializable)task -> {
            this.mergeLayout(task);
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void recordTaskInfo(SegmentExec.Task t) {
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(22).append("Segment ").append(this.segmentId()).append(" submit task: ").append(t.getTaskDesc()).toString());
    }

    private void mergeLayout(LayoutMergeTask task) {
        NDataLayout head = (NDataLayout)task.grouped().head();
        LayoutEntity layout = head.getLayout();
        long layoutId = layout.getId();
        Dataset<Row> unitedDS = this.newUnitedDS(Predef$.MODULE$.long2Long(layoutId));
        if (Objects.isNull(unitedDS)) {
            return;
        }
        this.mergeDataLayout(layout, unitedDS);
    }

    private Dataset<Row> newUnitedDS(Long layoutId) {
        ObjectRef unitedDS = ObjectRef.create(null);
        this.unmerged().foreach((Function1 & Serializable & scala.Serializable)segment -> {
            MergeStage.$anonfun$newUnitedDS$1(this, layoutId, unitedDS, segment);
            return BoxedUnit.UNIT;
        });
        return (Dataset)unitedDS.elem;
    }

    private void mergeDataLayout(LayoutEntity layout, Dataset<Row> unitedDS) {
        String readableDesc = new StringBuilder(13).append("Merge layout ").append(layout.getId()).toString();
        Dataset<Row> layoutDS = this.wrapLayoutDS(layout, unitedDS);
        this.newDataLayout(this.dataSegment(), layout, layoutDS, readableDesc, (Option<StorageListener>)None$.MODULE$);
    }

    @Override
    public SegmentExec.SourceStats newSourceStats(LayoutEntity layout, WriteTaskStats origin) {
        long sourceRows = BoxesRunTime.unboxToLong((Object)((TraversableOnce)((TraversableLike)((TraversableLike)this.unmerged().map((Function1 & Serializable & scala.Serializable)segment -> segment.getLayout(layout.getId()), Buffer$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)MergeStage.$anonfun$newSourceStats$2(x$1)))).map((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.getSourceRows()), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(20).append("Layout ").append(layout.getId()).append(" source rows ").append(sourceRows).toString());
        return new SegmentExec.SourceStats(sourceRows);
    }

    @Override
    public String sparkSchedulerPool() {
        return this.sparkSchedulerPool;
    }

    @Override
    public String columnIdFunc(TblColRef colRef) {
        String string;
        if (this.config().isUTEnv()) {
            SegmentFlatTableDesc tableDesc = new SegmentFlatTableDesc(this.config(), this.dataSegment(), null);
            string = tableDesc.getColumnIdAsString(colRef);
        } else {
            string = "-1";
        }
        return string;
    }

    public void mergeFlatTable() {
        if (!this.config().isPersistFlatTableEnabled()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Flat table persisting is not enabled.");
            this.onStageSkipped();
            return;
        }
        Seq<Path> unmergedFTPaths = this.getUnmergedFTPaths();
        if (unmergedFTPaths.isEmpty()) {
            this.onStageSkipped();
            return;
        }
        ObjectRef tableDS = ObjectRef.create((Object)this.sparkSession().read().parquet(((Path)unmergedFTPaths.head()).toString()));
        String schema = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])((Dataset)tableDS.elem).schema().fieldNames())).mkString(",");
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("FLAT-TABLE schema ").append(schema).toString());
        boolean schemaMatched = ((IterableLike)unmergedFTPaths.drop(1)).forall((Function1 & Serializable & scala.Serializable)fp -> BoxesRunTime.boxToBoolean((boolean)MergeStage.$anonfun$mergeFlatTable$3(this, schema, fp)));
        if (!schemaMatched) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Skip FLAT-TABLE schema not matched.");
            this.onStageSkipped();
            return;
        }
        ((IterableLike)unmergedFTPaths.drop(1)).foreach((Function1 & Serializable & scala.Serializable)fp -> {
            MergeStage.$anonfun$mergeFlatTable$6(this, tableDS, fp);
            return BoxedUnit.UNIT;
        });
        Path newPath = this.config().getFlatTableDir(this.project(), this.dataflowId(), this.segmentId());
        this.sparkSession().sparkContext().setLocalProperty("spark.scheduler.pool", "merge");
        this.sparkSession().sparkContext().setJobDescription("Persist flat table.");
        ((Dataset)tableDS.elem).write().mode(SaveMode.Overwrite).parquet(newPath.toString());
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Persist merged FLAT-TABLE ").append(newPath).append(" with schema ").append(schema).toString());
        NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)this.config(), (String)this.project());
        NDataflow copiedDataflow = dataflowManager.getDataflow(this.dataflowId()).copy();
        NDataSegment copiedSegment = copiedDataflow.getSegment(this.segmentId());
        copiedSegment.setFlatTableReady(true);
        NDataflowUpdate update = new NDataflowUpdate(this.dataflowId());
        update.setToUpdateSegs(new NDataSegment[]{copiedSegment});
        dataflowManager.updateDataflow(update);
    }

    public Seq<Path> getUnmergedFTPaths() {
        Buffer notReadies = (Buffer)((TraversableLike)this.unmerged().filterNot((Function1 & Serializable & scala.Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isFlatTableReady()))).map((Function1 & Serializable & scala.Serializable)x$5 -> x$5.getId(), Buffer$.MODULE$.canBuildFrom());
        if (notReadies.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(102).append("[UNEXPECTED_THINGS_HAPPENED] Merging FLAT-TABLE, ").append("but found that some flat table were not ready like [").append(notReadies.mkString(",")).append("]").toString());
            return (Seq)Nil$.MODULE$;
        }
        FileSystem fs = this.config().isBuildFilesSeparationEnabled() ? HadoopUtil.getWritingClusterFileSystem() : HadoopUtil.getWorkingFileSystem();
        Buffer notExists = (Buffer)((TraversableLike)this.unmerged().filterNot((Function1 & Serializable & scala.Serializable)segment -> BoxesRunTime.boxToBoolean((boolean)this.exists$1(segment, fs)))).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getId(), Buffer$.MODULE$.canBuildFrom());
        if (notExists.nonEmpty()) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(103).append("[UNEXPECTED_THINGS_HAPPENED] Merging FLAT-TABLE, ").append("but found that some flat table were not exists like [").append(notExists.mkString(",")).append("]").toString());
            return (Seq)Nil$.MODULE$;
        }
        return (Seq)this.unmerged().map((Function1 & Serializable & scala.Serializable)segment -> this.config().getFlatTableDir(this.project(), this.dataflowId(), segment.getId()), Buffer$.MODULE$.canBuildFrom());
    }

    public java.util.Map<String, DimensionRangeInfo> org$apache$kylin$engine$spark$job$stage$merge$MergeStage$$mergeDimRange() {
        java.util.Map<String, Object> map;
        Buffer emptyDimRangeSeg = (Buffer)this.unmerged().filter((Function1 & Serializable & scala.Serializable)seg -> BoxesRunTime.boxToBoolean((boolean)MergeStage.$anonfun$mergeDimRange$1(seg)));
        NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)this.config(), (String)this.project()).getDataflow(this.dataflowId());
        NDataSegment mergedSegment = dataflow.getSegment(this.segmentId());
        if (mergedSegment.isFlatTableReady()) {
            Path flatTablePath = this.config().getFlatTableDir(this.project(), this.dataflowId(), this.segmentId());
            Dataset mergedDS = this.sparkSession().read().parquet(flatTablePath.toString());
            map = this.calDimRange(mergedSegment, (Dataset<Row>)mergedDS);
        } else if (emptyDimRangeSeg.nonEmpty()) {
            map = new HashMap<String, DimensionRangeInfo>();
        } else {
            BiMap dimCols = dataflow.getIndexPlan().getEffectiveDimCols();
            scala.collection.immutable.Map mergedDimRange = (scala.collection.immutable.Map)((TraversableLike)((TraversableLike)((TraversableOnce)this.unmerged().map((Function1 & Serializable & scala.Serializable)seg -> JavaConverters$.MODULE$.mapAsScalaMap(seg.getDimensionRangeInfoMap()).toSeq(), Buffer$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$7, x$8) -> (Seq)x$7.$plus$plus((GenTraversableOnce)x$8, Seq$.MODULE$.canBuildFrom()))).groupBy((Function1 & Serializable & scala.Serializable)x$9 -> (String)x$9._1()).mapValues((Function1 & Serializable & scala.Serializable)x$10 -> ((Seq)x$10.map((Function1 & Serializable & scala.Serializable)x$11 -> (DimensionRangeInfo)x$11._2(), Seq$.MODULE$.canBuildFrom())).seq()).filter((Function1 & Serializable & scala.Serializable)dim -> BoxesRunTime.boxToBoolean((boolean)dimCols.containsKey((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt((String)dim._1())))))).map((Function1 & Serializable & scala.Serializable)dim -> new Tuple2(dim._1(), ((TraversableOnce)dim._2()).reduce((Function2 & Serializable & scala.Serializable)(x$12, x$13) -> x$12.merge(x$13, ((TblColRef)dimCols.get((Object)BoxesRunTime.boxToInteger((int)Integer.parseInt((String)dim._1())))).getType()))), Map$.MODULE$.canBuildFrom());
            map = JavaConverters$.MODULE$.mapAsJavaMap((Map)mergedDimRange);
        }
        return map;
    }

    public void mergeColumnBytes() {
        UnitOfWork.doInTransactionWithRetry((UnitOfWork.Callback)new UnitOfWork.Callback<BoxedUnit>(this){
            private final /* synthetic */ MergeStage $outer;

            public void preProcess() {
                super.preProcess();
            }

            public void onProcessError(Throwable x$1) {
                super.onProcessError(x$1);
            }

            public void process() {
                SourceUsageManager usageManager = SourceUsageManager.getInstance((KylinConfig)this.$outer.config());
                long totalCount = BoxesRunTime.unboxToLong((Object)((TraversableOnce)this.$outer.unmerged().map((Function1 & Serializable & scala.Serializable)x$14 -> BoxesRunTime.boxToLong((long)$anon$1.$anonfun$process$1(x$14)), Buffer$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
                java.util.Map evaluated = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)((TraversableLike)this.$outer.unmerged().flatMap((Function1 & Serializable & scala.Serializable)segment -> {
                    java.util.Map existed = segment.getColumnSourceBytes().isEmpty() ? usageManager.calcAvgColumnSourceBytes(segment) : segment.getColumnSourceBytes();
                    return (scala.collection.mutable.Map)JavaConverters$.MODULE$.mapAsScalaMapConverter(existed).asScala();
                }, Buffer$.MODULE$.canBuildFrom())).groupBy((Function1 & Serializable & scala.Serializable)x$15 -> (String)x$15._1()).mapValues((Function1 & Serializable & scala.Serializable)x$16 -> (Long)((TraversableOnce)x$16.map((Function1 & Serializable & scala.Serializable)x$17 -> (Long)x$17._2(), Buffer$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(x$18, x$19) -> Predef$.MODULE$.long2Long(Predef$.MODULE$.Long2long(x$18) + Predef$.MODULE$.Long2long(x$19))))).asJava();
                NDataflowManager dataflowManager = NDataflowManager.getInstance((KylinConfig)this.$outer.config(), (String)this.$outer.project());
                NDataflow copiedDataflow = dataflowManager.getDataflow(this.$outer.dataflowId()).copy();
                NDataSegment copiedSegment = copiedDataflow.getSegment(this.$outer.segmentId());
                NDataflowUpdate dataflowUpdate = new NDataflowUpdate(this.$outer.dataflowId());
                copiedSegment.setSourceCount(totalCount);
                copiedSegment.setDimensionRangeInfoMap(this.$outer.org$apache$kylin$engine$spark$job$stage$merge$MergeStage$$mergeDimRange());
                copiedSegment.getColumnSourceBytes().putAll(evaluated);
                dataflowUpdate.setToUpdateSegs(new NDataSegment[]{copiedSegment});
                this.$outer.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Merge COLUMN-BYTES segment ").append($this.$outer.segmentId()).toString());
                dataflowManager.updateDataflow(dataflowUpdate);
            }

            public static final /* synthetic */ long $anonfun$process$1(NDataSegment x$14) {
                return x$14.getSourceCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$process$1$adapted(org.apache.kylin.metadata.cube.model.NDataSegment ), $anonfun$process$2(org.apache.kylin.metadata.sourceusage.SourceUsageManager org.apache.kylin.metadata.cube.model.NDataSegment ), $anonfun$process$3(scala.Tuple2 ), $anonfun$process$4(scala.collection.mutable.Buffer ), $anonfun$process$7(org.apache.kylin.engine.spark.job.stage.merge.MergeStage$$anon$1 ), $anonfun$process$5(scala.Tuple2 ), $anonfun$process$6(java.lang.Long java.lang.Long )}, serializedLambda);
            }
        }, (String)this.project());
    }

    private final void LayoutMergeTask$lzycompute$1() {
        MergeStage mergeStage = this;
        synchronized (mergeStage) {
            if (this.LayoutMergeTask$module == null) {
                this.LayoutMergeTask$module = new MergeStage$LayoutMergeTask$(this);
            }
        }
    }

    public static final /* synthetic */ void $anonfun$newUnitedDS$1(MergeStage $this, Long layoutId$1, ObjectRef unitedDS$1, NDataSegment segment) {
        NDataLayout dataLayout = segment.getLayout(Predef$.MODULE$.Long2long(layoutId$1));
        if (Objects.isNull(dataLayout)) {
            $this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(62).append("[UNEXPECTED_THINGS_HAPPENED] Layout not found ").append("layout ").append(layoutId$1).append(" segment ").append(segment.getId()).toString());
        } else {
            LayoutEntity layout = dataLayout.getLayout();
            Dataset layoutDS = StorageStoreUtils$.MODULE$.toDF(segment, layout, $this.sparkSession());
            unitedDS$1.elem = Objects.isNull((Dataset)unitedDS$1.elem) ? layoutDS : ((Dataset)unitedDS$1.elem).union(layoutDS);
        }
    }

    public static final /* synthetic */ boolean $anonfun$newSourceStats$2(Object x$1) {
        return Objects.isNull(x$1);
    }

    public static final /* synthetic */ boolean $anonfun$mergeFlatTable$3(MergeStage $this, String schema$1, Path fp) {
        Dataset otherDS = $this.sparkSession().read().parquet(fp.toString());
        String other = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])otherDS.schema().fieldNames())).mkString(",");
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("FLAT-TABLE schema ").append(other).toString());
        return schema$1.equals(other);
    }

    public static final /* synthetic */ void $anonfun$mergeFlatTable$6(MergeStage $this, ObjectRef tableDS$1, Path fp) {
        Dataset other = $this.sparkSession().read().parquet(fp.toString());
        tableDS$1.elem = ((Dataset)tableDS$1.elem).union(other);
    }

    private final boolean exists$1(NDataSegment segment, FileSystem fs$1) {
        boolean bl;
        try {
            Path pathFT = this.config().getFlatTableDir(this.project(), this.dataflowId(), segment.getId());
            bl = fs$1.exists(pathFT);
        }
        catch (IOException ioe) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(67).append("[UNEXPECTED_THINGS_HAPPENED] Checking FLAT-TABLE exists of segment ").append(segment.getId()).toString(), ioe);
            bl = false;
        }
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$mergeDimRange$1(NDataSegment seg) {
        return seg.getDimensionRangeInfoMap().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    public MergeStage(SegmentJob jobContext, NDataSegment dataSegment) {
        void var3_3;
        this.jobContext = jobContext;
        this.dataSegment = dataSegment;
        Logging.$init$((Logging)this);
        SegmentExec.$init$(this);
        StageExec.$init$(this);
        this.jobId = jobContext.getJobId();
        this.config = jobContext.getConfig();
        this.dataflowId = jobContext.getDataflowId();
        this.sparkSession = jobContext.getSparkSession();
        this.resourceContext = jobContext.getBuildContext();
        this.runtime = jobContext.getRuntime();
        this.project = dataSegment.getProject();
        this.segmentId = dataSegment.getId();
        this.dataModel = dataSegment.getModel();
        this.storageType = this.dataModel().getStorageType();
        Buffer segments = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(jobContext.getUnmergedSegments(dataSegment)).asScala();
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(19).append("Unmerged SEGMENT [").append(((TraversableOnce)segments.map((Function1 & Serializable & scala.Serializable)x$1 -> x$1.getId(), Buffer$.MODULE$.canBuildFrom())).mkString(",")).append("]").toString());
        this.unmerged = var3_3;
        this.sparkSchedulerPool = "merge";
    }

    public class LayoutMergeTask
    implements SegmentExec.Task,
    Product,
    scala.Serializable {
        private final Seq<NDataLayout> grouped;
        public final /* synthetic */ MergeStage $outer;

        public Seq<NDataLayout> grouped() {
            return this.grouped;
        }

        @Override
        public String getTaskDesc() {
            return String.valueOf(BoxesRunTime.boxToLong((long)((NDataLayout)this.grouped().head()).getLayoutId()));
        }

        public LayoutMergeTask copy(Seq<NDataLayout> grouped) {
            return new LayoutMergeTask(this.org$apache$kylin$engine$spark$job$stage$merge$MergeStage$LayoutMergeTask$$$outer(), grouped);
        }

        public Seq<NDataLayout> copy$default$1() {
            return this.grouped();
        }

        public String productPrefix() {
            return "LayoutMergeTask";
        }

        public int productArity() {
            return 1;
        }

        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(Integer.toString(x$1));
                }
            }
            return this.grouped();
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof LayoutMergeTask;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof LayoutMergeTask)) return false;
            if (((LayoutMergeTask)object).org$apache$kylin$engine$spark$job$stage$merge$MergeStage$LayoutMergeTask$$$outer() != this.org$apache$kylin$engine$spark$job$stage$merge$MergeStage$LayoutMergeTask$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            LayoutMergeTask layoutMergeTask = (LayoutMergeTask)x$1;
            Seq<NDataLayout> seq = this.grouped();
            Seq<NDataLayout> seq2 = layoutMergeTask.grouped();
            if (seq == null) {
                if (seq2 != null) {
                    return false;
                }
            } else if (!seq.equals(seq2)) return false;
            if (!layoutMergeTask.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ MergeStage org$apache$kylin$engine$spark$job$stage$merge$MergeStage$LayoutMergeTask$$$outer() {
            return this.$outer;
        }

        public LayoutMergeTask(MergeStage $outer, Seq<NDataLayout> grouped) {
            this.grouped = grouped;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

