/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.merger;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.engine.spark.ExecutableUtils;
import org.apache.kylin.engine.spark.merger.SparkJobMetadataMerger;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NDataflowUpdate;
import org.apache.kylin.metadata.cube.model.PartitionStatusEnum;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AfterBuildResourceMerger
extends SparkJobMetadataMerger {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AfterBuildResourceMerger.class);

    public AfterBuildResourceMerger(KylinConfig config, String project) {
        super(config, project);
    }

    @Override
    public NDataLayout[] merge(String dataflowId, Set<String> segmentId, Set<Long> layoutIds, ResourceStore remoteResourceStore, JobTypeEnum jobType, Set<Long> partitions) {
        switch (jobType) {
            case INDEX_BUILD: 
            case SUB_PARTITION_BUILD: {
                return this.mergeAfterCatchup(dataflowId, segmentId, layoutIds, remoteResourceStore, partitions);
            }
            case INC_BUILD: {
                Preconditions.checkArgument((segmentId.size() == 1 ? 1 : 0) != 0);
                return this.mergeAfterIncrement(dataflowId, segmentId.iterator().next(), layoutIds, remoteResourceStore);
            }
        }
        throw new UnsupportedOperationException("Error job type: " + jobType);
    }

    @Override
    public void merge(AbstractExecutable abstractExecutable) {
        try (ResourceStore buildResourceStore = ExecutableUtils.getRemoteStore(this.getConfig(), abstractExecutable);){
            String dataFlowId = ExecutableUtils.getDataflowId(abstractExecutable);
            Set<String> segmentIds = ExecutableUtils.getSegmentIds(abstractExecutable);
            Set<Long> layoutIds = ExecutableUtils.getLayoutIds(abstractExecutable);
            Set<Long> partitionIds = ExecutableUtils.getPartitionIds(abstractExecutable);
            NDataLayout[] nDataLayouts = this.merge(dataFlowId, segmentIds, layoutIds, buildResourceStore, abstractExecutable.getJobType(), partitionIds);
            NDataflow dataflow = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject()).getDataflow(dataFlowId);
            if (ExecutableUtils.needBuildSnapshots(abstractExecutable)) {
                this.mergeSnapshotMeta(dataflow, buildResourceStore);
            }
            this.mergeTableExtMeta(dataflow, buildResourceStore);
            this.recordDownJobStats(abstractExecutable, nDataLayouts);
            abstractExecutable.notifyUserIfNecessary(nDataLayouts);
        }
    }

    public NDataLayout[] mergeAfterIncrement(String flowName, String segmentId, Set<Long> layoutIds, ResourceStore remoteStore) {
        NDataflowManager localDataflowManager = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataflowManager remoteDataflowManager = NDataflowManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)this.getProject());
        NDataflow remoteDataflow = remoteDataflowManager.getDataflow(flowName).copy();
        NDataflowUpdate dfUpdate = new NDataflowUpdate(flowName);
        NDataSegment theSeg = remoteDataflow.getSegment(segmentId);
        List toRemoveSegments = remoteDataflowManager.getToRemoveSegs(remoteDataflow, theSeg);
        if (theSeg.getModel().isMultiPartitionModel()) {
            long lastBuildTime = System.currentTimeMillis();
            theSeg.getMultiPartitions().forEach(partition -> {
                partition.setStatus(PartitionStatusEnum.READY);
                partition.setLastBuildTime(lastBuildTime);
            });
            theSeg.setLastBuildTime(lastBuildTime);
        } else {
            theSeg.setLastBuildTime(theSeg.getSegDetails().getLastModified());
        }
        this.resetBreakpoints(theSeg);
        theSeg.setStatus(SegmentStatusEnum.READY);
        dfUpdate.setToUpdateSegs(new NDataSegment[]{theSeg});
        dfUpdate.setToRemoveSegs(toRemoveSegments.toArray(new NDataSegment[toRemoveSegments.size()]));
        dfUpdate.setToAddOrUpdateLayouts(theSeg.getSegDetails().getLayouts().toArray(new NDataLayout[0]));
        localDataflowManager.updateDataflow(dfUpdate);
        this.updateIndexPlan(flowName, remoteStore);
        return dfUpdate.getToAddOrUpdateLayouts();
    }

    public NDataLayout[] mergeAfterCatchup(String flowName, Set<String> segmentIds, Set<Long> layoutIds, ResourceStore remoteStore, Set<Long> partitionIds) {
        if (CollectionUtils.isNotEmpty(partitionIds)) {
            return this.mergeMultiPartitionModelAfterCatchUp(flowName, segmentIds, layoutIds, remoteStore, partitionIds);
        }
        return this.mergeNormalModelAfterCatchUp(flowName, segmentIds, layoutIds, remoteStore);
    }

    public NDataLayout[] mergeNormalModelAfterCatchUp(String flowName, Set<String> segmentIds, Set<Long> layoutIds, ResourceStore remoteStore) {
        NDataflowManager localDataflowManager = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataflow dataflow = localDataflowManager.getDataflow(flowName);
        NDataflowManager remoteDataflowManager = NDataflowManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)this.getProject());
        NDataflow remoteDataflow = remoteDataflowManager.getDataflow(flowName).copy();
        NDataflowUpdate dfUpdate = new NDataflowUpdate(flowName);
        ArrayList addCuboids = Lists.newArrayList();
        Set<Long> availableLayoutIds = this.getAvailableLayoutIds(dataflow, layoutIds);
        ArrayList segsToUpdate = Lists.newArrayList();
        for (String segId : segmentIds) {
            NDataSegment localSeg = dataflow.getSegment(segId);
            NDataSegment remoteSeg = remoteDataflow.getSegment(segId);
            if (this.isUnavailableSegment(localSeg)) continue;
            remoteSeg.setLastBuildTime(remoteSeg.getSegDetails().getLastModified());
            for (long layoutId : availableLayoutIds) {
                NDataLayout dataCuboid = remoteSeg.getLayout(layoutId);
                Preconditions.checkNotNull((Object)dataCuboid);
                addCuboids.add(dataCuboid);
            }
            this.resetBreakpoints(remoteSeg);
            segsToUpdate.add(remoteSeg);
        }
        dfUpdate.setToUpdateSegs(segsToUpdate.toArray(new NDataSegment[0]));
        dfUpdate.setToAddOrUpdateLayouts(addCuboids.toArray(new NDataLayout[0]));
        localDataflowManager.updateDataflow(dfUpdate);
        this.updateIndexPlan(flowName, remoteStore);
        return dfUpdate.getToAddOrUpdateLayouts();
    }

    private boolean isUnavailableSegment(NDataSegment localSeg) {
        if (localSeg == null) {
            return true;
        }
        return localSeg.getStatus() != SegmentStatusEnum.READY && localSeg.getStatus() != SegmentStatusEnum.WARNING;
    }

    public NDataLayout[] mergeMultiPartitionModelAfterCatchUp(String flowName, Set<String> segmentIds, Set<Long> layoutIds, ResourceStore remoteStore, Set<Long> partitionIds) {
        NDataflowManager localDataflowManager = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        NDataflow localDataflow = localDataflowManager.getDataflow(flowName).copy();
        NDataflowManager remoteDataflowManager = NDataflowManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)this.getProject());
        NDataflow remoteDataflow = remoteDataflowManager.getDataflow(flowName).copy();
        NDataflow dataflow = localDataflowManager.getDataflow(flowName);
        NDataflowUpdate dfUpdate = new NDataflowUpdate(flowName);
        ArrayList upsertCuboids = Lists.newArrayList();
        Set<Long> availableLayoutIds = this.getAvailableLayoutIds(dataflow, layoutIds);
        ArrayList segsToUpdate = Lists.newArrayList();
        for (String segId : segmentIds) {
            NDataSegment localSeg = localDataflow.getSegment(segId);
            NDataSegment remoteSeg = remoteDataflow.getSegment(segId);
            if (this.isUnavailableSegment(localSeg)) continue;
            NDataSegment updateSegment = this.upsertSegmentPartition(localSeg, remoteSeg, partitionIds);
            for (long layoutId : availableLayoutIds) {
                NDataLayout remoteLayout = remoteSeg.getLayout(layoutId);
                NDataLayout localLayout = localSeg.getLayout(layoutId);
                NDataLayout upsertLayout = this.upsertLayoutPartition(localLayout, remoteLayout, partitionIds);
                if (upsertLayout == null) {
                    log.warn("Layout {} is null in segment {}. Segment have layouts {} ", new Object[]{layoutId, segId, remoteSeg.getLayoutIds()});
                }
                upsertCuboids.add(upsertLayout);
            }
            segsToUpdate.add(updateSegment);
        }
        dfUpdate.setToUpdateSegs(segsToUpdate.toArray(new NDataSegment[0]));
        dfUpdate.setToAddOrUpdateLayouts(upsertCuboids.toArray(new NDataLayout[0]));
        localDataflowManager.updateDataflow(dfUpdate);
        this.updateIndexPlan(flowName, remoteStore);
        return dfUpdate.getToAddOrUpdateLayouts();
    }

    private void resetBreakpoints(NDataSegment dataSegment) {
        dataSegment.setFactViewReady(false);
        dataSegment.setDictReady(false);
        if (!this.getConfig().isPersistFlatTableEnabled()) {
            dataSegment.setFlatTableReady(false);
        }
        if (Objects.nonNull(dataSegment.getModel()) && Objects.nonNull(dataSegment.getModel().getMultiPartitionDesc())) {
            dataSegment.setFlatTableReady(false);
        } else {
            dataSegment.setSnapshotReady(false);
        }
    }
}

