/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.merger;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.TimeUtil;
import org.apache.kylin.engine.spark.merger.MetadataMerger;
import org.apache.kylin.job.dao.JobStatisticsManager;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.JobTypeEnum;
import org.apache.kylin.job.execution.NExecutableManager;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.LayoutPartition;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.cube.model.PartitionStatusEnum;
import org.apache.kylin.metadata.cube.model.RuleBasedIndex;
import org.apache.kylin.metadata.cube.model.SegmentPartition;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SparkJobMetadataMerger
extends MetadataMerger {
    private static final Logger log = LoggerFactory.getLogger(SparkJobMetadataMerger.class);
    private final String project;

    protected SparkJobMetadataMerger(KylinConfig config, String project) {
        super(config);
        this.project = project;
    }

    public KylinConfig getProjectConfig(ResourceStore remoteStore) throws IOException {
        KylinConfig globalConfig = KylinConfig.createKylinConfig((Properties)KylinConfig.streamToProps((InputStream)remoteStore.getResource("/kylin.properties").getByteSource().openStream()));
        Map projectConfig = ((ProjectInstance)JsonUtil.readValue((byte[])remoteStore.getResource("/_global/project/" + this.project + ".json").getByteSource().read(), ProjectInstance.class)).getLegalOverrideKylinProps();
        return KylinConfigExt.createInstance((KylinConfig)globalConfig, (Map)projectConfig);
    }

    @Override
    public NDataLayout[] merge(String dataflowId, Set<String> segmentIds, Set<Long> layoutIds, ResourceStore remoteResourceStore, JobTypeEnum jobType, Set<Long> partitions) {
        return new NDataLayout[0];
    }

    public void recordDownJobStats(AbstractExecutable buildTask, NDataLayout[] addOrUpdateCuboids) {
        String model = buildTask.getTargetSubject();
        long buildEndTime = buildTask.getEndTime();
        long duration = buildTask.getParent().getDuration();
        long byteSize = 0L;
        for (NDataLayout dataCuboid : addOrUpdateCuboids) {
            byteSize += dataCuboid.getByteSize();
        }
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        long startOfDay = TimeUtil.getDayStart((long)buildEndTime);
        NExecutableManager executableManager = NExecutableManager.getInstance((KylinConfig)kylinConfig, (String)this.project);
        executableManager.updateJobOutput(buildTask.getParentId(), null, null, null, null, byteSize);
        JobStatisticsManager jobStatisticsManager = JobStatisticsManager.getInstance((KylinConfig)kylinConfig, (String)buildTask.getProject());
        jobStatisticsManager.updateStatistics(startOfDay, model, duration, byteSize, 0);
    }

    protected void mergeSnapshotMeta(NDataflow dataflow, ResourceStore remoteResourceStore) {
        if (!this.isSnapshotManualManagementEnabled(remoteResourceStore)) {
            NTableMetadataManager remoteTblMgr = NTableMetadataManager.getInstance((KylinConfig)remoteResourceStore.getConfig(), (String)this.getProject());
            NTableMetadataManager localTblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
            dataflow.getModel().getLookupTables().forEach(remoteTableRef -> {
                String tableName = remoteTableRef.getTableIdentity();
                TableDesc localTbDesc = localTblMgr.getTableDesc(tableName);
                TableDesc remoteTbDesc = remoteTblMgr.getTableDesc(tableName);
                if (remoteTbDesc == null) {
                    return;
                }
                TableDesc copy = localTblMgr.copyForWrite(localTbDesc);
                copy.setLastSnapshotPath(remoteTbDesc.getLastSnapshotPath());
                copy.setLastSnapshotSize(remoteTbDesc.getLastSnapshotSize());
                copy.setSnapshotLastModified(remoteTbDesc.getSnapshotLastModified());
                copy.setSnapshotTotalRows(remoteTbDesc.getSnapshotTotalRows());
                localTblMgr.updateTableDesc(copy);
            });
        }
    }

    protected void mergeTableExtMeta(NDataflow dataflow, ResourceStore remoteResourceStore) {
        NTableMetadataManager remoteTblMgr = NTableMetadataManager.getInstance((KylinConfig)remoteResourceStore.getConfig(), (String)this.getProject());
        NTableMetadataManager localTblMgr = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.getProject());
        dataflow.getModel().getLookupTables().forEach(remoteTableRef -> {
            String tableName = remoteTableRef.getTableIdentity();
            TableDesc localTbDesc = localTblMgr.getTableDesc(tableName);
            TableDesc remoteTbDesc = remoteTblMgr.getTableDesc(tableName);
            if (remoteTbDesc == null) {
                return;
            }
            TableExtDesc remoteTblExtDesc = remoteTblMgr.getOrCreateTableExt(remoteTbDesc);
            TableExtDesc copyExt = localTblMgr.copyForWrite(localTblMgr.getOrCreateTableExt(localTbDesc));
            if (remoteTblExtDesc.getOriginalSize() != -1L) {
                copyExt.setOriginalSize(remoteTblExtDesc.getOriginalSize());
            }
            copyExt.setTotalRows(remoteTblExtDesc.getTotalRows());
            localTblMgr.saveTableExt(copyExt);
        });
    }

    protected boolean isSnapshotManualManagementEnabled(ResourceStore configStore) {
        try {
            KylinConfig projectConfig = this.getProjectConfig(configStore);
            if (!projectConfig.isSnapshotManualManagementEnabled()) {
                return false;
            }
        }
        catch (IOException e) {
            log.error("Fail to get project config.");
        }
        return true;
    }

    public NDataSegment upsertSegmentPartition(NDataSegment localSegment, NDataSegment newSegment, Set<Long> partitionIds) {
        localSegment.getMultiPartitions().removeIf(partition -> partitionIds.contains(partition.getPartitionId()));
        List<SegmentPartition> upsertPartitions = newSegment.getMultiPartitions().stream().filter(partition -> partitionIds.contains(partition.getPartitionId())).collect(Collectors.toList());
        long lastBuildTime = System.currentTimeMillis();
        upsertPartitions.forEach(partition -> {
            partition.setStatus(PartitionStatusEnum.READY);
            partition.setLastBuildTime(lastBuildTime);
        });
        localSegment.getMultiPartitions().addAll(upsertPartitions);
        List partitions = localSegment.getMultiPartitions();
        localSegment.setSourceCount(partitions.stream().mapToLong(SegmentPartition::getSourceCount).sum());
        HashMap merged = Maps.newHashMap();
        partitions.stream().map(SegmentPartition::getColumnSourceBytes).forEach(item -> item.forEach((k, v) -> merged.put(k, v + merged.getOrDefault(k, 0L))));
        localSegment.setColumnSourceBytes((Map)merged);
        localSegment.setLastBuildTime(newSegment.getLastBuildTime());
        localSegment.setSourceBytesSize(newSegment.getSourceBytesSize());
        localSegment.setLastBuildTime(lastBuildTime);
        return localSegment;
    }

    public NDataLayout upsertLayoutPartition(NDataLayout localLayout, NDataLayout newLayout, Set<Long> partitionIds) {
        if (localLayout == null) {
            return newLayout;
        }
        localLayout.getMultiPartition().removeIf(partition -> partitionIds.contains(partition.getPartitionId()));
        List upsertLayouts = newLayout.getMultiPartition().stream().filter(partition -> partitionIds.contains(partition.getPartitionId())).collect(Collectors.toList());
        localLayout.getMultiPartition().addAll(upsertLayouts);
        List partitions = localLayout.getMultiPartition();
        localLayout.setRows(partitions.stream().mapToLong(LayoutPartition::getRows).sum());
        localLayout.setSourceRows(partitions.stream().mapToLong(LayoutPartition::getSourceRows).sum());
        localLayout.setFileCount(partitions.stream().mapToLong(LayoutPartition::getFileCount).sum());
        localLayout.setByteSize(partitions.stream().mapToLong(LayoutPartition::getByteSize).sum());
        return localLayout;
    }

    public Set<Long> getAvailableLayoutIds(NDataflow dataflow, Set<Long> layoutIds) {
        List layoutInCubeIds = dataflow.getIndexPlan().getAllLayouts().stream().map(LayoutEntity::getId).collect(Collectors.toList());
        return layoutIds.stream().filter(layoutInCubeIds::contains).collect(Collectors.toSet());
    }

    public void updateIndexPlan(String dfId, ResourceStore remoteStore) {
        NDataflowManager remoteDataflowManager = NDataflowManager.getInstance((KylinConfig)remoteStore.getConfig(), (String)this.getProject());
        IndexPlan remoteIndexPlan = remoteDataflowManager.getDataflow(dfId).getIndexPlan();
        NIndexPlanManager indexPlanManager = NIndexPlanManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject());
        indexPlanManager.updateIndexPlan(dfId, copyForWrite -> {
            copyForWrite.setLayoutBucketNumMapping(remoteIndexPlan.getLayoutBucketNumMapping());
            RuleBasedIndex remoteRuleIndex = remoteIndexPlan.getRuleBasedIndex();
            RuleBasedIndex currentRuleIndex = copyForWrite.getRuleBasedIndex();
            if (remoteRuleIndex != null && currentRuleIndex != null) {
                if (remoteRuleIndex.getLayoutsOfCostBasedList() != null && currentRuleIndex.getLayoutsOfCostBasedList() == null) {
                    currentRuleIndex.setLayoutsOfCostBasedList(remoteRuleIndex.getLayoutsOfCostBasedList());
                }
                copyForWrite.setRuleBasedIndex(currentRuleIndex);
            }
        });
    }

    @Generated
    public String getProject() {
        return this.project;
    }
}

