/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.mockup;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.mockup.CsvTable;
import org.apache.kylin.engine.spark.source.NSparkCubingSourceInput;
import org.apache.kylin.engine.spark.source.NSparkMetadataExplorer;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.IBuildable;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.source.IReadableTable;
import org.apache.kylin.source.ISampleDataDeployer;
import org.apache.kylin.source.ISource;
import org.apache.kylin.source.ISourceMetadataExplorer;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.utils.SchemaProcessor;
import org.apache.spark.sql.types.StructType;

public class CsvSource
implements ISource {
    public CsvSource(KylinConfig config) {
    }

    public ISourceMetadataExplorer getSourceMetadataExplorer() {
        return new LocalSourceMetadataExplorer();
    }

    public <I> I adaptToBuildEngine(Class<I> engineInterface) {
        if (engineInterface == NSparkCubingEngine.NSparkCubingSource.class) {
            return (I)new NSparkCubingEngine.NSparkCubingSource(){

                @Override
                public Dataset<Row> getSourceData(TableDesc table, SparkSession ss, Map<String, String> parameters) {
                    if (KylinConfig.getInstanceFromEnv().getDDLLogicalViewDB().equalsIgnoreCase(table.getDatabase())) {
                        return new NSparkCubingSourceInput().getSourceData(table, ss, parameters);
                    }
                    String path = new File(CsvSource.this.getUtMetaDir(), "data/" + table.getIdentity() + ".csv").getAbsolutePath();
                    ColumnDesc[] columnDescs = table.getColumns();
                    ArrayList tblColDescs = Lists.newArrayListWithCapacity((int)columnDescs.length);
                    for (ColumnDesc columnDesc : columnDescs) {
                        if (columnDesc.isComputedColumn()) continue;
                        tblColDescs.add(columnDesc);
                    }
                    StructType structType = SchemaProcessor.buildSchemaWithRawTable((ColumnDesc[])tblColDescs.toArray(new ColumnDesc[0]));
                    return ss.read().option("delimiter", ",").schema(structType).csv(path);
                }
            };
        }
        throw new IllegalArgumentException("Unsupported engine interface: " + engineInterface);
    }

    public IReadableTable createReadableTable(TableDesc tableDesc) {
        return new CsvTable(this.getUtMetaDir(), tableDesc);
    }

    public SegmentRange enrichSourcePartitionBeforeBuild(IBuildable buildable, SegmentRange srcPartition) {
        throw new UnsupportedOperationException();
    }

    public ISampleDataDeployer getSampleDataDeployer() {
        throw new UnsupportedOperationException();
    }

    public SegmentRange getSegmentRange(String start, String end) {
        start = StringUtils.isEmpty((String)start) ? "0" : start;
        end = StringUtils.isEmpty((String)end) ? "9223372036854775807" : end;
        return new SegmentRange.TimePartitionedSegmentRange(Long.valueOf(Long.parseLong(start)), Long.valueOf(Long.parseLong(end)));
    }

    private String getUtMetaDir() {
        String utMetaDir = System.getProperty("KYLIN_CONF");
        if (utMetaDir == null || !utMetaDir.startsWith("../example")) {
            throw new IllegalStateException();
        }
        return utMetaDir;
    }

    public boolean supportBuildSnapShotByPartition() {
        return true;
    }

    private class LocalSourceMetadataExplorer
    implements ISourceMetadataExplorer {
        private LocalSourceMetadataExplorer() {
        }

        public List<String> listDatabases() {
            File[] files;
            TreeSet<String> databases = new TreeSet<String>();
            String resPath = KylinConfig.getInstanceFromEnv().getMetadataUrl().getIdentifier();
            String path = resPath + "/../data/tableDesc";
            for (File file : files = new File(path).listFiles()) {
                String fileName;
                String suffix;
                if (file.isDirectory() || !"json".equals(suffix = (fileName = file.getName()).substring(fileName.lastIndexOf(".") + 1))) continue;
                databases.add(fileName.substring(0, fileName.indexOf(".")));
            }
            return new ArrayList<String>(databases);
        }

        public List<String> listTables(String database) {
            File[] files;
            TreeSet<String> tables = new TreeSet<String>();
            String resPath = KylinConfig.getInstanceFromEnv().getMetadataUrl().getIdentifier();
            String path = resPath + "/../data/tableDesc";
            for (File file : files = new File(path).listFiles()) {
                String fileName;
                String[] strings;
                if (file.isDirectory() || (strings = (fileName = file.getName()).split("\\.")).length < 1 || !database.equals(strings[0]) || !"json".equals(strings[strings.length - 1])) continue;
                tables.add(strings[1]);
            }
            return new ArrayList<String>(tables);
        }

        public Pair<TableDesc, TableExtDesc> loadTableMetadata(String database, String table, String prj) throws Exception {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            if (config.getDDLLogicalViewDB().equalsIgnoreCase(database)) {
                return new NSparkMetadataExplorer().loadTableMetadata(database, table, prj);
            }
            String resPath = config.getMetadataUrl().getIdentifier();
            String path = resPath + "/../data/tableDesc/" + database + "." + table + ".json";
            TableDesc tableDesc = (TableDesc)JsonUtil.readValue((File)new File(path), TableDesc.class);
            for (ColumnDesc column : tableDesc.getColumns()) {
                column.setName(column.getName().toUpperCase(Locale.ROOT));
            }
            tableDesc.setTableType("defaultTable");
            tableDesc.init(prj);
            TableExtDesc tableExt = new TableExtDesc();
            tableExt.setIdentity(tableDesc.getIdentity());
            return Pair.newPair((Object)tableDesc, (Object)tableExt);
        }

        public List<String> getRelatedKylinResources(TableDesc table) {
            return Collections.emptyList();
        }

        public boolean checkDatabaseAccess(String database) {
            return true;
        }

        public boolean checkTablesAccess(Set<String> tables) {
            return true;
        }

        public Set<String> getTablePartitions(String database, String table, String prj, String partitionCols) {
            if (table.equalsIgnoreCase("SUPPLIER") && partitionCols.equalsIgnoreCase("S_NATION")) {
                HashSet partitions = Sets.newHashSet((Object[])new String[]{"2019-01-03", "2019-01-04"});
                return partitions;
            }
            throw new UnsupportedOperationException();
        }
    }
}

