/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.mockup;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.IReadableTable;

public class CsvTableReader
implements IReadableTable.TableReader {
    private List<String> allLines;
    private int index = -1;

    public CsvTableReader(String baseDir, TableDesc table) {
        String path = new File(baseDir, "data/" + table.getIdentity() + ".csv").getAbsolutePath();
        try {
            this.allLines = FileUtils.readLines((File)new File(path));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean next() {
        ++this.index;
        return this.index < this.allLines.size() && !StringUtils.isEmpty((String)this.allLines.get(this.index));
    }

    public String[] getRow() {
        return this.allLines.get(this.index).split(",");
    }

    public void close() {
    }
}

