/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.model;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.model.SegmentFlatTableDesc;
import org.apache.kylin.metadata.cube.cuboid.AdaptiveSpanningTree;
import org.apache.kylin.metadata.cube.model.NDataSegment;

public class PartitionFlatTableDesc
extends SegmentFlatTableDesc {
    private final String jobId;
    private final List<Long> partitions;

    public PartitionFlatTableDesc(KylinConfig config, NDataSegment dataSegment, AdaptiveSpanningTree spanningTree, String jobId, List<Long> partitions) {
        super(config, dataSegment, spanningTree);
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull(partitions);
        this.jobId = jobId;
        this.partitions = Collections.unmodifiableList(partitions);
    }

    public PartitionFlatTableDesc(KylinConfig config, NDataSegment dataSegment, AdaptiveSpanningTree spanningTree, List<String> relatedTables, String jobId, List<Long> partitions) {
        super(config, dataSegment, spanningTree, relatedTables);
        Preconditions.checkNotNull((Object)jobId);
        Preconditions.checkNotNull(partitions);
        this.jobId = jobId;
        this.partitions = Collections.unmodifiableList(partitions);
    }

    public List<Long> getPartitions() {
        return this.partitions;
    }

    @Override
    public Path getFlatTablePath() {
        return this.config.getJobTmpFlatTableDir(this.project, this.jobId);
    }

    @Override
    public Path getFactTableViewPath() {
        return this.config.getJobTmpFactTableViewDir(this.project, this.jobId);
    }

    @Override
    public boolean shouldPersistFlatTable() {
        return true;
    }

    @Override
    protected void initColumns() {
        this.addPartitionColumns();
        if (this.isPartialBuild()) {
            this.addIndexPartialBuildColumns();
        } else {
            this.addIndexPlanColumns();
        }
    }

    private void addPartitionColumns() {
        this.dataModel.getMultiPartitionDesc().getColumnRefs().stream().filter(Objects::nonNull).forEach(this::addColumn);
    }
}

