/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.model;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.smarter.IndexDependencyParser;
import org.apache.kylin.metadata.cube.cuboid.AdaptiveSpanningTree;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.SegmentRange;
import org.apache.kylin.metadata.model.TblColRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentFlatTableDesc {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SegmentFlatTableDesc.class);
    protected final KylinConfig config;
    protected final KapConfig kapConfig;
    protected final NDataSegment dataSegment;
    protected final AdaptiveSpanningTree spanningTree;
    protected final String project;
    protected final String segmentId;
    protected final String dataflowId;
    protected final NDataModel dataModel;
    protected final IndexPlan indexPlan;
    private final IndexDependencyParser parser;
    private final Map<String, Integer> columnIdMap = Maps.newHashMap();
    private final List<TblColRef> columns = Lists.newLinkedList();
    private final List<Integer> columnIds = Lists.newArrayList();
    private final Map<Integer, String> columnId2Canonical = Maps.newHashMap();
    private final Map<String, String> canonical2Table = Maps.newHashMap();
    private final List<String> relatedTables = Lists.newArrayList();

    public SegmentFlatTableDesc(KylinConfig config, NDataSegment dataSegment, AdaptiveSpanningTree spanningTree) {
        this(config, dataSegment, spanningTree, Lists.newArrayList());
    }

    public SegmentFlatTableDesc(KylinConfig config, NDataSegment dataSegment, AdaptiveSpanningTree spanningTree, List<String> relatedTables) {
        this.config = config;
        this.kapConfig = KapConfig.getInstanceFromEnv();
        this.dataSegment = dataSegment;
        this.spanningTree = spanningTree;
        this.project = dataSegment.getProject();
        this.segmentId = dataSegment.getId();
        this.dataflowId = dataSegment.getDataflow().getId();
        this.dataModel = dataSegment.getModel();
        this.indexPlan = dataSegment.getIndexPlan();
        this.relatedTables.addAll(relatedTables);
        this.parser = new IndexDependencyParser(this.dataModel);
        this.initColumns();
    }

    public List<String> getRelatedTables() {
        return this.relatedTables;
    }

    public boolean isPartialBuild() {
        return !this.relatedTables.isEmpty();
    }

    public String getProject() {
        return this.project;
    }

    public NDataSegment getDataSegment() {
        return this.dataSegment;
    }

    public AdaptiveSpanningTree getSpanningTree() {
        return this.spanningTree;
    }

    public NDataModel getDataModel() {
        return this.dataModel;
    }

    public IndexPlan getIndexPlan() {
        return this.indexPlan;
    }

    public SegmentRange getSegmentRange() {
        return this.dataSegment.getSegRange();
    }

    public boolean buildFilesSeparationPathExists(Path flatTablePath) throws IOException {
        if (this.config.isBuildFilesSeparationEnabled()) {
            return HadoopUtil.getWritingClusterFileSystem().exists(flatTablePath);
        }
        return HadoopUtil.getWorkingFileSystem().exists(flatTablePath);
    }

    public Path getFlatTablePath() {
        return this.config.getFlatTableDir(this.project, this.dataflowId, this.segmentId);
    }

    public Path getFactTableViewPath() {
        return this.config.getFactTableViewDir(this.project, this.dataflowId, this.segmentId);
    }

    public String getWorkingDir() {
        String workingDir = KapConfig.wrap((KylinConfig)this.config).getMetadataWorkingDirectory();
        return StringUtils.removeEnd((String)workingDir, (String)"/");
    }

    public int getSampleRowCount() {
        return this.config.getCapacitySampleRows();
    }

    public boolean shouldPersistFlatTable() {
        return !this.isPartialBuild() && this.config.isPersistFlatTableEnabled();
    }

    public boolean shouldPersistView() {
        return this.config.isPersistFlatViewEnabled();
    }

    public String getColumnIdAsString(TblColRef colRef) {
        Integer id = this.columnIdMap.get(colRef.getIdentity());
        Preconditions.checkNotNull((Object)id);
        return id.toString();
    }

    public List<TblColRef> getColumns() {
        return Collections.unmodifiableList(this.columns);
    }

    public List<Integer> getColumnIds() {
        return Collections.unmodifiableList(this.columnIds);
    }

    public Set<MeasureDesc> getMeasures() {
        return Collections.unmodifiableSet(this.indexPlan.getEffectiveMeasures().values());
    }

    public String getCanonicalName(Integer columnId) {
        return this.columnId2Canonical.get(columnId);
    }

    public String getTableName(String canonicalName) {
        return this.canonical2Table.get(canonicalName);
    }

    public boolean shouldJoinLookupTables() {
        if (!this.config.isFlatTableJoinWithoutLookup()) {
            return true;
        }
        if (StringUtils.isNotBlank((CharSequence)this.dataModel.getFilterCondition())) {
            return true;
        }
        List joinTables = this.dataModel.getJoinTables();
        if (joinTables.stream().map(desc -> desc.getJoin().isLeftJoin()).count() != (long)joinTables.size()) {
            return true;
        }
        if (joinTables.stream().map(desc -> desc.getKind() == NDataModel.TableKind.LOOKUP).count() != (long)joinTables.size()) {
            return true;
        }
        String factTableId = this.dataModel.getRootFactTable().getTableIdentity();
        return this.spanningTree.getLevel0thIndices().stream().anyMatch(index -> index.getEffectiveDimCols().values().stream().anyMatch(col -> !col.getTableRef().getTableIdentity().equalsIgnoreCase(factTableId)) || index.getEffectiveMeasures().values().stream().anyMatch(m -> m.getFunction().getColRefs().stream().anyMatch(col -> !col.getTableRef().getTableIdentity().equalsIgnoreCase(factTableId))));
    }

    public int getFlatTableCoalescePartitionNum() {
        return this.config.getFlatTableCoalescePartitionNum();
    }

    protected void initColumns() {
        if (this.shouldPersistFlatTable()) {
            if (this.config.isIndexColumnFlatTableEnabled()) {
                this.addIndexPlanColumns();
            } else {
                this.addModelColumns();
            }
        } else if (this.isPartialBuild()) {
            this.addIndexPartialBuildColumns();
        } else {
            this.addIndexPlanColumns();
        }
    }

    private void addModelColumns() {
        this.dataModel.getEffectiveDimensions().values().stream().filter(Objects::nonNull).forEach(this::addColumn);
        this.dataModel.getEffectiveMeasures().values().stream().filter(Objects::nonNull).filter(measure -> Objects.nonNull(measure.getFunction())).filter(measure -> Objects.nonNull(measure.getFunction().getColRefs())).flatMap(measure -> measure.getFunction().getColRefs().stream()).forEach(this::addColumn);
    }

    protected void addIndexPartialBuildColumns() {
        Set dimSet = this.spanningTree.getIndices().stream().flatMap(layout -> layout.getDimensions().stream()).collect(Collectors.toSet());
        this.indexPlan.getEffectiveDimCols().entrySet().stream().filter(dimEntry -> dimSet.contains(dimEntry.getKey())).map(Map.Entry::getValue).filter(Objects::nonNull).forEach(this::addColumn);
        Set measureSet = this.spanningTree.getIndices().stream().flatMap(layout -> layout.getMeasures().stream()).collect(Collectors.toSet());
        this.indexPlan.getEffectiveMeasures().entrySet().stream().filter(measureEntry -> measureSet.contains(measureEntry.getKey())).map(Map.Entry::getValue).filter(measure -> Objects.nonNull(measure.getFunction())).filter(measure -> Objects.nonNull(measure.getFunction().getColRefs())).flatMap(measure -> measure.getFunction().getColRefs().stream()).forEach(this::addColumn);
    }

    protected final void addIndexPlanColumns() {
        this.indexPlan.getEffectiveDimCols().values().stream().filter(Objects::nonNull).forEach(this::addColumn);
        this.indexPlan.getEffectiveMeasures().values().stream().filter(Objects::nonNull).filter(measure -> Objects.nonNull(measure.getFunction())).filter(measure -> Objects.nonNull(measure.getFunction().getColRefs())).flatMap(measure -> measure.getFunction().getColRefs().stream()).forEach(this::addColumn);
    }

    protected final void addColumn(TblColRef colRef) {
        if (this.columnIdMap.containsKey(colRef.getIdentity())) {
            return;
        }
        this.columns.add(colRef);
        int id = this.dataModel.getColumnIdByColumnName(colRef.getIdentity());
        Preconditions.checkArgument((id != -1 ? 1 : 0) != 0, (Object)("Column: " + colRef.getIdentity() + " is not in model: " + this.dataModel.getUuid()));
        this.columnIdMap.put(colRef.getIdentity(), id);
        this.columnIds.add(id);
        this.columnId2Canonical.put(id, colRef.getCanonicalName());
        this.canonical2Table.put(colRef.getCanonicalName(), colRef.getTable());
        if (this.kapConfig.isSourceUsageUnwrapComputedColumn() && colRef.getColumnDesc().isComputedColumn()) {
            try {
                this.parser.unwrapComputeColumn(colRef.getExpressionInSourceDB()).forEach(this::addColumn);
            }
            catch (Exception e) {
                log.warn("UnWrap computed column {} in project {} model {} exception", new Object[]{colRef.getExpressionInSourceDB(), this.dataModel.getProject(), this.dataModel.getAlias(), e});
            }
        }
    }
}

