/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.smarter;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.engine.spark.builder.SegmentFlatTable$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.JoinTableDesc;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.ParameterDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.utils.SchemaProcessor$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import scala.Function1;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.SetLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005]d\u0001\u0002\f\u0018\u0001\u0011B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\ti\u0001\u0011\t\u0011)A\u0005[!)Q\u0007\u0001C\u0001m!9!\b\u0001b\u0001\n\u0013Y\u0004B\u0002*\u0001A\u0003%A\bC\u0004T\u0001\t\u0007I\u0011B\u001e\t\rQ\u0003\u0001\u0015!\u0003=\u0011\u001d)\u0006A1A\u0005\nYCaA\u0017\u0001!\u0002\u00139\u0006\"B.\u0001\t\u0003a\u0006\"\u00027\u0001\t\u0003i\u0007\"B.\u0001\t\u0003\u0001\b\"\u0002:\u0001\t\u0013\u0019\bBB@\u0001\t\u0013\t\t\u0001C\u0004\u0002\u000e\u0001!I!a\u0004\t\u000f\u0005E\u0002\u0001\"\u0003\u00024!9\u0011\u0011\t\u0001\u0005\n\u0005\r\u0003bBA&\u0001\u0011\u0005\u0011Q\n\u0005\b\u0003+\u0002A\u0011BA,\u0011\u001d\t\u0019\b\u0001C\u0005\u0003\u0007Bq!!\u001e\u0001\t\u0013\t\u0019EA\u000bJ]\u0012,\u0007\u0010R3qK:$WM\\2z!\u0006\u00148/\u001a:\u000b\u0005aI\u0012aB:nCJ$XM\u001d\u0006\u00035m\tQa\u001d9be.T!\u0001H\u000f\u0002\r\u0015tw-\u001b8f\u0015\tqr$A\u0003ls2LgN\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AI\u0001\u0004_J<7\u0001A\n\u0003\u0001\u0015\u0002\"AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\u0012a!\u00118z%\u00164\u0017!B7pI\u0016dW#A\u0017\u0011\u00059\u0012T\"A\u0018\u000b\u0005-\u0002$BA\u0019\u001e\u0003!iW\r^1eCR\f\u0017BA\u001a0\u0005)qE)\u0019;b\u001b>$W\r\\\u0001\u0007[>$W\r\u001c\u0011\u0002\rqJg.\u001b;?)\t9\u0014\b\u0005\u00029\u00015\tq\u0003C\u0003,\u0007\u0001\u0007Q&A\ndGR\u000b'\r\\3OC6,\u0017\t\\5bg6\u000b\u0007/F\u0001=!\u0011i$\tR(\u000e\u0003yR!a\u0010!\u0002\tU$\u0018\u000e\u001c\u0006\u0002\u0003\u0006!!.\u0019<b\u0013\t\u0019eHA\u0004ICNDW*\u00199\u0011\u0005\u0015ceB\u0001$K!\t9u%D\u0001I\u0015\tI5%\u0001\u0004=e>|GOP\u0005\u0003\u0017\u001e\na\u0001\u0015:fI\u00164\u0017BA'O\u0005\u0019\u0019FO]5oO*\u00111j\n\t\u0004{A#\u0015BA)?\u0005\r\u0019V\r^\u0001\u0015G\u000e$\u0016M\u00197f\u001d\u0006lW-\u00117jCNl\u0015\r\u001d\u0011\u0002#)|\u0017N\u001c+bE2,\u0017\t\\5bg6\u000b\u0007/\u0001\nk_&tG+\u00192mK\u0006c\u0017.Y:NCB\u0004\u0013AD1mYR\u000b'\r\\3t\u00032L\u0017m]\u000b\u0002/B\u0019Q\b\u0017#\n\u0005es$a\u0002%bg\"\u001cV\r^\u0001\u0010C2dG+\u00192mKN\fE.[1tA\u0005)r-\u001a;SK2\fG/\u001a3UC\ndWm]!mS\u0006\u001cHCA/a!\rid\fR\u0005\u0003?z\u0012A\u0001T5ti\")\u0011M\u0003a\u0001E\u00069A.Y=pkR\u001c\bcA\u001fdK&\u0011AM\u0010\u0002\u000b\u0007>dG.Z2uS>t\u0007C\u00014k\u001b\u00059'BA\u0016i\u0015\tI\u0007'\u0001\u0003dk\n,\u0017BA6h\u00051a\u0015-_8vi\u0016sG/\u001b;z\u0003A9W\r\u001e*fY\u0006$X\r\u001a+bE2,7\u000f\u0006\u0002^]\")qn\u0003a\u0001K\u0006aA.Y=pkR,e\u000e^5usR\u0011q*\u001d\u0005\u0006_2\u0001\r!Z\u0001\u000fSN4\u0016\r\\5e\u001b\u0016\f7/\u001e:f)\t!x\u000f\u0005\u0002'k&\u0011ao\n\u0002\b\u0005>|G.Z1o\u0011\u0015AX\u00021\u0001z\u0003\tIG\r\u0005\u0002{{6\t1P\u0003\u0002}\u0001\u0006!A.\u00198h\u0013\tq8PA\u0004J]R,w-\u001a:\u00029\u001d,G\u000fV1cY\u0016LE-\u001a8uSRLWm\u001d$s_6\u001cu\u000e\\;n]R\u0019q+a\u0001\t\u000f\u0005\u0015a\u00021\u0001\u0002\b\u0005\u0019!/\u001a4\u0011\u00079\nI!C\u0002\u0002\f=\u0012\u0011\u0002\u00162m\u0007>d'+\u001a4\u0002/\u001d,g.\u001a:bi\u00164U\u000f\u001c7GY\u0006$H+\u00192mK\u00123ECBA\t\u0003K\ty\u0003\u0005\u0004\u0002\u0014\u0005m\u0011qD\u0007\u0003\u0003+QA!a\u0006\u0002\u001a\u0005\u00191/\u001d7\u000b\u0005iy\u0012\u0002BA\u000f\u0003+\u0011q\u0001R1uCN,G\u000f\u0005\u0003\u0002\u0014\u0005\u0005\u0012\u0002BA\u0012\u0003+\u00111AU8x\u0011\u001d\t9c\u0004a\u0001\u0003S\t!a]:\u0011\t\u0005M\u00111F\u0005\u0005\u0003[\t)B\u0001\u0007Ta\u0006\u00148nU3tg&|g\u000eC\u0003,\u001f\u0001\u0007Q&\u0001\fhK:,'/\u0019;f\t\u0006$\u0018m]3u\u001f:$\u0016M\u00197f)\u0019\t\t\"!\u000e\u00028!9\u0011q\u0005\tA\u0002\u0005%\u0002bBA\u001d!\u0001\u0007\u00111H\u0001\ti\u0006\u0014G.\u001a*fMB\u0019a&!\u0010\n\u0007\u0005}rF\u0001\u0005UC\ndWMU3g\u00039Ig.\u001b;UC\ndWMT1nKN$\"!!\u0012\u0011\u0007\u0019\n9%C\u0002\u0002J\u001d\u0012A!\u00168ji\u0006\u0019RO\\<sCB\u001cu.\u001c9vi\u0016\u001cu\u000e\\;n]R!\u0011qJA)!\u0011i\u0004+a\u0002\t\r\u0005M#\u00031\u0001E\u0003E\u00197-\u00138oKJ,\u0005\u0010\u001d:fgNLwN\\\u0001\u001eS:LGOR5mi\u0016\u00148i\u001c8eSRLwN\u001c+bE2,g*Y7fgR1\u0011QIA-\u0003;Bq!a\u0017\u0014\u0001\u0004\t\t\"\u0001\u0005pe&<\u0017N\u001c#g\u0011\u001d\tyf\u0005a\u0001\u0003C\n\u0011bY8m\r&,G\u000eZ:\u0011\u000b\u0019\n\u0019'a\u001a\n\u0007\u0005\u0015tEA\u0003BeJ\f\u0017\u0010\u0005\u0003\u0002j\u0005=TBAA6\u0015\u0011\ti'!\u0006\u0002\u000bQL\b/Z:\n\t\u0005E\u00141\u000e\u0002\f'R\u0014Xo\u0019;GS\u0016dG-A\u000fj]&$\b+\u0019:uSRLwN\\\"pYVlg\u000eV1cY\u0016t\u0015-\\3t\u0003EIg.\u001b;K_&tG+\u00192mK:\u000bW.\u001a")
public class IndexDependencyParser {
    private final NDataModel model;
    private final HashMap<String, java.util.Set<String>> ccTableNameAliasMap;
    private final HashMap<String, java.util.Set<String>> joinTableAliasMap;
    private final HashSet<String> allTablesAlias;

    public NDataModel model() {
        return this.model;
    }

    private HashMap<String, java.util.Set<String>> ccTableNameAliasMap() {
        return this.ccTableNameAliasMap;
    }

    private HashMap<String, java.util.Set<String>> joinTableAliasMap() {
        return this.joinTableAliasMap;
    }

    private HashSet<String> allTablesAlias() {
        return this.allTablesAlias;
    }

    /*
     * WARNING - void declaration
     */
    public List<String> getRelatedTablesAlias(Collection<LayoutEntity> layouts) {
        void var3_3;
        HashSet relatedTables = Sets.newHashSet();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(layouts).asScala()).foreach((Function1 & Serializable & scala.Serializable)layout -> BoxesRunTime.boxToBoolean((boolean)relatedTables.addAll(this.getRelatedTablesAlias(layout))));
        ArrayList relatedTableList = Lists.newArrayList((Iterable)relatedTables);
        Collections.sort(relatedTableList);
        return var3_3;
    }

    public List<String> getRelatedTables(LayoutEntity layoutEntity) {
        java.util.Set<String> relatedTablesAlias = this.getRelatedTablesAlias(layoutEntity);
        scala.collection.immutable.Set relatedTables = ((TraversableOnce)((SetLike)JavaConverters$.MODULE$.asScalaSetConverter(relatedTablesAlias).asScala()).map((Function1 & Serializable & scala.Serializable)alias -> ((TableRef)this.model().getAliasMap().get(alias)).getTableIdentity(), Set$.MODULE$.canBuildFrom())).toSet();
        ArrayList relatedTableList = Lists.newArrayList((Iterable)((Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)relatedTables).asJava()));
        Collections.sort(relatedTableList);
        return relatedTableList;
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Set<String> getRelatedTablesAlias(LayoutEntity layoutEntity) {
        void var2_2;
        HashSet relatedTablesAlias = Sets.newHashSet(this.allTablesAlias());
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter((List)layoutEntity.getColOrder()).asScala()).foreach((Function1 & Serializable & scala.Serializable)id -> {
            Object object;
            if (Predef$.MODULE$.Integer2int(id) < 100000) {
                TblColRef ref = (TblColRef)this.model().getEffectiveCols().get(id);
                HashSet<String> tablesFromColumn = this.getTableIdentitiesFromColumn(ref);
                object = BoxesRunTime.boxToBoolean((boolean)relatedTablesAlias.addAll(tablesFromColumn));
            } else if (this.isValidMeasure((Integer)id)) {
                java.util.Set tablesFromMeasure = (java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((TraversableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(((MeasureDesc)this.model().getEffectiveMeasures().get(id)).getFunction().getParameters()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)IndexDependencyParser.$anonfun$getRelatedTablesAlias$3(x$1)))).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.getColRef(), Buffer$.MODULE$.canBuildFrom())).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> (scala.collection.mutable.Set)JavaConverters$.MODULE$.asScalaSetConverter(this.getTableIdentitiesFromColumn((TblColRef)x$3)).asScala(), Buffer$.MODULE$.canBuildFrom())).toSet()).asJava();
                object = BoxesRunTime.boxToBoolean((boolean)relatedTablesAlias.addAll(tablesFromMeasure));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        HashSet joinSet = Sets.newHashSet();
        ((IterableLike)JavaConverters$.MODULE$.asScalaSetConverter((java.util.Set)relatedTablesAlias).asScala()).foreach((Function1 & Serializable & scala.Serializable)tableName -> {
            java.util.Set<String> prSets = this.joinTableAliasMap().get(tableName);
            return prSets != null ? BoxesRunTime.boxToBoolean((boolean)joinSet.addAll(prSets)) : BoxedUnit.UNIT;
        });
        relatedTablesAlias.addAll(joinSet);
        return var2_2;
    }

    private boolean isValidMeasure(Integer id) {
        return this.model().getEffectiveMeasures() != null && this.model().getEffectiveMeasures().get((Object)id) != null && ((MeasureDesc)this.model().getEffectiveMeasures().get((Object)id)).getFunction() != null && ((MeasureDesc)this.model().getEffectiveMeasures().get((Object)id)).getFunction().getParameters() != null;
    }

    private HashSet<String> getTableIdentitiesFromColumn(TblColRef ref) {
        ColumnDesc desc = ref.getColumnDesc();
        return desc.isComputedColumn() ? Sets.newHashSet((Iterable)this.ccTableNameAliasMap().get(ref.getName())) : Sets.newHashSet((Object[])new String[]{ref.getTableAlias()});
    }

    private Dataset<Row> generateFullFlatTableDF(SparkSession ss, NDataModel model) {
        Dataset<Row> rootDF = this.generateDatasetOnTable(ss, model.getRootFactTable());
        LinkedHashMap joinTableDFMap = (LinkedHashMap)LinkedHashMap$.MODULE$.apply((Seq)Nil$.MODULE$);
        ((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(model.getJoinTables()).asScala()).map((Function1 & Serializable & scala.Serializable)joinTable -> joinTableDFMap.put(joinTable, this.generateDatasetOnTable(ss, joinTable.getTableRef())), Buffer$.MODULE$.canBuildFrom());
        Dataset<Row> df = SegmentFlatTable$.MODULE$.joinFactTableWithLookupTables(rootDF, (scala.collection.mutable.Map<JoinTableDesc, Dataset<Row>>)joinTableDFMap, model, ss);
        Object object = StringUtils.isNotEmpty((CharSequence)model.getFilterCondition()) ? df.where(NSparkCubingUtil.convertFromDotWithBackTick((String)model.getFilterCondition())) : BoxedUnit.UNIT;
        return df;
    }

    private Dataset<Row> generateDatasetOnTable(SparkSession ss, TableRef tableRef) {
        ColumnDesc[] tableCols = (ColumnDesc[])((TraversableOnce)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(tableRef.getColumns()).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getColumnDesc(), Iterable$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)IndexDependencyParser.$anonfun$generateDatasetOnTable$2(x$5)))).toArray(ClassTag$.MODULE$.apply(ColumnDesc.class));
        StructType structType = SchemaProcessor$.MODULE$.buildSchemaWithRawTable(tableCols);
        String alias = tableRef.getAlias();
        Dataset dataset = ss.createDataFrame((List)Lists.newArrayList(), structType).alias(alias);
        return SegmentFlatTable$.MODULE$.wrapAlias((Dataset<Row>)dataset, alias);
    }

    private void initTableNames() {
        List ccList = this.model().getComputedColumnDescs();
        Dataset<Row> originDf = this.generateFullFlatTableDF(SparderEnv$.MODULE$.getSparkSession(), this.model());
        StructField[] colFields = originDf.schema().fields();
        Dataset ds = originDf.selectExpr((Seq)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ccList).asScala()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.getInnerExpression(), Buffer$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$1 -> NSparkCubingUtil.convertFromDotWithBackTick((String)x$1), Buffer$.MODULE$.canBuildFrom()));
        ((IterableLike)((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(ccList).asScala()).zip((GenIterable)Predef$.MODULE$.wrapRefArray((Object[])ds.schema().fields()), Buffer$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)pair -> {
            IndexDependencyParser.$anonfun$initTableNames$3(this, colFields, pair);
            return BoxedUnit.UNIT;
        });
        this.initFilterConditionTableNames(originDf, colFields);
        this.initPartitionColumnTableNames();
        this.initJoinTableName();
        this.allTablesAlias().add(this.model().getRootFactTable().getAlias());
    }

    /*
     * WARNING - void declaration
     */
    public java.util.Set<TblColRef> unwrapComputeColumn(String ccInnerExpression) {
        void var2_2;
        HashSet result = Sets.newHashSet();
        Dataset<Row> originDf = this.generateFullFlatTableDF(SparderEnv$.MODULE$.getSparkSession(), this.model());
        StructField[] colFields = originDf.schema().fields();
        Dataset ccDs = originDf.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{NSparkCubingUtil.convertFromDotWithBackTick((String)ccInnerExpression)}));
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])ccDs.schema().fields())).foreach((Function1 & Serializable & scala.Serializable)fieldName -> {
            IndexDependencyParser.$anonfun$unwrapComputeColumn$1(this, colFields, result, fieldName);
            return BoxedUnit.UNIT;
        });
        return var2_2;
    }

    private void initFilterConditionTableNames(Dataset<Row> originDf, StructField[] colFields) {
        block0: {
            if (!StringUtils.isNotEmpty((CharSequence)this.model().getFilterCondition())) break block0;
            Dataset whereDs = originDf.selectExpr((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{NSparkCubingUtil.convertFromDotWithBackTick((String)this.model().getFilterCondition().replace("\"", "`"))}));
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])whereDs.schema().fields())).foreach((Function1 & Serializable & scala.Serializable)whereField -> {
                IndexDependencyParser.$anonfun$initFilterConditionTableNames$1(this, colFields, whereField);
                return BoxedUnit.UNIT;
            });
        }
    }

    private void initPartitionColumnTableNames() {
        block0: {
            if (this.model().getPartitionDesc() == null || this.model().getPartitionDesc().getPartitionDateColumnRef() == null) break block0;
            this.allTablesAlias().addAll(this.getTableIdentitiesFromColumn(this.model().getPartitionDesc().getPartitionDateColumnRef()));
        }
    }

    private void initJoinTableName() {
        if (CollectionUtils.isEmpty((Collection)this.model().getJoinTables())) {
            return;
        }
        HashMap pkTableToFkTableAliasMap = Maps.newHashMap();
        ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(this.model().getJoinTables()).asScala()).foreach((Function1 & Serializable & scala.Serializable)joinTable -> {
            Object object;
            if (joinTable.getJoin().getPKSide() != null && joinTable.getJoin().getFKSide() != null) {
                String pkTableAlias = joinTable.getJoin().getPKSide().getAlias();
                String fkTableAlias = joinTable.getJoin().getFKSide().getAlias();
                object = pkTableToFkTableAliasMap.put(pkTableAlias, fkTableAlias);
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
        ((IterableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter((Map)pkTableToFkTableAliasMap).asScala()).foreach((Function1 & Serializable & scala.Serializable)tableAliasPair -> {
            String pkTableAlias = (String)tableAliasPair._1();
            String fkTableAlias = (String)tableAliasPair._2();
            java.util.Set<String> dependencyTableSet = this.joinTableAliasMap().getOrDefault(pkTableAlias, Sets.newHashSet());
            while (fkTableAlias != null) {
                dependencyTableSet.add(fkTableAlias);
                fkTableAlias = (String)pkTableToFkTableAliasMap.get(fkTableAlias);
            }
            return this.joinTableAliasMap().putIfAbsent(pkTableAlias, dependencyTableSet);
        });
    }

    public static final /* synthetic */ boolean $anonfun$getRelatedTablesAlias$3(ParameterDesc x$1) {
        String string = x$1.getType();
        String string2 = "column";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$generateDatasetOnTable$2(ColumnDesc x$5) {
        return !x$5.isComputedColumn();
    }

    public static final /* synthetic */ void $anonfun$initTableNames$3(IndexDependencyParser $this, StructField[] colFields$1, Tuple2 pair) {
        String ccFieldName = ((StructField)pair._2()).name();
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colFields$1)).foreach((Function1 & Serializable & scala.Serializable)col -> {
            Object object;
            if (ccFieldName.contains(col.name())) {
                String tableName = col.name().substring(0, col.name().indexOf("_0_DOT_0_"));
                java.util.Set<String> tableSet = $this.ccTableNameAliasMap().getOrDefault(((ComputedColumnDesc)pair._1()).getColumnName(), Sets.newHashSet());
                tableSet.add(((TableRef)$this.model().getTableNameMap().get(tableName)).getAlias());
                object = $this.ccTableNameAliasMap().put(((ComputedColumnDesc)pair._1()).getColumnName(), tableSet);
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public static final /* synthetic */ void $anonfun$unwrapComputeColumn$1(IndexDependencyParser $this, StructField[] colFields$2, java.util.Set result$1, StructField fieldName) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colFields$2)).foreach((Function1 & Serializable & scala.Serializable)col -> {
            Object object;
            if (StringUtils.containsIgnoreCase((CharSequence)fieldName.name(), (CharSequence)col.name())) {
                String[] tableAndCol = col.name().split("_0_DOT_0_");
                TblColRef ref = $this.model().findColumn(tableAndCol[0], tableAndCol[1]);
                object = ref != null ? BoxesRunTime.boxToBoolean((boolean)result$1.add(ref)) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public static final /* synthetic */ void $anonfun$initFilterConditionTableNames$1(IndexDependencyParser $this, StructField[] colFields$3, StructField whereField) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])colFields$3)).foreach((Function1 & Serializable & scala.Serializable)colField -> {
            Object object;
            if (whereField.name().contains(colField.name())) {
                String tableName = colField.name().substring(0, colField.name().indexOf("_0_DOT_0_"));
                object = BoxesRunTime.boxToBoolean((boolean)$this.allTablesAlias().add(((TableRef)$this.model().getTableNameMap().get(tableName)).getAlias()));
            } else {
                object = BoxedUnit.UNIT;
            }
            return object;
        });
    }

    public IndexDependencyParser(NDataModel model) {
        this.model = model;
        this.ccTableNameAliasMap = Maps.newHashMap();
        this.joinTableAliasMap = Maps.newHashMap();
        this.allTablesAlias = Sets.newHashSet();
        this.initTableNames();
    }
}

