/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.source;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Locale;
import java.util.Map;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.NSparkCubingEngine;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.kylin.engine.spark.stats.utils.HiveTableRefChecker;
import org.apache.kylin.engine.spark.utils.HiveTransactionTableHelper;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.SparderTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkCubingSourceInput
implements NSparkCubingEngine.NSparkCubingSource {
    private static final Logger logger = LoggerFactory.getLogger(NSparkCubingSourceInput.class);

    @Override
    public Dataset<Row> getSourceData(TableDesc table, SparkSession ss, Map<String, String> params) {
        ColumnDesc[] columnDescs = table.getColumns();
        ArrayList tblColNames = Lists.newArrayListWithCapacity((int)columnDescs.length);
        StructType kylinSchema = new StructType();
        for (ColumnDesc columnDesc : columnDescs) {
            if (columnDesc.isComputedColumn()) continue;
            kylinSchema = kylinSchema.add(columnDesc.getName(), SparderTypeUtil.toSparkType((DataType)columnDesc.getType(), (boolean)false), true);
            tblColNames.add("`" + columnDesc.getName() + "`");
        }
        Object[] colNames = tblColNames.toArray(new String[0]);
        String colString = Joiner.on((String)",").join(colNames);
        KylinConfig kylinConfig = KylinBuildEnv.get().kylinConfig();
        logger.info("isRangePartition:{};isTransactional:{};isReadTransactionalTableEnabled:{}", new Object[]{table.isRangePartition(), table.isTransactional(), kylinConfig.isReadTransactionalTableEnabled()});
        String sql = HiveTableRefChecker.isNeedCreateHiveTemporaryTable(table.isRangePartition(), table.isTransactional(), kylinConfig.isReadTransactionalTableEnabled()) ? HiveTransactionTableHelper.doGetQueryHiveTemporaryTableSql(table, params, colString, KylinBuildEnv.get()) : String.format(Locale.ROOT, "select %s from %s", colString, table.getBackTickIdentity());
        Dataset df = ss.sql(sql);
        StructType sparkSchema = df.schema();
        logger.debug("Source data sql is: {}", (Object)sql);
        logger.debug("Kylin schema: {}", (Object)kylinSchema.treeString());
        return df.select(SparderTypeUtil.alignDataTypeAndName((StructType)sparkSchema, (StructType)kylinSchema));
    }
}

