/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.source;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.net.URI;
import java.net.URLStreamHandlerFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.jnet.Installer;
import org.apache.hadoop.fs.FsUrlStreamHandlerFactory;
import org.apache.kylin.engine.spark.source.NSparkTableMeta;
import org.apache.kylin.engine.spark.source.NSparkTableMetaBuilder;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.catalog.CatalogTable;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.catalog.SessionCatalog;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Option;
import scala.collection.JavaConversions;
import scala.collection.Map;
import scala.collection.Seq;

public class NSparkTableMetaExplorer
implements Serializable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkTableMetaExplorer.class);
    private static final List<String> UNSUPOORT_TYPE = Lists.newArrayList((Object[])new String[]{"array", "map", "struct", "binary"});
    private static final String CHAR_VARCHAR_TYPE_STRING_METADATA_KEY = "__CHAR_VARCHAR_TYPE_STRING";
    public static final String S3_ROLE_PROPERTY_KEY = "role";
    public static final String S3_ENDPOINT_PROPERTY_KEY = "s3_endpoint";

    public NSparkTableMeta getSparkTableMeta(String database, String tableName) {
        SessionCatalog catalog = SparderEnv.getSparkSession().sessionState().catalog();
        TableIdentifier tableIdentifier = TableIdentifier.apply((String)tableName, (Option)Option.apply((Object)(database.isEmpty() ? null : database)));
        CatalogTable tableMetadata = catalog.getTempViewOrPermanentTableMetadata(tableIdentifier);
        this.checkTableIsValid(tableMetadata, tableIdentifier, tableName);
        return this.getSparkTableMeta(tableName, tableMetadata);
    }

    public Set<String> checkAndGetTablePartitions(String database, String tableName, String partitionCol) {
        String firstPartCol;
        SessionCatalog catalog = SparderEnv.getSparkSession().sessionState().catalog();
        TableIdentifier tableIdentifier = TableIdentifier.apply((String)tableName, (Option)Option.apply((Object)(database.isEmpty() ? null : database)));
        CatalogTable tableMetadata = catalog.getTempViewOrPermanentTableMetadata(tableIdentifier);
        String string = firstPartCol = tableMetadata.partitionColumnNames().isEmpty() ? null : ((String)tableMetadata.partitionColumnNames().head()).toLowerCase(Locale.ROOT);
        if (!partitionCol.equalsIgnoreCase(firstPartCol)) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "table partition col %s not match col %s", firstPartCol, partitionCol));
        }
        return JavaConversions.seqAsJavaList((Seq)catalog.listPartitions(tableIdentifier, Option.empty())).stream().map(item -> JavaConversions.mapAsJavaMap((Map)item.spec()).entrySet().stream().filter(entry -> partitionCol.equalsIgnoreCase((String)entry.getKey())).findFirst().map(Map.Entry::getValue).orElse(null)).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private NSparkTableMeta getSparkTableMeta(String tableName, CatalogTable tableMetadata) {
        Option uriOption;
        NSparkTableMetaBuilder builder = new NSparkTableMetaBuilder();
        builder.setTableName(tableName);
        builder.setAllColumns(this.getColumns(tableMetadata, tableMetadata.schema()));
        builder.setOwner(tableMetadata.owner());
        builder.setCreateTime(tableMetadata.createTime() + "");
        builder.setLastAccessTime(tableMetadata.lastAccessTime() + "");
        builder.setTableType(tableMetadata.tableType().name());
        builder.setPartitionColumns(this.getColumns(tableMetadata, tableMetadata.partitionSchema()));
        builder.setIsRangePartition(this.isRangePartition(tableMetadata));
        if (tableMetadata.storage().inputFormat().isDefined()) {
            builder.setSdInputFormat((String)tableMetadata.storage().inputFormat().get());
        }
        if (tableMetadata.storage().outputFormat().isDefined()) {
            builder.setSdOutputFormat((String)tableMetadata.storage().outputFormat().get());
        }
        if ((uriOption = tableMetadata.storage().locationUri()).isDefined()) {
            builder.setSdLocation(((URI)uriOption.get()).toString());
        }
        if (tableMetadata.provider().isDefined()) {
            builder.setProvider((String)tableMetadata.provider().get());
        }
        if (tableMetadata.properties().contains((Object)"totalSize")) {
            builder.setFileSize(Long.parseLong((String)tableMetadata.properties().get((Object)"totalSize").get()));
        }
        if (tableMetadata.properties().contains((Object)"numFiles")) {
            builder.setFileNum(Long.parseLong((String)tableMetadata.properties().get((Object)"numFiles").get()));
        }
        if (tableMetadata.properties().contains((Object)"transactional")) {
            builder.setIsTransactional(Boolean.parseBoolean((String)tableMetadata.properties().get((Object)"transactional").get()));
        }
        if (tableMetadata.properties().contains((Object)S3_ROLE_PROPERTY_KEY)) {
            builder.setS3Role((String)tableMetadata.properties().get((Object)S3_ROLE_PROPERTY_KEY).get());
        }
        if (tableMetadata.properties().contains((Object)S3_ENDPOINT_PROPERTY_KEY)) {
            builder.setS3Endpoint((String)tableMetadata.properties().get((Object)S3_ENDPOINT_PROPERTY_KEY).get());
        }
        return builder.createSparkTableMeta();
    }

    private List<NSparkTableMeta.SparkTableColumnMeta> getColumns(CatalogTable tableMetadata, StructType schema) {
        return this.getColumns(tableMetadata, schema, true);
    }

    private List<NSparkTableMeta.SparkTableColumnMeta> getColumns(CatalogTable tableMetadata, StructType schema, boolean isCheckRepeatColumn) {
        ArrayList allColumns = Lists.newArrayListWithCapacity((int)schema.size());
        HashSet columnCacheTemp = Sets.newHashSet();
        for (StructField field : schema.fields()) {
            String type = field.dataType().simpleString();
            if (field.metadata().contains(CHAR_VARCHAR_TYPE_STRING_METADATA_KEY)) {
                type = field.metadata().getString(CHAR_VARCHAR_TYPE_STRING_METADATA_KEY);
            }
            String finalType = type;
            if (UNSUPOORT_TYPE.stream().anyMatch(finalType::contains)) {
                logger.info("Load table {} ignore column {}:{}", new Object[]{tableMetadata.identifier().identifier(), field.name(), finalType});
                continue;
            }
            if (isCheckRepeatColumn && columnCacheTemp.contains(field.name())) {
                logger.info("The\u3010{}\u3011column is already included and does not need to be added again", (Object)field.name());
                continue;
            }
            columnCacheTemp.add(field.name());
            allColumns.add(new NSparkTableMeta.SparkTableColumnMeta(field.name(), type, field.getComment().isDefined() ? (String)field.getComment().get() : null));
        }
        return allColumns;
    }

    private void checkTableIsValid(CatalogTable tableMetadata, TableIdentifier tableIdentifier, String tableName) {
        if (CatalogTableType.VIEW().equals((Object)tableMetadata.tableType())) {
            try {
                Installer.setURLStreamHandlerFactory((URLStreamHandlerFactory)new FsUrlStreamHandlerFactory());
                SparderEnv.getSparkSession().table(tableIdentifier).queryExecution().analyzed();
            }
            catch (Throwable e) {
                logger.error("Error for parser view: " + tableName, e);
                throw new RuntimeException("Error for parser view: " + tableName + ", " + e.getMessage() + "(There are maybe syntactic differences between HIVE and SparkSQL)", e);
            }
        }
    }

    private Boolean isRangePartition(CatalogTable tableMetadata) {
        List<NSparkTableMeta.SparkTableColumnMeta> allColumns = this.getColumns(tableMetadata, tableMetadata.schema(), false);
        return allColumns.stream().collect(Collectors.groupingBy(p -> p.name)).values().stream().anyMatch(p -> p.size() > 1);
    }

    static enum PROVIDER {
        HIVE("hive"),
        UNSPECIFIED("");

        private static final PROVIDER[] ALL;
        private String value;

        private PROVIDER(String value) {
            this.value = value;
        }

        public static PROVIDER fromString(Option<String> value) {
            if (value.isEmpty()) {
                return UNSPECIFIED;
            }
            for (PROVIDER provider : ALL) {
                if (!provider.value.equals(value.get())) continue;
                return provider;
            }
            return UNSPECIFIED;
        }

        static {
            ALL = new PROVIDER[]{HIVE};
        }
    }
}

