/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.source;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.analysis.UnresolvedRelation;
import org.apache.spark.sql.catalyst.catalog.CatalogTableType;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import scala.collection.JavaConverters;
import scala.collection.Seq;

public class SparkSqlUtil {
    public static Dataset<Row> query(SparkSession ss, String sql) {
        return ss.sql(sql);
    }

    public static List<Row> queryForList(SparkSession ss, String sql) {
        return ss.sql(sql).collectAsList();
    }

    public static List<Row> queryAll(SparkSession ss, String table) {
        String sql = String.format(Locale.ROOT, "select * from %s", table);
        return SparkSqlUtil.queryForList(ss, sql);
    }

    public static Set<String> getViewOrignalTables(String viewName, SparkSession spark) throws AnalysisException {
        String viewText = ((Row)spark.sql("desc formatted " + viewName).where("col_name = 'View Text'").head()).getString(1);
        LogicalPlan logicalPlan = spark.sessionState().sqlParser().parsePlan(viewText);
        HashSet viewTables = Sets.newHashSet();
        for (Object l : (List)JavaConverters.seqAsJavaListConverter((Seq)logicalPlan.collectLeaves()).asJava()) {
            if (!(l instanceof UnresolvedRelation)) continue;
            String tableName = ((UnresolvedRelation)l).tableName();
            int size = ((UnresolvedRelation)l).multipartIdentifier().size();
            if (size > 2 || !spark.catalog().tableExists(tableName)) {
                viewTables.add(tableName);
                continue;
            }
            if (spark.catalog().getTable(tableName).tableType().equals(CatalogTableType.VIEW().name())) {
                viewTables.addAll(SparkSqlUtil.getViewOrignalTables(tableName, spark));
                continue;
            }
            viewTables.add(tableName);
        }
        return viewTables;
    }
}

