/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.QueryErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.engine.spark.builder.CreateFlatTable;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.metadata.model.BadModelException;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.ComputedColumnDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.model.exception.IllegalCCExpressionException;
import org.apache.spark.sql.AnalysisException;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparderEnv;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.execution.utils.SchemaProcessor;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.util.SparderTypeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class ComputedColumnEvalUtil {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputedColumnEvalUtil.class);
    private static final int MAX_RENAME_CC_TIME = 99;

    private ComputedColumnEvalUtil() {
        throw new IllegalAccessError();
    }

    public static void evaluateExprAndTypeBatch(NDataModel nDataModel, List<ComputedColumnDesc> computedColumns) {
        ComputedColumnEvalUtil.evalDataTypeOfCCInAuto(computedColumns, nDataModel, 0, computedColumns.size());
        computedColumns.removeIf(cc -> cc.getDatatype().equals("ANY"));
    }

    public static void evaluateExprAndType(NDataModel nDataModel, ComputedColumnDesc computedColumn) {
        ComputedColumnEvalUtil.evalDataTypeOfCCInManual(Collections.singletonList(computedColumn), nDataModel, 0, 1);
    }

    public static void evalDataTypeOfCCInAuto(List<ComputedColumnDesc> computedColumns, NDataModel nDataModel, int start, int end) {
        try {
            ComputedColumnEvalUtil.evalDataTypeOfCC(computedColumns, SparderEnv.getSparkSession(), nDataModel, start, end);
        }
        catch (Exception e) {
            if (end - start > 1) {
                ComputedColumnEvalUtil.evalDataTypeOfCCInAuto(computedColumns, nDataModel, start, start + (end - start) / 2);
                ComputedColumnEvalUtil.evalDataTypeOfCCInAuto(computedColumns, nDataModel, start + (end - start) / 2, end);
            }
            computedColumns.get(start).setDatatype("ANY");
            log.info("Discard the computed column {} for {}", (Object)computedColumns.get(start).getInnerExpression(), (Object)e.getMessage());
        }
    }

    public static void evalDataTypeOfCCInBatch(NDataModel nDataModel, List<ComputedColumnDesc> computedColumns) {
        if (CollectionUtils.isEmpty(computedColumns)) {
            return;
        }
        try {
            ComputedColumnEvalUtil.evalDataTypeOfCC(computedColumns, SparderEnv.getSparkSession(), nDataModel, 0, computedColumns.size());
        }
        catch (AnalysisException e) {
            ComputedColumnEvalUtil.evalDataTypeOfCCInManual(computedColumns, nDataModel, 0, computedColumns.size());
        }
    }

    private static void evalDataTypeOfCCInManual(List<ComputedColumnDesc> computedColumns, NDataModel nDataModel, int start, int end) {
        for (int i = start; i < end; ++i) {
            try {
                ComputedColumnEvalUtil.evalDataTypeOfCC(computedColumns, SparderEnv.getSparkSession(), nDataModel, i, i + 1);
                continue;
            }
            catch (AnalysisException e) {
                Preconditions.checkNotNull((Object)computedColumns.get(i));
                throw new IllegalCCExpressionException((ErrorCodeSupplier)QueryErrorCode.CC_EXPRESSION_ILLEGAL, String.format(Locale.ROOT, MsgPicker.getMsg().getCheckCCExpression(), computedColumns.get(i).getTableAlias() + "." + computedColumns.get(i).getColumnName(), computedColumns.get(i).getExpression()));
            }
        }
    }

    private static void evalDataTypeOfCC(List<ComputedColumnDesc> computedColumns, SparkSession ss, NDataModel nDataModel, int start, int end) throws AnalysisException {
        Dataset<Row> originDf = ComputedColumnEvalUtil.generateFullFlatTableDF(ss, nDataModel);
        originDf.persist();
        Dataset ds = originDf.selectExpr((String[])computedColumns.subList(start, end).stream().map(ComputedColumnDesc::getInnerExpression).map(NSparkCubingUtil::convertFromDotWithBackTick).toArray(String[]::new));
        for (int i = start; i < end; ++i) {
            String dataType = SparderTypeUtil.convertSparkTypeToSqlType((DataType)ds.schema().fields()[i - start].dataType());
            computedColumns.get(i).setDatatype(dataType);
        }
    }

    private static Dataset<Row> generateFullFlatTableDF(SparkSession ss, NDataModel model) {
        Dataset<Row> rootDF = ComputedColumnEvalUtil.generateDatasetOnTable(ss, model.getRootFactTable());
        LinkedHashMap joinTableDFMap = Maps.newLinkedHashMap();
        model.getJoinTables().forEach(joinTable -> joinTableDFMap.put(joinTable, ComputedColumnEvalUtil.generateDatasetOnTable(ss, joinTable.getTableRef())));
        return CreateFlatTable.joinFactTableWithLookupTables(rootDF, joinTableDFMap, model, ss);
    }

    private static Dataset<Row> generateDatasetOnTable(SparkSession ss, TableRef tableRef) {
        ColumnDesc[] tableCols = (ColumnDesc[])tableRef.getColumns().stream().map(TblColRef::getColumnDesc).filter(col -> !col.isComputedColumn()).toArray(ColumnDesc[]::new);
        StructType structType = SchemaProcessor.buildSchemaWithRawTable((ColumnDesc[])tableCols);
        String alias = tableRef.getAlias();
        Dataset dataset = ss.createDataFrame((List)Lists.newArrayList(), structType).alias(alias);
        return CreateFlatTable.changeSchemaToAliasDotName((Dataset<Row>)dataset, alias);
    }

    public static boolean resolveCCName(ComputedColumnDesc ccDesc, NDataModel dataModel, List<NDataModel> otherModels) {
        int retryCount = 0;
        while (retryCount < 99) {
            ++retryCount;
            try {
                dataModel.initComputedColumnsFailFast(otherModels);
                return true;
            }
            catch (BadModelException e) {
                switch (e.getCauseType()) {
                    case SAME_NAME_DIFF_EXPR: 
                    case WRONG_POSITION_DUE_TO_NAME: 
                    case SELF_CONFLICT_WITH_SAME_NAME: {
                        String ccName = ccDesc.getColumnName();
                        ccDesc.setColumnName(ComputedColumnEvalUtil.incrementIndex(ccName));
                        break;
                    }
                    case SAME_EXPR_DIFF_NAME: {
                        ccDesc.setColumnName(e.getAdvise());
                        break;
                    }
                    case WRONG_POSITION_DUE_TO_EXPR: 
                    case LOOKUP_CC_NOT_REFERENCING_ITSELF: 
                    case SELF_CONFLICT_WITH_SAME_EXPRESSION: {
                        log.debug("Bad CC suggestion: {}", (Object)ccDesc.getExpression(), (Object)e);
                        retryCount = 99;
                        break;
                    }
                }
            }
            catch (Exception e) {
                log.debug("When resolving the name of computed column {}, model {} initializing failed.", new Object[]{ccDesc, dataModel.getUuid(), e});
                break;
            }
        }
        return false;
    }

    private static String incrementIndex(String oldAlias) {
        int idx;
        if (oldAlias == null || !oldAlias.startsWith("CC_AUTO_") || oldAlias.equals("CC_AUTO_")) {
            return "CC_AUTO_1";
        }
        String idxStr = oldAlias.substring("CC_AUTO_".length());
        try {
            idx = Integer.parseInt(idxStr);
        }
        catch (NumberFormatException e) {
            return "CC_AUTO_1";
        }
        return "CC_AUTO_" + ++idx;
    }
}

