/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import com.google.common.base.Throwables;
import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.util.CliCommandExecutor;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.ShellException;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.PartitionDesc;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.source.hive.HiveCmdBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HiveTransactionTableHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HiveTransactionTableHelper.class);
    private static final String QUOTE = "`";

    private HiveTransactionTableHelper() {
    }

    public static String doGetQueryHiveTemporaryTableSql(TableDesc table, Map<String, String> params, String colString, KylinBuildEnv kylinBuildEnv) {
        String sql = "";
        String jobId = kylinBuildEnv.buildJobInfos().getJobId();
        String project = kylinBuildEnv.buildJobInfos().getProject();
        KylinConfig kylinConfig = kylinBuildEnv.kylinConfig();
        String dir = kylinConfig.getJobTmpTransactionalTableDir(project, jobId);
        String tableSuffix = StringUtils.replace((String)StringUtils.substring((String)jobId, (int)0, (int)13), (String)"-", (String)"");
        String tempTableName = table.getTransactionalTableIdentity().concat(tableSuffix);
        String tempBackTickTableName = table.getBackTickTransactionalTableIdentity(tableSuffix);
        String tableDir = HiveTransactionTableHelper.getTableDir(tempTableName, dir);
        HiveTransactionTableHelper.checkInterTableExistFirst(table, params, kylinBuildEnv, jobId, dir, tableSuffix, tempTableName, tableDir);
        sql = HiveTransactionTableHelper.checkInterTableExistSecondAndGetSql(table, params, colString, jobId, tempBackTickTableName, tableDir);
        return sql;
    }

    public static String checkInterTableExistSecondAndGetSql(TableDesc table, Map<String, String> params, String colString, String jobId, String tempTableName, String tableDir) {
        boolean secondCheck = HiveTransactionTableHelper.checkInterTableExist(tableDir);
        log.info("second check is table ready : {} ", (Object)secondCheck);
        if (secondCheck) {
            log.info("table ready,start build sql");
            String queryCondition = HiveTransactionTableHelper.generateTxTableQueryCondition(table, params);
            return String.format(Locale.ROOT, "select %s from %s %s", colString, tempTableName, queryCondition);
        }
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.READ_TRANSACTIONAL_TBALE_FAILED, String.format(Locale.ROOT, "Can't read transactional table, jobId %s.", jobId));
    }

    public static void checkInterTableExistFirst(TableDesc table, Map<String, String> params, KylinBuildEnv kylinBuildEnv, String jobId, String dir, String tableSuffix, String tempTableName, String tableDir) {
        boolean firstCheck = HiveTransactionTableHelper.checkInterTableExist(tableDir);
        log.info("first check is table ready : {} ", (Object)firstCheck);
        if (!firstCheck) {
            try {
                HiveTransactionTableHelper.createHiveTableDirIfNeeded(dir, tempTableName);
            }
            catch (IOException ioException) {
                log.error(ServerErrorCode.READ_TRANSACTIONAL_TBALE_FAILED.name(), (Throwable)ioException);
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.READ_TRANSACTIONAL_TBALE_FAILED, String.format(Locale.ROOT, "Can't create hive table dir, jobId %s.", jobId));
            }
            HiveTransactionTableHelper.generateTxTable(kylinBuildEnv, table, tableSuffix, params, tableDir);
        }
    }

    private static String doQuote(String identifier) {
        return QUOTE + identifier + QUOTE;
    }

    public static String generateHiveInitStatements(String flatTableDatabase) {
        if (StringUtils.isEmpty((String)flatTableDatabase)) {
            log.info("database name is empty.");
            return "";
        }
        return "USE " + HiveTransactionTableHelper.doQuote(flatTableDatabase) + ";\n";
    }

    public static String generateInsertDataStatement(ColumnDesc[] columnDescs, String originTable, String interTable, String queryCondition) {
        String sep = "\n";
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT\n");
        for (int i = 0; i < columnDescs.length; ++i) {
            ColumnDesc col = columnDescs[i];
            if (i > 0) {
                sql.append(",");
            }
            sql.append(HiveTransactionTableHelper.doQuote(col.getName())).append("\n");
        }
        sql.append("FROM ").append(HiveTransactionTableHelper.doQuote(originTable)).append(" ").append(queryCondition).append("\n");
        return "INSERT OVERWRITE TABLE " + HiveTransactionTableHelper.doQuote(interTable) + " " + sql.toString() + ";\n";
    }

    public static String getCreateTableStatement(String originTable, String interTable, ColumnDesc[] columnDescs, String tableDir, String storageFormat, String fieldDelimiter, String queryCondition) {
        return HiveTransactionTableHelper.generateDropTableStatement(interTable) + HiveTransactionTableHelper.generateCreateTableStatement(interTable, tableDir, columnDescs, storageFormat, fieldDelimiter) + HiveTransactionTableHelper.generateInsertDataStatement(columnDescs, originTable, interTable, queryCondition);
    }

    public static String generateDropTableStatement(String interTable) {
        return "DROP TABLE IF EXISTS " + HiveTransactionTableHelper.doQuote(interTable) + ";\n";
    }

    public static String generateCreateTableStatement(String interTable, String tableDir, ColumnDesc[] columnDescs, String storageFormat, String fieldDelimiter) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("CREATE EXTERNAL TABLE IF NOT EXISTS ").append(HiveTransactionTableHelper.doQuote(interTable)).append("\n");
        ddl.append("(\n");
        for (int i = 0; i < columnDescs.length; ++i) {
            ColumnDesc col = columnDescs[i];
            if (i > 0) {
                ddl.append(",");
            }
            ddl.append(HiveTransactionTableHelper.doQuote(col.getName())).append(" ").append(HiveTransactionTableHelper.getHiveDataType(col.getDatatype())).append("\n");
        }
        ddl.append(")\n");
        if ("TEXTFILE".equalsIgnoreCase(storageFormat)) {
            ddl.append("ROW FORMAT DELIMITED FIELDS TERMINATED BY '").append(StringEscapeUtils.escapeJava((String)fieldDelimiter)).append("'\n");
        }
        ddl.append("STORED AS ").append(storageFormat).append("\n");
        ddl.append("LOCATION '").append(tableDir).append("';").append("\n");
        ddl.append("ALTER TABLE ").append(HiveTransactionTableHelper.doQuote(interTable)).append(" SET TBLPROPERTIES('auto.purge'='true');\n");
        return ddl.toString();
    }

    public static String getTableDir(String tableName, String storageDfsDir) {
        if (storageDfsDir.endsWith("/")) {
            return storageDfsDir.concat(tableName);
        }
        return storageDfsDir.concat("/").concat(tableName);
    }

    public static String getHiveDataType(String javaDataType) {
        String originDataType = javaDataType.toLowerCase(Locale.ROOT);
        String hiveDataType = originDataType.startsWith("varchar") ? "string" : (originDataType.startsWith("integer") ? "int" : (originDataType.startsWith("bigint") ? "bigint" : originDataType));
        return hiveDataType;
    }

    static boolean checkInterTableExist(String tableDir) {
        try {
            log.info("check intermediate table dir : {}", (Object)tableDir);
            Path path = new Path(tableDir);
            FileSystem fs = HadoopUtil.getWorkingFileSystem();
            if (fs.exists(path)) {
                return true;
            }
        }
        catch (IOException e) {
            Throwables.propagate((Throwable)e);
        }
        return false;
    }

    public static void generateTxTable(KylinBuildEnv kylinBuildEnv, TableDesc table, String tableSuffix, Map<String, String> params, String tableDir) {
        String jobId = kylinBuildEnv.buildJobInfos().getJobId();
        log.info("job wait for generate intermediate table, job id : {}", (Object)jobId);
        KylinConfig config = kylinBuildEnv.kylinConfig();
        String database = table.getCaseSensitiveDatabase().endsWith("null") ? "default" : table.getCaseSensitiveDatabase();
        ColumnDesc[] filtered = (ColumnDesc[])Arrays.stream(table.getColumns()).filter(t -> !t.isComputedColumn()).toArray(ColumnDesc[]::new);
        String queryCondition = HiveTransactionTableHelper.generateTxTableQueryCondition(table, params);
        HiveCmdBuilder hiveCmdBuilder = new HiveCmdBuilder(config);
        hiveCmdBuilder.addStatement(HiveTransactionTableHelper.generateHiveInitStatements(database));
        String createTableStatement = HiveTransactionTableHelper.getCreateTableStatement(table.getName(), table.getTransactionalTableName().concat(tableSuffix), filtered, tableDir, config.getFlatTableStorageFormat(), config.getFlatTableFieldDelimiter(), queryCondition);
        hiveCmdBuilder.addStatement(createTableStatement);
        String cmd = hiveCmdBuilder.toString();
        CliCommandExecutor cliCommandExecutor = new CliCommandExecutor();
        try {
            CliCommandExecutor.CliCmdExecResult result = cliCommandExecutor.execute(cmd, null);
            if (result.getCode() != 0) {
                log.error("execute create intermediate table return fail, jobId : {}", (Object)jobId);
            } else {
                log.info("execute create intermediate table succeeded, jobId : {}", (Object)jobId);
            }
        }
        catch (ShellException e) {
            log.error("failed to execute create intermediate table, jobId : {}, result : {}", (Object)jobId, (Object)e);
        }
    }

    private static String generateTxTableQueryCondition(TableDesc table, Map<String, String> params) {
        String sampleRowCount;
        log.info("table ready,start build sql");
        PartitionDesc partitionDesc = table.getPartitionDesc();
        log.info("table partition desc is :{}", (Object)partitionDesc);
        log.info("whether partition query is required ? :{}", (Object)Objects.nonNull(partitionDesc));
        log.info("table segment range start: {}; end: {}", (Object)params.get("segmentStart"), (Object)params.get("segmentEnd"));
        String sql = "";
        Boolean hasParam = Objects.nonNull(partitionDesc) && params.containsKey("segmentStart") && params.containsKey("segmentEnd") && Objects.nonNull(partitionDesc.getPartitionDateColumnRef()) && Objects.nonNull(partitionDesc.getPartitionDateColumnRef().getTable()) && partitionDesc.getPartitionDateColumnRef().getTable().equalsIgnoreCase(table.getIdentity());
        if (hasParam.booleanValue()) {
            boolean strDataTypeFlag;
            ColumnDesc partitionColumnDesc = partitionDesc.getPartitionDateColumnRef().getColumnDesc();
            String partitionDataColumn = partitionColumnDesc.getName();
            log.info("table partition column name is :{}", (Object)partitionDataColumn);
            String columnDataTypeName = partitionColumnDesc.getType().getName();
            log.info("table partition column data type is :{}", (Object)columnDataTypeName);
            boolean intDataTypeFlag = columnDataTypeName.equalsIgnoreCase("int") || columnDataTypeName.equalsIgnoreCase("integer");
            boolean dateDataTypeFlag = columnDataTypeName.equalsIgnoreCase("time") || columnDataTypeName.equalsIgnoreCase("timestamp") || columnDataTypeName.equalsIgnoreCase("date") || columnDataTypeName.equalsIgnoreCase("datetime");
            boolean bl = strDataTypeFlag = columnDataTypeName.equalsIgnoreCase("string") || columnDataTypeName.equalsIgnoreCase("varchar");
            if (intDataTypeFlag || dateDataTypeFlag || strDataTypeFlag) {
                String partitionDateFormat = partitionDesc.getPartitionDateFormat();
                log.info("table partition data format is :{}", (Object)partitionDateFormat);
                String beginDate = DateFormat.formatToDateStr((long)Long.parseLong(params.getOrDefault("segmentStart", "0")), (String)partitionDateFormat);
                String endDate = DateFormat.formatToDateStr((long)Long.parseLong(params.getOrDefault("segmentEnd", "0")), (String)partitionDateFormat);
                log.info("segment range is :[{},{}]", (Object)beginDate, (Object)endDate);
                sql = intDataTypeFlag ? String.format(Locale.ROOT, "WHERE %s BETWEEN %d AND %d", HiveTransactionTableHelper.doQuote(partitionDataColumn), Integer.parseInt(beginDate), Integer.parseInt(endDate)) : String.format(Locale.ROOT, "WHERE %s BETWEEN '%s' AND '%s'", HiveTransactionTableHelper.doQuote(partitionDataColumn), beginDate, endDate);
            }
        }
        if (!(sampleRowCount = params.getOrDefault("sampleRowCount", "")).isEmpty()) {
            sql = String.format(Locale.ROOT, " limit %d", Integer.parseInt(sampleRowCount));
        }
        return sql;
    }

    public static void createHiveTableDirIfNeeded(String jobWorkingDir, String tableName) throws IOException {
        Path path = new Path(jobWorkingDir, tableName);
        FileSystem fileSystem = HadoopUtil.getWorkingFileSystem();
        if (!fileSystem.exists(path)) {
            log.info("Create hive table dir in hdfs: {}: ", (Object)path);
        } else {
            log.info("Hive table dir already exists in hdfs: {}, delete old dir and recreate it", (Object)path);
            fileSystem.delete(path, true);
        }
        fileSystem.mkdirs(path);
        fileSystem.setPermission(path, new FsPermission(511));
    }
}

