/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.kylin.cluster.IClusterManager;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.spark.SparkConf;
import org.apache.spark.conf.rule.ExecutorCoreRule;
import org.apache.spark.conf.rule.ExecutorInstancesRule;
import org.apache.spark.conf.rule.ExecutorMemoryRule;
import org.apache.spark.conf.rule.ExecutorOverheadRule;
import org.apache.spark.conf.rule.ShufflePartitionsRule;
import org.apache.spark.conf.rule.SparkConfRule;
import org.apache.spark.conf.rule.StandaloneConfRule;
import org.apache.spark.conf.rule.YarnConfRule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkConfHelper {
    protected static final Logger logger = LoggerFactory.getLogger(SparkConfHelper.class);
    private HashMap<String, String> options = Maps.newHashMap();
    private HashMap<String, String> confs = Maps.newHashMap();
    private IClusterManager clusterManager;
    public static final String SOURCE_TABLE_SIZE = "source_table_size";
    public static final String LAYOUT_SIZE = "layout_size";
    public static final String DEFAULT_QUEUE = "spark.yarn.queue";
    public static final String REQUIRED_CORES = "required_cores";
    public static final String EXECUTOR_INSTANCES = "spark.executor.instances";
    public static final String EXECUTOR_CORES = "spark.executor.cores";
    public static final String EXECUTOR_MEMORY = "spark.executor.memory";
    public static final String EXECUTOR_OVERHEAD = "spark.executor.memoryOverhead";
    public static final String SHUFFLE_PARTITIONS = "spark.sql.shuffle.partitions";
    public static final String DRIVER_MEMORY = "spark.driver.memory";
    public static final String DRIVER_OVERHEAD = "spark.driver.memoryOverhead";
    public static final String DRIVER_CORES = "spark.driver.cores";
    public static final String MAX_CORES = "spark.cores.max";
    public static final String COUNT_DISTICT = "count_distinct";
    private static final List<SparkConfRule> EXECUTOR_RULES = Lists.newArrayList((Object[])new SparkConfRule[]{new ExecutorMemoryRule(), new ExecutorCoreRule(), new ExecutorOverheadRule(), new ExecutorInstancesRule(), new ShufflePartitionsRule(), new StandaloneConfRule(), new YarnConfRule()});

    public void generateSparkConf() {
        KylinConfig.getInstanceFromEnv().getSparkBuildConfExtraRules().forEach(rule -> EXECUTOR_RULES.add((SparkConfRule)ClassUtil.newInstance((String)rule)));
        EXECUTOR_RULES.forEach(sparkConfRule -> sparkConfRule.apply(this));
    }

    public String getOption(String key) {
        return this.options.getOrDefault(key, null);
    }

    public void setOption(String key, String value) {
        this.options.put(key, value);
    }

    public void setConf(String key, String value) {
        this.confs.put(key, value);
    }

    public String getConf(String key) {
        return this.confs.getOrDefault(key, null);
    }

    public IClusterManager getClusterManager() {
        return this.clusterManager;
    }

    public void setClusterManager(IClusterManager clusterManager) {
        this.clusterManager = clusterManager;
    }

    public void applySparkConf(SparkConf sparkConf) throws JsonProcessingException {
        KylinBuildEnv.get().buildJobInfos().recordAutoSparkConfs(this.confs);
        logger.info("Auto set spark conf: {}", (Object)JsonUtil.writeValueAsString(this.confs));
        for (Map.Entry<String, String> entry : this.confs.entrySet()) {
            sparkConf.set(entry.getKey(), entry.getValue());
        }
    }

    public boolean hasCountDistinct() {
        return "true".equalsIgnoreCase(this.getConf(COUNT_DISTICT));
    }
}

