/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.application;

import org.apache.kylin.common.util.Unsafe;
import org.apache.kylin.engine.spark.job.KylinBuildEnv;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.kylin.engine.spark.scheduler.ExceedMaxRetry;
import org.apache.kylin.engine.spark.scheduler.JobFailed;
import org.apache.kylin.engine.spark.scheduler.KylinJobEvent;
import org.apache.kylin.engine.spark.scheduler.KylinJobListener;
import org.apache.kylin.engine.spark.scheduler.ResourceLack;
import org.apache.kylin.engine.spark.scheduler.UnknownThrowable;
import org.apache.spark.application.NoRetryException;
import org.apache.spark.autoheal.ExceptionTerminator$;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.KylinJobEventLoop;
import org.slf4j.Logger;
import scala.Function0;
import scala.Serializable;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001a3AAC\u0006\u0001)!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005C\u0003)\u0001\u0011\u0005\u0011\u0006C\u0004.\u0001\u0001\u0007I\u0011\u0001\u0018\t\u000fI\u0002\u0001\u0019!C\u0001g!1\u0011\b\u0001Q!\n=BQA\u000f\u0001\u0005\u0002mBQ\u0001\u0010\u0001\u0005\u0002uBQA\u0013\u0001\u0005\u0002-CQ!\u0015\u0001\u0005\u0002I\u0013!BS8c\u001b>t\u0017\u000e^8s\u0015\taQ\"A\u0006baBd\u0017nY1uS>t'B\u0001\b\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!F\u000e\u0011\u0005YIR\"A\f\u000b\u0003a\tQa]2bY\u0006L!AG\f\u0003\r\u0005s\u0017PU3g!\tar$D\u0001\u001e\u0015\tqR\"\u0001\u0005j]R,'O\\1m\u0013\t\u0001SDA\u0004M_\u001e<\u0017N\\4\u0002\u0013\u00154XM\u001c;M_>\u0004\bCA\u0012'\u001b\u0005!#BA\u0013\u000e\u0003%\u00198\r[3ek2,'/\u0003\u0002(I\t\t2*\u001f7j]*{'-\u0012<f]Rdun\u001c9\u0002\rqJg.\u001b;?)\tQC\u0006\u0005\u0002,\u00015\t1\u0002C\u0003\"\u0005\u0001\u0007!%\u0001\u0006sKR\u0014\u0018\u0010V5nKN,\u0012a\f\t\u0003-AJ!!M\f\u0003\u0007%sG/\u0001\bsKR\u0014\u0018\u0010V5nKN|F%Z9\u0015\u0005Q:\u0004C\u0001\f6\u0013\t1tC\u0001\u0003V]&$\bb\u0002\u001d\u0005\u0003\u0003\u0005\raL\u0001\u0004q\u0012\n\u0014a\u0003:fiJLH+[7fg\u0002\nAa\u001d;paR\tA'\u0001\niC:$G.\u001a*fg>,(oY3MC\u000e\\GC\u0001\u001b?\u0011\u0015yt\u00011\u0001A\u0003\t\u0011H\u000e\u0005\u0002B\u00116\t!I\u0003\u0002&\u0007*\u0011a\u0002\u0012\u0006\u0003\u000b\u001a\u000ba!\u001a8hS:,'BA$\u0010\u0003\u0015Y\u0017\u0010\\5o\u0013\tI%I\u0001\u0007SKN|WO]2f\u0019\u0006\u001c7.\u0001\u000biC:$G.Z#yG\u0016,G-T1y%\u0016$(/\u001f\u000b\u0003i1CQ!\u0014\u0005A\u00029\u000b1!Z7s!\t\tu*\u0003\u0002Q\u0005\nqQ\t_2fK\u0012l\u0015\r\u001f*fiJL\u0018A\u00065b]\u0012dW-\u00168l]><h\u000e\u00165s_^\f'\r\\3\u0015\u0005Q\u001a\u0006\"\u0002+\n\u0001\u0004)\u0016AA;s!\t\te+\u0003\u0002X\u0005\n\u0001RK\\6o_^tG\u000b\u001b:po\u0006\u0014G.\u001a")
public class JobMonitor
implements Logging {
    private final KylinJobEventLoop eventLoop;
    private int retryTimes;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public int retryTimes() {
        return this.retryTimes;
    }

    public void retryTimes_$eq(int x$1) {
        this.retryTimes = x$1;
    }

    public void stop() {
    }

    public void handleResourceLack(ResourceLack rl) {
        block5: {
            try {
                if (rl.throwable() != null && rl.throwable().getCause() != null && rl.throwable().getCause() instanceof NoRetryException) {
                    this.eventLoop.post(new JobFailed(rl.throwable().getCause().getMessage(), rl.throwable().getCause()));
                    return;
                }
                this.logInfo((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(23).append("handleResourceLack --> ").append(rl.throwable().getCause()).toString());
                KylinBuildEnv buildEnv = KylinBuildEnv$.MODULE$.get();
                String jobStepId = buildEnv.buildJobInfos().getJobStepId();
                if (buildEnv.clusterManager().isApplicationBeenKilled(jobStepId)) {
                    this.eventLoop.post(new JobFailed(new StringBuilder(39).append("Submitted application ").append(jobStepId).append(" has been killed.").toString(), rl.throwable()));
                    return;
                }
                this.retryTimes_$eq(this.retryTimes() + 1);
                KylinBuildEnv$.MODULE$.get().buildJobInfos().recordRetryTimes(this.retryTimes());
                int maxRetry = buildEnv.kylinConfig().getSparkEngineMaxRetryTime();
                if (this.retryTimes() <= maxRetry) {
                    this.logError((Function0<String>)(Function0 & java.io.Serializable & Serializable)() -> new StringBuilder(27).append("Job failed ").append(this.retryTimes()).append(" time(s). Cause:").toString(), rl.throwable());
                    Unsafe.setProperty((String)"kylin.spark-conf.auto-prior", (String)"false");
                    ExceptionTerminator$.MODULE$.resolveException(rl, this.eventLoop);
                    break block5;
                }
                this.eventLoop.post(new ExceedMaxRetry(rl.throwable()));
            }
            catch (Throwable throwable) {
                this.eventLoop.post(new JobFailed("Error occurred when generate retry configuration.", throwable));
            }
        }
    }

    public void handleExceedMaxRetry(ExceedMaxRetry emr) {
        this.eventLoop.post(new JobFailed("Retry times exceed MaxRetry set in the KylinConfig.", emr.throwable()));
    }

    public void handleUnknownThrowable(UnknownThrowable ur) {
        this.eventLoop.post(new JobFailed("Unknown error occurred during the job.", ur.throwable()));
    }

    public JobMonitor(KylinJobEventLoop eventLoop) {
        this.eventLoop = eventLoop;
        Logging.$init$((Logging)this);
        this.retryTimes = 0;
        eventLoop.registerListener(new KylinJobListener(this){
            private final /* synthetic */ JobMonitor $outer;

            public void onReceive(KylinJobEvent event) {
                KylinJobEvent kylinJobEvent = event;
                if (kylinJobEvent instanceof ResourceLack) {
                    ResourceLack resourceLack = (ResourceLack)kylinJobEvent;
                    this.$outer.handleResourceLack(resourceLack);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (kylinJobEvent instanceof UnknownThrowable) {
                    UnknownThrowable unknownThrowable = (UnknownThrowable)kylinJobEvent;
                    this.$outer.handleUnknownThrowable(unknownThrowable);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (kylinJobEvent instanceof ExceedMaxRetry) {
                    ExceedMaxRetry exceedMaxRetry = (ExceedMaxRetry)kylinJobEvent;
                    this.$outer.handleExceedMaxRetry(exceedMaxRetry);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

