/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.application;

import java.io.Serializable;
import java.util.HashMap;
import java.util.concurrent.CountDownLatch;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.engine.spark.application.SparkApplication;
import org.apache.kylin.engine.spark.job.BuildJobInfos;
import org.apache.kylin.engine.spark.job.KylinBuildEnv$;
import org.apache.kylin.engine.spark.scheduler.JobFailed;
import org.apache.kylin.engine.spark.scheduler.JobSucceeded;
import org.apache.kylin.engine.spark.scheduler.KylinJobEvent;
import org.apache.kylin.engine.spark.scheduler.KylinJobListener;
import org.apache.kylin.engine.spark.scheduler.RunJob;
import org.apache.spark.application.JobMonitor;
import org.apache.spark.application.JobWorkSpace$;
import org.apache.spark.application.JobWorker;
import org.apache.spark.application.RetryInfo;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.KylinJobEventLoop;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015r!\u0002\u000b\u0016\u0011\u0003qb!\u0002\u0011\u0016\u0011\u0003\t\u0003\"\u0002\u0018\u0002\t\u0003y\u0003\"\u0002\u0019\u0002\t\u0003\t\u0004\"B#\u0002\t\u00031e\u0001\u0002\u0011\u0016\u0001UC\u0001BV\u0003\u0003\u0002\u0003\u0006Ia\u0016\u0005\t;\u0016\u0011\t\u0011)A\u0005=\"A\u0011-\u0002B\u0001B\u0003%!\rC\u0003/\u000b\u0011\u0005Q\rC\u0004k\u000b\u0001\u0007I\u0011B6\t\u000f=,\u0001\u0019!C\u0005a\"11/\u0002Q!\n1Dq\u0001^\u0003C\u0002\u0013%Q\u000fC\u0004\u0002\u0002\u0015\u0001\u000b\u0011\u0002<\t\u000f\u0005\rQ\u0001\"\u0001\u0002\u0006!9\u0011qA\u0003\u0005\u0002\u0005%\u0001bBA\u0006\u000b\u0011\u0005\u0011Q\u0002\u0005\b\u0003;)A\u0011AA\u0005\u0011\u001d\ty\"\u0002C\u0001\u0003C\tABS8c/>\u00148n\u00159bG\u0016T!AF\f\u0002\u0017\u0005\u0004\b\u000f\\5dCRLwN\u001c\u0006\u00031e\tQa\u001d9be.T!AG\u000e\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005a\u0012aA8sO\u000e\u0001\u0001CA\u0010\u0002\u001b\u0005)\"\u0001\u0004&pE^{'o[*qC\u000e,7cA\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!\u000b\u0017\u000e\u0003)R!aK\f\u0002\u0011%tG/\u001a:oC2L!!\f\u0016\u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012AH\u0001\bKb,7-\u001e;f)\t\u0011T\u0007\u0005\u0002$g%\u0011A\u0007\n\u0002\u0005+:LG\u000fC\u00037\u0007\u0001\u0007q'\u0001\u0003be\u001e\u001c\bcA\u00129u%\u0011\u0011\b\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003w\ts!\u0001\u0010!\u0011\u0005u\"S\"\u0001 \u000b\u0005}j\u0012A\u0002\u001fs_>$h(\u0003\u0002BI\u00051\u0001K]3eK\u001aL!a\u0011#\u0003\rM#(/\u001b8h\u0015\t\tE%A\u0006sKN|GN^3Be\u001e\u001cHCA$U!\u0011\u0019\u0003JS\u001c\n\u0005%##A\u0002+va2,'\u0007\u0005\u0002L%6\tAJ\u0003\u0002\u0017\u001b*\u0011\u0001D\u0014\u0006\u0003\u001fB\u000ba!\u001a8hS:,'BA)\u001a\u0003\u0015Y\u0017\u0010\\5o\u0013\t\u0019FJ\u0001\tTa\u0006\u00148.\u00119qY&\u001c\u0017\r^5p]\")a\u0007\u0002a\u0001oM\u0019QA\t\u0015\u0002\u0013\u00154XM\u001c;M_>\u0004\bC\u0001-\\\u001b\u0005I&B\u0001.\u0018\u0003%\u00198\r[3ek2,'/\u0003\u0002]3\n\t2*\u001f7j]*{'-\u0012<f]Rdun\u001c9\u0002\u000f5|g.\u001b;peB\u0011qdX\u0005\u0003AV\u0011!BS8c\u001b>t\u0017\u000e^8s\u0003\u00199xN]6feB\u0011qdY\u0005\u0003IV\u0011\u0011BS8c/>\u00148.\u001a:\u0015\t\u0019<\u0007.\u001b\t\u0003?\u0015AQAV\u0005A\u0002]CQ!X\u0005A\u0002yCQ!Y\u0005A\u0002\t\f!b\u001d;biV\u001c8i\u001c3f+\u0005a\u0007CA\u0012n\u0013\tqGEA\u0002J]R\fab\u001d;biV\u001c8i\u001c3f?\u0012*\u0017\u000f\u0006\u00023c\"9!oCA\u0001\u0002\u0004a\u0017a\u0001=%c\u0005Y1\u000f^1ukN\u001cu\u000eZ3!\u0003\u0015a\u0017\r^2i+\u00051\bCA<\u007f\u001b\u0005A(BA={\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003wr\fA!\u001e;jY*\tQ0\u0001\u0003kCZ\f\u0017BA@y\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"\fa\u0001\\1uG\"\u0004\u0013a\u0001:v]R\tA.A\u0004tk\u000e\u001cWm]:\u0015\u0003I\nAAZ1jYR\u0019!'a\u0004\t\u000f\u0005E\u0011\u00031\u0001\u0002\u0014\u0005\u0011!N\u001a\t\u0005\u0003+\tI\"\u0004\u0002\u0002\u0018)\u0011!,T\u0005\u0005\u00037\t9BA\u0005K_\n4\u0015-\u001b7fI\u0006!1\u000f^8q\u0003I)\b\u000fZ1uK*{'-\u0012:s_JLeNZ8\u0015\u0007I\n\u0019\u0003C\u0004\u0002\u0012M\u0001\r!a\u0005")
public class JobWorkSpace
implements Logging {
    private final KylinJobEventLoop eventLoop;
    private final JobMonitor monitor;
    private final JobWorker worker;
    private int statusCode;
    private final CountDownLatch latch;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static Tuple2<SparkApplication, String[]> resolveArgs(String[] stringArray) {
        return JobWorkSpace$.MODULE$.resolveArgs(stringArray);
    }

    public static void execute(String[] stringArray) {
        JobWorkSpace$.MODULE$.execute(stringArray);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private int statusCode() {
        return this.statusCode;
    }

    private void statusCode_$eq(int x$1) {
        this.statusCode = x$1;
    }

    private CountDownLatch latch() {
        return this.latch;
    }

    public int run() {
        this.eventLoop.start();
        this.eventLoop.post(new RunJob());
        this.latch().await();
        return this.statusCode();
    }

    public void success() {
        try {
            this.stop();
        }
        finally {
            this.statusCode_$eq(0);
            this.latch().countDown();
        }
    }

    public void fail(JobFailed jf) {
        try {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(31).append("Job failed eventually. Reason: ").append(jf.reason()).toString(), jf.throwable());
            KylinBuildEnv$.MODULE$.get().buildJobInfos().recordJobRetryInfos(new RetryInfo(new HashMap<String, String>(), jf.throwable()));
            this.updateJobErrorInfo(jf);
            this.stop();
        }
        finally {
            this.statusCode_$eq(1);
            this.latch().countDown();
        }
    }

    public void stop() {
        this.monitor.stop();
        this.worker.stop();
        this.eventLoop.stop();
    }

    public void updateJobErrorInfo(JobFailed jf) {
        BuildJobInfos infos = KylinBuildEnv$.MODULE$.get().buildJobInfos();
        SparkApplication context = this.worker.getApplication();
        String project = context.getProject();
        String jobId = context.getJobId();
        String stageId = infos.getStageId();
        String jobStepId = StringUtils.replace((String)infos.getJobStepId(), (String)"job_step_", (String)"");
        String failedStepId = StringUtils.isBlank((String)stageId) ? jobStepId : stageId;
        String failedSegmentId = infos.getSegmentId();
        String failedStack = ExceptionUtils.getStackTrace((Throwable)jf.throwable());
        String failedReason = context.getAtomicUnreachableSparkMaster().get() ? "Unable connect spark master to reach timeout maximum time" : jf.reason();
        String url = "/kylin/api/jobs/error";
        HashMap<String, String> payload = new HashMap<String, String>(5);
        payload.put("project", project);
        payload.put("job_id", jobId);
        payload.put("failed_step_id", failedStepId);
        payload.put("failed_segment_id", failedSegmentId);
        payload.put("failed_stack", failedStack);
        payload.put("failed_reason", failedReason);
        String json = JsonUtil.writeValueAsString(payload);
        HashMap<String, String> params = new HashMap<String, String>();
        KylinConfig config = KylinBuildEnv$.MODULE$.get().kylinConfig();
        params.put("time_out", Long.toString(config.getUpdateJobInfoTimeout()));
        params.put("job_tmp_dir", config.getJobTmpDir(project, true));
        context.getReport().updateSparkJobInfo(params, url, json);
    }

    public JobWorkSpace(KylinJobEventLoop eventLoop, JobMonitor monitor, JobWorker worker) {
        this.eventLoop = eventLoop;
        this.monitor = monitor;
        this.worker = worker;
        Logging.$init$((Logging)this);
        Predef$.MODULE$.require(eventLoop != null);
        Predef$.MODULE$.require(monitor != null);
        Predef$.MODULE$.require(worker != null);
        this.statusCode = 0;
        this.latch = new CountDownLatch(1);
        eventLoop.registerListener(new KylinJobListener(this){
            private final /* synthetic */ JobWorkSpace $outer;

            public void onReceive(KylinJobEvent event) {
                KylinJobEvent kylinJobEvent = event;
                if (kylinJobEvent instanceof JobSucceeded) {
                    this.$outer.success();
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else if (kylinJobEvent instanceof JobFailed) {
                    JobFailed jobFailed = (JobFailed)kylinJobEvent;
                    this.$outer.fail(jobFailed);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }
}

