/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.jdbc.shaded.org.apache.http.impl;

import java.io.IOException;
import java.net.SocketTimeoutException;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpClientConnection;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpConnectionMetrics;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpEntity;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpEntityEnclosingRequest;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpException;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpRequest;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpResponse;
import org.apache.kylin.jdbc.shaded.org.apache.http.HttpResponseFactory;
import org.apache.kylin.jdbc.shaded.org.apache.http.annotation.NotThreadSafe;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.HttpConnectionMetricsImpl;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.entity.EntityDeserializer;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.entity.EntitySerializer;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.entity.LaxContentLengthStrategy;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.entity.StrictContentLengthStrategy;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.io.DefaultHttpResponseParser;
import org.apache.kylin.jdbc.shaded.org.apache.http.impl.io.HttpRequestWriter;
import org.apache.kylin.jdbc.shaded.org.apache.http.io.EofSensor;
import org.apache.kylin.jdbc.shaded.org.apache.http.io.HttpMessageParser;
import org.apache.kylin.jdbc.shaded.org.apache.http.io.HttpMessageWriter;
import org.apache.kylin.jdbc.shaded.org.apache.http.io.HttpTransportMetrics;
import org.apache.kylin.jdbc.shaded.org.apache.http.io.SessionInputBuffer;
import org.apache.kylin.jdbc.shaded.org.apache.http.io.SessionOutputBuffer;
import org.apache.kylin.jdbc.shaded.org.apache.http.params.HttpParams;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@NotThreadSafe
public abstract class AbstractHttpClientConnection
implements HttpClientConnection {
    private final EntitySerializer entityserializer = this.createEntitySerializer();
    private final EntityDeserializer entitydeserializer = this.createEntityDeserializer();
    private SessionInputBuffer inbuffer = null;
    private SessionOutputBuffer outbuffer = null;
    private EofSensor eofSensor = null;
    private HttpMessageParser<HttpResponse> responseParser = null;
    private HttpMessageWriter<HttpRequest> requestWriter = null;
    private HttpConnectionMetricsImpl metrics = null;

    protected abstract void assertOpen() throws IllegalStateException;

    protected EntityDeserializer createEntityDeserializer() {
        return new EntityDeserializer(new LaxContentLengthStrategy());
    }

    protected EntitySerializer createEntitySerializer() {
        return new EntitySerializer(new StrictContentLengthStrategy());
    }

    protected HttpResponseFactory createHttpResponseFactory() {
        return new DefaultHttpResponseFactory();
    }

    protected HttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        return new DefaultHttpResponseParser(buffer, null, responseFactory, params);
    }

    protected HttpMessageWriter<HttpRequest> createRequestWriter(SessionOutputBuffer buffer, HttpParams params) {
        return new HttpRequestWriter(buffer, null, params);
    }

    protected HttpConnectionMetricsImpl createConnectionMetrics(HttpTransportMetrics inTransportMetric, HttpTransportMetrics outTransportMetric) {
        return new HttpConnectionMetricsImpl(inTransportMetric, outTransportMetric);
    }

    protected void init(SessionInputBuffer inbuffer, SessionOutputBuffer outbuffer, HttpParams params) {
        if (inbuffer == null) {
            throw new IllegalArgumentException("Input session buffer may not be null");
        }
        if (outbuffer == null) {
            throw new IllegalArgumentException("Output session buffer may not be null");
        }
        this.inbuffer = inbuffer;
        this.outbuffer = outbuffer;
        if (inbuffer instanceof EofSensor) {
            this.eofSensor = (EofSensor)((Object)inbuffer);
        }
        this.responseParser = this.createResponseParser(inbuffer, this.createHttpResponseFactory(), params);
        this.requestWriter = this.createRequestWriter(outbuffer, params);
        this.metrics = this.createConnectionMetrics(inbuffer.getMetrics(), outbuffer.getMetrics());
    }

    @Override
    public boolean isResponseAvailable(int timeout) throws IOException {
        this.assertOpen();
        try {
            return this.inbuffer.isDataAvailable(timeout);
        }
        catch (SocketTimeoutException ex) {
            return false;
        }
    }

    @Override
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        this.requestWriter.write(request);
        this.metrics.incrementRequestCount();
    }

    @Override
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        if (request == null) {
            throw new IllegalArgumentException("HTTP request may not be null");
        }
        this.assertOpen();
        if (request.getEntity() == null) {
            return;
        }
        this.entityserializer.serialize(this.outbuffer, request, request.getEntity());
    }

    protected void doFlush() throws IOException {
        this.outbuffer.flush();
    }

    @Override
    public void flush() throws IOException {
        this.assertOpen();
        this.doFlush();
    }

    @Override
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        this.assertOpen();
        HttpResponse response = this.responseParser.parse();
        if (response.getStatusLine().getStatusCode() >= 200) {
            this.metrics.incrementResponseCount();
        }
        return response;
    }

    @Override
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        if (response == null) {
            throw new IllegalArgumentException("HTTP response may not be null");
        }
        this.assertOpen();
        HttpEntity entity = this.entitydeserializer.deserialize(this.inbuffer, response);
        response.setEntity(entity);
    }

    protected boolean isEof() {
        return this.eofSensor != null && this.eofSensor.isEof();
    }

    @Override
    public boolean isStale() {
        if (!this.isOpen()) {
            return true;
        }
        if (this.isEof()) {
            return true;
        }
        try {
            this.inbuffer.isDataAvailable(1);
            return this.isEof();
        }
        catch (SocketTimeoutException ex) {
            return false;
        }
        catch (IOException ex) {
            return true;
        }
    }

    @Override
    public HttpConnectionMetrics getMetrics() {
        return this.metrics;
    }
}

