/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metrics.lib.impl.hive;

import java.util.List;
import java.util.Map;
import org.apache.kylin.shaded.com.google.common.base.Strings;

public class HiveProducerRecord {
    public static final String DELIMITER = ",";
    private final RecordKey key;
    private final List<Object> value;

    public HiveProducerRecord(RecordKey key, List<Object> value) {
        this.key = key;
        this.value = value;
    }

    public RecordKey key() {
        return this.key;
    }

    public List<Object> value() {
        return this.value;
    }

    public String toString() {
        String value = this.value == null ? "null" : this.value.toString();
        return "HiveProducerRecord(key=" + this.key.toString() + ", value=" + value + ")";
    }

    public String valueToString() {
        if (this.value == null || this.value.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.value.size() - 1; ++i) {
            sb.append(this.value.get(i) + DELIMITER);
        }
        sb.append(this.value.get(this.value.size() - 1));
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HiveProducerRecord record = (HiveProducerRecord)o;
        if (this.key != null ? !this.key.equals(record.key) : record.key != null) {
            return false;
        }
        return this.value != null ? this.value.equals(record.value) : record.value == null;
    }

    public int hashCode() {
        int result = this.key != null ? this.key.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    public static class RecordKey {
        public static final String DEFAULT_DB_NAME = "DEFAULT";
        private final String dbName;
        private final String tableName;
        private final Map<String, String> partitionKVs;

        public RecordKey(String dbName, String tableName, Map<String, String> partitionKVs) {
            this.dbName = Strings.isNullOrEmpty((String)dbName) ? DEFAULT_DB_NAME : dbName;
            this.tableName = tableName;
            this.partitionKVs = partitionKVs;
        }

        public String database() {
            return this.dbName;
        }

        public String table() {
            return this.tableName;
        }

        public Map<String, String> partition() {
            return this.partitionKVs;
        }

        public String toString() {
            String partitionKVs = this.partitionKVs == null ? "null" : this.partitionKVs.toString();
            return "RecordKey(database=" + this.dbName + ", table=" + this.tableName + ", partition=" + partitionKVs + ")";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RecordKey recordKey = (RecordKey)o;
            if (this.dbName != null ? !this.dbName.equals(recordKey.dbName) : recordKey.dbName != null) {
                return false;
            }
            if (this.tableName != null ? !this.tableName.equals(recordKey.tableName) : recordKey.tableName != null) {
                return false;
            }
            return this.partitionKVs != null ? this.partitionKVs.equals(recordKey.partitionKVs) : recordKey.partitionKVs == null;
        }

        public int hashCode() {
            int result = this.dbName != null ? this.dbName.hashCode() : 0;
            result = 31 * result + (this.tableName != null ? this.tableName.hashCode() : 0);
            result = 31 * result + (this.partitionKVs != null ? this.partitionKVs.hashCode() : 0);
            return result;
        }
    }

    public static class KeyBuilder {
        private final String tableName;
        private String dbName;
        private Map<String, String> partitionKVs;

        public KeyBuilder(String tableName) {
            this.tableName = tableName;
        }

        public KeyBuilder setDbName(String dbName) {
            this.dbName = dbName;
            return this;
        }

        public KeyBuilder setPartitionKVs(Map<String, String> partitionKVs) {
            this.partitionKVs = partitionKVs;
            return this;
        }

        public RecordKey build() {
            return new RecordKey(this.dbName, this.tableName, this.partitionKVs);
        }
    }
}

